<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Gerenciamento - Sistema de Avaliação IFCora</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">
    <style>
        /* Informações da Criança */
        .child-info {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 0px 15px;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
        }
        .child-info img {
            width: 20px;
            height: 20px;
            border-radius: 50%;
            border: 2px solid #08C89E;
            margin-right: 15px;
            object-fit: cover;
        }
        .child-info div {
            font-size: 16px;
        }
        .child-info div p {
            margin-bottom: 5px;
            color: #2d3748;
        }
        /* Histórico de Avaliações */
        .history {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 15px;
            margin-bottom: 20px;
        }
        .history h2 {
            font-size: 18px;
            color: #08C89E;
            margin-bottom: 15px;
            margin-top: -10px;
        }
        .history table {
            width: 100%;
            border-collapse: collapse;
        }
        .history th, .history td {
            text-align: left;
            padding: 10px;
            border-bottom: 1px solid #e2e8f0;
            font-size: 16px;
        }
        .history th {
            background-color: #f7fafc;
            color: #2d3748;
        }
        .history td a {
            color: #08C89E;
            text-decoration: underline;
        }
        /* Formulário do M-CHAT */
        /* Oculta o formulário inicialmente */
        .mchat-form {
            display: none;
        }
        .mchat-form {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 20px;
        }
        .mchat-form h2 {
            font-size: 24px;
            color: #08C89E;
            margin-bottom: 20px;
        }
        .progress-bar {
            width: 100%;
            background-color: #e2e8f0;
            border-radius: 8px;
            overflow: hidden;
            margin-bottom: 20px;
        }
        .progress {
            height: 10px;
            background-color: #08C89E;
            width: 0%;
        }
        .question {
            margin-bottom: 20px;
        }
        .question p {
            font-size: 16px;
            color: #2d3748;
            margin-bottom: 10px;
        }
        .question label {
            font-size: 16px;
            color: #4a5568;
            margin-right: 20px;
            cursor: pointer;
        }
        .question input {
            margin-right: 10px;
        }
        .notes {
            margin-top: 10px;
        }
        .notes textarea {
            width: 100%;
            padding: 10px;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            font-size: 14px;
            resize: vertical;
        }
        .form-actions {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 30px;
        }
        .form-actions .save-button {
            background-color: #F6AD55;
            color: #fff;
            padding: 12px 20px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
            transition: background 0.3s;
        }
        .form-actions .save-button:hover {
            background-color: #dd6b20;
        }
        .form-actions .submit-button {
            background-color: #08C89E;
            color: #fff;
            padding: 12px 20px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
            transition: background 0.3s;
        }
        .form-actions .submit-button:hover {
            background-color: #06b287;
        }
        
        .form-actions .cancel-button {
            background-color: #e53e3e;
            color: #fff;
            padding: 12px 20px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
            transition: background 0.3s;
            margin-right: 10px;
        }
        .form-actions .cancel-button:hover {
            background-color: #c53030;
        }
        
        /* Botão Continuar */
        .continue-button {
            display: inline-block;
            background-color: #ffffff; /* Fundo branco */
            color: #F7702D; /* Cor do texto laranja */
            padding: 8px 16px;
            border: 2px solid #F7702D; /* Borda laranja */
            border-radius: 8px; /* Bordas arredondadas */
            text-align: center;
            text-decoration: none;
            font-size: 14px;
            transition: background 0.3s, color 0.3s;
        }
        .continue-button:hover {
            background-color: #F7702D; /* Fundo laranja ao passar o mouse */
            color: #ffffff; /* Texto branco ao passar o mouse */
        }
        
        /* Botão Visualizar */
        .view-button {
            display: inline-block;
            background-color: #ffffff; /* Fundo branco */
            color: #08C89E; /* Cor do texto verde */
            padding: 8px 16px;
            border: 2px solid #08C89E; /* Borda verde */
            border-radius: 8px; /* Bordas arredondadas */
            text-align: center;
            text-decoration: none;
            font-size: 14px;
            transition: background 0.3s, color 0.3s;
        }
        .view-button:hover {
            background-color: #08C89E; /* Fundo verde ao passar o mouse */
            color: #ffffff; /* Texto branco ao passar o mouse */
        }
        
        
        /* Estilos para o botão "Nova Avaliação" */
        .new-evaluation-button {
            background-color: #08C89E;
            color: #fff;
            padding: 12px 20px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
            transition: background 0.3s;
            margin-bottom: 20px;
        }
        .new-evaluation-button:hover {
            background-color: #06b287;
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-painel-clinica-crianças.php'; ?>

    <!-- Conteúdo -->
    <main class="content">
        <div class="header-content">
            <h1 style="margin-left: 0px"><i class="fas fa-clipboard-list"></i> M-CHAT</h1>
        </div>
        <!-- Informações da Criança -->
        <div class="child-info">
            <p ><b>Nome: </b>Helena Silva Simon<b> - Idade:</b> 7 anos - <b>Nascimento: </b>20/05/2018 - <b>Responsável: </b> Maria da Silva</b></p>
        </div>
        </div>
        <!-- Histórico de Avaliações -->
        <div class="history">
            <h2>Histórico de Avaliações:</h2>
            <table>
                <thead>
                    <tr>
                        <th>Data</th>
                        <th>Idade</th>
                        <th>Resultado</th>
                        <th>Ações</th>
                        <th>Remover</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>01/11/2023</td>
                        <td>85 (meses)</td>
                        <td>Em andamento</td>
                        <td><a href="#" class="continue-button">Continuar</a></td>
                        <td><a href="#" class="remove-button">Remover</a></td>
                    </tr>
                    <tr>
                        <td>15/08/2023</td>
                        <td>84 (meses)</td>
                        <td>Risco Baixo</td>
                        <td><a href="#" class="view-button">Visualizar</a></td>
                        <td><a href="#" class="remove-button">Remover</a></td>
                    </tr>
                    <tr>
                        <td>10/05/2023</td>
                        <td>81 (meses)</td>
                        <td>Risco Médio</td>
                        <td><a href="#" class="view-button">Visualizar</a></td>
                        <td><a href="#" class="remove-button">Remover</a></td>
                    </tr>
                    <!-- Outras avaliações podem ser listadas aqui -->
                </tbody>
            </table>
        </div>
        <!-- Botão "Nova Avaliação" -->
        <button type="button" class="new-evaluation-button" id="new-evaluation-button">Nova Avaliação</button>
        <!-- Formulário do M-CHAT -->
        <form class="mchat-form" id="mchat-form">
            <h2>Questionário M-CHAT</h2>
            <!-- Barra de Progresso -->
            <div class="progress-bar">
                <div class="progress" id="progress-bar"></div>
            </div>
            <!-- Perguntas -->
            <!-- Pergunta 1 -->
            <div class="question">
                <p>1. Se você apontar para qualquer coisa do outro lado do cômodo, sua criança olha para o que você está apontando? (Por exemplo: se você apontar para um brinquedo ou um animal, sua criança olha para o brinquedo ou animal?)</p>
                <label><input type="radio" name="q1" value="Sim" required> Sim</label>
                <label><input type="radio" name="q1" value="Não"> Não</label>
                <!-- Notas -->
                <div class="notes">
                    <textarea name="notes1" placeholder="Observações"></textarea>
                </div>
            </div>
            <!-- Pergunta 2 -->
            <div class="question">
                <p>2. Alguma vez você já se perguntou se sua criança poderia ser surda?</p>
                <label><input type="radio" name="q2" value="Sim" required> Sim</label>
                <label><input type="radio" name="q2" value="Não"> Não</label>
                <!-- Notas -->
                <div class="notes">
                    <textarea name="notes2" placeholder="Observações"></textarea>
                </div>
            </div>
            <!-- Repita para todas as 20 perguntas -->
            <!-- ... Perguntas 3 a 19 ... -->
            <!-- Pergunta 20 -->
            <div class="question">
                <p>20. Sua criança gosta de atividades com movimento? (Por exemplo, ser balançada ou pular nos seus joelhos?)</p>
                <label><input type="radio" name="q20" value="Sim" required> Sim</label>
                <label><input type="radio" name="q20" value="Não"> Não</label>
                <!-- Notas -->
                <div class="notes">
                    <textarea name="notes20" placeholder="Observações"></textarea>
                </div>
            </div>
            <!-- Ações do Formulário -->
            <div class="form-actions">
                <button type="button" class="cancel-button">Cancelar</button>
                <button type="button" class="save-button">Salvar e Continuar Depois</button>
                <button type="submit" class="submit-button">Enviar Avaliação</button>
            </div>
        </form>
    </main>
    <!-- Modal para Visualizar Resultado -->
    <div id="result-modal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <p>Resultado do M-CHAT: Pontuação de Risco: 3. Nível de Risco: Risco Médio. As seguintes áreas do desenvolvimento podem estar comprometidas: Sensibilidade e resposta auditiva, Atenção, Compreensão, Comportamento, Uso Corporal. Perguntas que indicaram risco: item2, item5, item12. O resultado indica um risco médio de TEA. Recomenda-se repetir o teste em um mês e considerar uma avaliação profissional.</p>
            <button class="copy-button" id="copy-button">Copiar Texto</button>
        </div>
    </div>
    <!-- Script para as novas funcionalidades -->
    <script>
        // Script para o pop-up de "Visualizar"
        const modal = document.getElementById('result-modal');
        const closeModal = document.getElementsByClassName('close')[0];
        const viewButtons = document.querySelectorAll('.view-button');
        const copyButton = document.getElementById('copy-button');

        viewButtons.forEach(button => {
            button.addEventListener('click', function(event) {
                event.preventDefault();
                modal.style.display = 'block';
            });
        });

        closeModal.onclick = function() {
            modal.style.display = 'none';
        }

        window.onclick = function(event) {
            if (event.target == modal) {
                modal.style.display = 'none';
            }
        }

        copyButton.addEventListener('click', function() {
            const textToCopy = modal.querySelector('p').innerText;
            navigator.clipboard.writeText(textToCopy).then(function() {
                alert('Texto copiado para a área de transferência.');
            }, function() {
                alert('Erro ao copiar o texto.');
            });
        });

        // Script para o botão "Nova Avaliação"
        const newEvaluationButton = document.getElementById('new-evaluation-button');
        const mchatForm = document.getElementById('mchat-form');
        const progressBar = document.getElementById('progress-bar');
        const questions = document.querySelectorAll('.question');

        newEvaluationButton.addEventListener('click', function() {
            // Resetar o formulário
            mchatForm.reset();
            // Mostrar o formulário
            mchatForm.style.display = 'block';
            // Resetar barra de progresso
            progressBar.style.width = '0%';
            // Rolar até o formulário
            mchatForm.scrollIntoView({ behavior: 'smooth' });
        });

        // Script para a barra de progresso
        const totalQuestions = 20;
        const updateProgress = () => {
            let answered = 0;
            questions.forEach(question => {
                const inputs = question.querySelectorAll('input[type="radio"]');
                inputs.forEach(input => {
                    if (input.checked) {
                        answered++;
                    }
                });
            });
            const progressPercent = (answered / totalQuestions) * 100;
            progressBar.style.width = progressPercent + '%';
        };
        questions.forEach(question => {
            const inputs = question.querySelectorAll('input[type="radio"]');
            inputs.forEach(input => {
                input.addEventListener('change', updateProgress);
            });
        });

        // Script para o botão "Continuar"
        const continueButtons = document.querySelectorAll('.continue-button');

        continueButtons.forEach(button => {
            button.addEventListener('click', function(event) {
                event.preventDefault();
                // Mostrar o formulário
                mchatForm.style.display = 'block';
                // Simular dados salvos
                const savedData = {
                    q1: 'Sim',
                    notes1: 'Observação sobre a pergunta 1',
                    q2: 'Não',
                    notes2: 'Observação sobre a pergunta 2',
                    // Adicione os dados para todas as perguntas
                };
                // Preencher o formulário com os dados salvos
                for (let key in savedData) {
                    if (savedData.hasOwnProperty(key)) {
                        const field = mchatForm.querySelector(`[name="${key}"]`);
                        if (field) {
                            if (field.type === 'radio') {
                                const radio = mchatForm.querySelector(`input[name="${key}"][value="${savedData[key]}"]`);
                                if (radio) {
                                    radio.checked = true;
                                }
                            } else {
                                field.value = savedData[key];
                            }
                        }
                    }
                }
                // Atualizar a barra de progresso
                updateProgress();
                // Rolar até o formulário
                mchatForm.scrollIntoView({ behavior: 'smooth' });
            });
        });

        // Script para o botão "Cancelar"
        const cancelButton = document.querySelector('.cancel-button');

        cancelButton.addEventListener('click', function() {
            // Resetar o formulário
            mchatForm.reset();
            // Ocultar o formulário
            mchatForm.style.display = 'none';
            // Resetar a barra de progresso
            progressBar.style.width = '0%';
        });
    </script>
</body>
</html>