<?php
// parcerias.php
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Parcerias - Sistema de Avaliação IFCora</title>
    <!-- Fontes e Ícones -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- CSS Padrão do Sistema -->
    <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">
    <!-- Estilos Específicos para Parcerias -->
    <style>
        /* Estilos específicos para Parcerias */
        .summary-section {
            background-color: #f1f5f9;
            padding: 20px;
            border-radius: 12px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            margin-bottom: 20px;
            display: flex;
            flex-direction: column;
            gap: 15px;
            border: 1px solid #e2e8f0;
        }

        .summary-section h2 {
            font-size: 20px;
            color: #2d3748;
            margin-bottom: 10px;
        }

        /* Formulário de Aceitação de Convite de Parceira */
        #acceptPartnerInviteForm {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        #acceptPartnerInviteForm label {
            font-weight: bold;
        }

        #partnerInviteCodeInput {
            width: 150px;
            padding: 8px 16px;
            border: 2px solid #08C89E;
            border-radius: 8px;
            font-size: 16px;
        }

        /* Detalhes do Convite de Parceira */
        #parceirasInviteDetails {
            display: none;
            background-color: #f7fafc;
            padding: 15px;
            border-radius: 8px;
            border: 1px solid #e2e8f0;
        }

        #parceirasInviteDetails p {
            margin: 5px 0;
            font-size: 14px;
        }

        #parceirasInviteDetails strong {
            color: #2d3748;
        }

        #parceirasInviteDetails button {
            margin-right: 10px;
        }

        /* Seção Histórico de Convites */
        .section .filters {
            display: flex;
            gap: 20px;
            margin-bottom: 20px;
            flex-wrap: wrap;
        }

        .section .filters label {
            font-weight: bold;
            margin-bottom: 5px;
            display: block;
        }

        #inviteHistoryTable {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        #inviteHistoryTable th, #inviteHistoryTable td {
            padding: 10px;
            border-bottom: 1px solid #e2e8f0;
            text-align: left;
            font-size: 14px;
        }

        #inviteHistoryTable th {
            background-color: #f7fafc;
            color: #2d3748;
        }

        .status-aceito {
            color: #4A5568;
            font-weight: bold;
        }

        .status-encerrado {
            color: #FFA500; /* Laranja */
            font-weight: bold;
        }

        .action-icons button {
            background: transparent;
            border: none;
            cursor: pointer;
            padding: 4px;
            font-size: 16px;
            color: #4A5568;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .action-icons button:hover {
            color: #08C89E;
        }

        /* Botões */
        .btn.save {
            background-color: #08C89E;
            color: #fff;
            border: none;
            padding: 10px 20px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            margin-bottom: 20px;
        }

        .btn.save:hover {
            background-color: #06b287;
        }

        .btn.excluir {
            background-color: #E53E3E;
            color: #fff;
            border: none;
            padding: 6px 12px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
        }

        .btn.excluir:hover {
            background-color: #c53030;
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-painel-profissional-profissionais-3.php'; ?>

    <!-- Conteúdo Principal -->
    <main class="content">
        <div class="header-content" >
            <h1 style="color: #08C89E; margin-left: 0px"><i class="fas fa-handshake" style="margin-right: 8px"></i>Parcerias</h1>
                            <p style="margin-top: -5px">Insira o código de convite para se juntar a outra clínica como convidado.</p>

        </div>
            
        <div class="tabs-container">
    
            <!-- Seção de Aceitação de Convite -->
            <div class="summary-section">
                <form id="acceptPartnerInviteForm">
                    <label for="partnerInviteCodeInput">Digite o código de convite:</label>
                    <input type="text" id="partnerInviteCodeInput" required placeholder="ABC123">
                    <button type="submit" class="btn save" style="margin-bottom: 0px">Carregar Convite</button>
                </form>
    
                <div id="parceirasInviteDetails" style="display: none;">
                    <hr />
                    <p style="margin-top: 0px; margin-bottom: 0px;">Convite para a clínica: <strong id="parceirasClinicName"></strong></p>
                    <p>Convite enviado por: <strong id="parceirasInviterName"></strong></p>
                    <p style="margin-top: 0px;">Perfil atribuído: <strong>Colaborador</strong></p>
                    <div style="display: flex; align-items: center; margin-top: 10px;">
                        <button class="btn save" id="parceirasAcceptButton">Confirmar Convite</button>
                        <button class="btn excluir" id="parceirasDeclineButton">Cancelar</button>
                    </div>
                </div>
            </div>
            <hr />
    
            <!-- Seção Histórico de Convites -->
            <div class="section">
                <div class="filters">
                    <div>
                        <label for="clinicFilterParceirasHistory">Selecione a Clínica:</label>
                        <select id="clinicFilterParceirasHistory" style="width: 200px;">
                            <option value="">Todas</option>
                            <option value="Clínica Sertãozinho">Clínica Sertãozinho</option>
                            <option value="Clínica Central">Clínica Central</option>
                            <option value="Clínica do Norte">Clínica do Norte</option>
                        </select>
                    </div>
                    <div>
                        <label for="searchParceirasHistoryName">Pesquisar por Nome (Administrador):</label>
                        <input type="text" id="searchParceirasHistoryName" placeholder="Nome do administrador..." style="width: 300px;">
                    </div>
                </div>
                <table id="inviteHistoryTable" class="table-section">
                    <thead>
                        <tr>
                            <th>ID da Clínica</th>
                            <th>Nome da Clínica</th>
                            <th>Administrador</th>
                            <th>Meu Perfil</th>
                            <th>Status</th>
                            <th>#</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Histórico via JS -->
                    </tbody>
                </table>
            </div>
        </div>
    </main>

    <!-- Scripts Específicos para Parcerias -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Dados Iniciais (Em uma aplicação real, estes dados seriam provenientes do backend)
            let professionals = [
                { name: 'Mariana Santos', profession: 'Fonoaudióloga', email: 'mariana.santos@example.com', clinic: 'Clínica Sertãozinho', perfil: 'Administrador', status: 'Ativo', code: 'PRF001' },
                // ... outros profissionais
            ];

            let pendingInvites = [
                { id: 'INV001', name: 'Ana Silva', email: 'ana.silva@example.com', clinic: 'Clínica Sertãozinho', perfil: 'Colaborador', code: 'ABC123', status: 'Pendente' },
                // ... outros convites
            ];

            let inviteHistory = [
            { clinicId: 'CL001', clinicName: 'Clínica Sertãozinho', administrator: 'José Almeida', perfil: 'Administrador', status: 'Aceito', date: '01/10/2023' },
            { clinicId: 'CL002', clinicName: 'Clínica Central', administrator: 'Luiz Gustavo', perfil: 'Administrador', status: 'Aceito', date: '20/10/2023' },
            { clinicId: 'CL003', clinicName: 'Clínica do Norte', administrator: 'Maria Fernanda', perfil: 'Administrador', status: 'Encerrado', date: '25/10/2023' },
            { clinicId: 'CL003', clinicName: 'Clínica do Norte', administrator: 'Ana Paula', perfil: 'Colaborador', status: 'Aceito', date: '05/11/2023' },
        ];

            // Função para atualizar a tabela de histórico de convites
            function updateInviteHistoryTable() {
                const clinicFilter = document.getElementById('clinicFilterParceirasHistory').value;
                const searchNameFilter = document.getElementById('searchParceirasHistoryName').value.toLowerCase();

                const tableBody = document.querySelector('#inviteHistoryTable tbody');
                tableBody.innerHTML = '';

                const filtered = inviteHistory.filter(invite => {
                    const matchClinic = !clinicFilter || invite.clinicName === clinicFilter;
                    const matchName = invite.administrator.toLowerCase().includes(searchNameFilter) ||
                                      invite.clinicName.toLowerCase().includes(searchNameFilter);
                    return matchClinic && matchName;
                });

                filtered.forEach(invite => {
                    let actionButton = '';
                    if (invite.status === 'Aceito') {
                        actionButton = `<button class="btn encerrar" onclick="encerrarConvite('${invite.clinicId}')">
                                            <i class="fas fa-stop-circle" title="Encerrar Convite"></i></button>`;
                    } else if (invite.status === 'Encerrado') {
                        actionButton = `<button class="btn encerrar" onclick="excluirConvite('${invite.clinicId}')">
                                            <i class="fas fa-trash-alt" title="Excluir Convite"></i>
                                        </button>`;
                    }

                    const statusClass = invite.status.toLowerCase();

                    const row = document.createElement('tr');
                    
                    row.innerHTML = `
                        <td>${invite.clinicId}</td>
                        <td>${invite.clinicName}</td>
                        <td class="admin-name">${invite.administrator}</td>
                        <td>${invite.perfil}</td> <!-- Exibir Perfil -->
                        <td class="status-${statusClass}">${invite.status}</td>
                        <td class="action-icons">
                            ${actionButton}
                        </td>
                    `;
                    tableBody.appendChild(row);
                });
            }

            // Eventos de filtro
            document.getElementById('clinicFilterParceirasHistory').addEventListener('change', updateInviteHistoryTable);
            document.getElementById('searchParceirasHistoryName').addEventListener('input', updateInviteHistoryTable);
            updateInviteHistoryTable();

            // Função para encerrar convite
            window.encerrarConvite = function(clinicId) {
                if(confirm('Tem certeza que deseja encerrar este convite?')) {
                    const invite = inviteHistory.find(inv => inv.clinicId === clinicId && inv.status === 'Aceito');
                    if(invite) {
                        invite.status = 'Encerrado';
                        invite.date = new Date().toLocaleDateString();
                        updateInviteHistoryTable();
                        alert('Convite encerrado com sucesso.');
                    }
                }
            }
            
            // Função para excluir convite do histórico
            window.excluirConvite = function(clinicId) {
                if(confirm('Tem certeza que deseja excluir este convite?')) {
                    inviteHistory = inviteHistory.filter(inv => inv.clinicId !== clinicId);
                    updateInviteHistoryTable();
                    alert('Convite excluído com sucesso.');
                }
            }

            // Função para gerar ID da Clínica baseado no nome (Exemplo Simples)
            function generateClinicId(clinicName) {
                const clinicIds = {
                    'Clínica Sertãozinho': 'CL001',
                    'Clínica Central': 'CL002',
                    'Clínica do Norte': 'CL003'
                };
                return clinicIds[clinicName] || 'CL000';
            }

            // Função para obter o Administrador baseado no nome da clínica (Exemplo Simples)
            function getAdministrator(clinicName) {
                const administrators = {
                    'Clínica Sertãozinho': 'José Almeida',
                    'Clínica Central': 'Luiz Gustavo',
                    'Clínica do Norte': 'Maria Fernanda'
                };
                return administrators[clinicName] || 'Administrador Desconhecido';
            }

            // Modal de Aceitação de Convite
            const acceptPartnerInviteForm = document.getElementById('acceptPartnerInviteForm');
            const partnerInviteCodeInput = document.getElementById('partnerInviteCodeInput');
            const parceirasInviteDetails = document.getElementById('parceirasInviteDetails');
            const parceirasClinicName = document.getElementById('parceirasClinicName');
            const parceirasInviterName = document.getElementById('parceirasInviterName');
            const parceirasAcceptButton = document.getElementById('parceirasAcceptButton');
            const parceirasDeclineButton = document.getElementById('parceirasDeclineButton');

            let currentInvite = null;

            // Manipulação do Formulário de Aceitação de Convite
            acceptPartnerInviteForm.addEventListener('submit', function(event) {
                event.preventDefault();
                const codeInput = partnerInviteCodeInput.value.toUpperCase();

                const invite = pendingInvites.find(inv => inv.code === codeInput && inv.status === 'Pendente');
                if(invite) {
                    parceirasClinicName.textContent = invite.clinic;
                    parceirasInviterName.textContent = invite.name;
                    parceirasInviteDetails.style.display = 'block';
                    currentInvite = invite;
                } else {
                    alert('Convite não encontrado ou já processado.');
                    parceirasInviteDetails.style.display = 'none';
                    currentInvite = null;
                }
            });

            // Aceitar Convite de Parceria
            parceirasAcceptButton.addEventListener('click', function() {
                if(currentInvite) {
                    currentInvite.status = 'Aceito';
                    currentInvite.date = new Date().toLocaleDateString();
                    
                    // Adicionar ao Histórico de Convites
                    inviteHistory.push({
                        clinicId: generateClinicId(currentInvite.clinic),
                        clinicName: currentInvite.clinic,
                        administrator: getAdministrator(currentInvite.clinic),
                        perfil: currentInvite.perfil, // Adicionar perfil ao histórico
                        status: 'Aceito',
                        date: currentInvite.date
                    });

                    // Adicionar ao Profissionais
                    const newProfessionalCode = generateProfessionalCode(professionals.length);
                    const newProfessional = {
                        name: currentInvite.name,
                        profession: 'Profissão Indefinida', // Você pode ajustar isso conforme necessário
                        email: currentInvite.email,
                        clinic: currentInvite.clinic,
                        perfil: currentInvite.perfil,
                        status: 'Ativo',
                        code: newProfessionalCode
                    };
                    professionals.push(newProfessional);

                    // Remover do Convites Pendentes
                    pendingInvites = pendingInvites.filter(inv => inv !== currentInvite);
                    
                    // Atualizar Tabelas
                    updatePendingInvitesTable();
                    updateInviteHistoryTable();
                    // Atualizar profissionais.php também se necessário
                    // Dependendo de como o sistema é estruturado, isso pode exigir uma chamada ao backend

                    // Resetar Formulário e Estado
                    parceirasInviteDetails.style.display = 'none';
                    acceptPartnerInviteForm.reset();
                    currentInvite = null;

                    alert('Convite aceito e profissional adicionado com sucesso!');
                }
            });

            // Cancelar Aceitação de Convite de Parceria
            parceirasDeclineButton.addEventListener('click', function() {
                if(currentInvite) {
                    // Apenas cancelar a operação sem alterar registros
                    parceirasInviteDetails.style.display = 'none';
                    acceptPartnerInviteForm.reset();
                    currentInvite = null;
                    alert('Operação cancelada.');
                }
            });
        });
    </script>
</body>
</html>
