<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Super Admin - Suporte & Segurança</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">
    <style>
        .section {
            background:#fff;
            border:1px solid #e2e8f0;
            border-radius:12px;
            padding:20px;
            margin-bottom:20px;
        }

        .section h3 {
            font-size:18px;
            color:#2d3748;
            margin-top:-5px;
        }

        table {
            width:100%;
            border-collapse:collapse;
            margin-top:10px;
        }
        th,td {
            text-align:left;
            padding:10px;
            border-bottom:1px solid #e2e8f0;
            font-size:14px;
        }
        th {
            background:#f7fafc;
            color:#2d3748;
        }
        tr:hover {
            background:#f1f5f9;
        }

        .btn-resolve {
            background-color:#08C89E;
            color:#fff;
            border:none;
            border-radius:6px;
            padding:5px 10px;
            cursor:pointer;
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-superadmin.php'; ?>

    <main class="content">
        <div class="header-content">
            <h1 style="color:#08C89E;">Suporte, Segurança & Compliance</h1>
        </div>
        <p style="margin-top:-20px; margin-bottom:20px;">Gerencie tickets de suporte, segurança do sistema e conformidade com normas.</p>

        <div class="section">
            <h3>Central de Suporte</h3>
            <p>Abaixo, os tickets abertos pelos usuários.</p>
            <table>
                <thead>
                    <tr>
                        <th>ID do Ticket</th>
                        <th>Usuário</th>
                        <th>Assunto</th>
                        <th>Data Abertura</th>
                        <th>Status</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>#TCK001</td>
                        <td>mariana.santos@example.com</td>
                        <td>Problema no login</td>
                        <td>20/11/2024</td>
                        <td>Aberto</td>
                        <td><button class="btn-resolve">Resolver</button></td>
                    </tr>
                    <tr>
                        <td>#TCK002</td>
                        <td>ana.paula@example.com</td>
                        <td>Não consigo acessar relatório</td>
                        <td>21/11/2024</td>
                        <td>Em Análise</td>
                        <td><button class="btn-resolve">Resolver</button></td>
                    </tr>
                </tbody>
            </table>
        </div>

        <div class="section">
            <h3>Segurança e Auditoria</h3>
            <p>Monitoramento de tentativas de acesso e logs de auditoria do sistema.</p>
            <table>
                <thead>
                    <tr>
                        <th>ID Log</th>
                        <th>Usuário</th>
                        <th>Ação</th>
                        <th>Data/Hora</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>#LG001</td>
                        <td>mariana.santos@example.com</td>
                        <td>Login Bem-Sucedido</td>
                        <td>22/11/2024 10:00</td>
                        <td>OK</td>
                    </tr>
                    <tr>
                        <td>#LG002</td>
                        <td>ipsum@invalido.com</td>
                        <td>Tentativa de Acesso</td>
                        <td>22/11/2024 10:05</td>
                        <td>Falha</td>
                    </tr>
                </tbody>
            </table>
        </div>

        <div class="section">
            <h3>Políticas e Termos</h3>
            <p>Aqui é possível atualizar termos de uso, políticas de privacidade e gerenciar consentimentos.</p>
            <button class="btn save">Atualizar Termos</button>
        </div>

    </main>
</body>
</html>
