<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Super Admin - Gestão de Usuários</title>
    <!-- Fontes e Ícones -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- CSS Global do Projeto (Exemplo) -->
    <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f4f8;
            margin: 0;
            padding: 0;
        }
        .content {
            padding: 20px;
        }
        .header-content h1 {
            color: #08C89E;
            margin-top: -20px;
            font-size: 24px;
        }

        /* Barra de status / mensagem */
        .status-message {
            background-color: #48BB78;
            color: #fff;
            padding: 10px;
            margin-bottom: 20px;
            border-radius: 8px;
            display: none;
            transition: opacity 0.3s ease;
        }
        .status-error {
            background-color: #E53E3E !important;
        }

        /* Container principal */
        .partnership-management {
            background-color: #FFFFFF;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }

        /* Filtros */
        .filters {
            display: flex;
            align-items: flex-end;
            gap: 20px;
            flex-wrap: wrap;
            margin-bottom: 20px;
        }

        .filters .filter-group {
            display: flex;
            flex-direction: column;
        }

        .filters label {
            font-size:14px;
            font-weight:600;
            margin-bottom:5px;
            color:#2d3748;
        }

        .filters select, .filters input {
            padding:8px 12px;
            border:1px solid #e2e8f0;
            border-radius:8px;
            font-size:14px;
            width:250px;
            transition: border-color 0.3s ease;
        }

        .filters select:focus, .filters input:focus {
            border-color: #08C89E;
            outline: none;
        }

        .filters .btn {
            padding:8px 16px;
            background-color:#08C89E;
            color:#fff;
            border:none;
            border-radius:8px;
            cursor:pointer;
            font-size:14px;
            transition: background-color 0.3s ease;
        }
        .filters .btn:hover {
            background-color: #06a08a;
        }

        /* Tabela de Usuários */
        table {
            width:100%;
            border-collapse:collapse;
            margin-bottom:20px;
        }
        th,td {
            text-align:left;
            padding:10px;
            border-bottom:1px solid #e2e8f0;
            font-size:14px;
            cursor:default;
        }
        th {
            background:#f7fafc;
            color:#2d3748;
        }
        tr:hover {
            background:#f1f5f9;
        }

        /* Botões de ação */
        .btn-action {
            padding:5px 10px;
            border:none;
            border-radius:5px;
            cursor:pointer;
            font-size:12px;
            margin:0 5px;
            transition: background-color 0.3s ease;
            color:#fff;
        }
        .btn-gerenciar {
            background-color:#3182ce;
        }
        .btn-gerenciar:hover {
            background-color:#2c5282;
        }
        .btn-clinicas {
            background-color:#38A169;
        }
        .btn-clinicas:hover {
            background-color:#2F855A;
        }
        .btn-logins {
            background-color:#ED8936;
        }
        .btn-logins:hover {
            background-color:#DD6B20;
        }

        /* Paginação */
        .pagination {
            margin-top:20px;
            display:flex;
            gap:10px;
        }
        .pagination button {
            background:#fff;
            border:1px solid #e2e8f0;
            border-radius:5px;
            padding:5px 10px;
            cursor:pointer;
            transition: background-color 0.3s ease;
        }
        .pagination button.active {
            background:#08C89E;
            color:#fff;
        }
        .pagination button:hover:not(.active) {
            background:#cceaf5;
        }

        /* Modal */
        .modal-overlay {
            display:none;
            position:fixed;
            top:0;left:0;right:0;bottom:0;
            background:rgba(0,0,0,0.5);
            z-index:9999;
            justify-content:center;
            align-items:center;
        }
        .modal-container {
            background:#fff;
            border-radius:10px;
            padding:20px;
            width:90%;
            max-width:600px;
            box-shadow:0 2px 10px rgba(0,0,0,0.2);
            position:relative;
            animation: fadeIn 0.3s ease-in-out;
        }
        .modal-container h2 {
            font-size:20px;
            color:#08C89E;
            margin-bottom:10px;
        }
        .modal-container .close-modal {
            position:absolute;
            right:20px;
            top:20px;
            font-size:24px;
            cursor:pointer;
            color:#aaa;
            transition: color 0.3s ease;
        }
        .modal-container .close-modal:hover {
            color:#333;
        }
        .modal-container p {
            margin-bottom:5px;
            font-size:14px;
        }
        .modal-container .section-title {
            font-size:16px;
            color:#2d3748;
            margin:15px 0 5px;
            border-bottom:1px solid #e2e8f0;
            padding-bottom:5px;
        }
        .modal-container .user-actions {
            margin-top:20px;
            display:flex;
            justify-content:flex-end;
            gap:10px;
        }

        /* Alert */
        .alert {
            background:#48BB78;
            color:#fff;
            padding:10px 15px;
            border-radius:8px;
            position:fixed;
            top:20px;right:20px;
            box-shadow:0 2px 6px rgba(0,0,0,0.2);
            display:none;
            animation: fadeIn 0.3s ease-in-out;
        }
        .alert.error {
            background:#E53E3E;
        }

        @keyframes fadeIn {
            from {opacity:0;transform:translateY(-10px);}
            to {opacity:1;transform:translateY(0);}
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-superadmin-usuarios.php'; ?>

    <main class="content">
        <div class="header-content">
            <h1 style="color:#08C89E;">Gestão de Usuários</h1>
        </div>

        <div class="partnership-management">
            <p style="margin-top:-20px; margin-bottom:20px;">Acompanhe e gerencie todos os usuários do sistema com recursos avançados.</p>
            <hr />
            <!-- Filtros -->
            <div class="filters">
                <div class="filter-group" style="width:100px;">
                    <label for="filterNameEmail">Código:</label>
                    <input type="text" id="filterNameEmail" placeholder="Ex: PRA001">
                </div>
                <div class="filter-group">
                    <label for="filterNameEmail">Nome do Profissional ou Email</label>
                    <input type="text" id="filterNameEmail" placeholder="Pesquisar por Nome ou Email">
                </div>
                <div class="filter-group" style="width:200px;">
                    <label for="filterProfile">Filtrar Perfil:</label>
                    <select id="filterProfile">
                        <option value="">Perfil</option>
                        <option value="Profissional">Profissional/Empresa</option>
                        <option value="Responsável (Pais)">Responsável (Pais)</option>
                        <option value="Assistente">Assistente</option>
                    </select>
                </div>    
                <div class="filter-group" style="display:none; width:100px;">
                    <label for="filterStatus">Status</label>
                    <select id="filterStatus">
                        <option value="">Status</option>
                        <option value="Ativo">Ativo</option>
                        <option value="Inativo">Inativo</option>
                    </select>
                </div>
                <button class="btn" id="applyFilters">Aplicar Filtros</button>
            </div>

            <!-- Tabela de Usuários -->
            <table id="usersTable">
                <thead>
                    <tr>
                        <th>ORD</th>
                        <th>Código</th>
                        <th>Nome</th>
                        <th>Email</th>
                        <th>Perfil</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- Linhas simuladas via JS -->
                </tbody>
            </table>

            <div class="pagination" id="pagination">
                <!-- Botões de paginação gerados via JS -->
            </div>
        </div>
    </main>

    <!-- Modal Detalhes do Usuário -->
    <div class="modal-overlay" id="userModalOverlay">
        <div class="modal-container">
            <span class="close-modal" id="closeUserModal">&times;</span>
            <h2>Detalhes do Usuário</h2>
            <p><b>ID:</b> <span id="modalUserId">USR001</span></p>
            <p><b>Nome:</b> <span id="modalUserName">Mariana Santos</span></p>
            <p><b>Email:</b> <span id="modalUserEmail">mariana.santos@example.com</span></p>
            <p><b>Perfil:</b> <span id="modalUserPerfil">Profissional</span></p>
            <p><b>Status:</b> <span id="modalUserStatus">Ativo</span></p>

            <div class="section-title">Clínicas Vinculadas</div>
            <table style="width:100%; border-collapse:collapse; margin-bottom:15px;">
                <thead>
                    <tr>
                        <th style="text-align:left; padding:8px; border-bottom:1px solid #e2e8f0;">ID da Clínica</th>
                        <th style="text-align:left; padding:8px; border-bottom:1px solid #e2e8f0;">Nome da Clínica</th>
                        <th style="text-align:left; padding:8px; border-bottom:1px solid #e2e8f0;">Localização</th>
                        <th style="text-align:left; padding:8px; border-bottom:1px solid #e2e8f0;">Vínculo</th>
                        <th style="text-align:left; padding:8px; border-bottom:1px solid #e2e8f0;">Status</th>
                    </tr>
                </thead>
                <tbody id="modalUserClinics">
                    <!-- Clínicas do usuário -->
                    <tr>
                        <td>CL001</td>
                        <td>Clínica Sertãozinho</td>
                        <td>Sertãozinho, SP</td>
                        <td>Admin</td>
                        <td>Ativa</td>
                    </tr>
                    <tr>
                        <td>CL002</td>
                        <td>Clínica Central</td>
                        <td>São Paulo, SP</td>
                        <td>Supervisor</td>
                        <td>Ativa</td>
                    </tr>
                </tbody>
            </table>

            <div class="section-title">Histórico de Logins</div>
            <ul id="modalUserLogins" style="list-style:none; padding-left:0; margin-bottom:15px;">
                <!-- Histórico de login -->
                <li>Login: 22/11 10:00</li>
                <li>Login: 21/11 09:30</li>
            </ul>

            <div class="user-actions">
                <button class="btn-action btn-gerenciar" id="openManageUserModal" title="Gerenciar Usuário"><i class="fas fa-user-edit"></i> Gerenciar</button>
                <button class="btn-action btn-clinicas" id="openClinicsModal" title="Ver Clínicas"><i class="fas fa-list"></i> Clínicas</button>
                <button class="btn-action btn-logins" id="openLoginsModal" title="Histórico de Logins"><i class="fas fa-clock"></i> Logins</button>
            </div>
        </div>
    </div>

    <!-- Modal Gerenciar Usuário -->
    <div class="modal-overlay" id="manageUserModalOverlay">
        <div class="modal-container">
            <span class="close-modal" id="closeManageUserModal">&times;</span>
            <h2>Gerenciar Usuário</h2>
            <form id="manageUserForm">
                <div class="modal-form-group" style="margin-bottom:15px;">
                    <label for="newUserEmail" style="display:block; font-size:14px; font-weight:600; color:#2d3748; margin-bottom:5px;">
                        <i class="fas fa-envelope"></i> Novo Email
                    </label>
                    <input 
                        type="email" 
                        id="newUserEmail" 
                        placeholder="Digite o novo email" 
                        required 
                        style="width:100%; padding:8px 12px; border:1px solid #e2e8f0; border-radius:8px; font-size:14px; color:#2d3748;">
                </div>
                <div class="modal-form-group" style="margin-bottom:15px;">
                    <label for="newUserPassword" style="display:block; font-size:14px; font-weight:600; color:#2d3748; margin-bottom:5px;">
                        <i class="fas fa-key"></i> Redefinir Senha
                    </label>
                    <input 
                        type="password" 
                        id="newUserPassword" 
                        placeholder="Digite a nova senha" 
                        required 
                        style="width:100%; padding:8px 12px; border:1px solid #e2e8f0; border-radius:8px; font-size:14px; color:#2d3748;">
                </div>
                <div class="user-actions">
                    <button type="button" class="btn-action btn-gerenciar" id="cancelManageUserModal" style="background-color:#e53e3e; color:#fff;"><i class="fas fa-times"></i> Cancelar</button>
                    <button type="submit" class="btn-action btn-clinicas" style="background-color:#38A169; color:#fff;"><i class="fas fa-save"></i> Salvar Alterações</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Modal Listagem de Clínicas -->
    <div class="modal-overlay" id="clinicsModalOverlay">
        <div class="modal-container">
            <span class="close-modal" id="closeClinicsModal">&times;</span>
            <h2>Clínicas Vinculadas</h2>
            <table style="width:100%; border-collapse:collapse; margin-bottom:15px;">
                <thead>
                    <tr>
                        <th style="text-align:left; padding:8px; border-bottom:1px solid #e2e8f0;">ID da Clínica</th>
                        <th style="text-align:left; padding:8px; border-bottom:1px solid #e2e8f0;">Nome da Clínica</th>
                        <th style="text-align:left; padding:8px; border-bottom:1px solid #e2e8f0;">Localização</th>
                        <th style="text-align:left; padding:8px; border-bottom:1px solid #e2e8f0;">Vínculo</th>
                        <th style="text-align:left; padding:8px; border-bottom:1px solid #e2e8f0;">Status</th>
                    </tr>
                </thead>
                <tbody id="clinicsModalContent">
                    <!-- Clínicas vinculadas -->
                    <tr>
                        <td>CL001</td>
                        <td>Clínica Sertãozinho</td>
                        <td>Sertãozinho, SP</td>
                        <td>Admin</td>
                        <td>Ativa</td>
                    </tr>
                    <tr>
                        <td>CL002</td>
                        <td>Clínica Central</td>
                        <td>São Paulo, SP</td>
                        <td>Supervisor</td>
                        <td>Ativa</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Modal Histórico de Logins -->
    <div class="modal-overlay" id="loginsModalOverlay">
        <div class="modal-container">
            <span class="close-modal" id="closeLoginsModal">&times;</span>
            <h2>Histórico de Logins</h2>
            <ul id="loginsModalContent" style="list-style:none; padding-left:0; margin-bottom:15px;">
                <!-- Histórico de logins -->
                <li>Login: 22/11 10:00</li>
                <li>Login: 21/11 09:30</li>
            </ul>
        </div>
    </div>

    <!-- Alert -->
    <div class="alert" id="alertBox"></div>

    <script>
        // Dados simulados com 'clinics' como array de objetos com detalhes e vínculo
        let users = [
            {
                ORD: '1',
                id: 'USR001',
                name: 'Mariana Santos',
                email: 'mariana.santos@example.com',
                perfil: 'Profissional',
                clinics: [
                    {id: 'CL001', name: 'Clínica Sertãozinho', location: 'Sertãozinho, SP', status: 'Ativa', role: 'Admin'},
                    {id: 'CL002', name: 'Clínica Central', location: 'São Paulo, SP', status: 'Ativa', role: 'Supervisor'}
                ],
                status: 'Ativo',
                logins: ['22/11 10:00','21/11 09:30']
            },
            {
                id: 'USR002',
                 ORD: '2',
                name: 'Ana Paula',
                email: 'ana.paula@example.com',
                perfil: 'Responsável (Pais)',
                clinics: [
                    {id: 'CL003', name: 'Clínica do Norte', location: 'Manaus, AM', status: 'Inativa', role: 'Colaborador'}
                ],
                status: 'Inativo',
                logins: ['20/11 08:00']
            },
            {
                id: 'USR003',
                 ORD: '3',
                name: 'Felipe Costa',
                email: 'felipe.costa@example.com',
                perfil: 'Assistente',
                clinics: [],
                status: 'Ativo',
                logins: ['22/11 11:00','21/11 11:00','20/11 07:45']
            },
            {
                id: 'USR004',
                 ORD: '4',
                name: 'Camila Rocha',
                email: 'camila.rocha@example.com',
                perfil: 'Profissional',
                clinics: [
                    {id: 'CL004', name: 'Clínica Exemplo 1', location: 'Curitiba, PR', status: 'Ativa', role: 'Co-Admin'},
                    {id: 'CL005', name: 'Clínica Exemplo 2', location: 'Porto Alegre, RS', status: 'Ativa', role: 'Supervisor'},
                    {id: 'CL006', name: 'Clínica Exemplo 3', location: 'Belo Horizonte, MG', status: 'Ativa', role: 'Admin'}
                ],
                status: 'Inativo',
                logins: ['19/11 15:00']
            },
            {
                id: 'USR005',
                 ORD: '5',
                name: 'Juliana Lima',
                email: 'juliana.lima@example.com',
                perfil: 'Responsável (Pais)',
                clinics: [
                    {id: 'CL007', name: 'Clínica Exemplo 4', location: 'Rio de Janeiro, RJ', status: 'Ativa', role: 'Colaborador'}
                ],
                status: 'Ativo',
                logins: ['22/11 09:00']
            },
            {
                id: 'USR006',
                 ORD: '6',
                name: 'Ricardo Pinto',
                email: 'ricardo.pinto@example.com',
                perfil: 'Assistente',
                clinics: [
                    {id: 'CL008', name: 'Clínica Exemplo 5', location: 'Florianópolis, SC', status: 'Ativa', role: 'Co-Admin'},
                    {id: 'CL009', name: 'Clínica Exemplo 6', location: 'Salvador, BA', status: 'Ativa', role: 'Supervisor'}
                ],
                status: 'Ativo',
                logins: ['21/11 20:00','20/11 10:00']
            },
        ];

        let currentPage = 1;
        const perPage = 5;

        const usersTableBody = document.querySelector('#usersTable tbody');
        const pagination = document.getElementById('pagination');
        const alertBox = document.getElementById('alertBox');

        function renderUsers() {
            // Aplicar filtros
            const nameEmailFilter = document.getElementById('filterNameEmail').value.toLowerCase();
            const profileFilter = document.getElementById('filterProfile').value;
            const statusFilter = document.getElementById('filterStatus').value;

            let filtered = users.filter(u=>{
                const matchNameEmail = u.name.toLowerCase().includes(nameEmailFilter) || u.email.toLowerCase().includes(nameEmailFilter);
                const matchProfile = !profileFilter || u.perfil === profileFilter;
                const matchStatus = !statusFilter || u.status === statusFilter;
                return matchNameEmail && matchProfile && matchStatus;
            });

            // Paginação
            const total = filtered.length;
            const totalPages = Math.ceil(total/perPage);
            if(currentPage > totalPages && totalPages > 0) currentPage = totalPages;
            const start = (currentPage-1)*perPage;
            const end = start+perPage;
            const pageData = filtered.slice(start,end);

            usersTableBody.innerHTML = '';
            pageData.forEach(u=>{
                const tr = document.createElement('tr');
                tr.innerHTML = `
                    <td>${u.ORD}</td>
                    <td>${u.id}</td>
                    <td>${u.name}</td>
                    <td>${u.email}</td>
                    <td>${u.perfil}</td>
                    <td>
                        <button class="btn-action btn-gerenciar" data-id="${u.id}" title="Gerenciar Usuário"><i class="fas fa-user-edit"></i></button>
                        <button class="btn-action btn-clinicas" data-id="${u.id}" title="Ver Clínicas"><i class="fas fa-list"></i></button>
                        <button class="btn-action btn-logins" data-id="${u.id}" title="Histórico de Logins"><i class="fas fa-clock"></i></button>
                    </td>
                `;
                usersTableBody.appendChild(tr);
            });

            renderPagination(totalPages);
        }

        function renderPagination(totalPages) {
            pagination.innerHTML='';
            for(let i=1; i<=totalPages; i++){
                const btn = document.createElement('button');
                btn.textContent = i;
                if(i===currentPage) btn.classList.add('active');
                btn.addEventListener('click', ()=>{
                    currentPage = i;
                    renderUsers();
                });
                pagination.appendChild(btn);
            }
        }

        // Aplicar filtros
        document.getElementById('applyFilters').addEventListener('click',()=>{
            currentPage=1;
            renderUsers();
        });

        // Modal de detalhes
        const userModalOverlay = document.getElementById('userModalOverlay');
        const closeUserModal = document.getElementById('closeUserModal');
        const modalUserId = document.getElementById('modalUserId');
        const modalUserName = document.getElementById('modalUserName');
        const modalUserEmail = document.getElementById('modalUserEmail');
        const modalUserPerfil = document.getElementById('modalUserPerfil');
        const modalUserStatus = document.getElementById('modalUserStatus');
        const modalUserClinics = document.getElementById('modalUserClinics');
        const modalUserLogins = document.getElementById('modalUserLogins');
        const modalActivateBtn = document.getElementById('modalActivateBtn');
        const modalDeactivateBtn = document.getElementById('modalDeactivateBtn');

        // Modals adicionais
        const manageUserModalOverlay = document.getElementById('manageUserModalOverlay');
        const closeManageUserModal = document.getElementById('closeManageUserModal');
        const manageUserForm = document.getElementById('manageUserForm');
        const cancelManageUserModal = document.getElementById('cancelManageUserModal');

        const clinicsModalOverlay = document.getElementById('clinicsModalOverlay');
        const closeClinicsModal = document.getElementById('closeClinicsModal');
        const clinicsModalContent = document.getElementById('clinicsModalContent');

        const loginsModalOverlay = document.getElementById('loginsModalOverlay');
        const closeLoginsModal = document.getElementById('closeLoginsModal');
        const loginsModalContent = document.getElementById('loginsModalContent');

        // Eventos de abertura dos modals
        document.body.addEventListener('click',(e)=>{
            const target = e.target.closest('button');
            if(target){
                const id = target.dataset.id;
                if(target.classList.contains('btn-gerenciar')) {
                    openManageUserModal(id);
                }
                if(target.classList.contains('btn-clinicas')) {
                    openClinicsModal(id);
                }
                if(target.classList.contains('btn-logins')) {
                    openLoginsModal(id);
                }
            }
        });

        // Fechar o modal de detalhes
        closeUserModal.addEventListener('click',()=>{
            userModalOverlay.style.display='none';
        });

        // Fechar o modal de gerenciamento
        closeManageUserModal.addEventListener('click',()=>{
            manageUserModalOverlay.style.display='none';
        });
        cancelManageUserModal.addEventListener('click',()=>{
            manageUserModalOverlay.style.display='none';
        });

        // Fechar os modals adicionais
        closeClinicsModal.addEventListener('click',()=>{
            clinicsModalOverlay.style.display='none';
        });
        closeLoginsModal.addEventListener('click',()=>{
            loginsModalOverlay.style.display='none';
        });

        // Fechar os modals ao clicar fora
        window.addEventListener('click',(e)=>{
            if(e.target===userModalOverlay) {
                userModalOverlay.style.display='none';
            }
            if(e.target===manageUserModalOverlay) {
                manageUserModalOverlay.style.display='none';
            }
            if(e.target===clinicsModalOverlay) {
                clinicsModalOverlay.style.display='none';
            }
            if(e.target===loginsModalOverlay) {
                loginsModalOverlay.style.display='none';
            }
        });

        function openUserModal(id) {
            const u = users.find(x=>x.id===id);
            if(!u) return;
            modalUserId.textContent=u.id;
            modalUserName.textContent=u.name;
            modalUserEmail.textContent=u.email;
            modalUserPerfil.textContent=u.perfil;
            modalUserStatus.textContent=u.status;

            // Listar clínicas vinculadas com nomes reais e vínculos
            modalUserClinics.innerHTML='';
            if(u.clinics.length > 0){
                u.clinics.forEach(clinic=>{
                    const tr = document.createElement('tr');
                    tr.innerHTML = `
                        <td>${clinic.id}</td>
                        <td>${clinic.name}</td>
                        <td>${clinic.location}</td>
                        <td>${clinic.role}</td>
                        <td>${clinic.status}</td>
                    `;
                    modalUserClinics.appendChild(tr);
                });
            } else {
                const p = document.createElement('p');
                p.textContent='Nenhuma clínica vinculada.';
                modalUserClinics.appendChild(p);
            }

            // Histórico de logins
            modalUserLogins.innerHTML='';
            if(u.logins.length > 0){
                // Exibir apenas o último acesso
                const lastLogin = u.logins[u.logins.length - 1];
                const li=document.createElement('li');
                li.textContent='Último Login: '+lastLogin;
                modalUserLogins.appendChild(li);
            } else {
                const li=document.createElement('li');
                li.textContent='Nenhum login registrado.';
                modalUserLogins.appendChild(li);
            }

            // Ajustar botões Ativar/Desativar
            if(u.status==='Ativo') {
                modalActivateBtn.style.display='none';
                modalDeactivateBtn.style.display='inline-block';
            } else {
                modalActivateBtn.style.display='inline-block';
                modalDeactivateBtn.style.display='none';
            }

            modalActivateBtn.onclick=()=>{
                u.status='Ativo';
                showAlert(`Usuário ${u.id} ativado!`,'');
                userModalOverlay.style.display='none';
                renderUsers();
            };
            modalDeactivateBtn.onclick=()=>{
                u.status='Inativo';
                showAlert(`Usuário ${u.id} desativado!`,'');
                userModalOverlay.style.display='none';
                renderUsers();
            };

            userModalOverlay.style.display='flex';
        }

        function openManageUserModal(id) {
            const u = users.find(x=>x.id===id);
            if(!u) return;
            manageUserForm.dataset.id = u.id;
            manageUserForm.reset(); // Limpar campos anteriores
            manageUserModalOverlay.style.display='flex';
        }

        function openClinicsModal(id) {
            const u = users.find(x=>x.id===id);
            if(!u) return;
            clinicsModalContent.innerHTML='';
            if(u.clinics.length > 0){
                u.clinics.forEach(clinic=>{
                    const tr = document.createElement('tr');
                    tr.innerHTML = `
                        <td>${clinic.id}</td>
                        <td>${clinic.name}</td>
                        <td>${clinic.location}</td>
                        <td>${clinic.role}</td>
                        <td>${clinic.status}</td>
                    `;
                    clinicsModalContent.appendChild(tr);
                });
            } else {
                const p = document.createElement('p');
                p.textContent='Nenhuma clínica vinculada.';
                clinicsModalContent.appendChild(p);
            }
            clinicsModalOverlay.style.display='flex';
        }

        function openLoginsModal(id) {
            const u = users.find(x=>x.id===id);
            if(!u) return;
            loginsModalContent.innerHTML='';
            if(u.logins.length > 0){
                // Exibir apenas o último acesso
                const lastLogin = u.logins[u.logins.length - 1];
                const li=document.createElement('li');
                li.textContent='Último Login: '+lastLogin;
                loginsModalContent.appendChild(li);
            } else {
                const li=document.createElement('li');
                li.textContent='Nenhum login registrado.';
                loginsModalContent.appendChild(li);
            }
            loginsModalOverlay.style.display='flex';
        }

        // Gerenciar Usuário - Formulário
        manageUserForm.addEventListener('submit', (e)=>{
            e.preventDefault();
            const id = manageUserForm.dataset.id;
            const newEmail = document.getElementById('newUserEmail').value.trim();
            const newPassword = document.getElementById('newUserPassword').value.trim();

            if(newEmail === '' || newPassword === ''){
                showAlert('Todos os campos são obrigatórios.', 'error');
                return;
            }

            // Atualizar dados (simulado)
            const user = users.find(u=>u.id === id);
            if(user){
                user.email = newEmail;
                // Senha seria atualizada no back-end
                showAlert(`Usuário ${id} atualizado com sucesso!`);
                manageUserModalOverlay.style.display='none';
                renderUsers();
            } else {
                showAlert('Usuário não encontrado.', 'error');
            }
        });

        function showAlert(msg, type) {
            alertBox.textContent=msg;
            alertBox.classList.remove('error');
            if(type==='error') {
                alertBox.classList.add('error');
            }
            alertBox.style.display='block';
            setTimeout(()=>{
                alertBox.style.display='none';
            },3000);
        }

        renderUsers();
    </script>
</body>
</html>
