<?php

$apiKey = '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';
$endpoint = 'https://api.openai.com/v1/chat/completions';

// Função para gerar a interpretação com base no enunciado
function gerarInterpretacao($enunciado) {
    global $apiKey, $endpoint;

    // Formule o prompt com os dados do enunciado
    $prompt = "Tenho um enunciado estruturado com os seguintes campos:\n\n".
    "- NOME DA TAREFA: " . $enunciado['nome_tarefa'] . "\n".
    "- RECURSOS MATERIAIS: " . $enunciado['recursos_materiais'] . "\n".
    "- CONDIÇÃO: " . $enunciado['condicao'] . "\n".
    "- RESPOSTA: " . $enunciado['resposta'] . "\n".
    "- CRITÉRIOS: \n  " . $enunciado['criterios'] . "\n\n".
    "Instrução para ChatGPT:\n".
    "Com base nos campos \"RECURSOS MATERIAIS\", \"CONDIÇÃO\", \"RESPOSTA\" e \"CRITÉRIOS\", gere o conteúdo do campo \"INTERPRETAÇÃO:\". ".
    "A interpretação deve ser o mais concisa e objetiva possível. Use no máximo 3 frases curtas para resumir claramente o enunciado.\n\n".
    "Crie a interpretação:";

    // Preparar os dados para a requisição
    $data = [
        'model' => 'gpt-3.5-turbo',
        'messages' => [
            ['role' => 'system', 'content' => 'Você é um assistente útil.'],
            ['role' => 'user', 'content' => $prompt]
        ],
        'max_tokens' => 50,
        'temperature' => 0.7,
    ];

    // Iniciar cURL
    $ch = curl_init($endpoint);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $apiKey,
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

    // Executar a requisição
    $response = curl_exec($ch);

    // Verificar se houve erro na requisição cURL
    if ($response === false) {
        echo 'Erro na requisição cURL: ' . curl_error($ch);
        exit;
    }

    // Verificar o código de status HTTP
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    // Decodificar a resposta JSON
    $responseData = json_decode($response, true);

    if ($httpCode != 200) {
        // Se o código HTTP não for 200 (OK), exibe o erro
        echo "Erro HTTP: $httpCode\n";
        echo "Resposta da API: " . print_r($responseData, true);
        exit;
    }

    // Verifique se a resposta contém a chave esperada
    if (isset($responseData['choices'][0]['message']['content'])) {
        return trim($responseData['choices'][0]['message']['content']);
    } else {
        return 'Erro ao obter resposta do ChatGPT: ' . print_r($responseData, true);
    }
}

// Definir os enunciados em um array
$enunciados = [
    [
        'nome_tarefa' => 'Vocaliza em resposta à atenção do adulto',
        'recursos_materiais' => 'Não exige material.',
        'condicao' => 'Ao alimentar, trocar, acalentar ou colocar a criança no berço ou sentada, o adulto deve manter sua face distante de 20 a 25 cm do rosto da criança, sorrir e falar baixinho por 10 segundos.',
        'resposta' => 'Vocalizar em resposta à atenção = apresentar qualquer tipo de vocalização dentro de 10 segundos após a atenção de um adulto.',
        'criterios' => 'X = Não vocaliza em resposta à atenção do adulto; V = Vocaliza em resposta à atenção do adulto dentro de 10 segundos após o adulto dar atenção à criança; O = Item anulado.'
    ],
    // Adicione mais enunciados aqui se necessário
    [
        'nome_tarefa' => 'Sorriso em resposta a estímulos',
        'recursos_materiais' => 'Não exige material.',
        'condicao' => 'O adulto deve sorrir para a criança enquanto interage de forma calma e atenta por 5 segundos.',
        'resposta' => 'A criança deve sorrir em resposta ao adulto dentro de 5 segundos.',
        'criterios' => 'X = Não sorri em resposta ao estímulo do adulto; V = Sorri em resposta ao estímulo do adulto dentro de 5 segundos; O = Item anulado.'
    ]
];

// Gerar e exibir as interpretações para todos os enunciados
foreach ($enunciados as $enunciado) {
    echo "INTERPRETAÇÃO para " . $enunciado['nome_tarefa'] . ":\n";
    echo gerarInterpretacao($enunciado) . "\n\n";
}
?>
