<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8" />
    <title>Avaliações - Sistema IFCora</title>
    <!-- Fonte e Ícones -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

    <!-- Bootstrap -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">

    <!-- CSS Personalizado -->
        <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">

    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f9fafb;
            color: #2d3748;
        }

        .container-page {
            margin-top: 60px;
            margin-left: 220px;
            padding: 20px;
        }

        h1 {
            color: #08C89E;
            font-size: 24px;
            margin-bottom: 20px;
        }

        

        /* Tabela de Avaliações */
        .evaluations-table {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
        }

        .evaluations-table table {
            width: 100%;
        }

        .evaluations-table th, .evaluations-table td {
            text-align: center;
            vertical-align: middle;
        }

        .evaluations-table th {
            background-color: #f7fafc;
            color: #2d3748;
        }

        /* Botões de Ação */
        .action-btn {
            background-color: #08C89E;
            color: #fff;
            border: none;
            border-radius: 6px;
            padding: 6px 10px;
            font-size: 12px;
            cursor: pointer;
            transition: background 0.3s;
            margin: 0 2px;
        }

        .action-btn:hover {
            background-color: #06b287;
        }

        /* Botão para criar nova avaliação */
        .new-evaluation-btn {
            background-color: #08C89E;
            color: #fff;
            border: none;
            padding: 10px 20px;
            border-radius: 8px;
            font-size: 14px;
            cursor: pointer;
            transition: background 0.3s;
            margin-bottom: 20px;
        }

        .new-evaluation-btn:hover {
            background-color: #06b287;
        }

        /* Modal Estilização */
        .modal-header {
            border-bottom: 1px solid #e2e8f0;
        }

        .modal-title {
            font-weight: 600;
            color: #08C89E;
        }

        .modal-footer {
            border-top: 1px solid #e2e8f0;
        }

        .form-group label {
            font-weight: 600;
            margin-bottom: 5px;
            color: #2d3748;
        }

        .form-control {
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            font-size: 14px;
            color: #2d3748;
        }

        /* Toasts */
        .toast-container {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1055;
        }

        /* Responsividade */
        @media(max-width: 768px) {
            .container-page {
                margin-left: 0;
                padding: 10px;
            }

            .info-section {
                padding: 15px;
            }

            .evaluations-table {
                padding: 15px;
            }

            .new-evaluation-btn {
                width: 100%;
                text-align: center;
            }

            .action-btn {
                padding: 4px 8px;
                font-size: 10px;
            }
        }
        
        /* Informações da Criança */
        .child-info {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 0px 15px;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
        }
        .child-info img {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            border: 2px solid #08C89E;
            margin-right: 15px;
            object-fit: cover;
        }
        .child-info div {
            font-size: 16px;
        }
        .child-info div p {
            margin-bottom: 5px;
            color: #2d3748;
        }

        /* Nova Coluna Senha */
        .senha-cell {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }

        .copy-url-btn {
            background-color: #3182ce;
            color: #fff;
            border: none;
            border-radius: 4px;
            padding: 4px 8px;
            font-size: 12px;
            cursor: pointer;
            transition: background 0.3s;
        }

        .copy-url-btn:hover {
            background-color: #2b6cb0;
        }
    </style>
</head>
<body>
    <!-- Cabeçalho e Sidebar padrão do sistema -->
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-painel-clinica-crianças.php'; ?>

    <div class="container-page">
        <h1 style="margin-bottom: -10px">Linha do Tempo: <span style="color: #F7702D">TL001 (10/01/2023)</span></h1>
        <hr>
        <p style="margin-top: -10px">sdsd</p>
        <!-- Informações da Criança -->
        <!--<div class="child-info">
            <img src="https://api.dicebear.com/6.x/pixel-art/svg?seed=avatar007" alt="Foto da Criança">
            <div>
                <p><b>Nome:</b> Luís Gustavo</p>
                <p><b>Data de Nascimento:</b> 20/05/2018</p>
                <p><b>Responsável:</b> Maria da Silva</p>
            </div>
        </div> -->

        <!-- Botão para criar nova avaliação -->
        <button class="new-evaluation-btn" onclick="window.location.href='painel-clinica-perfil-criança-portage.php'"><i class="fas fa-chart-line"></i> Análise</button>
        <button class="new-evaluation-btn" data-toggle="modal" data-target="#createEvaluationModal"><i class="fas fa-plus"></i> Nova Avaliação</button>

        <!-- Tabela de Avaliações -->
        <div class="evaluations-table">
            <table class="table table-bordered table-hover">
                <thead class="thead-light">
                    <tr>
                        <th>ID Avaliação</th>
                        <th>Data da Avaliação</th>
                        <th>Tipo de Avaliação</th>
                        <th>Status</th>
                        <th>Chave de Acesso</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody id="evaluationsTableBody">
                    <!-- Avaliação Exemplo 1 -->
                    <tr>
                        <td>AV003</td>
                        <td>18/12/2023</td>
                        <td><span class="badge badge-warning">Reavaliação</span></td>
                        <td><span class="badge badge-secondary">Aberta</span></td>
                        <td class="senha-cell">
                            <span class="password-text">ABC12345</span>
                            <button class="copy-url-btn" onclick="copyURL('AV003', 'ABC12345')"><i class="fas fa-copy"></i> Copiar URL</button>
                        </td>
                        <td>
                            <button class="action-btn" onclick="window.location.href='painel-clinica-perfil-crian%C3%A7a-portage-novo.php'"><i class="fas fa-list"></i> Portage</button>
                            <button class="action-btn" onclick="toggleStatus('AV003')" id="status-btn-AV003"><i class="fas fa-check"></i> Finalizar</button>
                            <button class="action-btn" onclick="deleteEvaluation('AV003')" id="delete-btn-AV003" disabled><i class="fas fa-trash-alt"></i> Excluir</button>
                        </td>
                    </tr>

                    <!-- Avaliação Exemplo 2 -->
                    <tr>
                        <td>AV002</td>
                        <td>20/06/2023</td>
                        <td><span class="badge badge-warning">Reavaliação</span></td>
                        <td><span class="badge badge-success">Finalizada</span></td>
                        <td class="senha-cell">
                            <span class="password-text">DEF67890</span>
                            <button class="copy-url-btn" onclick="copyURL('AV002', 'DEF67890')"><i class="fas fa-copy"></i> Copiar URL</button>
                        </td>
                        <td>
                            <button class="action-btn" onclick="window.location.href='painel-clinica-perfil-crian%C3%A7a-portage-novo.php'"><i class="fas fa-list"></i> Portage</button>
                            <button class="action-btn" onclick="toggleStatus('AV002')" id="status-btn-AV002"><i class="fas fa-redo"></i> Reabrir</button>
                            <button class="action-btn" onclick="deleteEvaluation('AV002')" id="delete-btn-AV002" disabled><i class="fas fa-trash-alt"></i> Excluir</button>
                        </td>
                    </tr>

                    <!-- Avaliação Exemplo 3 -->
                    <tr>
                        <td>AV001</td>
                        <td>15/02/2023</td>
                        <td><span class="badge badge-info">Inicial</span></td>
                        <td><span class="badge badge-success">Finalizada</span></td>
                        <td class="senha-cell">
                            <span class="password-text">GHI13579</span>
                            <button class="copy-url-btn" onclick="copyURL('AV001', 'GHI13579')"><i class="fas fa-copy"></i> Copiar URL</button>
                        </td>
                        <td>
                            <button class="action-btn" onclick="window.location.href='painel-clinica-perfil-crian%C3%A7a-portage-novo.php'"><i class="fas fa-list"></i> Portage</button>
                            <button class="action-btn" onclick="toggleStatus('AV001')" id="status-btn-AV001"><i class="fas fa-redo"></i> Reabrir</button>
                            <button class="action-btn" onclick="deleteEvaluation('AV001')" id="delete-btn-AV001"><i class="fas fa-trash-alt"></i> Excluir</button>
                        </td>
                    </tr>
                </tbody>
            </table>
            
        </div>
        <p>(a analise só pode ser feita em avaliações finalizadas)</p>
    </div>

    <!-- Modal Nova Avaliação -->
    <div class="modal fade" id="createEvaluationModal" tabindex="-1" role="dialog" aria-labelledby="createEvaluationModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h2 class="modal-title" id="createEvaluationModalLabel">Nova Avaliação</h2>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Fechar" style="border:none;background:none;font-size:20px;">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="evaluationForm">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="evaluationDate">Data da Avaliação</label>
                            <input type="date" id="evaluationDate" name="evaluationDate" class="form-control" value="<?php echo date('Y-m-d'); ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="evaluationType">Tipo de Avaliação</label>
                            <select id="evaluationType" name="evaluationType" class="form-control" required>
                                <option value="" disabled selected>Selecione o Tipo</option>
                                <option value="inicial">Avaliação Inicial</option>
                                <option value="reavaliacao">Reavaliação</option>
                            </select>
                        </div>
                        <p class="text-muted" style="font-size:12px;">Ao criar uma nova avaliação, o status será definido automaticamente como "Aberta". Somente você terá acesso a esta avaliação, outros profissionais não terão acesso.</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="action-btn" style="background-color:#e53e3e;" data-dismiss="modal"><i class="fas fa-times"></i> Cancelar</button>
                        <button type="submit" class="action-btn" style="background-color:#08C89E;"><i class="fas fa-save"></i> Criar Avaliação</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Alterar Status -->
    <div class="modal fade" id="changeStatusModal" tabindex="-1" role="dialog" aria-labelledby="changeStatusModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h2 class="modal-title" id="changeStatusModalLabel">Alterar Status da Avaliação</h2>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Fechar" style="border:none;background:none;font-size:20px;">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="changeStatusForm">
                    <div class="modal-body">
                        <input type="hidden" id="currentEvalId" name="currentEvalId">
                        <div class="form-group">
                            <label for="newStatus">Novo Status</label>
                            <select id="newStatus" name="newStatus" class="form-control" required>
                                <option value="" disabled selected>Selecione o Novo Status</option>
                                <option value="finalizada">Finalizada</option>
                                <option value="aberta">Aberta</option>
                            </select>
                        </div>
                        <p class="text-muted" style="font-size:12px;">Após finalizar a avaliação, ela não poderá ser editada até que o status seja alterado para "Aberta".</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="action-btn" style="background-color:#e53e3e;" data-dismiss="modal"><i class="fas fa-times"></i> Cancelar</button>
                        <button type="submit" class="action-btn" style="background-color:#08C89E;"><i class="fas fa-save"></i> Alterar Status</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Container para Toasts -->
    <div class="toast-container" aria-live="polite" aria-atomic="true">
        <!-- Toasts serão inseridos via JavaScript -->
    </div>

    <!-- Scripts Bootstrap e jQuery -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Script para Gerenciar Avaliações -->
    <script>
        // Simulação de ID da Linha do Tempo selecionada
        const currentTimelineId = 'TL001';

        // Função para acessar o Checklist do Portage
        function accessChecklist(evalId, password) {
            // Compor a URL com evalId e password
            const checklistURL = `checklist-portage.php?evalId=${encodeURIComponent(evalId)}&password=${encodeURIComponent(password)}`;
            // Redirecionar para a URL do checklist
            window.location.href = checklistURL;
        }

        // Função para acessar o Painel de Análise do Portage
        function accessAnalysisPanel(evalId) {
            // Redirecionar para a página do painel de análise do portage
            window.location.href = `analise-portage.php?evalId=${encodeURIComponent(evalId)}`;
        }

        // Função para gerar uma senha aleatória
        function generatePassword(length = 8) {
            const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
            let password = '';
            for(let i = 0; i < length; i++) {
                password += chars.charAt(Math.floor(Math.random() * chars.length));
            }
            return password;
        }

        // Função para gerar uma URL única para a avaliação
        function generateURL(evalId, password) {
            return `https://ifcora.com/av/av3/painel-clinica-perfil-crian%C3%A7a-portage-novo-avalia%C3%A7%C3%B5es.php?evalId=${encodeURIComponent(evalId)}`;
        }

        // Função para copiar a URL para a área de transferência
        function copyURL(evalId, password) {
            const url = generateURL(evalId, password);
            navigator.clipboard.writeText(url).then(() => {
                showToast('Sucesso', 'URL copiada para a área de transferência.');
            }).catch(err => {
                showToast('Erro', 'Não foi possível copiar a URL.');
                console.error('Erro ao copiar URL:', err);
            });
        }

        // Função para alternar o status da avaliação
        function toggleStatus(evalId) {
            // Obter a linha da tabela correspondente usando jQuery
            const row = $(`#evaluationsTableBody tr:has(td:first-child:contains("${evalId}"))`);
            const currentStatusBadge = row.find('td:nth-child(4) .badge');
            const currentStatus = currentStatusBadge.text().trim();

            // Configurar o modal de alteração de status
            $('#currentEvalId').val(evalId);
            const newStatusSelect = $('#newStatus');
            newStatusSelect.empty(); // Limpar opções

            if(currentStatus === 'Aberta') {
                newStatusSelect.append('<option value="" disabled selected>Selecione o Novo Status</option>');
                newStatusSelect.append('<option value="finalizada">Finalizada</option>');
            } else if(currentStatus === 'Finalizada') {
                newStatusSelect.append('<option value="" disabled selected>Selecione o Novo Status</option>');
                newStatusSelect.append('<option value="aberta">Aberta</option>');
            }

            // Mostrar o modal
            $('#changeStatusModal').modal('show');
        }

        // Função para alterar o status da avaliação
        $('#changeStatusForm').on('submit', function(e) {
            e.preventDefault();
            const evalId = $('#currentEvalId').val();
            const newStatus = $('#newStatus').val();

            if(!newStatus) {
                showToast('Erro', 'Por favor, selecione um novo status.');
                return;
            }

            // Obter a linha da tabela correspondente usando jQuery
            const row = $(`#evaluationsTableBody tr:has(td:first-child:contains("${evalId}"))`);
            const statusCell = row.find('td:nth-child(4)');
            const actionButtonsCell = row.find('td:nth-child(6)');

            // Atualizar o badge de status
            let badgeClass = '';
            let badgeText = '';

            if(newStatus === 'finalizada') {
                badgeClass = 'badge-success';
                badgeText = 'Finalizada';
            } else if(newStatus === 'aberta') {
                badgeClass = 'badge-secondary';
                badgeText = 'Aberta';
            }

            statusCell.html(`<span class="badge ${badgeClass}">${badgeText}</span>`);

            // Atualizar os botões de ação
            const statusBtn = actionButtonsCell.find(`#status-btn-${evalId}`);
            const deleteBtn = actionButtonsCell.find(`#delete-btn-${evalId}`);

            if(newStatus === 'finalizada') {
                // Desabilitar os botões de excluir
                deleteBtn.prop('disabled', true);
                // Alterar o botão de status para "Reabrir"
                statusBtn.html('<i class="fas fa-redo"></i> Reabrir');
            } else if(newStatus === 'aberta') {
                // Habilitar os botões de excluir
                deleteBtn.prop('disabled', false);
                // Alterar o botão de status para "Finalizar"
                statusBtn.html('<i class="fas fa-check"></i> Finalizar');
            }

            // Fechar o modal
            $('#changeStatusModal').modal('hide');

            // Mostrar notificação de sucesso
            showToast('Status Atualizado', `A avaliação ${evalId} foi marcada como "${badgeText}".`);
        });

        // Função para deletar avaliação
        function deleteEvaluation(evalId) {
            // Obter a linha da tabela correspondente usando jQuery
            const row = $(`#evaluationsTableBody tr:has(td:first-child:contains("${evalId}"))`);
            const status = row.find('td:nth-child(4) .badge').text().trim();

            if(status === 'Finalizada') {
                showToast('Erro', 'Avaliações finalizadas não podem ser excluídas.');
                return;
            }

            if(confirm('Tem certeza que deseja excluir a avaliação ' + evalId + '?')) {
                // Remover a linha da tabela
                row.remove();
                // Mostrar notificação de sucesso
                showToast('Avaliação Excluída', 'A avaliação foi excluída com sucesso.');
            }
        }

        // Função para mostrar toasts de notificações
        function showToast(title, message) {
            const toastId = 'toast' + Date.now();

            const toastHTML = `
                <div class="toast" id="${toastId}" role="alert" aria-live="assertive" aria-atomic="true" data-delay="3000">
                    <div class="toast-header">
                        <strong class="mr-auto text-success">${title}</strong>
                        <small>Agora</small>
                        <button type="button" class="ml-2 mb-1 close" data-dismiss="toast" aria-label="Fechar">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="toast-body">
                        ${message}
                    </div>
                </div>
            `;

            $('.toast-container').append(toastHTML);
            $(`#${toastId}`).toast('show');

            // Remover o toast do DOM após ocultar
            $(`#${toastId}`).on('hidden.bs.toast', function () {
                $(this).remove();
            });
        }

        // Evento para criar nova avaliação
        $('#evaluationForm').on('submit', function(e) {
            e.preventDefault();
            const evaluationDate = $('#evaluationDate').val();
            const evaluationType = $('#evaluationType').val();

            if(evaluationDate === '' || evaluationType === ''){
                showToast('Erro', 'Preencha todos os campos para criar a avaliação.');
                return;
            }

            // Criar um novo ID simulado
            const newEvalIdNumber = $('#evaluationsTableBody tr').length + 1;
            const newEvalId = 'AV' + String(newEvalIdNumber).padStart(3, '0');

            // Gerar senha e URL
            const newPassword = generatePassword(8);
            const newURL = generateURL(newEvalId, newPassword);

            // Determinar a classe e texto do badge com base no tipo de avaliação
            let typeBadgeClass = '';
            let typeBadgeText = '';
            if(evaluationType === 'inicial') {
                typeBadgeClass = 'badge-info';
                typeBadgeText = 'Inicial';
            } else if(evaluationType === 'reavaliacao') {
                typeBadgeClass = 'badge-warning';
                typeBadgeText = 'Reavaliação';
            }

            // Status inicial sempre "Aberta"
            let statusBadgeClass = 'badge-secondary';
            let statusBadgeText = 'Aberta';

            // Formatar a data
            const formattedDate = new Date(evaluationDate).toLocaleDateString('pt-BR');

            // Criar nova linha na tabela
            const tableBody = $('#evaluationsTableBody');
            const newRow = `
                <tr>
                    <td>${newEvalId}</td>
                    <td>${formattedDate}</td>
                    <td><span class="badge ${typeBadgeClass}">${typeBadgeText}</span></td>
                    <td><span class="badge ${statusBadgeClass}">${statusBadgeText}</span></td>
                    <td class="senha-cell">
                        <span class="password-text">${newPassword}</span>
                        <button class="copy-url-btn" onclick="copyURL('${newEvalId}')"><i class="fas fa-copy"></i> Copiar URL</button>
                    </td>
                    <td>
                        <button class="action-btn" onclick="accessChecklist('${newEvalId}', '${newPassword}')"><i class="fas fa-list"></i> Checklist</button>
                        <button class="action-btn" onclick="accessAnalysisPanel('${newEvalId}')"><i class="fas fa-chart-line"></i> Análise</button>
                        <button class="action-btn" onclick="toggleStatus('${newEvalId}')" id="status-btn-${newEvalId}"><i class="fas fa-check"></i> Finalizar</button>
                        <button class="action-btn" onclick="deleteEvaluation('${newEvalId}')" id="delete-btn-${newEvalId}"><i class="fas fa-trash-alt"></i> Excluir</button>
                    </td>
                </tr>
            `;

            // Prepend the new row to have a reverse order (most recent at top)
            tableBody.prepend(newRow);

            // Mostrar notificação de sucesso
            showToast('Sucesso', 'Nova avaliação criada com sucesso!');
            // Fechar modal
            $('#createEvaluationModal').modal('hide');
            // Resetar o formulário
            $('#evaluationForm')[0].reset();
        });

        // Função para acessar o Checklist do Portage (implementação fictícia)
        function accessChecklist(evalId, password) {
            // Compor a URL com evalId e password
            const checklistURL = `checklist-portage.php?evalId=${encodeURIComponent(evalId)}&password=${encodeURIComponent(password)}`;
            // Redirecionar para a URL do checklist
            window.location.href = checklistURL;
        }

        // Função para acessar o Painel de Análise do Portage (implementação fictícia)
        function accessAnalysisPanel(evalId) {
            // Redirecionar para a página do painel de análise do portage
            window.location.href = `analise-portage.php?evalId=${encodeURIComponent(evalId)}`;
        }
    </script>
</body>
</html>


