<?php

// Defina a URL da API
$url = "http://localhost:8000/api/auth/forgot-password";

// Dados a serem enviados
$data = [
    'email' => 'teste@example.com',
    'captchaAnswer' => '5' // Substitua pelo valor correto da resposta CAPTCHA
];

// Inicialize cURL
$ch = curl_init();

// Configure a requisição POST
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data)); // Envia os dados no formato JSON
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json', // Define o tipo de conteúdo como JSON
]);

// Execute a requisição e obtenha a resposta
$response = curl_exec($ch);

// Verifique se houve erro na requisição
if (curl_errno($ch)) {
    echo 'Erro cURL: ' . curl_error($ch);
} else {
    // Exiba a resposta do servidor
    echo "<h2>Resposta da API:</h2>";
    echo "<pre>" . print_r(json_decode($response, true), true) . "</pre>";
}

// Feche a conexão cURL
curl_close($ch);
?>
