<!DOCTYPE html>
<html lang="pt-BR">
   <head>
      <meta charset="UTF-8">
      <title>Anamnese - Sistema de Avaliação IFCora</title>
      <!-- Fontes e Ícones -->
      <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
      <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
      <!-- Estilos Globais -->
      <link rel="stylesheet" href="css/global.css">
      <link rel="stylesheet" href="css/header.css">
      <link rel="stylesheet" href="css/sidebar.css">
      <style>
         /* Conteúdo Principal */
         .content {
         margin-top: 60px;
         margin-left: 250px;
         padding: 20px;
         flex: 1;
         box-sizing: border-box;
         background-color: #F9FAFB;
         }
         .anamnese-container {
         background-color: #ffffff;
         border: 1px solid #e2e8f0;
         border-radius: 10px;
         padding: 20px;
         box-shadow: 0 2px 4px rgba(0,0,0,0.05);
         }
         .anamnese-container h1 {
         color: #08C89E;
         margin-bottom: 20px;
         font-size: 24px;
         }
         /* Seção Informativa da Identificação da Criança */
         .informativa-identificacao {
         background-color: #f7fafc;
         }
         /* Abas */
         .tab-container {
         margin-top: 0;
         }
         .tabs {
         display: flex;
         border-bottom: 1px solid #e2e8f0;
         margin-bottom: 0; /* Remover margem entre as abas e o conteúdo */
         padding-bottom: 0; /* Remover o padding inferior das abas */
         }
         .tab {
         padding: 10px 20px;
         cursor: pointer;
         font-weight: 600;
         color: #4a5568;
         transition: background-color 0.3s, color 0.3s;
         border-top-left-radius: 8px;
         border-top-right-radius: 8px;
         margin-right: 0px;
         white-space: nowrap;
         border-bottom: 2px solid transparent; /* Remover a linha de separação */
         background-color: #fff;
         border: 1px solid #e2e8f0;
         }
         .tab.active {
         background-color: #08C89E;
         color: #ffffff;
         border-bottom: 2px solid #08C89E; /* Linha de destaque ativa */
         }
         .tab-content {
         display: none;
         background-color: #fff;
         padding: 20px;
         border-radius: 0px 0px 10px 10px;
         border: 1px solid #e2e8f0;
         box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
         margin-top: 0; /* Remover espaço extra entre o conteúdo e as abas */
         }
         .tab-content.active {
         display: block;
         margin-top: 0; /* Remover qualquer margem extra */
         }
         /* Formulário de Anamnese */
         .anamnese-form fieldset {
         border: 1px solid #e2e8f0;
         border-radius: 8px;
         padding: 15px;
         margin-bottom: 20px;
         }
         .anamnese-form legend {
         font-size: 18px;
         font-weight: bold;
         color: #08C89E;
         padding: 0 10px;
         }
         .anamnese-form .form-group {
         margin-bottom: 15px;
         display: flex;
         flex-direction: column;
         }
         .anamnese-form label {
         font-size: 14px;
         font-weight: normal;
         color: #2d3748;
         margin-bottom: 5px;
         font-weight: 600;
         }
         .anamnese-form input,
         .anamnese-form select,
         .anamnese-form textarea {
         width: 100%;
         padding: 8px;
         border: 1px solid #e2e8f0;
         border-radius: 6px;
         font-size: 14px;
         color: #2d3748;
         box-sizing: border-box;
         background-color: #fff;
         }
         .anamnese-form input:focus,
         .anamnese-form select:focus,
         .anamnese-form textarea:focus {
         outline: none;
         border-color: #08C89E;
         box-shadow: 0 0 0 1px #08C89E;
         }
         .anamnese-form .radio-group {
         display: flex;
         gap: 20px;
         align-items: flex-start;
         }
         .anamnese-form .radio-group label {
         display: flex;
         align-items: center;
         font-size: 14px;
         color: #2d3748;
         cursor: pointer;
         }
         .anamnese-form .radio-group input {
         margin-right: 8px;
         align-self: center;
         }
         .anamnese-form .submit-btn {
         background-color: #08C89E;
         color: #fff;
         padding: 10px 20px;
         border: none;
         border-radius: 8px;
         cursor: pointer;
         font-size: 16px;
         transition: background 0.3s;
         align-self: flex-start;
         }
         .anamnese-form .submit-btn:hover {
         background-color: #06b287;
         }
         /* Área de Texto da Anamnese */
         .anamnese-text-area {
         display: flex;
         flex-direction: column;
         }
         .anamnese-text-area textarea {
         width: 100%;
         height: 400px;
         padding: 10px;
         border: 1px solid #e2e8f0;
         border-radius: 6px;
         resize: vertical;
         font-size: 14px;
         color: #2d3748;
         box-sizing: border-box;
         background-color: #fff;
         }
         .anamnese-text-area textarea[readonly] {
         background-color: #f7fafc;
         cursor: not-allowed;
         }
         .anamnese-text-area .botao-editar {
         align-self: flex-end;
         background-color: #4a5568;
         color: #fff;
         padding: 8px 16px;
         border: none;
         border-radius: 6px;
         cursor: pointer;
         font-size: 14px;
         margin-top: 10px;
         transition: background 0.3s;
         }
         .anamnese-text-area .botao-editar:hover {
         background-color: #2d3748;
         }
         .anamnese-text-area .save-btn {
         align-self: flex-end;
         background-color: #08C89E;
         color: #fff;
         padding: 8px 16px;
         border: none;
         border-radius: 6px;
         cursor: pointer;
         font-size: 14px;
         margin-top: 10px;
         transition: background 0.3s;
         display: none;
         }
         .anamnese-text-area .save-btn:hover {
         background-color: #06b287;
         }
         /* Responsividade */
         @media (max-width: 768px) {
         .sidebar {
         width: 200px;
         }
         .tabs {
         flex-direction: column;
         }
         .tab {
         margin-right: 0;
         margin-bottom: 5px;
         }
         .informativa-identificacao {
         padding: 10px;
         }
         }
         /* Estilo para o ícone de ajuda */
         /* Estilo para o ícone de ajuda */
         .help-icon {
         position: relative;
         display: inline-block;
         }
         /* Estilo do tooltip como uma caixa de resposta */
         .tooltip-text {
         visibility: hidden;
         width: 300px;
         background-color: #f1f5f9;
         color: #2d3748;
         text-align: left;
         border-radius: 8px;
         padding: 12px;
         position: absolute;
         z-index: 1;
         bottom: 120%; /* Coloca o tooltip acima do ícone */
         left: 50%;
         margin-left: -150px; /* Centraliza o tooltip */
         opacity: 0;
         transition: opacity 0.3s;
         font-size: 12px;
         box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); /* Sombra para destacar a caixa */
         border: 1px solid #e2e8f0; /* Borda sutil */
         font-weight: 300;
         }
         .help-icon:hover .tooltip-text {
         visibility: visible;
         opacity: 1;
         }
         .help-icon i {
         color: #08C89E;
         font-size: 16px;
         }
      </style>
   </head>
   <body>
      <?php include 'includes/header.php'; ?>
      <?php include 'includes/sidebar-anamnese.php'; ?>
      <!-- Conteúdo Principal -->
      <main class="content">
         <div class="header-content" style="margin-top: 15px; margin-bottom: 15px; margin-left: -15px">
            <h1><i class="fas fa-file-alt"></i> Anamnese</h1>
         </div>
         <div class="tab-container">
            <div class="tabs">
               <div class="tab active" data-tab="formulario">Formulário de Anamnese</div>
               <div class="tab" data-tab="texto">Texto da Anamnese</div>
            </div>
            <!-- Conteúdo das Abas -->
            <div id="formulario" class="tab-content active">
               <form class="anamnese-form" id="anamnese-form">
                  <fieldset class="informativa-identificacao">
                     <legend>1. Identificação da Criança</legend>
                     <div class="form-row" style="display: flex; justify-content: space-between; gap: 10px;">
                        <div class="form-group" style="flex: 2;">
                           <label for="nome_crianca">Nome completo:</label>
                           <input type="text" id="nome_crianca" name="nome_crianca" value="João Silva" required style="width: 100%;">
                        </div>
                        <div class="form-group" style="flex: 1;">
                           <label for="data_nascimento">Data de nascimento:</label>
                           <input type="date" id="data_nascimento" name="data_nascimento" value="2015-05-20" required style="width: 100%;">
                        </div>
                        <div class="form-group" style="flex: 1;">
                           <label for="idade_atual">Idade atual:</label>
                           <input type="number" id="idade_atual" name="idade_atual" min="0" value="8" required style="width: 100%;">
                        </div>
                        <div class="form-group" style="flex: 1;">
                           <label for="sexo">Sexo:</label>
                           <select id="sexo" name="sexo" required>
                              <option value="">Selecione</option>
                              <option value="masculino" selected>Masculino</option>
                              <option value="feminino">Feminino</option>
                           </select>
                        </div>
                     </div>
                     <div class="form-row" style="display: flex; justify-content: space-between; gap: 10px;">
                        <div class="form-group" style="flex: 2;">
                           <label for="responsaveis">Pai/Responsável presente na entrevista (Anamnese):</label>
                           <input type="text" id="responsaveis" name="responsaveis" value="Maria da Silva" required style="width: 100%;">
                        </div>
                        <div class="form-group" style="flex: 1;">
                           <label for="vinculo">Vínculo:</label>
                           <input type="text" id="vinculo" name="vinculo" value="Mãe" required style="width: 100%;">
                        </div>
                     </div>
                     
                  </fieldset>
                  <script>
                     function toggleDiagnostico(isDiagnosed) {
                         if (isDiagnosed) {
                             document.getElementById('diagnostico_info').style.display = 'block';
                             document.getElementById('em_avaliacao_info').style.display = 'none';
                         } else {
                             document.getElementById('diagnostico_info').style.display = 'none';
                             document.getElementById('em_avaliacao_info').style.display = 'block';
                         }
                     }
                     
                     function toggleAcompanhamento(isAccompanied) {
                         if (isAccompanied) {
                             document.getElementById('acompanhamento_info').style.display = 'block';
                         } else {
                             document.getElementById('acompanhamento_info').style.display = 'none';
                         }
                     }
                  </script>
                  <!-- 2. Histórico Familiar -->
                  <fieldset>
                     <legend>2. Histórico Familiar</legend>
                     <div class="form-group">
                        <label for="composicao_familiar">
                           Composição familiar (nome, idade, relação com a criança):
                           <span class="help-icon" style="cursor: pointer; margin-left: 8px;">
                              <i class="fas fa-info-circle"></i>
                              <span class="tooltip-text">
                                 Exemplo de resposta:
                                 <hr>
                                 Maria Silva, 35 anos, mãe; <br />Pedro Silva, 37 anos, pai; <br />Ana Silva, 10 anos, irmã
                              </span>
                           </span>
                        </label>
                        <textarea id="composicao_familiar" name="composicao_familiar" rows="5" required>Maria Silva, 35 anos, mãe; Pedro Silva, 37 anos, pai; Ana Silva, 10 anos, irmã.</textarea>
                     </div>
                     <div class="form-group">
                        <label>Há casos na família de transtornos neurológicos, atraso de fala, autismo ou outros diagnósticos relevantes?</label>
                        <div class="radio-group">
                           <label for="historico_sim">
                           <input type="radio" id="historico_sim" name="historico_familiar" value="sim" checked>
                           Sim
                           </label>
                           <label for="historico_nao">
                           <input type="radio" id="historico_nao" name="historico_familiar" value="nao">
                           Não
                           </label>
                        </div>
                     </div>
                     <div class="form-group" id="detalhes_historico_group">
                        <label for="detalhes_historico">
                           Se sim, especifique quais e em quais familiares:
                           <span class="help-icon" style="cursor: pointer; margin-left: 8px;">
                              <i class="fas fa-info-circle"></i>
                              <span class="tooltip-text">
                                 Exemplo de resposta: 
                                 <hr>
                                 Maria Silva, mãe, possui diagnóstico de transtorno de déficit de atenção e hiperatividade (TDAH).
                              </span>
                           </span>
                        </label>
                        <textarea id="detalhes_historico" name="detalhes_historico" rows="3">Maria Silva, mãe, possui diagnóstico de transtorno de déficit de atenção e hiperatividade (TDAH).</textarea>
                     </div>
                  </fieldset>
                  <!-- 3. Histórico Gestacional e Neonatal -->
                  <fieldset>
                     <legend>3. Histórico Gestacional e Neonatal</legend>
                     <div class="form-group">
                        <label>A gestação foi planejada?</label>
                        <div class="radio-group">
                           <label for="gestacao_sim">
                           <input type="radio" id="gestacao_sim" name="gestacao_planejada" value="sim" checked>
                           Sim
                           </label>
                           <label for="gestacao_nao">
                           <input type="radio" id="gestacao_nao" name="gestacao_planejada" value="nao">
                           Não
                           </label>
                        </div>
                     </div>
                     <div class="form-group">
                        <label for="complicacoes_gestacao">Houve complicações durante a gravidez?
                        </label>
                        <div class="radio-group">
                           <label for="complicacoes_sim">
                           <input type="radio" id="complicacoes_sim" name="complicacoes_gestacao" value="sim" onclick="toggleComplicacoes(true)" checked>
                           Sim
                           </label>
                           <label for="complicacoes_nao">
                           <input type="radio" id="complicacoes_nao" name="complicacoes_gestacao" value="nao" onclick="toggleComplicacoes(false)">
                           Não
                           </label>
                        </div>
                        <div id="complicacoes_details" style="display: block;">
                           <label for="detalhes_complicacoes">Se sim, quais?
                           <span class="help-icon" style="cursor: pointer; margin-left: 8px;">
                              <i class="fas fa-info-circle"></i>
                              <span class="tooltip-text">
                                 Exemplo de resposta: 
                                 <hr>
                                 A gravidez apresentou hipertensão gestacional controlada com medicação.
                              </span>
                           </span>
                           </label>
                           <textarea id="detalhes_complicacoes" name="detalhes_complicacoes" rows="3">A gravidez apresentou hipertensão gestacional controlada com medicação.</textarea>
                        </div>
                     </div>
                     <script>
                        function toggleComplicacoes(show) {
                            const details = document.getElementById('complicacoes_details');
                            if (show) {
                                details.style.display = 'block';
                            } else {
                                details.style.display = 'none';
                            }
                        }
                     </script>
                     <div class="form-row" style="display: flex; justify-content: space-between; gap: 10px;">
                        <div class="form-group" style="flex: 1;">
                           <label>Tipo de parto:</label>
                           <select id="tipo_parto" name="tipo_parto">
                              <option value="">Selecione</option>
                              <option value="normal" selected>Normal</option>
                              <option value="cesarea">Cesárea</option>
                              <option value="prematuro">Prematuro</option>
                           </select>
                        </div>
                        <div class="form-group" style="flex: 1;">
                           <label for="semanas_gestacao">Quantas semanas de gestação?</label>
                           <input type="number" id="semanas_gestacao" name="semanas_gestacao" min="20" max="42" value="39">
                        </div>
                     </div>
                     <div class="form-group">
                        <label>A criança necessitou de cuidados especiais ao nascer (ex.: UTI neonatal)?</label>
                        <div class="radio-group">
                           <label for="cuidados_sim">
                           <input type="radio" id="cuidados_sim" name="cuidados_especiais" value="sim" checked >
                           Sim
                           </label>
                           <label for="cuidados_nao">
                           <input type="radio" id="cuidados_nao" name="cuidados_especiais" value="nao" >
                           Não
                           </label>
                        </div>
                     </div>
                     <div class="form-group" id="detalhes_cuidados_group" style="display: block;">
                        <label for="detalhes_cuidados">Se sim, quais cuidados?
                        <span class="help-icon" style="cursor: pointer; margin-left: 8px;">
                              <i class="fas fa-info-circle"></i>
                              <span class="tooltip-text">
                                 Exemplo de resposta: 
                                 <hr>
                                 Necessitou de cuidados especiais devido a dificuldades respiratórias nas primeiras horas após o nascimento, sendo transferida para a UTI neonatal.
                              </span>
                           </span>
                        </label>
                        <textarea id="detalhes_cuidados" name="detalhes_cuidados" rows="3">A criança necessitou de cuidados especiais devido a dificuldades respiratórias nas primeiras horas após o nascimento, sendo transferida para a UTI neonatal.</textarea>
                     </div>
                  </fieldset>
                  <!-- 4. Histórico Médico e Saúde Geral -->
                  <fieldset>
                     <legend>4. Histórico Médico e Saúde Geral</legend>
                     <!-- Diagnóstico Médico Atual -->
                     <div class="form-group">
                        <label for="diagnostico_medico">A criança possui algum diagnóstico médico atual (ex.: epilepsia, alergias, problemas auditivos ou visuais)?</label>
                        <div class="radio-group">
                           <label for="diagnostico_medico_sim">
                           <input type="radio" id="diagnostico_medico_sim" name="diagnostico_medico" value="sim" onclick="toggleDiagnosticoMedico(true)" required checked>
                           Sim
                           </label>
                           <label for="diagnostico_medico_nao">
                           <input type="radio" id="diagnostico_medico_nao" name="diagnostico_medico" value="nao" onclick="toggleDiagnosticoMedico(false)" required>
                           Não
                           </label>
                        </div>
                        <div id="diagnostico_medico_details" style="display: block; margin-top: 10px;">
                           <label for="detalhes_diagnostico_medico">Se sim, qual?
                           <span class="help-icon" style="cursor: pointer; margin-left: 8px;">
                              <i class="fas fa-info-circle"></i>
                              <span class="tooltip-text">
                                 Exemplo de resposta: 
                                 <hr>
                                 Transtorno de Déficit de Atenção e Hiperatividade (TDAH).
                              </span>
                           </span>
                           </label>
                           <textarea id="detalhes_diagnostico_medico" name="detalhes_diagnostico_medico" rows="3" placeholder="Descreva o diagnóstico médico atual.">Transtorno de Déficit de Atenção e Hiperatividade (TDAH).</textarea>
                        </div>
                     </div>
                     <!-- Internações ou Cirurgias -->
                     <div class="form-group">
                        <label for="internacoes">Já foi internada ou submetida a cirurgias?</label>
                        <div class="radio-group">
                           <label for="internacoes_sim">
                           <input type="radio" id="internacoes_sim" name="internacoes" value="sim" onclick="toggleInternacoes(true)" required checked>
                           Sim
                           </label>
                           <label for="internacoes_nao">
                           <input type="radio" id="internacoes_nao" name="internacoes" value="nao" onclick="toggleInternacoes(false)" required>
                           Não
                           </label>
                        </div>
                        <div id="internacoes_details" style="display: block; margin-top: 10px;">
                           <label for="detalhes_internacoes">Se sim, quando e por quê?
                           <span class="help-icon" style="cursor: pointer; margin-left: 8px;">
                              <i class="fas fa-info-circle"></i>
                              <span class="tooltip-text">
                                 Exemplo de resposta: 
                                 <hr>
                                 Foi internada aos 4 anos devido a uma infecção respiratória grave, necessitando de internação por 5 dias.
                              </span>
                           </span>
                           </label>
                           <textarea id="detalhes_internacoes" name="detalhes_internacoes" rows="3" placeholder="Descreva as internacoes ou cirurgias realizadas.">A criança foi internada aos 4 anos devido a uma infecção respiratória grave, necessitando de internação por 5 dias.</textarea>
                        </div>
                     </div>
                     <!-- Uso de Medicação Contínua -->
                     <div class="form-group">
                        <label for="medicamentos">Faz uso de medicação contínua?</label>
                        <div class="radio-group">
                           <label for="medicamentos_sim">
                           <input type="radio" id="medicamentos_sim" name="medicamentos" value="sim" onclick="toggleMedicamentos(true)" required checked>
                           Sim
                           </label>
                           <label for="medicamentos_nao">
                           <input type="radio" id="medicamentos_nao" name="medicamentos" value="nao" onclick="toggleMedicamentos(false)" required>
                           Não
                           </label>
                        </div>
                        <div id="medicamentos_details" style="display: block; margin-top: 10px;">
                           <label for="detalhes_medicamentos">Se sim, quais?
                           <span class="help-icon" style="cursor: pointer; margin-left: 8px;">
                              <i class="fas fa-info-circle"></i>
                              <span class="tooltip-text">
                                 Exemplo de resposta: 
                                 <hr>
                                 Faz uso contínuo de medicação para controle de TDAH, sendo medicada com metilfenidato 5mg, administrado pela manhã e após o almoço.
                              </span>
                           </span>
                           </label>
                           <textarea id="detalhes_medicamentos" name="detalhes_medicamentos" rows="3" placeholder="Liste as medicações contínuas utilizadas.">A criança faz uso contínuo de medicação para controle de TDAH, sendo medicada com metilfenidato 5mg, administrado pela manhã e após o almoço.</textarea>
                        </div>
                     </div>
                     <!-- Diagnóstico -->
                     <div class="form-group">
                        <label for="diagnostico">A criança já foi diagnosticada?</label>
                        <div class="radio-group">
                           <label for="diagnostico_sim">
                           <input type="radio" id="diagnostico_sim" name="diagnostico" value="sim" onclick="toggleDiagnostico(true)" required checked>
                           Sim
                           </label>
                           <label for="diagnostico_nao">
                           <input type="radio" id="diagnostico_nao" name="diagnostico" value="nao" onclick="toggleDiagnostico(false)" required>
                           Não
                           </label>
                        </div>
                     </div>
                     <!-- Campo do Diagnóstico -->
                     <div id="diagnostico_info" style="display: block; margin-top: 10px;">
                        <div class="form-group">
                           <label for="diagnostico_texto">Qual o diagnóstico?</label>
                           <input type="text" id="diagnostico_texto" name="diagnostico_texto" style="width: 100%;" placeholder="Informe o diagnóstico detalhado." value="Transtorno de Déficit de Atenção e Hiperatividade (TDAH).">
                        </div>
                     </div>
                     <!-- Campo "Em Processo de Avaliação" -->
                     <div id="em_avaliacao_info" style="display: none; margin-top: 10px;">
                        <div class="form-group">
                           <label for="diagnostico_status">Status do diagnóstico:</label>
                           <input type="text" id="diagnostico_status" name="diagnostico_status" value="Em Processo de Avaliação e Análise Clínica" disabled style="width: 100%;">
                        </div>
                     </div>
                     <!-- Acompanhamento -->
                     <div class="form-group">
                        <label for="acompanhamento">A criança já vem sendo acompanhada por profissionais?</label>
                        <div class="radio-group">
                           <label for="acompanhamento_sim">
                           <input type="radio" id="acompanhamento_sim" name="acompanhamento" value="sim" onclick="toggleAcompanhamento(true)" required checked>
                           Sim
                           </label>
                           <label for="acompanhamento_nao">
                           <input type="radio" id="acompanhamento_nao" name="acompanhamento" value="nao" onclick="toggleAcompanhamento(false)" required>
                           Não
                           </label>
                        </div>
                     </div>
                     <!-- Campo do Acompanhamento -->
                     <div id="acompanhamento_info" style="display: block; margin-top: 10px;">
                        <div class="form-group">
                           <label for="detalhes_acompanhamento">Quais profissionais estão acompanhando e há quanto tempo?
                           <span class="help-icon" style="cursor: pointer; margin-left: 8px;">
                              <i class="fas fa-info-circle"></i>
                              <span class="tooltip-text">
                                 Exemplo de resposta: 
                                 <hr>
                                 Está sendo acompanhado por um psicólogo infantil há 2 anos.
                              </span>
                           </span>
                           </label>
                           <textarea id="detalhes_acompanhamento" name="detalhes_acompanhamento" rows="3" placeholder="Descreva os profissionais de saúde que estão acompanhando.">João está sendo acompanhado por um psicólogo infantil há 2 anos.</textarea>
                        </div>
                     </div>
                  </fieldset>
                  <!-- Scripts para toggle de campos -->
                  <script>
                     function toggleDiagnosticoMedico(show) {
                         const details = document.getElementById('diagnostico_medico_details');
                         details.style.display = show ? 'block' : 'none';
                     }
                     
                     function toggleInternacoes(show) {
                         const details = document.getElementById('internacoes_details');
                         details.style.display = show ? 'block' : 'none';
                     }
                     
                     function toggleMedicamentos(show) {
                         const details = document.getElementById('medicamentos_details');
                         details.style.display = show ? 'block' : 'none';
                     }
                     
                     function toggleDiagnostico(sim) {
                         const diagnosticoInfo = document.getElementById('diagnostico_info');
                         const emAvaliacaoInfo = document.getElementById('em_avaliacao_info');
                     
                         if (sim) {
                             diagnosticoInfo.style.display = 'block';
                             emAvaliacaoInfo.style.display = 'none';
                         } else {
                             diagnosticoInfo.style.display = 'none';
                             emAvaliacaoInfo.style.display = 'block';
                         }
                     }
                     
                     function toggleAcompanhamento(show) {
                         const acompanhamentoInfo = document.getElementById('acompanhamento_info');
                         acompanhamentoInfo.style.display = show ? 'block' : 'none';
                     }
                  </script>
                  <!-- 5. Rotina e Ambiente -->
                  <fieldset>
                     <legend>5. Rotina e Ambiente</legend>
                     <div class="form-group">
                        <label for="cuidador_principal">Quem é o principal cuidador da criança?
                        <span class="help-icon" style="cursor: pointer; margin-left: 8px;">
                              <i class="fas fa-info-circle"></i>
                              <span class="tooltip-text">
                                 Exemplo de resposta: 
                                 <hr>
                                 Maria Silva (mãe)
                              </span>
                           </span>
                        </label>
                        <input type="text" id="cuidador_principal" name="cuidador_principal" value="Maria Silva (mãe)">
                     </div>
                     <div class="form-group">
                        <label>A criança frequenta escola ou creche?</label>
                        <div class="radio-group">
                           <label for="escola_sim">
                           <input type="radio" id="escola_sim" name="frequenta_escola" value="sim" onclick="toggleEscola(true)" checked>
                           Sim
                           </label>
                           <label for="escola_nao">
                           <input type="radio" id="escola_nao" name="frequenta_escola" value="nao" onclick="toggleEscola(false)">
                           Não
                           </label>
                        </div>
                     </div>
                     <div id="escola_details" style="display: block; margin-top: 10px;">
                        <div class="form-group" id="nome_instituicao_group">
                           <label for="nome_instituicao">Se sim, qual instituição e em que período?
                           <span class="help-icon" style="cursor: pointer; margin-left: 8px;">
                              <i class="fas fa-info-circle"></i>
                              <span class="tooltip-text">
                                 Exemplo de resposta: 
                                 <hr>
                                 Escola Infantil ABC, período da manhã.
                              </span>
                           </span>
                           </label>
                           <textarea id="nome_instituicao" name="nome_instituicao" rows="2" placeholder="Informe o nome da instituição e o período.">Escola Infantil ABC, período da manhã.</textarea>
                        </div>
                        <div class="form-group">
                           <label for="comportamento_escola">Como é o comportamento da criança na escola ou creche?
                           <span class="help-icon" style="cursor: pointer; margin-left: 8px;">
                              <i class="fas fa-info-circle"></i>
                              <span class="tooltip-text">
                                 Exemplo de resposta: 
                                 <hr>
                                 É uma criança participativa e interage bem com os colegas.
                              </span>
                           </span>
                           </label>
                           <textarea id="comportamento_escola" name="comportamento_escola" rows="3" placeholder="Descreva o comportamento da criança.">João é participativo e interage bem com os colegas.</textarea>
                        </div>
                        <div class="form-group">
                           <label>A instituição já sinalizou alguma preocupação com a criança?</label>
                           <div class="radio-group">
                              <label for="preocupacao_escola_sim">
                              <input type="radio" id="preocupacao_escola_sim" name="preocupacao_escola" value="sim" onclick="togglePreocupacaoEscola(true)" required checked>
                              Sim
                              </label>
                              <label for="preocupacao_escola_nao">
                              <input type="radio" id="preocupacao_escola_nao" name="preocupacao_escola" value="nao" onclick="togglePreocupacaoEscola(false)" required>
                              Não
                              </label>
                           </div>
                           <div id="preocupacao_escola_details" style="display: block; margin-top: 10px;">
                              <label for="detalhes_preocupacao_escola">Se sim, por favor descreva:
                              <span class="help-icon" style="cursor: pointer; margin-left: 8px;">
                              <i class="fas fa-info-circle"></i>
                              <span class="tooltip-text">
                                 Exemplo de resposta: 
                                 <hr>
                                 A professora mencionou que ele tem dificuldade em manter a atenção em atividades prolongadas.
                              </span>
                           </span>
                              </label>
                              <textarea id="detalhes_preocupacao_escola" name="detalhes_preocupacao_escola" rows="3" placeholder="Descreva as preocupações sinalizadas pela instituição.">A professora mencionou que ele tem dificuldade em manter a atenção em atividades prolongadas.</textarea>
                           </div>
                        </div>
                     </div>
                     <div class="form-group">
                        <label for="exposicao_estresse">
                        Há exposição a fatores estressantes no ambiente familiar (ex.: conflitos, mudanças frequentes, perdas recentes)?
                        </label>
                        <div class="radio-group">
                           <label for="exposicao_estresse_sim">
                           <input type="radio" id="exposicao_estresse_sim" name="exposicao_estresse" value="sim" onclick="toggleEstresse(true)" required checked>
                           Sim
                           </label>
                           <label for="exposicao_estresse_nao">
                           <input type="radio" id="exposicao_estresse_nao" name="exposicao_estresse" value="nao" onclick="toggleEstresse(false)" required>
                           Não
                           </label>
                        </div>
                        <div id="exposicao_estresse_details" style="display: block; margin-top: 10px;">
                           <label for="detalhes_exposicao_estresse">Se sim, por favor descreva:
                           <span class="help-icon" style="cursor: pointer; margin-left: 8px;">
                              <i class="fas fa-info-circle"></i>
                              <span class="tooltip-text">
                                 Exemplo de resposta: 
                                 <hr>
                                 Tem enfrentado estresse devido ao recente divórcio dos pais e às mudanças frequentes de casa.
                              </span>
                           </span>
                           </label>
                           <textarea id="detalhes_exposicao_estresse" name="detalhes_exposicao_estresse" rows="3" placeholder="Descreva os fatores estressantes aqui.">A criança tem sido exposta a fatores estressantes devido a um recente divórcio dos pais e mudanças de residência frequentes, o que tem gerado algum impacto emocional.</textarea>
                        </div>
                     </div>
                     <script>
                        function toggleEstresse(show) {
                            const details = document.getElementById('exposicao_estresse_details');
                            details.style.display = show ? 'block' : 'none';
                        }
                        
                        function toggleEscola(show) {
                            const escolaDetails = document.getElementById('escola_details');
                            escolaDetails.style.display = show ? 'block' : 'none';
                        }
                        
                        function togglePreocupacaoEscola(show) {
                            const detalhesPreocupacao = document.getElementById('preocupacao_escola_details');
                            detalhesPreocupacao.style.display = show ? 'block' : 'none';
                        }
                     </script>
                  </fieldset>
                  <!-- 6. Observações Adicionais -->
                  <fieldset>
                     <legend>6. Observações Adicionais</legend>
                     <div class="form-group">
                        <label for="observacoes_responsáveis">Espaço para anotações relevantes dos responsáveis:
                        <span class="help-icon" style="cursor: pointer; margin-left: 8px;">
                              <i class="fas fa-info-circle"></i>
                              <span class="tooltip-text">
                                 Exemplo de resposta: 
                                 <hr>
                                 Tem demonstrado interesse em esportes e atividades ao ar livre.
                              </span>
                           </span>
                        </label>
                        <textarea id="observacoes_responsáveis" name="observacoes_responsáveis" rows="5">João tem demonstrado interesse em esportes e atividades ao ar livre.</textarea>
                     </div>
                     <div class="form-group">
                        <label for="observacoes_profissionais">Espaço para anotações relevantes do profissonal (avaliador):
                        <span class="help-icon" style="cursor: pointer; margin-left: 8px;">
                              <i class="fas fa-info-circle"></i>
                              <span class="tooltip-text">
                                 Exemplo de resposta: 
                                 <hr>
                                 Está desenvolvendo habilidades sociais positivas, porém apresenta desafios na manutenção do foco durante as atividades escolares.
                              </span>
                           </span>
                        </label>
                        <textarea id="observacoes_profissionais" name="observacoes_profissionais" rows="5">João está desenvolvendo habilidades sociais positivas, porém apresenta desafios na manutenção do foco durante as atividades escolares.</textarea>
                     </div>
                  </fieldset>
                  <!-- Botão de Enviar -->
                  <button type="submit" class="submit-btn"><i class="fas fa-paper-plane"></i> Enviar</button>
               </form>
            </div>
            <div id="texto" class="tab-content">
               <div class="anamnese-text-area">
                  <label for="anamnese_texto"><strong>Texto da Anamnese:</strong></label>
                  <textarea id="anamnese_texto" name="anamnese_texto" rows="20" readonly>
                  Anamnese do Paciente: João Silva
1. Identificação da Criança:
- Nome Completo: João Silva
- Data de Nascimento: 2015-05-20
- Idade Atual: 8 anos
- Sexo: Masculino
- Responsáveis: Maria Silva (mãe) - (11) 99999-9999; Pedro Silva (pai) - (11) 98888-8888

2. Histórico Familiar:
                  - Composição Familiar: Maria Silva, 35 anos, mãe; Pedro Silva, 37 anos, pai; Ana Silva, 10 anos, irmã
                  - Há casos na família de transtornos neurológicos, atraso de fala, autismo ou outros diagnósticos relevantes? Sim
                  - Detalhes: Maria Silva, mãe, possui diagnóstico de transtorno de déficit de atenção e hiperatividade (TDAH).
                  3. Histórico Gestacional e Neonatal:
                  - Gestação foi planejada? Sim
                  - Complicações durante a gravidez: Nenhuma complicação significativa.
                  - Tipo de Parto: Normal
                  - Quantas semanas de gestação? 39 semanas
                  - A criança necessitou de cuidados especiais ao nascer? Não
                  4. Histórico Médico e Saúde Geral:
                  - Diagnóstico Médico Atual: Nenhum diagnóstico médico atual.
                  - Internações ou Cirurgias: Não.
                  - Uso de Medicação Contínua: Não.
                  5. Rotina e Ambiente:
                  - Principal Cuidador: Maria Silva (mãe)
                  - Frequência na Escola ou Creche: Sim
                  - Nome da Instituição e Período: Escola Infantil ABC, período da manhã.
                  - Exposição a Fatores Estressantes no Ambiente Familiar: Não há exposição a fatores estressantes significativos.
                  6. Histórico Escolar:
                  - Comportamento na Escola ou Creche: João é participativo e interage bem com os colegas.
                  - Preocupações Sinalizadas pela Instituição: A professora mencionou que ele tem dificuldade em manter a atenção em atividades prolongadas.
                  7. Motivo da Avaliação:
                  - Motivo da Busca por Avaliação: Preocupação com a dificuldade de atenção e concentração.
                  - Preocupações Específicas com o Comportamento ou Desenvolvimento: Dificuldade em concluir tarefas que exigem foco por mais tempo.
                  8. Observações Adicionais:
                  - João tem demonstrado interesse em esportes e atividades ao ar livre.
                  </textarea>
                  <button class="botao-editar" id="editar_anamnese_texto"><i class="fas fa-edit"></i> Editar</button>
                  <button class="save-btn" id="save_anamnese_texto"><i class="fas fa-save"></i> Salvar Alterações</button>
               </div>
            </div>
         </div>
         </div>
      </main>
      <!-- Scripts Específicos para Anamnese -->
      <script>
  document.addEventListener('DOMContentLoaded', () => {
    // Seleção das abas
    const tabs = document.querySelectorAll('.tab');
    const tabContents = document.querySelectorAll('.tab-content');
    
    tabs.forEach(tab => {
      tab.addEventListener('click', () => {
        // Remover 'active' de todas as abas e conteúdos
        tabs.forEach(item => item.classList.remove('active'));
        tabContents.forEach(content => content.classList.remove('active'));

        // Adicionar 'active' na aba clicada e no conteúdo correspondente
        tab.classList.add('active');
        document.getElementById(tab.getAttribute('data-tab')).classList.add('active');
      });
    });

    // Mostrar/ocultar detalhes do histórico familiar
    const historicoFamiliaSim = document.getElementById('historico_sim');
    const historicoFamiliaNao = document.getElementById('historico_nao');
    const detalhesHistoricoGroup = document.getElementById('detalhes_historico_group');

    historicoFamiliaSim.addEventListener('change', function() {
      if (this.checked) {
        detalhesHistoricoGroup.style.display = 'block';
      }
    });

    historicoFamiliaNao.addEventListener('change', function() {
      if (this.checked) {
        detalhesHistoricoGroup.style.display = 'none';
        // Removido o reset do textarea para preservar o conteúdo
      }
    });

    // Mostrar/ocultar detalhes dos cuidados especiais
    const cuidadosSim = document.getElementById('cuidados_sim');
    const cuidadosNao = document.getElementById('cuidados_nao');
    const detalhesCuidadosGroup = document.getElementById('detalhes_cuidados_group');

    cuidadosSim.addEventListener('change', function() {
      if (this.checked) {
        detalhesCuidadosGroup.style.display = 'block';
      }
    });

    cuidadosNao.addEventListener('change', function() {
      if (this.checked) {
        detalhesCuidadosGroup.style.display = 'none';
        // Removido o reset do textarea para preservar o conteúdo
      }
    });

    // Mostrar/ocultar nome da instituição (quando a criança frequenta escola)
    const frequentaEscolaSim = document.getElementById('escola_sim');
    const frequentaEscolaNao = document.getElementById('escola_nao');
    const escolaDetails = document.getElementById('escola_details');

    frequentaEscolaSim.addEventListener('change', function() {
      if (this.checked) {
        escolaDetails.style.display = 'block';
      }
    });

    frequentaEscolaNao.addEventListener('change', function() {
      if (this.checked) {
        escolaDetails.style.display = 'none';
        // Removidos os resets para preservar o conteúdo dos textareas
        // document.getElementById('nome_instituicao').value = '';
        // document.getElementById('comportamento_escola').value = '';
        // document.getElementById('detalhes_preocupacao_escola').value = '';
      }
    });

    // Lógica para editar/salvar texto da anamnese (aba "Texto da Anamnese")
    const anamneseTexto = document.getElementById('anamnese_texto');
    const editarAnamneseBtn = document.getElementById('editar_anamnese_texto');
    const saveAnamneseBtn = document.getElementById('save_anamnese_texto');

    editarAnamneseBtn.addEventListener('click', () => {
      anamneseTexto.removeAttribute('readonly');
      anamneseTexto.focus();
      editarAnamneseBtn.style.display = 'none';
      saveAnamneseBtn.style.display = 'block';
    });

    saveAnamneseBtn.addEventListener('click', () => {
      const texto = anamneseTexto.value.trim();

      if (texto === '') {
        alert('O texto da anamnese não pode estar vazio.');
        return;
      }

      // Salvar no LocalStorage (opcional)
      localStorage.setItem('anamnese_texto', texto);

      // Bloqueia novamente a edição
      anamneseTexto.setAttribute('readonly', true);
      editarAnamneseBtn.style.display = 'block';
      saveAnamneseBtn.style.display = 'none';

      alert('Anamnese salva com sucesso!');
    });

    // Carrega texto salvo anteriormente (se existir) — opcional
    const savedAnamnese = localStorage.getItem('anamnese_texto');
    if (savedAnamnese) {
      anamneseTexto.value = savedAnamnese;
    }

    // ------------------ AQUI ESTÁ A PARTE MODIFICADA ------------------
    const anamneseForm = document.getElementById('anamnese-form');
    anamneseForm.addEventListener('submit', (e) => {
      e.preventDefault(); // Evita o envio real do formulário

      // 1. Identificação da Criança
      const nome_crianca = document.getElementById('nome_crianca').value.trim();
      const data_nascimento = document.getElementById('data_nascimento').value;
      const idade_atual = document.getElementById('idade_atual').value;
      const sexo = document.getElementById('sexo').value;
      const responsaveis = document.getElementById('responsaveis').value.trim();
      const vinculo = document.getElementById('vinculo').value.trim();

      // 2. Histórico Familiar
      const composicao_familiar = document.getElementById('composicao_familiar').value.trim();
      const historicoSim = document.getElementById('historico_sim').checked;
      const historicoFamilia = historicoSim ? 'Sim' : 'Não';
      let detalhesHistorico = '';
      if (historicoSim) {
        detalhesHistorico = document.getElementById('detalhes_historico').value.trim();
      }

      // 3. Histórico Gestacional e Neonatal
      const gestacaoPlanejada = document.querySelector('input[name="gestacao_planejada"]:checked')?.value === 'sim' ? 'Sim' : 'Não';
      const complicacoesSim = document.getElementById('complicacoes_sim').checked;
      const houveComplicacao = complicacoesSim ? 'Sim' : 'Não';
      let detalhesComplicacoes = '';
      if (complicacoesSim) {
        detalhesComplicacoes = document.getElementById('detalhes_complicacoes').value.trim();
      }

      const tipo_parto = document.getElementById('tipo_parto').value;
      const semanas_gestacao = document.getElementById('semanas_gestacao').value;
      const cuidadosSimChecked = document.getElementById('cuidados_sim').checked;
      const cuidadosEspeciais = cuidadosSimChecked ? 'Sim' : 'Não';
      let detalhesCuidados = '';
      if (cuidadosSimChecked) {
        detalhesCuidados = document.getElementById('detalhes_cuidados').value.trim();
      }

      // 4. Histórico Médico e Saúde Geral
      // (a) Diagnóstico Médico Atual (ex.: epilepsia, alergias)
      const diagMedicoSim = document.getElementById('diagnostico_medico_sim').checked;
      const diagMedicoNao = document.getElementById('diagnostico_medico_nao').checked;
      const diagnosticoMedico = diagMedicoSim ? 'Sim' : 'Não';
      let detalhesDiagMedico = '';
      if (diagMedicoSim) {
        detalhesDiagMedico = document.getElementById('detalhes_diagnostico_medico').value.trim();
      }

      // (b) Internações ou Cirurgias
      const internacoesSim = document.getElementById('internacoes_sim').checked;
      const internacoesNao = document.getElementById('internacoes_nao').checked;
      const internacoes = internacoesSim ? 'Sim' : 'Não';
      let detalhesInternacoes = '';
      if (internacoesSim) {
        detalhesInternacoes = document.getElementById('detalhes_internacoes').value.trim();
      }

      // (c) Uso de Medicação Contínua
      const medicamentosSim = document.getElementById('medicamentos_sim').checked;
      const medicamentosNao = document.getElementById('medicamentos_nao').checked;
      const medicamentos = medicamentosSim ? 'Sim' : 'Não';
      let detalhesMedicamentos = '';
      if (medicamentosSim) {
        detalhesMedicamentos = document.getElementById('detalhes_medicamentos').value.trim();
      }

      // (d) Diagnóstico (Ex.: TEA, TDAH, etc.)
      const diagSim = document.getElementById('diagnostico_sim').checked;
      const diagNao = document.getElementById('diagnostico_nao').checked;
      let diagnosticoStatus = '';
      if (diagSim) {
        diagnosticoStatus = document.getElementById('diagnostico_texto').value.trim();
      } else {
        // Se "Não", usa texto padrão ou deixa vazio
        diagnosticoStatus = document.getElementById('diagnostico_status').value.trim();
      }

      // (e) Acompanhamento
      const acompanhamentoSim = document.getElementById('acompanhamento_sim').checked;
      const acompanhamentoNao = document.getElementById('acompanhamento_nao').checked;
      let detalhesAcompanhamento = '';
      if (acompanhamentoSim) {
        detalhesAcompanhamento = document.getElementById('detalhes_acompanhamento').value.trim();
      }

      // 5. Rotina e Ambiente
      const cuidadorPrincipal = document.getElementById('cuidador_principal').value.trim();
      const escolaSim = document.getElementById('escola_sim').checked;
      const escolaNao = document.getElementById('escola_nao').checked;
      const frequentaEscola = escolaSim ? 'Sim' : 'Não';
      
      let nomeInstituicao = '';
      let comportamentoEscola = '';
      let preocupacaoEscolaSim = false;
      let detalhesPreocupacaoEscola = '';

      if (escolaSim) {
        nomeInstituicao = document.getElementById('nome_instituicao').value.trim();
        comportamentoEscola = document.getElementById('comportamento_escola').value.trim();
        preocupacaoEscolaSim = document.getElementById('preocupacao_escola_sim').checked;

        if (preocupacaoEscolaSim) {
          detalhesPreocupacaoEscola = document.getElementById('detalhes_preocupacao_escola').value.trim();
        }
      }

      const estresseSim = document.getElementById('exposicao_estresse_sim').checked;
      const estresseNao = document.getElementById('exposicao_estresse_nao').checked;
      const exposicaoEstresse = estresseSim ? 'Sim' : 'Não';
      let detalhesEstresse = '';
      if (estresseSim) {
        detalhesEstresse = document.getElementById('detalhes_exposicao_estresse').value.trim();
      }

      // 7. Observações Adicionais
      const observacoesResponsaveis = document.getElementById('observacoes_responsáveis').value.trim();
      const observacoesProfissionais = document.getElementById('observacoes_profissionais').value.trim();

      // ---------------------------------------------------------------
      // MONTA O TEXTO DA ANAMNESE
      // ---------------------------------------------------------------
      let texto = `Anamnese do Paciente: ${nome_crianca}\n\n`;

      texto += `1. Identificação da Criança:\n`;
      texto += `- Nome completo: ${nome_crianca}\n`;
      texto += `- Data de nascimento: ${data_nascimento}\n`;
      texto += `- Idade atual: ${idade_atual}\n`;
      texto += `- Sexo: ${sexo}\n`;
      texto += `- Pai/Responsável presente na entrevista: ${responsaveis} (Vínculo: ${vinculo})\n\n`;

      texto += `2. Histórico Familiar:\n`;
      texto += `- Composição familiar: ${composicao_familiar}\n`;
      texto += `- Há casos na família de transtornos neurológicos ou similares? ${historicoFamilia}\n`;
      if (historicoSim) {
        texto += `  Detalhes: ${detalhesHistorico}\n`;
      }
      texto += `\n`;

      texto += `3. Histórico Gestacional e Neonatal:\n`;
      texto += `- A gestação foi planejada? ${gestacaoPlanejada}\n`;
      texto += `- Houve complicações na gravidez? ${houveComplicacao}\n`;
      if (houveComplicacao === 'Sim') {
        texto += `  Detalhes: ${detalhesComplicacoes}\n`;
      }
      texto += `- Tipo de parto: ${tipo_parto}\n`;
      texto += `- Semanas de gestação: ${semanas_gestacao}\n`;
      texto += `- Necessitou de cuidados especiais ao nascer? ${cuidadosEspeciais}\n`;
      if (cuidadosEspeciais === 'Sim') {
        texto += `  Detalhes: ${detalhesCuidados}\n`;
      }
      texto += `\n`;

      texto += `4. Histórico Médico e Saúde Geral:\n`;
      texto += `- Possui algum diagnóstico médico atual? ${diagnosticoMedico}\n`;
      if (diagnosticoMedico === 'Sim') {
        texto += `  Detalhes: ${detalhesDiagMedico}\n`;
      }
      texto += `- Já foi internada ou submetida a cirurgias? ${internacoes}\n`;
      if (internacoes === 'Sim') {
        texto += `  Detalhes: ${detalhesInternacoes}\n`;
      }
      texto += `- Faz uso de medicação contínua? ${medicamentos}\n`;
      if (medicamentos === 'Sim') {
        texto += `  Detalhes: ${detalhesMedicamentos}\n`;
      }
      texto += `- A criança já foi diagnosticada? ${diagSim ? 'Sim' : 'Não'}\n`;
      if (diagSim) {
        texto += `  Qual diagnóstico? ${diagnosticoStatus}\n`;
      } else {
        texto += `  Status: ${diagnosticoStatus}\n`;
      }
      texto += `- Acompanhamento profissional? ${acompanhamentoSim ? 'Sim' : 'Não'}\n`;
      if (acompanhamentoSim) {
        texto += `  Detalhes: ${detalhesAcompanhamento}\n`;
      }
      texto += `\n`;

      texto += `5. Rotina e Ambiente:\n`;
      texto += `- Principal cuidador da criança: ${cuidadorPrincipal}\n`;
      texto += `- Frequenta escola ou creche? ${frequentaEscola}\n`;
      if (frequentaEscola === 'Sim') {
        texto += `  Instituição / Período: ${nomeInstituicao}\n`;
        texto += `  Comportamento na escola: ${comportamentoEscola}\n`;
        texto += `  Alguma preocupação sinalizada? ${preocupacaoEscolaSim ? 'Sim' : 'Não'}\n`;
        if (preocupacaoEscolaSim) {
          texto += `    Detalhes: ${detalhesPreocupacaoEscola}\n`;
        }
      }
      texto += `- Exposição a fatores estressantes? ${exposicaoEstresse}\n`;
      if (exposicaoEstresse === 'Sim') {
        texto += `  Detalhes: ${detalhesEstresse}\n`;
      }
      texto += `\n`;

      texto += `6. Observações Adicionais:\n`;
      texto += `- Dos responsáveis: ${observacoesResponsaveis}\n`;
      texto += `- Do profissional (avaliador): ${observacoesProfissionais}\n`;

      // Insere o texto na aba "Texto da Anamnese"
      anamneseTexto.value = texto;

      // Salvar no LocalStorage (opcional)
      localStorage.setItem('anamnese_texto', texto);

      // Alternar para a aba "Texto da Anamnese"
      tabs.forEach(item => item.classList.remove('active'));
      tabContents.forEach(content => content.classList.remove('active'));

      document.querySelector('.tab[data-tab="texto"]').classList.add('active');
      document.getElementById('texto').classList.add('active');
    });
  });
</script>

   </body>
</html>
