<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Gerenciamento - Sistema de Avaliação IFCora</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">
    <style>
        /* Card de Perfil com Abas Lado a Lado */
        .profile-card {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 20px;
            display: flex;
            flex-wrap: wrap;
        }
        .profile-left {
            width: 100%;
            max-width: 300px;
            padding-right: 15px;
            border-right: 1px solid #e2e8f0;
        }
        .profile-right {
            flex: 1;
            padding-left: 15px;
        }
        .profile-header {
            display: flex;
            align-items: center;
            margin-bottom: 0px;
            position: relative;
        }
        .profile-header img {
            width: 90px;
            height: 90px;
            border-radius: 50%;
            border: 2px solid #08C89E;
            margin-right: 15px;
        }
        .edit-photo {
            position: absolute;
            top: 60px;
            left: 60px;
            background-color: #08C89E;
            color: #fff;
            border: none;
            border-radius: 50%;
            padding: 6px;
            cursor: pointer;
        }
        .profile-header h2 {
            font-size: 22px;
            color: #08C89E;
            line-height: 100%;
        }
        .profile-info p {
            font-size: 15px;
            color: #4a5568;
            margin-bottom: 2px;
            margin: 0px;
        }
        
        
        .profile-actions {
            display: flex;
            flex-wrap: wrap;
            margin-top: 10px;
        }
        .profile-actions button {
            background-color: #08C89E;
            color: #fff;
            padding: 8px 12px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 13px;
            margin-right: 8px;
            margin-bottom: 8px;
            transition: background 0.3s;
            display: flex;
            align-items: center;
        }
        .profile-actions button:hover {
            background-color: #06b287;
        }
        .profile-actions button i {
            margin-right: 4px;
        }
        
        
        
        
        
        .person-card {
            background-color: #f7fafc;
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            padding: 10px;
            margin-bottom: 10px;
            display: flex;
            flex-direction: column;
            align-items: flex-start;
        }
        .person-card h3 {
            font-size: 15px;
            color: #2d3748;
            margin-bottom: 4px;
            margin-top: 0px;
        }
        .person-card p {
            font-size: 13px;
            color: #4a5568;
            margin: 0px;
        }
        .person-card .remove-btn {
            background-color: #E53E3E;
            color: #fff;
            padding: 6px 10px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 12px;
            margin-top: 8px;
            transition: background 0.3s;
        }
        .person-card .remove-btn:hover {
            background-color: #c53030;
        }
        
        
        
        #responsaveis .person-card {
            display: inline-block;
            width: calc(30% - 10px);
            margin: 5px;
            vertical-align: top;
        }
        
        
        .remove-icon {
            font-size: 16px;
            color: #e53e3e;
            cursor: pointer;
            transition: color 0.3s;
        }
        .remove-icon:hover {
            color: #c53030;
        }

        .annotations {
            margin-top: 40px;
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 10px;
            padding: 20px;
        }
        .annotations h2 {
            font-size: 22px;
            color: #2d3748;
            margin-bottom: 15px;
            text-align: left;
        }
        .status-button {
            background-color: #ffffff;
            color: #F7702D;
            border: 2px solid #F7702D;
            padding: 5px 10px;
            border-radius: 6px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: background-color 0.3s, color 0.3s;
        }
        .status-button:hover {
            background-color: #F7702D;
            color: #ffffff;
        }
        
        
        /* Estilos para o Formulário de Anamnese */
.anamnese-form {
    margin-top: 20px;
}

        /* Ferramentas */
        .tools {
            margin-top: 20px;
        }
        .tools h2 {
            font-size: 22px;
            color: #2d3748;
            margin-bottom: 15px;
        }
        .tools-grid {
            display: grid; /* Usa Grid Layout */
            grid-template-columns: repeat(4, 1fr); /* Até 4 colunas */
            gap: 20px; /* Espaçamento entre os cartões */
        }
        .tool-card {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 10px 10px 10px 10px;
            transition: box-shadow 0.2s, transform 0.2s;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }
        .tool-card:hover {
            box-shadow: 0 3px 10px rgba(0, 0, 0, 0.1);
            transform: translateY(-2px);
        }
        .tool-info h3 {
            font-size: 18px;
            color: #2d3748;
            margin: 0 0 5px;
            font-weight: 600;
        }
        .tool-info p {
            font-size: 14px;
            color: #4a5568;
            margin: 0 0 10px;
        }
        .tool-info button {
            background-color: #08C89E;
            color: #fff;
            border: none;
            padding: 8px 12px;
            border-radius: 6px;
            font-size: 14px;
            cursor: pointer;
            transition: background 0.3s;
            align-self: start;
        }
        .tool-info button:hover {
            background-color: #06b287;
        }
        
        
        /* Área de Texto para Anotações */
        .annotation-area {
            width: 100%;
            margin-top: 10px;
        }
        .annotation-area textarea {
            width: 100%;
            height: 80px;
            padding: 10px;
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            resize: vertical;
            font-size: 14px;
            color: #2d3748;
            box-sizing: border-box;
        }
        .annotation-area button {
            background-color: #08C89E;
            color: #fff;
            padding: 8px 15px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 13px;
            margin-top: 8px;
            transition: background 0.3s;
        }
        .annotation-area button:hover {
            background-color: #06b287;
        }
        /* Estilos das Anotações */
        .annotation {
            background-color: #f7fafc;
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            padding: 10px;
            margin-bottom: 10px;
            margin-top: 10px;
        }
        .annotation-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .annotation-author {
            font-weight: bold;
            font-size: 14px;
            color: #2d3748;
        }
        .annotation-date {
            font-size: 12px;
            color: #718096;
        }
        .annotation-content {
            margin-top: 5px;
            font-size: 14px;
            color: #4a5568;
        }
        .annotation-actions {
            margin-top: 5px;
            display: flex;
            gap: 10px;
        }
        .annotation-actions button {
            background: none;
            border: none;
            color: #08C89E;
            cursor: pointer;
            font-size: 13px;
            padding: 0;
        }
        .annotation-actions button:hover {
            text-decoration: underline;
        }
        /* Respostas às Anotações */
        .annotation-replies {
            margin-left: 20px;
            margin-top: 10px;
        }
        /* Formulário de Anamnese */
        .anamnese-form h2 {
    font-size: 22px;
    color: #2d3748;
    margin-bottom: 15px;
    text-align: left;
}

.anamnese-form fieldset {
    border: 1px solid #e2e8f0;
    border-radius: 6px;
    padding: 15px;
    margin-bottom: 20px;
}

.anamnese-form legend {
    font-size: 18px;
    font-weight: 600;
    color: #08C89E;
    padding: 0 10px;
}

.anamnese-form .form-group {
    margin-bottom: 15px;
}

.anamnese-form label {
    display: block;
    font-size: 14px;
    color: #2d3748;
    margin-bottom: 5px;
}

.anamnese-form input,
.anamnese-form select,
.anamnese-form textarea {
    width: 100%;
    padding: 8px;
    border: 1px solid #e2e8f0;
    border-radius: 6px;
    font-size: 14px;
    color: #2d3748;
    box-sizing: border-box;
    background-color: #fff;
}

.anamnese-form input:focus,
.anamnese-form select:focus,
.anamnese-form textarea:focus {
    outline: none;
    border-color: #08C89E;
    box-shadow: 0 0 0 1px #08C89E;
}

.anamnese-form .radio-group {
    display: flex;
    gap: 20px;
    align-items: center;
}

.anamnese-form .radio-group input {
    margin-right: 5px;
}

.submit-btn {
    background-color: #08C89E;
    color: #fff;
    padding: 10px 20px;
    border: none;
    border-radius: 6px;
    cursor: pointer;
    font-size: 15px;
    transition: background 0.3s;
}

.submit-btn:hover {
    background-color: #06b287;
}
        
        
        /* Estilos do Modal */
        .modal {
            display: none; /* Oculto por padrão */
            position: fixed;
            z-index: 200; /* Sobrepõe outros elementos */
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0,0,0,0.5); /* Fundo semitransparente */
        }
        .modal-content {
            background-color: #fefefe;
            margin: 5% auto; /* Centraliza verticalmente */
            padding: 20px;
            border: 1px solid #888;
            width: 80%; /* Largura do modal */
            max-width: 800px;
            border-radius: 10px;
            position: relative;
        }
        .close-button {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
            position: absolute;
            right: 20px;
            top: 10px;
            cursor: pointer;
        }
        .close-button:hover,
        .close-button:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }
        
        
        .annotations {
            margin-top: 40px;
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 10px;
            padding: 20px;
        }
        .annotations h2 {
            font-size: 22px;
            color: #2d3748;
            margin-bottom: 15px;
            text-align: left;
        }
        .status-button {
            background-color: #ffffff;
            color: #F7702D;
            border: 2px solid #F7702D;
            padding: 5px 10px;
            border-radius: 6px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: background-color 0.3s, color 0.3s;
        }
        .status-button:hover {
            background-color: #F7702D;
            color: #ffffff;
        }
        
        
        
    </style>
</head>
<body>
    <?php include 'includes/header1.php'; ?>
    <?php include 'includes/sidebar-painel-clinica-crianças.php'; ?>

    <!-- Conteúdo -->
    <main class="content">
        <div class="header-content">
                <h1 style="color: #08C89E; margin-left: 0px"><i class="fa-solid fa-address-card" style="margin-right: 8px"></i>Perfil da Criança</h1>

        </div>
        <!-- Card de Perfil com Abas Lado a Lado -->
        <section class="profile-card">
            <!-- Esquerda: Informações do Perfil -->
            <div class="profile-left">
                <div class="profile-header">
                    <!-- <img src="https://api.dicebear.com/6.x/pixel-art/svg?seed=2" alt="Foto da Criança">
                    <!-- Botão para alterar foto -->
                    <!-- <button class="edit-photo" title="Alterar Foto"><i class="fas fa-camera"></i></button> -->
                    <h2>Luís Gustavo de Oliveira Santos Barosa</h2>
                </div>
                <div class="profile-info">
                    <p><b>COD:</b> #ABC12345</p>
                    <p><b>DT/Nasc.:</b> 01/01/2016</p>
                    <p><b>Idade:</b> 7 anos</p>
                    <p><b>Responsável:</b> Maria da Silva</p>
                    <p><b>Clínica:</b> Sertãozinho</p>

                    <p>‎ </p>
                </div>
                <!-- Ações do Perfil -->
                <!-- <div class="profile-actions">
                    <button><i class="fas fa-edit"></i>Editar Dados</button>
                </div> -->
            </div>
            
            <!-- Direita: Abas -->
            <div class="profile-right">
                <!-- Abas -->
                <div class="tab-container">
                    <div class="tabs">
                        <div class="tab active" data-tab="profissionais">Profissionais</div>
                        <div class="tab" data-tab="responsaveis">Assistente/Responsáveis</div>
                        
                        
                    </div>
                    <!-- Conteúdo das Abas -->
                    
                    
                    <div id="profissionais" class="tab-content active">
                        
                        <!-- Cards de pessoas -->
                        <table class="table-section" id="profissionaisTable">
                            <p style="margin-top: -10px;">Profissionais Associados:</p>
                            <thead>
                                <tr>
                                    <th data-field="ORD">ORD</th>
                                    <th data-field="id">ID</th>
                                    <th data-field="nome">Nome</th>
                                    <th data-field="especialidade">Especialidade</th>
                                    <th data-field="perfil">Perfil</th>
                                    
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Linhas da tabela via JavaScript -->
                            </tbody>
                        </table>
                        <!-- Paginação para Profissionais -->
                    <div class="pagination" style="text-align: center; margin-top: 20px;">
                        <a href="#" class="active">1</a>
                        <a href="#">2</a>
                        <a href="#">3</a>
                        <a href="#">4</a>
                        <a href="#">Próximo &raquo;</a>
                    </div>
                        
                    </div>
                    
                    
                    
                    

                    <div id="responsaveis" class="tab-content">
                        
                        <!-- Tabela de Responsáveis -->
                        <table class="table-section" id="responsaveisTable">
                            <!-- Outros cards de pessoas -->
                        <div style="margin-top: -10px; padding: 5px; margin-bottom: -10px;">
                        <p style="margin-top: -10px; margin-bottom: 0px">Responsáveis Associados:</p>

                        <button class="add-person-btn"><i class="fas fa-user-plus"></i>Adicionar Pessoa</button>
                        </div>
                        <hr />
                            <thead>
                                <tr>
                                    <th data-field="ORD">ORD</th>
                                    <th data-field="id">ID</th>
                                    <th data-field="nome">Nome</th>
                                    <th data-field="email">Email</th>
                                    <th data-field="perfil">Perfil</th>
                                    <th>#</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Linhas da tabela via JavaScript -->
                            </tbody>
                        </table>
                        <!-- Paginação para Profissionais -->
                    <div class="pagination" style="text-align: center; margin-top: 20px;">
                        <a href="#" class="active">1</a>
                        <a href="#">2</a>
                        <a href="#">3</a>
                        <a href="#">4</a>
                        <a href="#">Próximo &raquo;</a>
                    </div>
                    </div>
                    

                    
                    
                </div>
            </div>
        </section>
        
        
        
        
        
        
        
        <!-- Modal para Adicionar Responsável -->
<div id="add-responsavel-modal" style="display: none; position: fixed; z-index: 300; left: 0; top: 0; width: 100%; height: 100%; overflow: auto; background-color: rgba(0,0,0,0.5); justify-content: center; align-items: center;">
    <div style="background-color: #fff; padding: 20px; border-radius: 10px; width: 90%; max-width: 500px; position: relative;">
        <span id="closeAddResponsavelModal" style="color: #aaa; font-size: 28px; font-weight: bold; position: absolute; top: 10px; right: 20px; cursor: pointer;">&times;</span>
        
        <section>
            <h2 style="font-size: 22px; color: #333; margin-bottom: 10px;">Adicionar Responsável</h2>
            <hr style="border: 1px solid #e2e8f0; margin-bottom: 20px;">
            
            <form id="addResponsavelForm" style="display: flex; flex-direction: column; gap: 20px;">
                <!-- Campo de Email com Ícone de Pesquisa -->
                <div style="display: flex; flex-direction: column;">
                    <label for="search_email" style="font-size: 14px; color: #333; margin-bottom: 8px;">Email do Usuário:</label>
                    <div style="display: flex; gap: 10px; align-items: center;">
                        <input type="email" id="search_email" name="search_email" placeholder="Digite o email..." required style="padding: 10px; border: 1px solid #ccc; border-radius: 6px; flex: 1; font-size: 14px;" value="laura.martins@example.com">
                        <button type="button" id="searchBtn" title="Pesquisar" style="background-color: #08C89E; color: #fff; border: none; padding: 10px 15px; border-radius: 6px; cursor: pointer; font-size: 14px;">
                            <i class="fas fa-search"></i>
                        </button>
                    </div>
                </div>
                
                <!-- Seção para Exibir Informações do Usuário -->
                <div id="userInfo" style="display: none; ">
                    <h4 style="margin-top: -10px; margin-bottom: -10px">Usuario localizado com sucesso!</h4>
                    <div style="margin-bottom: 20px; margin-top: 10px; background-color: #f9f9f9; padding: 8px 16px; border-radius: 8px; border: 1px solid #ccc;">
                        <p style="font-size: 14px; color: #333; "><strong>ID:</strong> <span id="user_id"></span></p>
                        <p style="font-size: 14px; color: #333; margin-top:-10px"><strong>Nome:</strong> <span id="user_nome"></span></p>
                        <p style="font-size: 14px; color: #333; margin-top:-10px"><strong>Email:</strong> <span id="user_email"></span></p>
                        <p style="font-size: 14px; color: #333; margin-top:-10px;"><strong>Perfil:</strong> <span id="user_perfil"></span></p>
                    </div>
                </div>
                <!-- Botões de Ação -->
                <div id="formActions" style="display: none; flex: 1; gap: 10px; justify-content: space-between;">
                    <button type="button" id="addBtn" style="background-color: #08C89E; color: white; padding: 10px 20px; border-radius: 6px; font-size: 14px; cursor: pointer; flex: 1;">Adicionar</button>
                    <button type="button" id="cancelBtn" style="background-color: #E53E3E; color: white; padding: 10px 20px; border-radius: 6px; font-size: 14px; cursor: pointer; flex: 1;">Cancelar</button>
                </div>
            </form>
        </section>
    </div>
</div>



        
        
        
        
        
        <!-- Seleção de Ferramentas -->
        <section class="tools">
            <h2 style="color: #08C89E; margin-bottom: -10px">Ferramentas</h2>
            <hr />
            <div class="tools-grid">
                <!-- Anamneses -->
                <div class="tool-card" style="background-color: #E9F4FF;">
                    <div class="tool-info" >
                        <h3>Anamnese</h3>
                        <p style="margin-top:-10px">Dados da criança.</p>
                        <button class="action-btn" onclick="window.location.href='painel-clinica-perfil-criança-anamnese.php';"><i class="fas fa-arrow-right"></i> Acessar</button>
                    </div>
                </div>
                <!-- Regsitros Clínicos -->
                <div class="tool-card" style="background-color: #E9F4FF;">
                    <div class="tool-info" >
                        <h3>Registros Clínicos</h3>
                        <p style="margin-top:-10px">Registros de supervisão.</p>
                        <button class="action-btn" onclick="window.location.href='painel-clinica-perfil-criança-registro-clinico.php';"><i class="fas fa-arrow-right"></i> Acessar</button>
                    </div>
                </div>
                <!-- Ferramenta 1 -->
                <div class="tool-card">
                    <div class="tool-info">
                        <h3>PORTAGE</h3>
                        <p style="margin-top:-10px">Avaliação de desenvolvimento infantil.</p>
                        <button class="action-btn" onclick="window.location.href='portage/painel-clinica-perfil-criança-linha-portage.php';"><i class="fas fa-arrow-right"></i> Acessar</button>
                    </div>
                </div>
                <!-- Ferramenta 2 -->
                <div class="tool-card">
                    <div class="tool-info">
                        <h3>M-CHAT</h3>
                        <p style="margin-top:-10px">Checklist hipotese.</p>
                        <button class="action-btn" onclick="window.location.href='painel-clinica-perfil-criança-mchat.php';"><i class="fas fa-arrow-right"></i> Acessar</button>
                    </div>
                </div>
                <!-- Ferramenta 3 -->
                <div class="tool-card">
                    <div class="tool-info">
                        <h3>CARS</h3>
                        <p style="margin-top:-10px">Escala de avaliação de autismo.</p>
                        <button>Acessar</button>
                    </div>
                </div>
                <!-- Ferramenta 4 -->
                <div class="tool-card">
                    <div class="tool-info">
                        <h3>ABLLS</h3>
                        <p style="margin-top:-10px">Ferramenta para habilidades.</p>
                        <button>Acessar</button>
                    </div>
                </div>
                <!-- Ferramenta 1 -->
                <div class="tool-card">
                    <div class="tool-info">
                        <h3>ATA</h3>
                        <p style="margin-top:-10px">Avaliação de desenvolvimento infantil.</p>
                        <button>Acessar</button>
                    </div>
                </div>
                
                
            </div>
        </section>
        
        <h2 style="color: #08C89E; margin-bottom: 0px">Anotações</h2>
        <!-- Seção de Anotações -->
        <section id="anotacoes-section" class="annotations" style="margin-top: 0px">
            
            <h2>Anotações</h2>
            <!-- Área de Texto para Anotações -->
            <div class="annotation-area">
                <textarea placeholder="Escreva uma nova anotação..."></textarea>
                <button><i class="fas fa-paper-plane" ></i> Salvar Anotação</button>
            </div>
            <!-- Lista de Anotações Anteriores -->
            <div class="annotation">
                <div class="annotation-header">
                    <div class="annotation-author">Coralina Matos</div>
                    <div class="annotation-date">10/05/2023</div>
                </div>
                <div class="annotation-content">
                    Esta é uma anotação de exemplo. Aqui estão os detalhes importantes.
                </div>
                <div class="annotation-actions">
                    <button class="reply-btn">Responder</button>
                    <button class="edit-btn">Editar</button>
                    <button class="delete-btn">Excluir</button>
                </div>
                <!-- Respostas -->
                <div class="annotation-replies">
                    <div class="annotation">
                        <div class="annotation-header">
                            <div class="annotation-author">João Pereira</div>
                            <div class="annotation-date">11/05/2023</div>
                        </div>
                        <div class="annotation-content">
                            Esta é uma resposta à anotação.
                        </div>
                        <div class="annotation-actions">
                            <button class="reply-btn">Responder</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="annotation">
                <div class="annotation-header">
                    <div class="annotation-author">Coralina Matos</div>
                    <div class="annotation-date">10/05/2023</div>
                </div>
                <div class="annotation-content">
                    Esta é uma anotação de exemplo. Aqui estão os detalhes importantes.
                </div>
                <div class="annotation-actions">
                    <button class="reply-btn">Responder</button>
                    <button class="edit-btn">Editar</button>
                    <button class="delete-btn">Excluir</button>
                </div>
                <!-- Respostas -->
                <div class="annotation-replies">
                    <div class="annotation">
                        <div class="annotation-header">
                            <div class="annotation-author">João Pereira</div>
                            <div class="annotation-date">11/05/2023</div>
                        </div>
                        <div class="annotation-content">
                            Esta é uma resposta à anotação.
                        </div>
                        <div class="annotation-actions">
                            <button class="reply-btn">Responder</button>
                        </div>
                        
                    </div>
                    <div class="annotation">
                        <div class="annotation-header">
                            <div class="annotation-author">João Pereira</div>
                            <div class="annotation-date">11/05/2023</div>
                        </div>
                        <div class="annotation-content">
                            Esta é uma resposta à anotação.
                        </div>
                        <div class="annotation-actions">
                            <button class="reply-btn">Responder</button>
                        </div>
                        
                    </div>
                </div>
            </div>
            <!-- Outras anotações -->
        </section>
        
        
        
        


    </main>

    <!-- JavaScript para as Abas e Formulários -->
    <script>
        // Seleciona todas as abas
        const tabs = document.querySelectorAll('.tab');
        // Seleciona todo o conteúdo das abas
        const tabContents = document.querySelectorAll('.tab-content');

        tabs.forEach(tab => {
            tab.addEventListener('click', () => {
                // Remove a classe 'active' de todas as abas e conteúdos
                tabs.forEach(item => item.classList.remove('active'));
                tabContents.forEach(content => content.classList.remove('active'));

                // Adiciona a classe 'active' na aba clicada e no conteúdo correspondente
                tab.classList.add('active');
                document.getElementById(tab.getAttribute('data-tab')).classList.add('active');
            });
        });

        // Modal do Formulário de Anamnese
        const openAnamneseModalBtn = document.getElementById('open-anamnese-modal');
        const anamneseModal = document.getElementById('anamnese-modal');
        const closeModalBtn = document.querySelector('.close-button');

        openAnamneseModalBtn.addEventListener('click', () => {
            anamneseModal.style.display = 'block';
        });

        closeModalBtn.addEventListener('click', () => {
            anamneseModal.style.display = 'none';
        });

        // Fechar o modal ao clicar fora dele
        window.addEventListener('click', (event) => {
            if (event.target == anamneseModal) {
                anamneseModal.style.display = 'none';
            }
        });
    </script>
    
    <script>
    // Mostrar/ocultar detalhes do histórico familiar
    document.getElementsByName('historico_familiar').forEach((elem) => {
        elem.addEventListener('change', function() {
            let detalhesGroup = document.getElementById('detalhes_historico_group');
            if (this.value === 'sim') {
                detalhesGroup.style.display = 'block';
            } else {
                detalhesGroup.style.display = 'none';
            }
        });
    });

    // Mostrar/ocultar detalhes dos cuidados especiais
    document.getElementsByName('cuidados_especiais').forEach((elem) => {
        elem.addEventListener('change', function() {
            let detalhesCuidadosGroup = document.getElementById('detalhes_cuidados_group');
            if (this.value === 'sim') {
                detalhesCuidadosGroup.style.display = 'block';
            } else {
                detalhesCuidadosGroup.style.display = 'none';
            }
        });
    });

    // Mostrar/ocultar nome da instituição
    document.getElementsByName('frequenta_escola').forEach((elem) => {
        elem.addEventListener('change', function() {
            let instituicaoGroup = document.getElementById('nome_instituicao_group');
            if (this.value === 'sim') {
                instituicaoGroup.style.display = 'block';
            } else {
                instituicaoGroup.style.display = 'none';
            }
        });
    });
</script>

<script>
    // Função para fechar o modal ao clicar no "X"
    document.getElementById('closeAnamneseModal').addEventListener('click', function() {
        document.getElementById('anamnese-modal').style.display = 'none';
    });

    // Fechar o modal ao clicar fora da área de conteúdo
    window.addEventListener('click', function(event) {
        const modal = document.getElementById('anamnese-modal');
        if (event.target == modal) {
            modal.style.display = 'none';
        }
    });

    // Lógica para mostrar/ocultar campos condicionais

    // Histórico Familiar
    const historicoSim = document.getElementById('historico_sim');
    const historicoNao = document.getElementById('historico_nao');
    const detalhesHistoricoGroup = document.getElementById('detalhes_historico_group');

    historicoSim.addEventListener('change', function() {
        if (this.checked) {
            detalhesHistoricoGroup.style.display = 'block';
        }
    });

    historicoNao.addEventListener('change', function() {
        if (this.checked) {
            detalhesHistoricoGroup.style.display = 'none';
            document.getElementById('detalhes_historico').value = '';
        }
    });

    // Histórico Gestacional e Neonatal
    const cuidadosSim = document.getElementById('cuidados_sim');
    const cuidadosNao = document.getElementById('cuidados_nao');
    const detalhesCuidadosGroup = document.getElementById('detalhes_cuidados_group');

    cuidadosSim.addEventListener('change', function() {
        if (this.checked) {
            detalhesCuidadosGroup.style.display = 'block';
        }
    });

    cuidadosNao.addEventListener('change', function() {
        if (this.checked) {
            detalhesCuidadosGroup.style.display = 'none';
            document.getElementById('detalhes_cuidados').value = '';
        }
    });

    // Rotina e Ambiente - Frequência na Escola
    const frequentaEscolaSim = document.getElementById('escola_sim');
    const frequentaEscolaNao = document.getElementById('escola_nao');
    const nomeInstituicaoGroup = document.getElementById('nome_instituicao_group');

    frequentaEscolaSim.addEventListener('change', function() {
        if (this.checked) {
            nomeInstituicaoGroup.style.display = 'block';
        }
    });

    frequentaEscolaNao.addEventListener('change', function() {
        if (this.checked) {
            nomeInstituicaoGroup.style.display = 'none';
            document.getElementById('nome_instituicao').value = '';
        }
    });
    
    
    
</script>

<!-- JavaScript para a Tabela de Profissionais -->
    <script>
        // Dados simulados (em produção, esses dados viriam do backend)
        const profissionais = [
            {ORD: '1', id: 'PROF001', nome: 'Mariana Santos', especialidade: 'Fonoaudióloga', perfil: 'Colaborador'},
            {ORD: '2', id: 'PROF002', nome: 'Pedro Oliveira', especialidade: 'Psicólogo', perfil: 'Supervisor'},
            {ORD: '3', id: 'PROF003', nome: 'Ana Luiza', especialidade: 'Terapeuta Ocupacional', perfil: 'Co-Admin'},
            {ORD: '4', id: 'PROF004', nome: 'Carla Paes', especialidade: 'Fonoaudiólogo', perfil: 'Colaborador'},
            {ORD: '5', id: 'PROF005', nome: 'João Pereira', especialidade: 'Psicólogo', perfil: 'Assistente'},
            // Adicione mais profissionais conforme necessário
        ];

        const profissionaisTableBody = document.querySelector('#profissionaisTable tbody');
        const tableHeaders = document.querySelectorAll('.profissionais-table th[data-field]');
        let currentSortField = '';
        let currentSortAsc = true;

        // Função para renderizar a tabela de profissionais
        function renderProfissionais() {
            profissionaisTableBody.innerHTML = '';

            profissionais.forEach(prof => {
                const tr = document.createElement('tr');

                tr.innerHTML = `
                    <td data-label="ID">${prof.ORD}</td>
                    <td data-label="ID">${prof.id}</td>
                    <td data-label="Nome">${prof.nome}</td>
                    <td data-label="Especialidade">${prof.especialidade}</td>
                    <td data-label="Perfil">${prof.perfil}</td>
                    
                `;
                profissionaisTableBody.appendChild(tr);
            });
        }

        // Função para ordenar a tabela
        tableHeaders.forEach(header => {
            header.addEventListener('click', () => {
                const field = header.getAttribute('data-field');
                if (currentSortField === field) {
                    currentSortAsc = !currentSortAsc;
                } else {
                    currentSortField = field;
                    currentSortAsc = true;
                }

                // Limpar classes de ordenação anteriores
                tableHeaders.forEach(h => h.classList.remove('sort-asc', 'sort-desc'));

                // Adicionar classe de ordenação atual
                header.classList.add(currentSortAsc ? 'sort-asc' : 'sort-desc');

                profissionais.sort((a, b) => {
                    let valA = a[field].toLowerCase();
                    let valB = b[field].toLowerCase();

                    if (valA < valB) return currentSortAsc ? -1 : 1;
                    if (valA > valB) return currentSortAsc ? 1 : -1;
                    return 0;
                });

                renderProfissionais();
            });
        });

        // Funções para editar e remover profissionais
        function editarProfissional(id) {
            // Implementar a lógica de edição (pode abrir um modal com os dados do profissional)
            alert('Editar profissional: ' + id);
        }

        function removerProfissional(id) {
            if (confirm('Deseja realmente remover o profissional ' + id + '?')) {
                const index = profissionais.findIndex(prof => prof.id === id);
                if (index !== -1) {
                    profissionais.splice(index, 1);
                    renderProfissionais();
                    alert('Profissional removido com sucesso.');
                }
            }
        }

        // Renderizar a tabela ao carregar a página
        document.addEventListener('DOMContentLoaded', () => {
            renderProfissionais();
        });
    </script>
    
    
    <!-- JavaScript para a Tabela de Responsáveis -->
<script>
    // Dados simulados (em produção, esses dados viriam do backend)
    const responsaveis = [
        {ORD:'1', id: 'REA001', nome: 'Maria da Silva', email: 'maria.silva@example.com', perfil: 'Responsável'},
        {ORD:'2', id: 'ATP002', nome: 'João Pereira', email: 'joao.pereira@example.com', perfil: 'Assistente'},
        {ORD:'3', id: 'REA003', nome: 'Carla Mendes', email: 'carla.mendes@example.com', perfil: 'Responsável'},
        {ORD:'4', id: 'ATB004', nome: 'Fernando Costa', email: 'fernando.costa@example.com', perfil: 'Assistente'},
        // Adicione mais responsáveis conforme necessário
    ];

    const responsaveisTableBody = document.querySelector('#responsaveisTable tbody');
    const responsaveisTableHeaders = document.querySelectorAll('.responsaveis-table th[data-field]');
    let currentSortFieldResp = '';
    let currentSortAscResp = true;

    // Função para renderizar a tabela de responsáveis
    function renderResponsaveis() {
        responsaveisTableBody.innerHTML = '';

        responsaveis.forEach(resp => {
            const tr = document.createElement('tr');

            tr.innerHTML = `
                <td data-label="ID">${resp.ORD}</td>
                <td data-label="ID">${resp.id}</td>
                <td data-label="Nome">${resp.nome}</td>
                <td data-label="Email">${resp.email}</td>
                <td data-label="Perfil">${resp.perfil}</td>
                <td data-label="Ações">
                    <div class="action-buttons">
                        <button style="background-color: transparent; border: none; color: red" onclick="removerResponsavel('${resp.id}')"><i class="fas fa-trash"></i></button>
                    </div>
                </td>
            `;
            responsaveisTableBody.appendChild(tr);
        });
    }

    // Função para ordenar a tabela de responsáveis
    responsaveisTableHeaders.forEach(header => {
        header.addEventListener('click', () => {
            const field = header.getAttribute('data-field');
            if (currentSortFieldResp === field) {
                currentSortAscResp = !currentSortAscResp;
            } else {
                currentSortFieldResp = field;
                currentSortAscResp = true;
            }

            // Limpar classes de ordenação anteriores
            responsaveisTableHeaders.forEach(h => h.classList.remove('sort-asc', 'sort-desc'));

            // Adicionar classe de ordenação atual
            header.classList.add(currentSortAscResp ? 'sort-asc' : 'sort-desc');

            responsaveis.sort((a, b) => {
                let valA = a[field].toLowerCase();
                let valB = b[field].toLowerCase();

                if (valA < valB) return currentSortAscResp ? -1 : 1;
                if (valA > valB) return currentSortAscResp ? 1 : -1;
                return 0;
            });

            renderResponsaveis();
        });
    });

    // Funções para editar e remover responsáveis
    function editarResponsavel(id) {
        // Implementar a lógica de edição (pode abrir um modal com os dados do responsável)
        alert('Editar responsável: ' + id);
    }

    function removerResponsavel(id) {
        if (confirm('Deseja realmente remover o responsável ' + id + '?')) {
            const index = responsaveis.findIndex(resp => resp.id === id);
            if (index !== -1) {
                responsaveis.splice(index, 1);
                renderResponsaveis();
                alert('Responsável removido com sucesso.');
            }
        }
    }

    // Renderizar a tabela ao carregar a página
    document.addEventListener('DOMContentLoaded', () => {
        renderResponsaveis();
    });
</script>
    
    
    
    <!-- JavaScript para Adicionar Responsável via Modal -->
<script>
// Dados simulados de usuários disponíveis para adicionar
const usuariosDisponiveis = [
    {id: 'RESP005', nome: 'Laura Martins', email: 'laura.martins@example.com', perfil: 'Responsável'},
    {id: 'RESP006', nome: 'Carlos Souza', email: 'carlos.souza@example.com', perfil: 'Assistente'},
    {id: 'RESP007', nome: 'Fernanda Lima', email: 'fernanda.lima@example.com', perfil: 'Responsável'},
    {id: 'RESP008', nome: 'Ricardo Gomes', email: 'ricardo.gomes@example.com', perfil: 'Assistente'},
    // Adicione mais usuários conforme necessário
];

// Seleciona elementos do modal
const addResponsavelModal = document.getElementById('add-responsavel-modal');
const openAddResponsavelBtn = document.querySelector('#responsaveis .add-person-btn');
const closeAddResponsavelModalBtn = document.getElementById('closeAddResponsavelModal');
const searchBtn = document.getElementById('searchBtn');
const addBtn = document.getElementById('addBtn');
const cancelBtn = document.getElementById('cancelBtn');

// Campos do formulário
const searchEmailInput = document.getElementById('search_email');
const userInfoDiv = document.getElementById('userInfo');
const user_id = document.getElementById('user_id');
const user_nome = document.getElementById('user_nome');
const user_email = document.getElementById('user_email');
const user_perfil = document.getElementById('user_perfil');
const formActions = document.getElementById('formActions');

// Variável para armazenar o usuário encontrado
let usuarioEncontrado = null;

// Função para abrir o modal
openAddResponsavelBtn.addEventListener('click', () => {
    addResponsavelModal.style.display = 'flex';
    resetModal();
});

// Função para fechar o modal
closeAddResponsavelModalBtn.addEventListener('click', () => {
    addResponsavelModal.style.display = 'none';
    resetModal();
});

// Função para cancelar a operação
cancelBtn.addEventListener('click', () => {
    addResponsavelModal.style.display = 'none';
    resetModal();
});

// Função para resetar o modal
function resetModal() {
    document.getElementById('addResponsavelForm').reset();
    userInfoDiv.style.display = 'none';
    formActions.style.display = 'none';
    usuarioEncontrado = null;
}

// Função para pesquisar usuário por email
searchBtn.addEventListener('click', () => {
    const email = searchEmailInput.value.trim().toLowerCase();

    if (email === '') {
        alert('Por favor, insira um email para pesquisar.');
        return;
    }

    // Procurar o usuário na lista de disponíveis
    const usuario = usuariosDisponiveis.find(user => user.email.toLowerCase() === email);

    if (!usuario) {
        alert('Usuário não encontrado.');
        resetModal();
        return;
    }

    if (usuario.perfil !== 'Responsável' && usuario.perfil !== 'Assistente') {
        alert('O usuário pesquisado não possui o perfil necessário para ser adicionado.');
        resetModal();
        return;
    }

    // Verificar se o usuário já está na tabela de responsáveis
    const existe = responsaveis.some(resp => resp.email.toLowerCase() === email);
    if (existe) {
        alert('Este usuário já está adicionado como responsável.');
        resetModal();
        return;
    }

    // Exibir as informações do usuário
    user_id.textContent = usuario.id;
    user_nome.textContent = usuario.nome;
    user_email.textContent = usuario.email;
    user_perfil.textContent = usuario.perfil;

    userInfoDiv.style.display = 'block';
    formActions.style.display = 'flex';

    // Armazenar o usuário encontrado para adicionar posteriormente
    usuarioEncontrado = usuario;
});

// Função para adicionar o usuário à tabela de responsáveis
addBtn.addEventListener('click', () => {
    if (!usuarioEncontrado) {
        alert('Nenhum usuário encontrado para adicionar.');
        return;
    }

    // Adicionar o usuário à tabela de responsáveis
    responsaveis.push(usuarioEncontrado);
    renderResponsaveis();

    alert('Responsável adicionado com sucesso.');

    // Fechar o modal e resetar
    addResponsavelModal.style.display = 'none';
    resetModal();
});
</script>
    
</body>
</html>
