<?php
/**
 * Script de análise de respostas cognitivas com retorno JSON estruturado.
 */

header('Content-Type: application/json');

// ===================== CONFIGURAÇÕES =====================
$EXPECTED_API_KEY = 'sua_chave_secreta_aqui';

// (mesmos mapeamentos e respostas padrão do script original)
$item_mapping = [
    // Classe 1: Discriminação Visual 
        "soc_item1" => ["class" => 1, "age_range" => "0-1"], 
        "soc_item4" => ["class" => 1, "age_range" => "0-1"], 
    
        
    // Classe 2: Sorrir
        "soc_item2" => ["class" => 2, "age_range" => "0-1"], 
        "soc_item6" => ["class" => 2, "age_range" => "0-1"], 
        "soc_item7" => ["class" => 2, "age_range" => "0-1"],
        
    // Classe 3: Vocalização
        "soc_item3" => ["class" => 3, "age_range" => "0-1"], 
        "soc_item17" => ["class" => 3, "age_range" => "0-1"], 
    
    // Classe 4: Reatividade ao Contato Humano
        "soc_item5" => ["class" => 4, "age_range" => "0-1"], 
    
    // Classe 5: Acariciar/Abracar
        "soc_item8" => ["class" => 5, "age_range" => "0-1"], 
        "soc_item23" => ["class" => 5, "age_range" => "0-1"], 
        "soc_item35" => ["class" => 5, "age_range" => "1-2"], 
    
    // Classe 6: Estender Mãos/Braços em Direção a ...
        "soc_item9" => ["class" => 6, "age_range" => "0-1"], 
        "soc_item10" => ["class" => 6, "age_range" => "0-1"], 
        "soc_item11" => ["class" => 6, "age_range" => "0-1"], 
    
    // Classe 7: Manipular Objetos
        "soc_item12" => ["class" => 7, "age_range" => "0-1"], 
        "soc_item13" => ["class" => 7, "age_range" => "0-1"], 
        "soc_item25" => ["class" => 7, "age_range" => "0-1"], 
        "soc_item26" => ["class" => 7, "age_range" => "0-1"], 
        "soc_item34" => ["class" => 7, "age_range" => "1-2"], 
    
    // Classe 8: Brincar
        "soc_item14" => ["class" => 8, "age_range" => "0-1"], 
        "soc_item16" => ["class" => 8, "age_range" => "0-1"], 
        "soc_item30" => ["class" => 8, "age_range" => "1-2"], 
        "soc_item31" => ["class" => 8, "age_range" => "1-2"], 
        "soc_item41" => ["class" => 8, "age_range" => "1-2"], 
        "soc_item49" => ["class" => 8, "age_range" => "2-3"], 
        "soc_item63" => ["class" => 8, "age_range" => "3-4"], 
        "soc_item70" => ["class" => 8, "age_range" => "4-5"], 
        "soc_item74" => ["class" => 8, "age_range" => "5-6"], 
    
    // Classe 9: Contato Visual
        "soc_item15" => ["class" => 9, "age_range" => "0-1"], 
    
    // Classe 10: Imitação Motora
        "soc_item18" => ["class" => 10, "age_range" => "0-1"], 
        "soc_item19" => ["class" => 10, "age_range" => "0-1"], 
        "soc_item20" => ["class" => 10, "age_range" => "0-1"], 
        "soc_item21" => ["class" => 10, "age_range" => "0-1"], 
        "soc_item28" => ["class" => 10, "age_range" => "0-1"], 
        "soc_item29" => ["class" => 10, "age_range" => "1-2"], 
        "soc_item36" => ["class" => 10, "age_range" => "1-2"], 
        "soc_item76" => ["class" => 10, "age_range" => "5-6"], 
    
    // Classe 11: Dar/Compartilhar Objetos
        "soc_item22" => ["class" => 11, "age_range" => "0-1"], 
        "soc_item27" => ["class" => 11, "age_range" => "0-1"], 
        "soc_item37" => ["class" => 11, "age_range" => "1-2"], 
        "soc_item42" => ["class" => 11, "age_range" => "1-2"], 
    
    // Classe 12: Discriminação Auditiva
        "soc_item24" => ["class" => 12, "age_range" => "0-1"], 
    
    // Classe 13: Independência dos Pais
        "soc_item32" => ["class" => 13, "age_range" => "1-2"], 
    
    // Classe 14: Exploração do Ambiente
        "soc_item33" => ["class" => 14, "age_range" => "1-2"], 
    
    // Classe 15: Puxar Pessoas para Mostrar
        "soc_item38" => ["class" => 15, "age_range" => "1-2"], 
    
    // Classe 16: Cumprimentar
        "soc_item43" => ["class" => 16, "age_range" => "1-2"], 
        "soc_item54" => ["class" => 16, "age_range" => "3-4"], 
    
    // Classe 17: Seguir Ordens/Instruções
        "soc_item39" => ["class" => 17, "age_range" => "1-2"], 
        "soc_item44" => ["class" => 17, "age_range" => "2-3"], 
        "soc_item45" => ["class" => 17, "age_range" => "2-3"], 
        "soc_item61" => ["class" => 17, "age_range" => "3-4"], 
    
    // Classe 18: Esperar a Vez
        "soc_item40" => ["class" => 18, "age_range" => "1-2"], 
        "soc_item59" => ["class" => 18, "age_range" => "3-4"], 
        "soc_item69" => ["class" => 18, "age_range" => "4-5"], 
    
    // Classe 19: Prestar Atenção
        "soc_item46" => ["class" => 19, "age_range" => "2-3"], 
    
    // Classe 20: Agradecer
        "soc_item47" => ["class" => 20, "age_range" => "2-3"], 
        "soc_item57" => ["class" => 20, "age_range" => "3-4"], 
    
    // Classe 21: Ajudar
        "soc_item48" => ["class" => 21, "age_range" => "2-3"], 
    
    // Classe 22: Escolher
        "soc_item50" => ["class" => 22, "age_range" => "2-3"], 
        "soc_item80" => ["class" => 22, "age_range" => "5-6"], 
    
    // Classe 23: Expressão de Sentimentos
        "soc_item51" => ["class" => 23, "age_range" => "2-3"], 
        "soc_item73" => ["class" => 23, "age_range" => "5-6"], 
        "soc_item79" => ["class" => 23, "age_range" => "5-6"], 
    
    // Classe 24: Cantar/Dançar
        "soc_item52" => ["class" => 24, "age_range" => "3-4"], 
        "soc_item66" => ["class" => 24, "age_range" => "4-5"], 
    
    // Classe 25: Seguir Regras de Jogo
        "soc_item53" => ["class" => 25, "age_range" => "3-4"], 
        "soc_item55" => ["class" => 25, "age_range" => "3-4"], 
        "soc_item60" => ["class" => 25, "age_range" => "3-4"], 
        "soc_item78" => ["class" => 25, "age_range" => "5-6"], 
    
    // Classe 26: Pedir Permissão
        "soc_item56" => ["class" => 26, "age_range" => "3-4"], 
        "soc_item72" => ["class" => 26, "age_range" => "4-5"], 
    
    // Classe 27: Falar ao Telefone
        "soc_item58" => ["class" => 27, "age_range" => "3-4"], 
    
    // Classe 28: Permanecer em Sua Área
        "soc_item62" => ["class" => 28, "age_range" => "3-4"], 
    
    // Classe 29: Pedir Ajuda
        "soc_item64" => ["class" => 29, "age_range" => "4-5"], 
    
    // Classe 30: Verbalizar para Adultos
        "soc_item65" => ["class" => 30, "age_range" => "4-5"], 
        "soc_item77" => ["class" => 30, "age_range" => "5-6"], 
    
    // Classe 31: Fazer Tarefa Sozinho
        "soc_item67" => ["class" => 31, "age_range" => "4-5"], 
    
    // Classe 32: Pedir Desculpas
        "soc_item68" => ["class" => 32, "age_range" => "4-5"], 
    
    // Classe 33: Apresentar Comportamentos Aceitáveis em Público
        "soc_item71" => ["class" => 33, "age_range" => "4-5"], 
    
    // Classe 34: Explicar Regras
        "soc_item75" => ["class" => 34, "age_range" => "5-6"], 
    
    // Classe 35: Usar Ferramentas
        "soc_item81" => ["class" => 35, "age_range" => "5-6"], 
    
    // Classe 36: Estabelecer Metas para Si
        "soc_item82" => ["class" => 36, "age_range" => "5-6"], 
    
    // Classe 37: Dramatizar
        "soc_item83" => ["class" => 37, "age_range" => "5-6"], 


    

];

// Definição das respostas padrão por classe e faixa etária
$standard_responses = [
    // Classe 1: Discriminação Visual
    1 => [
        "0-1" => "Não acompanhou movimento de pessoas ou não reconheceu a própria mão, sugerindo atraso na percepção visual de si e do outro.",
    ],
    
    // Classe 2: Sorrir
    2 => [
        "0-1" => "Não sorriu em resposta a pessoas ou a imagem no espelho, indicando pouco engajamento afetivo inicial.",
    ],
    
    // Classe 3: Vocalização
    3 => [
        "0-1" => "Não vocalizou para interagir ou chamar atenção, sugerindo limitação na comunicação pré-verbal.",
    ],
    
    // Classe 4: Reatividade ao Contato Humano
    4 => [
        "0-1" => "Não reagiu positivamente ao círculo familiar (sorrindo ou acalmando), mostrando pouca interação afetiva.",
    ],
    
    // Classe 5: Acariciar/Abracar
    5 => [
        "0-1" => "Não tocou ou puxou o rosto de adultos, evidenciando pouco interesse no contato físico.",
        "1-2" => "Não abraçou ou carregou um brinquedo macio, indicando atraso na expressão de afeto.",
    ],
    
    // Classe 6: Estender Mãos/Braços em Direção a...
    6 => [
        "0-1" => "Não estendeu braços para pessoas familiares ou para o espelho, sugerindo pouca iniciativa de aproximação.",
    ],
    
    // Classe 7: Manipular Objetos
    7 => [
        "0-1" => "Não segurou ou sacudiu brinquedos, apontando pouco interesse exploratório.",
        "1-2" => "Não realizou atividades manipulativas conjuntas, prejudicando a interação lúdica com outros.",
    ],
    
    // Classe 8: Brincar
    8 => [
        "0-1"   => "Não brincou sozinho por alguns minutos, demonstrando baixa autonomia lúdica.",
        "1-2"   => "Dificuldade em brincar ao lado de outras crianças, indicando pouca participação social.",
        "2-3"   => "Não envolveu brincadeira de vestir-se como adulto, prejudicando a imaginação social.",
        "3-4"   => "Falhou em conversar enquanto brinca perto de outras crianças, impactando a interação cooperativa.",
        "4-5"   => "Não se envolveu em atividade cooperativa prolongada, indicando atraso na socialização em grupo.",
        // Nota: A faixa 5-6 anos foi agrupada com 4-5 conforme texto.
    ],
    
    // Classe 9: Contato Visual
    9 => [
        "0-1" => "Não sustentou contato visual quando alguém lhe dá atenção, sugerindo dificuldade de vínculo social inicial.",
    ],
    
    // Classe 10: Imitação Motora
    10 => [
        "0-1" => "Não imitou 'bate palmas' ou 'cadê?', evidenciando atraso na aprendizagem social por imitação.",
        "1-2" => "Falhou em imitar tarefas simples ou ações que fazem rir, prejudicando a interação e brincadeiras.",
        "5-6" => "Não imitou papéis de adulto em brincadeiras, impactando o jogo simbólico e criatividade social.",
    ],
    
    // Classe 11: Dar/Compartilhar Objetos
    11 => [
        "0-1" => "Oferecia algo, mas não entregava de fato, ou não oferecia, mostrando pouca interação de troca.",
        "1-2" => "Não compartilhou brinquedos/alimentos, sugerindo atraso na capacidade de dividir e cooperar.",
    ],
    
    // Classe 12: Discriminação Auditiva
    12 => [
        "0-1" => "Não respondeu ao próprio nome, indicando pouca atenção auditiva à chamada social.",
    ],
    
    // Classe 13: Independência dos Pais
    13 => [
        "1-2" => "Não aceitava ausência dos pais, mostrando insegurança e dificuldade de adaptação.",
    ],
    
    // Classe 14: Exploração do Ambiente
    14 => [
        "1-2" => "Não explorou ativamente o meio, evidenciando falta de curiosidade e iniciativa motora-social.",
    ],
    
    // Classe 15: Puxar Pessoas para Mostrar
    15 => [
        "1-2" => "Não puxou o adulto para ver algo, apontando dificuldade em compartilhar interesse.",
    ],
    
    // Classe 16: Cumprimentar
    16 => [
        "1-2" => "Não cumprimentou colegas/adultos quando lembrado, indicando atraso em convenções sociais.",
        "3-4" => "Não cumprimentou pessoas familiares sem ser lembrado, prejudicando a espontaneidade social.",
    ],
    
    // Classe 17: Seguir Ordens/Instruções
    17 => [
        "1-2" => "Não afastou a mão ao ser lembrado de objeto proibido, revelando pouca compreensão ou obediência.",
        "2-3" => "Falhou ao obedecer ordens dos pais metade das vezes, indicando baixa adesão a instruções.",
        "3-4" => "Não obedeceu adulto em 75% das vezes, prejudicando o convívio e limites sociais.",
    ],
    
    // Classe 18: Esperar a Vez
    18 => [
        "1-2" => "Não esperou quando colocado na cadeira/trocador, mostrando impaciência.",
        "3-4" => "Dificuldade em aguardar a própria vez, impactando jogos ou interações coletivas.",
        "4-5" => "Não respeitou a vez em brincadeiras com mais crianças, prejudicando a convivência em grupo.",
    ],
    
    // Classe 19: Prestar Atenção
    19 => [
        "2-3" => "Não escutou história ou música por 5-10 minutos, revelando pouca concentração em atividades sociais.",
    ],
    
    // Classe 20: Agradecer
    20 => [
        "2-3" => "Não disse 'por favor' ou 'obrigado' quando lembrado, evidenciando atraso nas fórmulas de cortesia.",
        "3-4" => "Não usou agradecimento espontâneo em metade das vezes, prejudicando a polidez na interação social.",
    ],
    
    // Classe 21: Ajudar
    21 => [
        "2-3" => "Não tentou auxiliar adultos em tarefas simples, mostrando pouca cooperação.",
    ],
    
    // Classe 22: Escolher
    22 => [
        "2-3" => "Não fez escolha quando indagado, indicando pouca iniciativa ou tomada de decisão.",
        "5-6" => "Não selecionou seus próprios amigos, sugerindo dificuldade em formar preferências sociais.",
    ],
    
    // Classe 23: Expressão de Sentimentos
    23 => [
        "2-3" => "Não manifestou que entende os próprios sentimentos, denotando dificuldade em comunicar emoções.",
        "5-6" => "Não consolou colegas ou não expressou sentimentos, apontando pouca empatia.",
    ],
    
    // Classe 24: Cantar/Dançar
    24 => [
        "3-4" => "Não cantou nem dançou ao ouvir música, sugerindo pouco envolvimento em atividades rítmicas grupais.",
        "4-5" => "Falhou em repetir rimas ou canções para os outros, prejudicando a expressão artística e interação social.",
    ],
    
    // Classe 25: Seguir Regras de Jogo
    25 => [
        "3-4" => "Não acompanhou regras em jogos coletivos, indicando dificuldade em cooperação e limites.",
        "5-6" => "Falhou em respeitar regras mais complexas que exigem raciocínio verbal, prejudicando a participação em grupo.",
    ],
    
    // Classe 26: Pedir Permissão
    26 => [
        "3-4" => "Não solicitou para brincar com brinquedo ocupado, evidenciando pouca consideração pelo outro.",
        "4-5" => "Falhou em pedir permissão para usar objetos, afetando as regras de convivência.",
    ],
    
    // Classe 27: Falar ao Telefone
    27 => [
        "3-4" => "Não atendeu ou chamou adulto ao telefone quando necessário, indicando atraso na comunicação social por meios diferentes.",
    ],
    
    // Classe 28: Permanecer em Sua Área
    28 => [
        "3-4" => "Saiu do quintal ou jardim sem permissão, sugerindo pouca noção de limites e segurança.",
    ],
    
    // Classe 29: Pedir Ajuda
    29 => [
        "4-5" => "Não pediu ajuda ao ter dificuldade, demonstrando baixa iniciativa para solucionar problemas sociais.",
    ],
    
    // Classe 30: Verbalizar para Adultos
    30 => [
        "4-5" => "Não contribuiu para a conversa de adultos, limitando a interação verbal.",
        "5-6" => "Não colaborou na conversa durante refeições, mostrando pouco envolvimento com o grupo familiar.",
    ],
    
    // Classe 31: Fazer Tarefa Sozinho
    31 => [
        "4-5" => "Falhou ao realizar uma atividade por 20-30 minutos, indicando pouca autonomia e persistência.",
    ],
    
    // Classe 32: Pedir Desculpas
    32 => [
        "4-5" => "Não se desculpou espontaneamente na maioria das vezes, prejudicando a responsabilidade social.",
    ],
    
    // Classe 33: Apresentar Comportamentos Aceitáveis em Público
    33 => [
        "4-5" => "Não manteve conduta adequada em locais públicos, sugerindo dificuldade em regras sociais externas.",
    ],
    
    // Classe 34: Explicar Regras
    34 => [
        "5-6" => "Não explicou a outros as regras do jogo, evidenciando dificuldade em liderança e comunicação clara.",
    ],
    
    // Classe 35: Usar Ferramentas
    35 => [
        "5-6" => "Não planejou ou construiu algo com ferramentas simples, prejudicando a cooperação e a criatividade em grupo.",
    ],
    
    // Classe 36: Estabelecer Metas para Si
    36 => [
        "5-6" => "Não definiu ou perseguiu um objetivo, indicando atraso na autonomia e organização social de tarefas.",
    ],
    
    // Classe 37: Dramatizar
    37 => [
        "5-6" => "Não dramatizou histórias ou utilizou fantoches, sugerindo pouco envolvimento no jogo simbólico social.",
    ],

];

// ===================== FUNÇÕES DE SUPORTE =====================
function getRequestHeaders() {
    if (function_exists('getallheaders')) {
        return getallheaders();
    }
    $headers = [];
    foreach ($_SERVER as $name => $value) {
        if (substr($name, 0, 5) === 'HTTP_') {
            $headerName = str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', substr($name, 5)))));
            $headers[$headerName] = $value;
        }
    }
    return $headers;
}

function send_json_response($data, $status_code = 200) {
    http_response_code($status_code);
    echo json_encode($data);
    exit;
}

function validate_authentication($expected_key) {
    $headers = getRequestHeaders();
    if (!isset($headers['Authorization'])) {
        send_json_response(['status' => 'error', 'message' => 'Unauthorized'], 401);
    }
    if (preg_match('/Bearer\s(\S+)/', $headers['Authorization'], $matches)) {
        $provided_key = $matches[1];
    } else {
        send_json_response(['status' => 'error', 'message' => 'Unauthorized'], 401);
    }
    if ($provided_key !== $expected_key) {
        send_json_response(['status' => 'error', 'message' => 'Unauthorized'], 401);
    }
}

function get_age_order($age_range) {
    // Retorna a "prioridade" da faixa etária de acordo com o primeiro número
    $parts = explode('-', $age_range);
    return (int)$parts[0];
}

// ===================== FUNÇÃO PRINCIPAL: generate_detailed_report =====================
function generate_detailed_report($input, $item_mapping, $standard_responses) {
    $class_failures = [];

    // Percorre cada item do JSON e armazena a classe e a menor faixa etária
    foreach ($input as $item => $value) {
        // '1' significa que houve falha no item
        if ($value == 1 && isset($item_mapping[$item])) {
            $class = $item_mapping[$item]['class'];
            $age_range = $item_mapping[$item]['age_range'];
            $age_order = get_age_order($age_range);

            // Salva a menor faixa etária encontrada para aquela classe
            if (!isset($class_failures[$class]) || $age_order < $class_failures[$class]['age_order']) {
                $class_failures[$class] = [
                    'age_range' => $age_range,
                    'age_order' => $age_order
                ];
            }
        }
    }

    // Monta lista detalhada de falhas
    $failures_list = [];
    foreach ($class_failures as $class => $info) {
        $age_range = $info['age_range'];

        if (isset($standard_responses[$class][$age_range])) {
            $description = $standard_responses[$class][$age_range];
            $failures_list[] = [
                'class' => $class,
                'age_range' => $age_range,
                'description' => $description
            ];
        }
    }

    return $failures_list;
}

// ===================== EXECUÇÃO =====================

// 1. Valida a autenticação
validate_authentication($EXPECTED_API_KEY);

// 2. Lê e decodifica o corpo JSON
$json_input = file_get_contents('php://input');
$input_data = json_decode($json_input, true);

if ($input_data === null) {
    send_json_response([
        'status' => 'error',
        'message' => 'JSON inválido.'
    ], 400);
}

// 3. Gera relatório detalhado
$failures = generate_detailed_report($input_data, $item_mapping, $standard_responses);

// 4. Retorna JSON mais organizado
if (empty($failures)) {
    send_json_response([
        'status' => 'success',
        'message' => 'Nenhuma falha identificada nos itens avaliados.',
        'data' => [
            'failures_found' => [],
            'recommendations' => 'Parabéns, nenhum indicador de atraso encontrado!'
        ]
    ]);
} else {
    // Você pode, por exemplo, criar lógica para gerar recomendações baseadas nas classes identificadas
    $recommendations = 'Considere práticas de estímulo de linguagem adequadas às faixas etárias detectadas.';

    send_json_response([
        'status' => 'success',
        'message' => 'Análise realizada com sucesso.',
        'data' => [
            'failures_found' => $failures,
            //'recommendations' => $recommendations
        ]
    ]);
}

