<?php
// send_json.php

// URL para o script alvo (substitua pela URL correta do seu servidor)
$url = 'https://ifcora.com/av/av3/1_gerdor_de_relatório_socializacao.php';

// Dados do JSON de exemplo
$json_data = [
    "soc_item1" => 3,
    "soc_item2" => 3,
    "soc_item3" => 3,
    "soc_item4" => 3,
    "soc_item5" => 3,
    "soc_item6" => 3,
    "soc_item7" => 3,
    "soc_item8" => 3,
    "soc_item9" => 3,
    "soc_item10" => 3,
    "soc_item11" => 3,
    "soc_item12" => 3,
    "soc_item13" => 3,
    "soc_item14" => 3,
    "soc_item15" => 3,
    "soc_item16" => 3,
    "soc_item17" => 3,
    "soc_item18" => 3,
    "soc_item19" => 3,
    "soc_item20" => 3,
    "soc_item21" => 3,
    "soc_item22" => 3,
    "soc_item23" => 1,
    "soc_item24" => 3,
    "soc_item25" => 3,
    "soc_item26" => 1,
    "soc_item27" => 1,
    "soc_item28" => 1,
    "soc_item29" => 1,
    "soc_item30" => 3,
    "soc_item31" => 3,
    "soc_item32" => 3,
    "soc_item33" => 3,
    "soc_item34" => 1,
    "soc_item35" => 1,
    "soc_item36" => 1,
    "soc_item37" => 1,
    "soc_item38" => 3,
    "soc_item39" => 1,
    "soc_item40" => 3,
    "soc_item41" => 1,
    "soc_item42" => 1
];


// Converter o array para JSON
$json_input = json_encode($json_data);

// Chave de autenticação (deve corresponder à esperada pelo script de destino)
$api_key = 'sua_chave_secreta_aqui';

// Inicializar cURL
$ch = curl_init($url);

// Configurar cabeçalhos para cURL, incluindo Content-Type e Authorization
$headers = [
    'Content-Type: application/json',
    'Authorization: Bearer ' . $api_key
];
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

// Configurar opções do cURL para envio de POST
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $json_input);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

// Executar a requisição cURL
$response = curl_exec($ch);

$data = json_decode($response, true);

echo "<h2>Relatório Gerado:</h2>";

if ($data === null) {
    // Caso a resposta não seja um JSON válido
    echo "<div style='border:1px solid #ddd; padding:15px; background-color:#f9f9f9;'>
            <p>Erro ao interpretar a resposta do servidor.</p>
          </div>";
} else {
    // Personalização da mensagem com base no conteúdo do JSON
    echo "<div style='border:1px solid #ddd; padding:15px; background-color:#f9f9f9;'>";
    
    // Exibe a mensagem principal do relatório
    if (isset($data['message'])) {
        echo "<p><strong>{$data['message']}</strong></p>";
    }

    // Verifica se há falhas encontradas e exibe-as
    if (!empty($data['data']['failures_found'])) {
        echo "<h3>Falhas Encontradas:</h3><ul>";
        foreach ($data['data']['failures_found'] as $failure) {
            echo "<li>
                    <strong>Classe {$failure['class']} (Faixa {$failure['age_range']}):</strong> 
                    {$failure['description']}
                  </li>";
        }
        echo "</ul>";
    } else {
        echo "<p>Nenhuma falha identificada nos itens avaliados.</p>";
    }

    // Exibe recomendações, se disponíveis
    if (!empty($data['data']['recommendations'])) {
        echo "<h3>Recomendações:</h3>";
        echo "<p>{$data['data']['recommendations']}</p>";
    }

    echo "</div>";
}

// Fechar a sessão cURL
curl_close($ch);
?>
