<?php
/**
 * Script para analisar respostas de itens cognitivos e gerar relatório com respostas padrão.
 * Agora com autenticação e recebimento de JSON via requisição HTTP.
 */

// Chave esperada para autenticação
$EXPECTED_API_KEY = 'sua_chave_secreta_aqui';

// Função para obter todos os cabeçalhos (compatível com diferentes ambientes)
function getRequestHeaders() {
    if (function_exists('getallheaders')) {
        return getallheaders();
    }
    $headers = [];
    foreach ($_SERVER as $name => $value) {
        if (substr($name, 0, 5) == 'HTTP_') {
            $headerName = str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', substr($name, 5)))));
            $headers[$headerName] = $value;
        }
    }
    return $headers;
}

// Verificação da chave de autenticação
$headers = getRequestHeaders();
if(isset($headers['Authorization'])) {
    // Extrai a chave do cabeçalho Authorization: Bearer {token}
    $authHeader = $headers['Authorization'];
    if (preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
        $provided_key = $matches[1];
    } else {
        $provided_key = '';
    }
    
    if($provided_key !== $EXPECTED_API_KEY) {
        header('HTTP/1.1 401 Unauthorized');
        echo json_encode(['error' => 'Unauthorized']);
        exit;
    }
} else {
    header('HTTP/1.1 401 Unauthorized');
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

// Ler o corpo da requisição contendo o JSON
$json_input = file_get_contents('php://input');

// Definição do mapeamento de itens para classes e faixas etárias
$item_mapping = [
    // Classe 1: Preensão de Objetos
    "motor_item1" => ["class" => 1, "age_range" => "0-1"],  
    "motor_item2" => ["class" => 1, "age_range" => "0-1"], 
    "motor_item3" => ["class" => 1, "age_range" => "0-1"],
    "motor_item4" => ["class" => 1, "age_range" => "0-1"],
    "motor_item17" => ["class" => 1, "age_range" => "0-1"],
    "motor_item18" => ["class" => 1, "age_range" => "0-1"],
    "motor_item28" => ["class" => 1, "age_range" => "0-1"],
    "motor_item29" => ["class" => 1, "age_range" => "0-1"],
    "motor_item32" => ["class" => 1, "age_range" => "0-1"],
    "motor_item78" => ["class" => 1, "age_range" => "2-3"],
    
    // Classe 2: Exploração de Objetos com a Boca
    "motor_item5" => ["class" => 2, "age_range" => "0-1"], 
    "motor_item8" => ["class" => 2, "age_range" => "0-1"], 
    
    // Classe 3: Controle de Cabeça/Tronco
    "motor_item6" => ["class" => 3, "age_range" => "0-1"],
    "motor_item7" => ["class" => 3, "age_range" => "0-1"],
    "motor_item15" => ["class" => 3, "age_range" => "0-1"],
    
    // Classe 4: Rotação de Tronco/Quadril
    "motor_item9" => ["class" => 4, "age_range" => "0-1"],
    "motor_item10" => ["class" => 4, "age_range" => "0-1"],
    "motor_item12" => ["class" => 4, "age_range" => "0-1"],
    "motor_item13" => ["class" => 4, "age_range" => "0-1"],
    "motor_item62" => ["class" => 4, "age_range" => "1-2"],
    
    // Classe 5: Engatinhar
    "motor_item11" => ["class" => 5, "age_range" => "0-1"],
    "motor_item21" => ["class" => 5, "age_range" => "0-1"],
    "motor_item23" => ["class" => 5, "age_range" => "0-1"],
    "motor_item27" => ["class" => 5, "age_range" => "0-1"],
    "motor_item33" => ["class" => 5, "age_range" => "0-1"],
    "motor_item34" => ["class" => 5, "age_range" => "0-1"],
    
    // Classe 6: Sentar
    "motor_item14" => ["class" => 6, "age_range" => "0-1"],
    "motor_item16" => ["class" => 6, "age_range" => "0-1"],
    "motor_item22" => ["class" => 6, "age_range" => "0-1"],
    "motor_item24" => ["class" => 6, "age_range" => "0-1"],
    "motor_item25" => ["class" => 6, "age_range" => "0-1"],
    "motor_item42" => ["class" => 6, "age_range" => "0-1"],
    "motor_item49" => ["class" => 6, "age_range" => "1-2"],
    "motor_item57" => ["class" => 6, "age_range" => "1-2"],
    
    // Classe 7: Andar
    "motor_item19" => ["class" => 7, "age_range" => "0-1"],
    "motor_item20" => ["class" => 7, "age_range" => "0-1"],
    "motor_item31" => ["class" => 7, "age_range" => "0-1"],
    "motor_item35" => ["class" => 7, "age_range" => "0-1"],
    "motor_item37" => ["class" => 7, "age_range" => "0-1"],
    "motor_item44" => ["class" => 7, "age_range" => "0-1"],
    "motor_item45" => ["class" => 7, "age_range" => "0-1"],
    "motor_item47" => ["class" => 7, "age_range" => "1-2"],
    "motor_item55" => ["class" => 7, "age_range" => "1-2"],
    "motor_item58" => ["class" => 7, "age_range" => "1-2"],
    "motor_item59" => ["class" => 7, "age_range" => "1-2"],
    "motor_item67" => ["class" => 7, "age_range" => "2-3"],
    "motor_item85" => ["class" => 7, "age_range" => "3-4"],
    "motor_item92" => ["class" => 7, "age_range" => "3-4"],
    "motor_item114" => ["class" => 7, "age_range" => "5-6"],
    
    // Classe 8: Manipular Objetos
    "motor_item26" => ["class" => 8, "age_range" => "0-1"],
    "motor_item38" => ["class" => 8, "age_range" => "0-1"],
    "motor_item41" => ["class" => 8, "age_range" => "0-1"],
    "motor_item65" => ["class" => 8, "age_range" => "2-3"],
    
    // Classe 9: Ajoelhar
    "motor_item30" => ["class" => 9, "age_range" => "0-1"],
    
    // Classe 10: Controle de Língua
    "motor_item36" => ["class" => 10, "age_range" => "0-1"],
    
    // Classe 11: Virar Páginas de Livro
    "motor_item39" => ["class" => 11, "age_range" => "0-1"],
    "motor_item71" => ["class" => 11, "age_range" => "2-3"],
    
    // Classe 12: Escavar com Pá
    "motor_item40" => ["class" => 12, "age_range" => "0-1"],
    
    // Classe 13: Bater Palmas
    "motor_item43" => ["class" => 13, "age_range" => "0-1"],
    
    // Classe 14: Subir/Descer Escadas
    "motor_item46" => ["class" => 14, "age_range" => "1-2"],
    "motor_item56" => ["class" => 14, "age_range" => "1-2"],
    "motor_item61" => ["class" => 14, "age_range" => "1-2"],
    "motor_item68" => ["class" => 14, "age_range" => "2-3"],
    "motor_item91" => ["class" => 14, "age_range" => "3-4"],
    "motor_item106" => ["class" => 14, "age_range" => "4-5"],
    "motor_item118" => ["class" => 14, "age_range" => "5-6"],
    
    // Classe 15: Jogar Bola
    "motor_item48" => ["class" => 15, "age_range" => "1-2"],
    "motor_item69" => ["class" => 15, "age_range" => "2-3"],
    "motor_item76" => ["class" => 15, "age_range" => "2-3"],
    "motor_item84" => ["class" => 15, "age_range" => "3-4"],
    "motor_item93" => ["class" => 15, "age_range" => "3-4"],
    "motor_item102" => ["class" => 15, "age_range" => "4-5"],
    "motor_item120" => ["class" => 15, "age_range" => "5-6"],
    "motor_item127" => ["class" => 15, "age_range" => "5-6"],
    "motor_item129" => ["class" => 15, "age_range" => "5-6"],
    
    // Classe 16: Colocar Aros em Estacas
    "motor_item50" => ["class" => 16, "age_range" => "1-2"],
    
    // Classe 17: Retirar/Encaixar Pinos
    "motor_item51" => ["class" => 17, "age_range" => "1-2"],
    "motor_item52" => ["class" => 17, "age_range" => "1-2"],
    
    // Classe 18: Empilhar Blocos
    "motor_item53" => ["class" => 18, "age_range" => "1-2"],
    "motor_item70" => ["class" => 18, "age_range" => "2-3"],
    
    // Classe 19: Realizar Traçados no Papel
    "motor_item54" => ["class" => 19, "age_range" => "1-2"],
    "motor_item94" => ["class" => 19, "age_range" => "3-4"],
    "motor_item110" => ["class" => 19, "age_range" => "4-5"],
    "motor_item121" => ["class" => 19, "age_range" => "5-6"],
    "motor_item124" => ["class" => 19, "age_range" => "5-6"],
    
    // Classe 20: Balançar
    "motor_item60" => ["class" => 20, "age_range" => "1-2"],
    "motor_item88" => ["class" => 20, "age_range" => "3-4"],
    "motor_item115" => ["class" => 20, "age_range" => "5-6"],
    
    // Classe 21: Realizar Movimentos Circulares com Dedos
    "motor_item63" => ["class" => 21, "age_range" => "1-2"],
    
    // Classe 22: Enfiar Contas
    "motor_item64" => ["class" => 22, "age_range" => "2-3"],
    
    // Classe 23: Saltar/Pular
    "motor_item66" => ["class" => 23, "age_range" => "2-3"],
    "motor_item83" => ["class" => 23, "age_range" => "3-4"],
    "motor_item99" => ["class" => 23, "age_range" => "4-5"],
    "motor_item100" => ["class" => 23, "age_range" => "4-5"],
    "motor_item101" => ["class" => 23, "age_range" => "4-5"],
    "motor_item108" => ["class" => 23, "age_range" => "4-5"],
    "motor_item128" => ["class" => 23, "age_range" => "5-6"],
    "motor_item136" => ["class" => 23, "age_range" => "5-6"],
    "motor_item138" => ["class" => 23, "age_range" => "5-6"],
    
    // Classe 24: Desembrulhar Objetos
    "motor_item72" => ["class" => 24, "age_range" => "2-3"],
    
    // Classe 25: Dobrar Papel
    "motor_item73" => ["class" => 25, "age_range" => "2-3"],
    "motor_item126" => ["class" => 25, "age_range" => "5-6"],
    
    // Classe 26: Realizar Encaixes Rosca/Pressão
    "motor_item74" => ["class" => 26, "age_range" => "2-3"],
    "motor_item75" => ["class" => 26, "age_range" => "2-3"],
    "motor_item105" => ["class" => 26, "age_range" => "4-5"],
    
    // Classe 27: Manipular Massa de Modelar
    "motor_item77" => ["class" => 27, "age_range" => "2-3"],
    "motor_item103" => ["class" => 27, "age_range" => "4-5"],
    
    // Classe 28: Virar Cambalhotas
    "motor_item79" => ["class" => 28, "age_range" => "2-3"],
    "motor_item90" => ["class" => 28, "age_range" => "3-4"],
    
    // Classe 29: Martelar
    "motor_item80" => ["class" => 29, "age_range" => "2-3"],
    "motor_item119" => ["class" => 29, "age_range" => "5-6"],
    
    // Classe 30: Fazer Quebra-cabeças
    "motor_item81" => ["class" => 30, "age_range" => "3-4"],
    
    // Classe 31: Usar Tesoura
    "motor_item82" => ["class" => 31, "age_range" => "3-4"],
    "motor_item95" => ["class" => 31, "age_range" => "3-4"],
    "motor_item104" => ["class" => 31, "age_range" => "4-5"],
    "motor_item109" => ["class" => 31, "age_range" => "5-6"],
    "motor_item111" => ["class" => 31, "age_range" => "4-5"],
    "motor_item122" => ["class" => 31, "age_range" => "5-6"],
    
    // Classe 32: Correr
    "motor_item86" => ["class" => 32, "age_range" => "3-4"],
    "motor_item97" => ["class" => 32, "age_range" => "4-5"],
    "motor_item130" => ["class" => 32, "age_range" => "5-6"],
    
    // Classe 33: Pedalar/Patinar
    "motor_item87" => ["class" => 33, "age_range" => "3-4"],
    "motor_item107" => ["class" => 33, "age_range" => "4-5"],
    "motor_item131" => ["class" => 33, "age_range" => "5-6"],
    "motor_item132" => ["class" => 33, "age_range" => "5-6"],
    "motor_item135" => ["class" => 33, "age_range" => "5-6"],
    
    // Classe 34: Escorregar
    "motor_item89" => ["class" => 34, "age_range" => "3-4"],
    "motor_item133" => ["class" => 34, "age_range" => "5-6"],
    
    // Classe 35: Equilibrar-se
    "motor_item96" => ["class" => 35, "age_range" => "4-5"],
    "motor_item98" => ["class" => 35, "age_range" => "4-5"],
    "motor_item113" => ["class" => 35, "age_range" => "5-6"],
    "motor_item139" => ["class" => 35, "age_range" => "5-6"],
    "motor_item140" => ["class" => 35, "age_range" => "5-6"],
    
    // Classe 36: Escrever
    "motor_item112" => ["class" => 36, "age_range" => "5-6"],
    "motor_item117" => ["class" => 36, "age_range" => "5-6"],
    "motor_item137" => ["class" => 36, "age_range" => "5-6"],
    
    // Classe 37: Esticar Dedos
    "motor_item116" => ["class" => 37, "age_range" => "5-6"],
    
    // Classe 38: Usar o Apontador
    "motor_item123" => ["class" => 38, "age_range" => "5-6"],
    
    // Classe 39: Rasgar Figuras
    "motor_item125" => ["class" => 39, "age_range" => "5-6"],
    
    // Classe 40: Brincar na Água
    "motor_item134" => ["class" => 40, "age_range" => "5-6"],

    

];

// Definição das respostas padrão por classe e faixa etária
$standard_responses = [
    // Classe 1: Preensão de objetos
    1 => [
        "0-1" => "Dificuldade em pegar objetos demonstra atraso na coordenação fina, prejudicando a exploração do ambiente.",
        "2-3" => "Problemas ao segurar o lápis indicam atraso na precisão manual, afetando o desenho.",
    ],
    
    // Classe 2: Exploração de objetos com a boca
    2 => [
        "0-1" => "Não levou objetos à boca, sugerindo atraso na exploração sensório-motora e descoberta de texturas.",
    ],
    
    // Classe 3: Controle de cabeça/tronco
    3 => [
        "0-1" => "Dificuldade em manter cabeça e tronco eretos indica atraso no controle postural.",
    ],
    
    // Classe 4: Rotação de tronco/quadril
    4 => [
        "0-1" => "Não rolou ou virou de lado facilmente, apontando atraso na mobilidade do tronco.",
        "1-2" => "Falha ao dobrar o corpo para pegar objetos sem cair evidencia instabilidade e falta de controle.",
    ],
    
    // Classe 5: Engatinhar
    5 => [
        "0-1" => "Dificuldade em engatinhar reduz a exploração autônoma do espaço, evidenciando atraso na coordenação motora.",
    ],
    
    // Classe 6: Sentar
    6 => [
        "0-1" => "Não conseguiu manter-se sentado sozinho, sugerindo atraso no controle do tronco e equilíbrio.",
        "1-2" => "Dificuldade em sentar-se em cadeiras indica falta de firmeza e controle postural.",
    ],
    
    // Classe 7: Andar
    7 => [
        "0-1" => "Falha em sustentar-se ou dar passos com apoio aponta atraso na coordenação inicial.",
        "1-2" => "Não andou sozinho ou ao agachar/levantar, indicando falta de equilíbrio e força.",
        "2-3" => "Insegurança ao andar de costas revela falta de coordenação motora.",
        "3-4" => "Dificuldade em marchar ritmadamente indica atraso na fluidez do andar.",
        "5-6" => "Incapacidade de caminhar saltitando sugere atraso em movimentos mais complexos.",
    ],
    
    // Classe 8: Manipular objetos
    8 => [
        "0-1" => "Não atirou ou derrubou objetos intencionalmente, demonstrando atraso em coordenação mão-olho.",
        "2-3" => "Dificuldade em girar maçanetas ou trincos indica pouca destreza manual.",
    ],
    
    // Classe 9: Ajoelhar
    9 => [
        "0-1" => "Incapacidade de ficar de joelhos evidencia atraso na força e transição postural.",
    ],
    
    // Classe 10: Controle de língua
    10 => [
        "0-1" => "Não lambeu a comida ao redor da boca, sugerindo atraso na coordenação motora oral.",
    ],
    
    // Classe 11: Virar páginas de livro
    11 => [
        "0-1" => "Não virou páginas exploratoriamente, apontando atraso na destreza manual.",
        "2-3" => "Dificuldade em virar páginas uma a uma indica atraso no controle fino.",
    ],
    
    // Classe 12: Escavar com pá
    12 => [
        "0-1" => "Não usou colher ou pá para escavar, indicando atraso na coordenação de movimentos para cavar.",
    ],
    
    // Classe 13: Bater palmas
    13 => [
        "0-1" => "Não bateu palmas ao estímulo, evidenciando atraso na coordenação motora das mãos.",
    ],
    
    // Classe 14: Subir/Descer escadas
    14 => [
        "1-2" => "Não subiu/desceu escadas com ajuda, sugerindo falta de equilíbrio e força.",
        "2-3" => "Incapacidade de descer escadas sem auxílio mostra insegurança motora.",
        "3-4" => "Dificuldade em alternar os pés ao subir escadas revela atraso no ritmo de passos.",
        "4-5" => "Falha em descer escadas alternadamente prejudica a fluidez do movimento.",
        "5-6" => "Dificuldade em escadas mais complexas indica atraso na coordenação global.",
    ],
    
    // Classe 15: Jogar bola
    15 => [
        "1-2" => "Não rolou a bola, mostrando atraso na coordenação olho-mão.",
        "2-3" => "Falha em chutar ou arremessar a bola corretamente indica atraso na coordenação motora.",
        "3-4" => "Dificuldade em aparar a bola demonstra atraso na sincronia.",
        "4-5" => "Incapacidade de rebater ou apanhar a bola indica falta de coordenação refinada.",
        "5-6" => "Não conseguiu arremessar ou pegar bola em movimento, evidenciando atraso no controle motor.",
    ],
    
    // Classe 16: Colocar aros em estacas
    16 => [
        "1-2" => "Não colocou aros na estaca, sugerindo atraso na coordenação olho-mão fina.",
    ],
    
    // Classe 17: Retirar/Encaixar pinos
    17 => [
        "1-2" => "Dificuldade em retirar ou encaixar pinos aponta atraso na motricidade fina.",
    ],
    
    // Classe 18: Empilhar blocos
    18 => [
        "1-2" => "Não construiu torre de 3 blocos, sugerindo atraso em planejamento e coordenação.",
        "2-3" => "Incapaz de empilhar 5-6 blocos corretamente, demonstrando falta de precisão manual.",
    ],
    
    // Classe 19: Realizar traçados no papel
    19 => [
        "1-2" => "Não fez traços com lápis, indicando atraso inicial na coordenação mão-olho.",
        "3-4" => "Falha em seguir contornos ou pontilhados denota atraso no controle do lápis.",
        "4-5" => "Dificuldade em desenhar figuras simples aponta em atraso na motricidade fina.",
        "5-6" => "Incapacidade de colorir dentro das margens ou desenhar complexos reflete atraso na escrita.",
    ],
    
    // Classe 20: Balançar
    20 => [
        "1-2" => "Não usou balanço adequadamente, sugerindo atraso no equilíbrio dinâmico.",
        "3-4" => "Falha ao balançar em movimento indica falta de coordenação entre corpo e balanço.",
        "5-6" => "Dificuldade em iniciar ou manter balanço sozinho denota atraso na coordenação motora.",
    ],
    
    // Classe 21: Realizar movimentos circulares com dedos
    21 => [
        "1-2" => "Não imitou movimento circular com o dedo, apontando atraso na destreza digital.",
    ],
    
    // Classe 22: Enfiar contas
    22 => [
        "2-3" => "Não enfiou contas no cordão, sugerindo atraso na precisão e coordenação manual.",
    ],
    
    // Classe 23: Saltar/pular
    23 => [
        "2-3" => "Não saltou com ambos os pés, indicando atraso no equilíbrio e coordenação.",
        "3-4" => "Dificuldade em pular de pequenas alturas demonstra falta de força e coordenação.",
        "5-6" => "Não executou saltos complexos como pular corda ou girar em um pé, evidenciando atraso em movimentos avançados.",
    ],
    
    // Classe 24: Desembrulhar objetos
    24 => [
        "2-3" => "Não desembrulhou objetos, demonstrando pouca habilidade manual ao lidar com embalagens.",
    ],
    
    // Classe 25: Dobrar papel
    25 => [
        "2-3" => "Não dobrou papel ao meio, indicando atraso na coordenação bimanual.",
        "5-6" => "Dificuldade em dobrar papel em diagonal aponta falha na precisão motora fina.",
    ],
    
    // Classe 26: Realizar encaixes rosca/pressão
    26 => [
        "2-3" => "Incapaz de desenroscar ou pressionar peças indica atraso na coordenação manual.",
        "4-5" => "Dificuldade em encaixar objetos com rosca revela falta de precisão.",
    ],
    
    // Classe 27: Manipular massa de modelar
    27 => [
        "2-3" => "Não fez bolas com massa, sugerindo atraso na força e coordenação das mãos.",
        "4-5" => "Falhou em unir pedaços de massinha, indicando dificuldade na manipulação fina.",
    ],
    
    // Classe 28: Virar cambalhotas
    28 => [
        "2-3" => "Não deu cambalhota com auxílio, apontando atraso na coordenação corporal.",
        "3-4" => "Incapaz de realizar cambalhota sozinha, denotando dificuldade em movimentos complexos.",
    ],
    
    // Classe 29: Martelar
    29 => [
        "2-3" => "Dificuldade ao martelar pinos indica atraso na coordenação olho-mão.",
        "5-6" => "Não conseguiu bater pregos com martelo, sugerindo falta de controle de força.",
    ],
    
    // Classe 30: Fazer quebra-cabeças
    30 => [
        "3-4" => "Não completou quebra-cabeça de 3 peças, indicando atraso na coordenação fina e percepção espacial.",
    ],
    
    // Classe 31: Usar tesoura
    31 => [
        "3-4" => "Dificuldade em cortar ao longo de linhas retas aponta atraso na coordenação manual.",
        "4-5" => "Problemas ao recortar curvas denotam falta de precisão com a tesoura.",
        "5-6" => "Recorte fora da margem indica dificuldade de controle fino.",
    ],
    
    // Classe 32: Correr
    32 => [
        "3-4" => "Não correu coordenadamente, mostrando atraso na sincronização motora.",
        "4-5" => "Dificuldade em mudar de direção rapidamente revela falta de agilidade.",
        "5-6" => "Não apanhou objeto enquanto corria, indicando controle motor insuficiente.",
    ],
    
    // Classe 33: Pedalar/patinar
    33 => [
        "3-4" => "Incapaz de pedalar 1,5 m sinaliza atraso na coordenação de pernas e força.",
        "4-5" => "Dificuldade em pedaladas com curvas evidencia falta de estabilidade.",
        "5-6" => "Não conseguiu patinar ou andar de bicicleta com confiança, comprometendo o equilíbrio.",
    ],
    
    // Classe 34: Escorregar
    34 => [
        "3-4" => "Não subiu e escorregou no escorregador, demonstrando insegurança e falta de coordenação.",
        "5-6" => "Incapacidade de escorregar em terreno inclinado sugere falta de domínio corporal.",
    ],
    
    // Classe 35: Equilibrar-se
    35 => [
        "4-5" => "Dificuldade em ficar em um pé ou caminhar sobre tábua aponta atraso no equilíbrio.",
        "5-6" => "Incapaz de manter-se em um pé com olhos fechados ou se pendurar na barra, mostrando deficiência no equilíbrio avançado.",
    ],
    
    // Classe 36: Escrever
    36 => [
        "5-6" => "Dificuldade em escrever letras ou nome denota atraso na coordenação motora fina e pré-escrita.",
    ],
    
    // Classe 37: Esticar dedos
    37 => [
        "5-6" => "Não tocou o polegar em cada dedo, evidenciando atraso na destreza digital.",
    ],
    
    // Classe 38: Usar o apontador
    38 => [
        "5-6" => "Dificuldade em usar apontador para lápis aponta atraso na rotação do punho e destreza.",
    ],
    
    // Classe 39: Rasgar figuras
    39 => [
        "5-6" => "Não rasgou papel com precisão, sugerindo atraso na força e coordenação bimanual.",
    ],
    
    // Classe 40: Brincar na água
    40 => [
        "5-6" => "Insegurança ao brincar em piscina com água até a cintura indica falta de domínio corporal em ambiente aquático.",
    ],

];

// Função para ordenar faixas etárias
function get_age_order($age_range) {
    $parts = explode('-', $age_range);
    return intval($parts[0]);
}

// Função para processar as respostas e gerar o relatório
function generate_report($json_data, $item_mapping, $standard_responses) {
    $input = json_decode($json_data, true);
    
    if ($input === null) {
        return "Erro: JSON inválido.";
    }
    
    $class_failures = [];
    
    foreach ($input as $item => $value) {
        if ($value == 1 && isset($item_mapping[$item])) {
            $class = $item_mapping[$item]['class'];
            $age_range = $item_mapping[$item]['age_range'];
            $age_order = get_age_order($age_range);
            
            if (!isset($class_failures[$class])) {
                $class_failures[$class] = [
                    "age_range" => $age_range,
                    "age_order" => $age_order,
                ];
            } else {
                if ($age_order < $class_failures[$class]['age_order']) {
                    $class_failures[$class] = [
                        "age_range" => $age_range,
                        "age_order" => $age_order,
                    ];
                }
            }
        }
    }
    
    $report = [];
    
    foreach ($class_failures as $class => $info) {
        $age_range = $info['age_range'];
        if (isset($standard_responses[$class][$age_range])) {
            $report[] = $standard_responses[$class][$age_range];
        }
    }
    
    if (empty($report)) {
        return "Nenhuma falha identificada nos itens avaliados.";
    } else {
        $output = "Relatório de Desenvolvimento Motor:\n\n";
        foreach ($report as $index => $response) {
            $output .= ($index + 1) . ". " . $response . "\n\n";
        }
        return $output;
    }
}

// Gerar e exibir o relatório
$relatorio = generate_report($json_input, $item_mapping, $standard_responses);
echo $relatorio;
?>