<?php
   // 1. Configurações de conexão
   $servername = "localhost"; // Altere se o servidor não for local
   $username = "wwifcora_teste";
   $password = "Lucas@31!";
   $dbname = "wwifcora_teste";
   
   // 2. Criar conexão
   $conn = new mysqli($servername, $username, $password, $dbname);
   
   // 3. Verificar conexão
   if ($conn->connect_error) {
       die("Falha na conexão: " . $conn->connect_error);
   }
   
   // 4. Consultar dados da tabela avl_rsp
   $sql = "SELECT qst, rsp FROM avl_rsp WHERE avl = 'AVA001'";
   $result = $conn->query($sql);
   
   // 5. Array para mapear qst para rsp
   $qst_rsp_map = array();
   
   if ($result->num_rows > 0) {
       while($row = $result->fetch_assoc()) {
           // Remover o 'S' de qst se estiver presente e converter para inteiro
           $qst_num = intval(str_replace('S', '', $row["qst"]));
           $qst_rsp_map[$qst_num] = intval($row["rsp"]);
       }
   } 
   
   $conn->close();
   
   // 6. Função para determinar a cor de fundo com base no rsp
   function getBackgroundColor($rsp) {
       if ($rsp === 3) {
           return "background-color: #08CA9D; color: #fff";
       } elseif ($rsp === 2) {
           return "background-color: #F7702E; color: #fff";
       } elseif ($rsp === 1 || $rsp === 0) {
           return "background-color: #DCDCDC;";
       } else {
           return ""; // Transparente
       }
   }
   
   // Função para calcular pontos com base no rsp
   function calculatePoints($rsp) {
       if ($rsp === 3) {
           return 1.0;
       } elseif ($rsp === 2) {
           return 0.5;
       } else {
           // rsp = 1 ou 0 ou nulo => 0 ponto
           return 0.0;
       }
   }
   
   
   // 8. Funções de verificação de inconsistência
   /**
    * Verifica se, dentro de uma lista de questões ($qsts), 
    * existe a situação de “qst maior tem valor 3 enquanto qst menor 
    * não tem valor 3”.
    *
    * Retorna true se houver qualquer inconsistência, false caso contrário.
    */
   function existeInconsistencia(array $qsts, array $qst_rsp_map): bool {
       // Ordena as questões do menor para o maior
       sort($qsts);
   
       for ($i = 0; $i < count($qsts); $i++) {
           for ($j = $i + 1; $j < count($qsts); $j++) {
               $qstMenor = $qsts[$i];
               $qstMaior = $qsts[$j];
   
               // Respostas
               $rspMenor = $qst_rsp_map[$qstMenor] ?? null;
               $rspMaior = $qst_rsp_map[$qstMaior] ?? null;
   
               // Se a questão maior (qstMaior) tiver rsp=3 e a questão menor não for 3 => inconsistente
               if ($rspMaior === 3 && $rspMenor !== 3) {
                   return true;  // Achou inconsistência, pode retornar imediatamente
               }
           }
       }
       return false; // Se chegou até aqui, não achou inconsistência
   }
   
   
?>

<style>
  .skill-description {
    display: none; /* Oculta a descrição por padrão */
    margin-top: 5px;
    /* Você pode adicionar mais estilos conforme necessário */
  }

  .checkbox-title {
    cursor: pointer; /* Indica que o título é clicável */
    color: #4a5568; /* Cor azul para destacar o título */
  }

  .checkbox-title::after {
    content: " ▼"; /* Seta para indicar que pode ser expandido */
    font-size: 0.8em;
  }

  .checkbox-title.expanded::after {
    content: " ▲"; /* Seta para indicar que pode ser recolhido */
  }
  
  
  /* Cores de destaque para as linhas */
  .highlight-sim {
    background-color: #d4edda; /* Verde claro */
  }

  .highlight-av {
    background-color: #fff3cd; /* Laranja claro */
  }

  .highlight-nao {
    background-color: #f8d7da; /* Vermelho claro */
  }

  /* Estilos para a descrição */
  .skill-description {
    display: none; /* Oculta a descrição por padrão */
    margin-top: 5px;
  }

  .checkbox-title {
    cursor: pointer; /* Indica que o título é clicável */
    color: #007BFF; /* Cor azul para destacar o título */
  }

  .checkbox-title::after {
    content: " ▼"; /* Seta para indicar que pode ser expandido */
    font-size: 0.8em;
  }

  .checkbox-title.expanded::after {
    content: " ▲"; /* Seta para indicar que pode ser recolhido */
  }

  /* Estilos para a tabela */
  table {
    width: 100%;
    border-collapse: collapse;
  }

  td {
    border: 1px solid #ddd;
    padding: 8px;
  }

  .text-center {
    text-align: center;
  }
  
  
  /* Tabela de Plano de Intervenção */
        .intervention-table {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
        }

        .intervention-table table {
            width: 100%;
        }

        .intervention-table th,
        .intervention-table td {
            text-align: center;
            vertical-align: middle;
        }

        .intervention-table th {
            background-color: #f7fafc;
            color: #2d3748;
        }

        /* Botões de Ação */
        .action-btn {
            background-color: #08C89E;
            color: #fff;
            border: none;
            border-radius: 6px;
            padding: 6px 10px;
            font-size: 12px;
            cursor: pointer;
            transition: background 0.3s;
            margin: 0 2px;
        }

        .action-btn:hover {
            background-color: #06b287;
        }

        /* Botão para criar novo plano de intervenção */
        .new-intervention-btn {
            background-color: #08C89E;
            color: #fff;
            border: none;
            padding: 10px 20px;
            border-radius: 8px;
            font-size: 14px;
            cursor: pointer;
            transition: background 0.3s;
            margin-bottom: 20px;
        }

        .new-intervention-btn:hover {
            background-color: #06b287;
        }

        /* Modal Estilização */
        .modal-header {
            border-bottom: 1px solid #e2e8f0;
        }

        .modal-title {
            font-weight: 600;
            color: #08C89E;
        }

        .modal-footer {
            border-top: 1px solid #e2e8f0;
        }

        .form-group label {
            font-weight: 600;
            margin-bottom: 5px;
            color: #2d3748;
        }

        .form-control {
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            font-size: 14px;
            color: #2d3748;
        }

        /* Toasts */
        .toast-container {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1055;
        }

</style>

  <script>
    // Função para alternar a exibição da descrição
    function toggleDescription(element) {
      const description = element.nextElementSibling;
      if (description.style.display === "none" || description.style.display === "") {
        description.style.display = "block"; // Exibe a descrição
        element.classList.add("expanded"); // Adiciona a classe para mudar a seta
      } else {
        description.style.display = "none"; // Oculta a descrição
        element.classList.remove("expanded"); // Remove a classe para mudar a seta
      }
    }

    // Função para atualizar o destaque da linha com base na seleção
    function updateRowHighlight(rowId, selection) {
      const row = document.getElementById(rowId);
      if (!row) {
        console.error(`Linha com ID '${rowId}' não encontrada.`);
        return;
      }

      // Remove classes de destaque existentes
      row.classList.remove("highlight-sim", "highlight-av", "highlight-nao");

      // Adiciona a classe correspondente à seleção
      switch (selection) {
        case "Sim":
          row.classList.add("highlight-sim");
          break;
        case "AV":
          row.classList.add("highlight-av");
          break;
        case "Não":
          row.classList.add("highlight-nao");
          break;
        default:
          console.warn(`Seleção desconhecida: ${selection}`);
      }
    }

    // Inicializa o destaque das linhas com base nas seleções padrão
    document.addEventListener("DOMContentLoaded", function() {
      const rows = document.querySelectorAll("table tr");
      rows.forEach((row) => {
        const selectedRadio = row.querySelector("input[type='radio']:checked");
        if (selectedRadio) {
          updateRowHighlight(row.id, selectedRadio.value);
        }
      });
    });
  </script>



<!-- Área Social -->
<?php include 'painel-clinica-perfil-criança-portage_Social.php'; ?>


<!-- Área Cognição -->
<?php include 'painel-clinica-perfil-criança-portage_Cognicao.php'; ?>

<!-- Área Linguagem -->
<?php include 'painel-clinica-perfil-criança-portage_Linguagem.php'; ?>

<!-- Área autocuidado -->
<?php include 'painel-clinica-perfil-criança-portage_Autocuidado.php'; ?>

<!-- Área Motor -->
<?php include 'painel-clinica-perfil-criança-portage_Motor.php'; ?>

<!-- Graficos -->
<?php include 'painel-clinica-perfil-criança-portage_Graficos.php'; ?>

<!-- Plano -->
<?php include 'ch_portage_plano_de_intervencao.php'; ?>

<!-- Relatório -->
<div id="relatorio" class="tab-pane fade" role="tabpanel" aria-labelledby="relatorio-tab">
    <h5>Relatório</h5>
</div>
