<div id="plano" class="tab-pane fade" role="tabpanel" aria-labelledby="plano-tab">
    <h4>Plano de intervenção</h4>
    <p style="margin-top: -15px">Listamos abaixo apenas os itens que apresentaram "<strong>Não</strong>" ou "<strong>Às vezes</strong>".<br /> Selecione quais deseja trabalhar e adicione instruções personalizadas para cada um.</p>
    

    <!-- 
    Removido o botão "Novo Plano de Intervenção"
    que abria o modal de criação de plano
    -->

    <!-- CSS Personalizado -->
    <style>
        

                /* Seção de Itens em Atraso */
        .overdue-items-section {
            
        }

        .overdue-items-section h2 {
            color: #F7702D;
            font-size: 20px;
            margin-bottom: 15px;
        }

        .badge {
            font-size: 12px;
        }

        /* Botão para Confirmar Seleção */
        .confirm-selection-btn {
            background-color: #3182ce;
            color: #fff;
            border: none;
            padding: 10px 20px;
            border-radius: 8px;
            font-size: 14px;
            cursor: pointer;
            transition: background 0.3s;
            margin-top: 20px;
        }
        .confirm-selection-btn:hover {
            background-color: #2b6cb0;
        }

        /* Destaque para Itens Selecionados */
        .selected-item {
            background-color: #e6fffa; /* Azul Claro */
            border-radius: 4px;
        }

        /* Status do Item */
        .status-nao {
            color: #e53e3e; /* Vermelho Pastel */
            font-weight: bold;
            margin-right: 5px;
            font-size: 12px;
        }
        .status-av {
            color: #ed8936; /* Laranja Suave */
            font-weight: bold;
            margin-right: 5px;
            font-size: 12px;
        }

        /* Estilização para Faixas Etárias */
        .age-group {
            font-weight: bold;
            margin-top: 5px;
            margin-bottom: -20px;
            font-size: 16px;
            color: #2d3748;
        }

        /* Seção de Plano de Intervenção Selecionado */
        .selected-plan-section {
            margin-top: 30px;
            margin-bottom: 30px;
        }
        .selected-plan-section h3 {
            font-size: 20px;
            color: #08C89E;
            margin-bottom: 15px;
        }

        /* Cartões do plano selecionado */
        .ippl-portage-card {
            background-color: #fff;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 15px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
        }
        .ippl-portage-card .ippl-area-faixa {
            font-size: 14px;
            color: #4a5568;
            margin-bottom: 5px;
        }
        .ippl-portage-card .ippl-classe {
            font-weight: 600;
            margin-bottom: 10px;
        }

        /* Botão Toggle Orientações */
        .ippl-orient-toggle {
            cursor: pointer;
            color: #3182ce;
            font-weight: 600;
            margin-bottom: 5px;
        }
        .ippl-orient-text {
            display: none;
            background-color: #f7fafc;
            padding: 10px;
            margin-bottom: 10px;
            border-radius: 4px;
            font-size: 14px;
        }
        .ippl-orient-text ol {
            padding-left: 20px;
        }

        /* Instruções Personalizadas */
        .ippl-instrucoes-personalizadas {
            margin-bottom: 10px;
        }
        .ippl-instrucoes-personalizadas label {
            font-weight: 500;
            font-size: 14px;
            display: block;
            margin-bottom: 5px;
        }
        .ippl-instrucoes-personalizadas textarea {
            width: 100%;
            min-height: 60px;
            border-radius: 6px;
            border: 1px solid #e2e8f0;
            padding: 8px;
            font-size: 14px;
            color: #2d3748;
            resize: vertical;
        }

        /* Botões Editar / Salvar */
        .ippl-buttons-instrucao {
            margin-top: 8px;
        }
        .btn-editar-instrucao,
        .btn-salvar-instrucao {
            background-color: #06b287;
            color: #fff;
            border: none;
            padding: 6px 12px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
            margin-right: 8px;
        }
        .btn-editar-instrucao:hover,
        .btn-salvar-instrucao:hover {
            background-color: #05a07a;
        }
        .btn-salvar-instrucao:disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }

        /* Contadores */
        .ippl-resposta-contadores {
            display: flex;
            gap: 20px;
            margin-top: 8px;
            font-size: 14px;
        }
        .ippl-contador-label {
            font-weight: 600;
        }
        .ippl-contador-valor {
            margin-left: 5px;
            color: #08C89E;
            font-weight: bold;
        }

        /* Toasts */
        .toast-container {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1055;
        }
        
        .card-header h4 {
            font-size: 16px;
            margin-bottom:-5px;
            margin-top:-5px
        }
        
        .form-check-hr {
            margin-bottom:5px;
        }
    </style>
</head>
<body>
    <div class="container-page">
        
        <!-- Seção de Itens em Atraso -->
        <div class="overdue-items-section">
            
            <form id="selectOverdueItemsForm">
                <!-- Área 1: Cognitiva -->
                <div class="card mb-3">
                    <div class="card-header">
                        <h4>1. Cognitiva</h4>
                    </div>
                    <div class="card-body">
                        <p class="age-group">0-1 ano</p>
                        <hr class="form-check-hr">
                        <div class="form-check">
                            <input
                                class="form-check-input"
                                type="checkbox"
                                value="S1_Reconhecimento_Cores_0_1"
                                id="S1_Reconhecimento_Cores_0_1"
                                name="overdueItems[]"
                            />
                            <label class="form-check-label" for="S1_Reconhecimento_Cores_0_1">
                                <span class="status-av">(AV)</span> 
                                S1 - A criança acompanha o movimento de uma pessoa com os olhos.
                            </label>
                        </div>
                        <div class="form-check">
                            <input
                                class="form-check-input"
                                type="checkbox"
                                value="S15_Contagem_Basica_0_1"
                                id="S15_Contagem_Basica_0_1"
                                name="overdueItems[]"
                            />
                            <label class="form-check-label" for="S15_Contagem_Basica_0_1">
                                <span class="status-nao">(Não)</span>
                                S2 - A criança tem dificuldade em reconhecer cores básicas.
                            </label>
                        </div>

                        <p class="age-group">1-2 anos</p>
                        <hr class="form-check-hr">
                        <div class="form-check">
                            <input
                                class="form-check-input"
                                type="checkbox"
                                value="S1_Reconhecimento_Cores_1_2"
                                id="S1_Reconhecimento_Cores_1_2"
                                name="overdueItems[]"
                            />
                            <label class="form-check-label" for="S1_Reconhecimento_Cores_1_2">
                                <span class="status-av">(AV)</span>
                                S1 - Reconhecimento de Cores
                            </label>
                        </div>
                        <div class="form-check">
                            <input
                                class="form-check-input"
                                type="checkbox"
                                value="S15_Contagem_Basica_1_2"
                                id="S15_Contagem_Basica_1_2"
                                name="overdueItems[]"
                            />
                            <label class="form-check-label" for="S15_Contagem_Basica_1_2">
                                <span class="status-nao">(Não)</span>
                                S15 - Contagem Básica
                            </label>
                        </div>
                    </div>
                </div>

                <!-- Área 2: Motora -->
                <div class="card mb-3">
                    <div class="card-header">
                        <h4>2. Motora</h4>
                    </div>
                    <div class="card-body">
                        <p class="age-group">0-1 ano</p>
                        <hr class="form-check-hr">
                        <div class="form-check">
                            <input
                                class="form-check-input"
                                type="checkbox"
                                value="S1_Coord_Motora_Grossa_0_1"
                                id="S1_Coord_Motora_Grossa_0_1"
                                name="overdueItems[]"
                            />
                            <label class="form-check-label" for="S1_Coord_Motora_Grossa_0_1">
                                <span class="status-av">(AV)</span>
                                S1 - Coordenação Motora Grossa
                            </label>
                        </div>
                        <div class="form-check">
                            <input
                                class="form-check-input"
                                type="checkbox"
                                value="S2_Coord_Motora_Fina_0_1"
                                id="S2_Coord_Motora_Fina_0_1"
                                name="overdueItems[]"
                            />
                            <label class="form-check-label" for="S2_Coord_Motora_Fina_0_1">
                                <span class="status-nao">(Não)</span>
                                S2 - Coordenação Motora Fina
                            </label>
                        </div>

                        <p class="age-group">1-2 anos</p>
                        <hr class="form-check-hr">
                        <div class="form-check">
                            <input
                                class="form-check-input"
                                type="checkbox"
                                value="S1_Coord_Motora_Grossa_1_2"
                                id="S1_Coord_Motora_Grossa_1_2"
                                name="overdueItems[]"
                            />
                            <label class="form-check-label" for="S1_Coord_Motora_Grossa_1_2">
                                <span class="status-av">(AV)</span>
                                S1 - Coordenação Motora Grossa
                            </label>
                        </div>
                        <div class="form-check">
                            <input
                                class="form-check-input"
                                type="checkbox"
                                value="S2_Coord_Motora_Fina_1_2"
                                id="S2_Coord_Motora_Fina_1_2"
                                name="overdueItems[]"
                            />
                            <label class="form-check-label" for="S2_Coord_Motora_Fina_1_2">
                                <span class="status-nao">(Não)</span>
                                S2 - Coordenação Motora Fina
                            </label>
                        </div>
                    </div>
                </div>

                <!-- Área 3: Comportamental -->
                <div class="card mb-3">
                    <div class="card-header">
                        <h4>3. Comportamental</h4>
                    </div>
                    <div class="card-body">
                        <p class="age-group">0-1 ano</p>
                        <hr class="form-check-hr">
                        <div class="form-check">
                            <input
                                class="form-check-input"
                                type="checkbox"
                                value="S1_Controle_Impulsos_0_1"
                                id="S1_Controle_Impulsos_0_1"
                                name="overdueItems[]"
                            />
                            <label class="form-check-label" for="S1_Controle_Impulsos_0_1">
                                <span class="status-av">(AV)</span>
                                S1 - Controle de Impulsos
                            </label>
                        </div>
                        <div class="form-check">
                            <input
                                class="form-check-input"
                                type="checkbox"
                                value="S2_Interacao_Social_0_1"
                                id="S2_Interacao_Social_0_1"
                                name="overdueItems[]"
                            />
                            <label class="form-check-label" for="S2_Interacao_Social_0_1">
                                <span class="status-nao">(Não)</span>
                                S2 - Interação Social
                            </label>
                        </div>

                        <p class="age-group">1-2 anos</p>
                        <hr class="form-check-hr">
                        <div class="form-check">
                            <input
                                class="form-check-input"
                                type="checkbox"
                                value="S1_Controle_Impulsos_1_2"
                                id="S1_Controle_Impulsos_1_2"
                                name="overdueItems[]"
                            />
                            <label class="form-check-label" for="S1_Controle_Impulsos_1_2">
                                <span class="status-av">(AV)</span>
                                S1 - Controle de Impulsos
                            </label>
                        </div>
                        <div class="form-check">
                            <input
                                class="form-check-input"
                                type="checkbox"
                                value="S2_Interacao_Social_1_2"
                                id="S2_Interacao_Social_1_2"
                                name="overdueItems[]"
                            />
                            <label class="form-check-label" for="S2_Interacao_Social_1_2">
                                <span class="status-nao">(Não)</span>
                                S2 - Interação Social
                            </label>
                        </div>
                    </div>
                </div>

                <!-- Área 4: Social -->
                <div class="card mb-3">
                    <div class="card-header">
                        <h4>4. Social</h4>
                    </div>
                    <div class="card-body">
                        <p class="age-group">0-1 ano</p>
                        <hr class="form-check-hr">
                        <div class="form-check">
                            <input
                                class="form-check-input"
                                type="checkbox"
                                value="S1_Empatia_0_1"
                                id="S1_Empatia_0_1"
                                name="overdueItems[]"
                            />
                            <label class="form-check-label" for="S1_Empatia_0_1">
                                <span class="status-av">(AV)</span>
                                S1 - Empatia
                            </label>
                        </div>
                        <div class="form-check">
                            <input
                                class="form-check-input"
                                type="checkbox"
                                value="S2_Trabalho_Equipe_0_1"
                                id="S2_Trabalho_Equipe_0_1"
                                name="overdueItems[]"
                            />
                            <label class="form-check-label" for="S2_Trabalho_Equipe_0_1">
                                <span class="status-nao">(Não)</span>
                                S2 - Trabalho em Equipe
                            </label>
                        </div>

                        <p class="age-group">1-2 anos</p>
                        <hr class="form-check-hr">
                        <div class="form-check">
                            <input
                                class="form-check-input"
                                type="checkbox"
                                value="S1_Empatia_1_2"
                                id="S1_Empatia_1_2"
                                name="overdueItems[]"
                            />
                            <label class="form-check-label" for="S1_Empatia_1_2">
                                <span class="status-av">(AV)</span>
                                S1 - Empatia
                            </label>
                        </div>
                        <div class="form-check">
                            <input
                                class="form-check-input"
                                type="checkbox"
                                value="S2_Trabalho_Equipe_1_2"
                                id="S2_Trabalho_Equipe_1_2"
                                name="overdueItems[]"
                            />
                            <label class="form-check-label" for="S2_Trabalho_Equipe_1_2">
                                <span class="status-nao">(Não)</span>
                                S2 - Trabalho em Equipe
                            </label>
                        </div>
                    </div>
                </div>

                <!-- Área 5: Adaptativa -->
                <div class="card mb-3">
                    <div class="card-header">
                        <h4 >5. Adaptativa</h4>
                    </div>
                    <div class="card-body">
                        <p class="age-group">0-1 ano</p>
                        <hr class="form-check-hr">
                        <div class="form-check">
                            <input
                                class="form-check-input"
                                type="checkbox"
                                value="S1_Independencia_Pessoal_0_1"
                                id="S1_Independencia_Pessoal_0_1"
                                name="overdueItems[]"
                            />
                            <label class="form-check-label" for="S1_Independencia_Pessoal_0_1">
                                <span class="status-av">(AV)</span>
                                S1 - Independência Pessoal
                            </label>
                        </div>
                        <div class="form-check">
                            <input
                                class="form-check-input"
                                type="checkbox"
                                value="S2_Habilidades_Vida_Diaria_0_1"
                                id="S2_Habilidades_Vida_Diaria_0_1"
                                name="overdueItems[]"
                            />
                            <label class="form-check-label" for="S2_Habilidades_Vida_Diaria_0_1">
                                <span class="status-nao">(Não)</span>
                                S2 - Habilidades de Vida Diária
                            </label>
                        </div>

                        <p class="age-group">1-2 anos</p>
                        <hr class="form-check-hr">
                        <div class="form-check">
                            <input
                                class="form-check-input"
                                type="checkbox"
                                value="S1_Independencia_Pessoal_1_2"
                                id="S1_Independencia_Pessoal_1_2"
                                name="overdueItems[]"
                            />
                            <label class="form-check-label" for="S1_Independencia_Pessoal_1_2">
                                <span class="status-av">(AV)</span>
                                S1 - Independência Pessoal
                            </label>
                        </div>
                        <div class="form-check">
                            <input
                                class="form-check-input"
                                type="checkbox"
                                value="S2_Habilidades_Vida_Diaria_1_2"
                                id="S2_Habilidades_Vida_Diaria_1_2"
                                name="overdueItems[]"
                            />
                            <label class="form-check-label" for="S2_Habilidades_Vida_Diaria_1_2">
                                <span class="status-nao">(Não)</span>
                                S2 - Habilidades de Vida Diária
                            </label>
                        </div>
                    </div>
                </div>
            </form>

            <!-- Botão para Confirmar Seleção -->
            <button type="submit" class="confirm-selection-btn" onclick="confirmSelection()">
                <i class="fas fa-check"></i> Confirmar Seleção
            </button>
        </div>

        <!-- Seção de Plano de Intervenção Selecionado -->
        <div class="selected-plan-section">
            <h3>Plano de Intervenção Selecionado</h3>
            <div id="selectedItemsContainer">
                <!-- Os cards com detalhes dos itens selecionados serão inseridos aqui via JavaScript -->
            </div>
        </div>
    </div>

    <!-- Container para Toasts -->
    <div class="toast-container" aria-live="polite" aria-atomic="true">
        <!-- Toasts serão inseridos via JavaScript -->
    </div>

    <!-- Scripts Bootstrap e jQuery -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <!-- Mantendo apenas Bootstrap Bundle para funcionalidades de modal e toast -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        // Objeto que mapeia cada item a suas informações detalhadas
        const itemInfoMap = {
            "S1_Reconhecimento_Cores_0_1": {
                area: "Cognitiva",
                faixaEtaria: "0-1 ano",
                classe: "1 - Discriminação Visual",
                orientacoes: [
                    "Use objetos coloridos para estimular a percepção visual.",
                    "Varie as cores e mostre ao bebê em diferentes distâncias.",
                    "Observação: verificar se a criança acompanha o objeto."
                ],
                passou: 3,
                falha: 2
            },
            "S15_Contagem_Basica_0_1": {
                area: "Cognitiva",
                faixaEtaria: "0-1 ano",
                classe: "2 - Reconhecimento de Formas/Cores",
                orientacoes: [
                    "Iniciar contagem de pequenos objetos para exposição.",
                    "Associar contagem a gestos (dedos) para reforçar."
                ],
                passou: 1,
                falha: 2
            },
            "S1_Reconhecimento_Cores_1_2": {
                area: "Cognitiva",
                faixaEtaria: "1-2 anos",
                classe: "1 - Discriminação Visual",
                orientacoes: [
                    "Apresentar cartões coloridos e perguntar o nome das cores.",
                    "Brincar de separar brinquedos por cores."
                ],
                passou: 4,
                falha: 1
            },
            "S15_Contagem_Basica_1_2": {
                area: "Cognitiva",
                faixaEtaria: "1-2 anos",
                classe: "4 - Início de Contagem",
                orientacoes: [
                    "Incentivar a criança a contar até 3 em brincadeiras.",
                    "Usar músicas que envolvam contagem."
                ],
                passou: 2,
                falha: 3
            },

            "S1_Coord_Motora_Grossa_0_1": {
                area: "Motora",
                faixaEtaria: "0-1 ano",
                classe: "1 - Coordenação Motora Grossa",
                orientacoes: [
                    "Estimular a rolar no chão com segurança.",
                    "Brincadeiras que incentivem o bebê a erguer a cabeça."
                ],
                passou: 5,
                falha: 2
            },
            "S2_Coord_Motora_Fina_0_1": {
                area: "Motora",
                faixaEtaria: "0-1 ano",
                classe: "2 - Coordenação Motora Fina",
                orientacoes: [
                    "Oferecer brinquedos seguros para segurar.",
                    "Estimular o bebê a agarrar objetos macios."
                ],
                passou: 1,
                falha: 3
            },
            "S1_Coord_Motora_Grossa_1_2": {
                area: "Motora",
                faixaEtaria: "1-2 anos",
                classe: "1 - Coordenação Motora Grossa",
                orientacoes: [
                    "Praticar caminhar segurando a mão da criança.",
                    "Incentivar subir degraus baixos com supervisão."
                ],
                passou: 3,
                falha: 2
            },
            "S2_Coord_Motora_Fina_1_2": {
                area: "Motora",
                faixaEtaria: "1-2 anos",
                classe: "2 - Coordenação Motora Fina",
                orientacoes: [
                    "Oferecer blocos de montar para encaixar.",
                    "Propor atividades de folhear páginas de livros."
                ],
                passou: 0,
                falha: 2
            },

            "S1_Controle_Impulsos_0_1": {
                area: "Comportamental",
                faixaEtaria: "0-1 ano",
                classe: "1 - Controle de Impulsos",
                orientacoes: [
                    "Observar sinais de irritação e tentar acalmar antes do choro.",
                    "Uso de canções de ninar para reduzir ansiedade."
                ],
                passou: 2,
                falha: 2
            },
            "S2_Interacao_Social_0_1": {
                area: "Comportamental",
                faixaEtaria: "0-1 ano",
                classe: "2 - Interação Social",
                orientacoes: [
                    "Fazer contato visual frequente e conversar com a criança.",
                    "Permitir a aproximação de pessoas seguras para interação."
                ],
                passou: 1,
                falha: 4
            },
            "S1_Controle_Impulsos_1_2": {
                area: "Comportamental",
                faixaEtaria: "1-2 anos",
                classe: "1 - Controle de Impulsos",
                orientacoes: [
                    "Utilizar rotina clara para diminuir frustrações.",
                    "Evitar exposição a excessos de estímulos (TV alta)."
                ],
                passou: 3,
                falha: 3
            },
            "S2_Interacao_Social_1_2": {
                area: "Comportamental",
                faixaEtaria: "1-2 anos",
                classe: "2 - Interação Social",
                orientacoes: [
                    "Estimular brincadeiras em grupo com supervisão.",
                    "Ensinar a esperar a vez em pequenas atividades."
                ],
                passou: 0,
                falha: 2
            },

            "S1_Empatia_0_1": {
                area: "Social",
                faixaEtaria: "0-1 ano",
                classe: "1 - Empatia",
                orientacoes: [
                    "Conversar de forma carinhosa e suave para criar vínculo.",
                    "Responder prontamente quando o bebê chora."
                ],
                passou: 2,
                falha: 1
            },
            "S2_Trabalho_Equipe_0_1": {
                area: "Social",
                faixaEtaria: "0-1 ano",
                classe: "2 - Cooperação Inicial",
                orientacoes: [
                    "Envolver o bebê em interações familiares.",
                    "Uso de músicas e brincadeiras que incluam mais de um adulto."
                ],
                passou: 0,
                falha: 3
            },
            "S1_Empatia_1_2": {
                area: "Social",
                faixaEtaria: "1-2 anos",
                classe: "1 - Empatia",
                orientacoes: [
                    "Ensinar a identificar emoções básicas nas pessoas.",
                    "Ler livros de histórias que mostrem sentimentos."
                ],
                passou: 3,
                falha: 2
            },
            "S2_Trabalho_Equipe_1_2": {
                area: "Social",
                faixaEtaria: "1-2 anos",
                classe: "2 - Trabalho em Equipe",
                orientacoes: [
                    "Brincar de guardar brinquedos em grupo.",
                    "Propor atividades simples que precisem da ajuda de um adulto."
                ],
                passou: 1,
                falha: 4
            },

            "S1_Independencia_Pessoal_0_1": {
                area: "Adaptativa",
                faixaEtaria: "0-1 ano",
                classe: "1 - Independência Pessoal",
                orientacoes: [
                    "Permitir que tente segurar a mamadeira com supervisão.",
                    "Dar espaço para a criança tentar movimentos de se virar."
                ],
                passou: 2,
                falha: 1
            },
            "S2_Habilidades_Vida_Diaria_0_1": {
                area: "Adaptativa",
                faixaEtaria: "0-1 ano",
                classe: "2 - Habilidades de Vida Diária",
                orientacoes: [
                    "Criar rotina de horários de alimentação e soneca.",
                    "Manter objetos pessoais em local acessível."
                ],
                passou: 1,
                falha: 2
            },
            "S1_Independencia_Pessoal_1_2": {
                area: "Adaptativa",
                faixaEtaria: "1-2 anos",
                classe: "1 - Independência Pessoal",
                orientacoes: [
                    "Ensinar a levar objetos leves de um lugar para outro.",
                    "Permitir tentativas de comer sozinho com talheres adequados."
                ],
                passou: 4,
                falha: 1
            },
            "S2_Habilidades_Vida_Diaria_1_2": {
                area: "Adaptativa",
                faixaEtaria: "1-2 anos",
                classe: "2 - Habilidades de Vida Diária",
                orientacoes: [
                    "Estimular a criança a participar ao vestir roupas simples.",
                    "Incentivar a limpar pequenas bagunças com supervisão."
                ],
                passou: 0,
                falha: 2
            }
        };

        // =====================================
        // ==== Funções para Toast (Notificações)
        // =====================================
        function showToast(title, message, type = 'success') {
            const toastId = 'toast' + Date.now();
            let headerClass = 'text-success';
            if (type === 'error') {
                headerClass = 'text-danger';
            } else if (type === 'info') {
                headerClass = 'text-info';
            }

            const toastHTML = `
                <div class="toast" id="${toastId}" role="alert" aria-live="assertive" aria-atomic="true" data-delay="3000">
                    <div class="toast-header">
                        <strong class="mr-auto ${headerClass}">${title}</strong>
                        <small>Agora</small>
                        <button type="button" class="ml-2 mb-1 close" data-dismiss="toast" aria-label="Fechar">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="toast-body">
                        ${message}
                    </div>
                </div>
            `;
            $('.toast-container').append(toastHTML);
            $(`#${toastId}`).toast('show');
            $(`#${toastId}`).on('hidden.bs.toast', function () {
                $(this).remove();
            });
        }

        // =====================================
        // == Eventos: Seleção de Itens, Botão ==
        // =====================================
        function confirmSelection() {
            const form = document.getElementById('selectOverdueItemsForm');
            form.dispatchEvent(new Event('submit'));
        }

        // Ao enviar o formulário de seleção de itens
        document.getElementById('selectOverdueItemsForm').addEventListener('submit', function(event) {
            event.preventDefault();
            const selectedItems = Array.from(
                document.querySelectorAll('input[name="overdueItems[]"]:checked')
            ).map(el => el.value);

            if (selectedItems.length === 0) {
                showToast('Erro', 'Por favor, selecione pelo menos um item para trabalhar.', 'error');
                return;
            }

            // Monta a exibição do plano selecionado
            updateSelectedPlan(selectedItems);
            showToast('Sucesso', `Itens selecionados: ${selectedItems.join(', ')}`);
        });

        // Destaque visual do checkbox selecionado
        document.querySelectorAll('input[name="overdueItems[]"]').forEach(function(checkbox) {
            checkbox.addEventListener('change', function() {
                const formCheckDiv = this.closest('.form-check');
                if (this.checked) {
                    formCheckDiv.classList.add('selected-item');
                } else {
                    formCheckDiv.classList.remove('selected-item');
                }
            });
        });

        // =====================================
        // ========== Monta o Plano ============
        // =====================================
        function updateSelectedPlan(selectedItems) {
            const container = document.getElementById('selectedItemsContainer');
            container.innerHTML = ''; // Limpa antes de recriar

            selectedItems.forEach((itemKey) => {
                const info = itemInfoMap[itemKey];
                if (!info) return;

                // Monta as orientações em <li>
                const orientacoesList = info.orientacoes
                    .map(o => `<li>${o}</li>`)
                    .join('');

                // Cria o card para cada item
                const cardHTML = `
                    <div class="ippl-portage-card" id="card_${itemKey}">
                        <!-- Cabeçalho com Área e Faixa Etária -->
                        <div class="ippl-area-faixa">
                            <strong>Área:</strong> ${info.area} |
                            <strong>Faixa Etária:</strong> ${info.faixaEtaria}
                        </div>
                        <!-- Classe do Item -->
                        <div class="ippl-classe">Classe: ${info.classe}</div>

                        <!-- Botão Toggle Orientações -->
                        <div class="ippl-orient-toggle" onclick="toggleOrientation('orient_${itemKey}')">
                            <i class="fas fa-chevron-down"></i> Orientações
                        </div>
                        <div class="ippl-orient-text" id="orient_${itemKey}">
                            <ol>
                                ${orientacoesList}
                            </ol>
                        </div>

                        <!-- Instruções Personalizadas (desabilitado inicialmente) -->
                        <div class="ippl-instrucoes-personalizadas">
                            <label>Instruções Personalizadas:</label>
                            <textarea
                                name="instrucoes_${itemKey}"
                                placeholder="Digite aqui suas orientações extras..."
                                disabled
                            ></textarea>
                            <div class="ippl-buttons-instrucao">
                                <button
                                    class="btn-editar-instrucao"
                                    onclick="enableEdit('instrucoes_${itemKey}', this)"
                                >
                                    <i class="fas fa-edit"></i> Editar
                                </button>
                                <button
                                    class="btn-salvar-instrucao"
                                    disabled
                                    onclick="saveInstructions('instrucoes_${itemKey}', this)"
                                >
                                    <i class="fas fa-save"></i> Salvar
                                </button>
                            </div>
                        </div>

                        <!-- Contadores -->
                        <div class="ippl-resposta-contadores">
                            <div class="ippl-contador">
                                <span class="ippl-contador-label">Passou:</span>
                                <span class="ippl-contador-valor">${info.passou}</span>
                            </div>
                            <div class="ippl-contador">
                                <span class="ippl-contador-label">Falha:</span>
                                <span class="ippl-contador-valor">${info.falha}</span>
                            </div>
                        </div>
                    </div>
                `;
                container.insertAdjacentHTML('beforeend', cardHTML);
            });
        }

        // =====================================
        // ======== Exibir/Ocultar Texto ========
        // =====================================
        function toggleOrientation(orientId) {
            const elem = document.getElementById(orientId);
            if (!elem) return;
            if (elem.style.display === 'none' || elem.style.display === '') {
                elem.style.display = 'block';
            } else {
                elem.style.display = 'none';
            }
        }

        // =====================================
        // == Funções de Edição e Salvamento ====
        // =====================================
        // Libera o textarea para edição e habilita o botão Salvar
        function enableEdit(textareaName, editBtn) {
            const textarea = document.getElementsByName(textareaName)[0];
            const parentDiv = editBtn.closest('.ippl-instrucoes-personalizadas');
            const saveBtn = parentDiv.querySelector('.btn-salvar-instrucao');
            
            // Habilita o campo e o botão Salvar
            textarea.disabled = false;
            saveBtn.disabled = false;
            
            // (Opcional) Pode focar no textarea
            textarea.focus();
        }

        // Simula a ação de salvamento das instruções
        function saveInstructions(textareaName, saveBtn) {
            const textarea = document.getElementsByName(textareaName)[0];
            // Exemplo: imprimir no console ou enviar a um servidor
            console.log("Instruções salvas para:", textareaName, "=>", textarea.value);

            // Bloqueia novamente o textarea e desabilita o botão Salvar
            textarea.disabled = true;
            saveBtn.disabled = true;

            showToast("Sucesso", "Instruções personalizadas salvas!");
        }
    </script>
    
</div>
