<?php
// avaliacao.php

// Configurações do banco de dados
$servername = "localhost";
$username   = "wwifcora_teste";
$password   = "Lucas@31!";
$dbname     = "wwifcora_teste";

// Conecta ao banco de dados
$conn = new mysqli($servername, $username, $password, $dbname);

// Verifica a conexão
if ($conn->connect_error) {
    die("Conexão falhou: " . $conn->connect_error);
}

// Define a linha do tempo atual
$current_timeline_id = 1; // ID da linha do tempo
$current_cod_timeline = 'LTA000'; // Código da linha do tempo
$current_chave_acesso = 'ABC12345'; // Chave de acesso
$current_id_paciente = 1; // ID do paciente
$current_id_usuario = 1; // ID do usuário/profissional
$current_status = 'publica'; // Status da linha do tempo
$current_data_criacao = '2025-01-13 14:44:45'; // Data de criação

// Processa o formulário de nova avaliação
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'create_evaluation') {
    // Captura os dados do formulário
    $evaluationDate = $_POST['evaluationDate'];
    
    // Determina o tipo de avaliação automaticamente
    // Conta quantas avaliações já existem para esta linha do tempo
    $sql_count = "SELECT COUNT(*) as total FROM portage_avaliacao WHERE cod_timeline = ?";
    $stmt_count = $conn->prepare($sql_count);
    $stmt_count->bind_param("s", $current_cod_timeline);
    $stmt_count->execute();
    $result_count = $stmt_count->get_result();
    $row_count = $result_count->fetch_assoc();
    $total_evaluations = $row_count['total'];
    $stmt_count->close();
    
    // Define o tipo de avaliação
    if ($total_evaluations == 0) {
        $evaluationType = 'inicial';
    } else {
        $evaluationType = 'reavaliacao';
    }

    // Gera um novo código de avaliação (exemplo: AV006)
    // Primeiro, encontra o último código de avaliação para incrementá-lo
    $sql_last = "SELECT cod_avaliacao FROM portage_avaliacao ORDER BY id DESC LIMIT 1";
    $result_last = $conn->query($sql_last);
    if ($result_last->num_rows > 0) {
        $row_last = $result_last->fetch_assoc();
        $last_cod = $row_last['cod_avaliacao'];
        $last_num = intval(substr($last_cod, 2)); // Extrai o número após "AV"
        $new_num = $last_num + 1;
    } else {
        $new_num = 1;
    }
    $cod_avaliacao = 'AV' . str_pad($new_num, 3, '0', STR_PAD_LEFT);

    // Define o status inicial
    $status = 'aberta';

    // Insere a nova avaliação na tabela portage_avaliacao
    $stmt = $conn->prepare("INSERT INTO portage_avaliacao (cod_avaliacao, cod_timeline, cod_paciente, data_criacao, tipo_avaliacao, status, id_usuario) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $current_datetime = date('Y-m-d H:i:s');
    $stmt->bind_param("sssissi", $cod_avaliacao, $current_cod_timeline, $current_id_paciente, $evaluationDate, $evaluationType, $status, $current_id_usuario);

    if ($stmt->execute()) {
        // Redireciona para evitar reenvio do formulário
        header("Location: painel-clinica-perfil-criança-linha-lista-portage.php?success=1");
        exit();
    } else {
        $error_message = "Erro ao criar a avaliação: " . $stmt->error;
    }

    $stmt->close();
}

// Consulta as avaliações da linha do tempo atual
$sql = "SELECT * FROM portage_avaliacao WHERE cod_timeline = '$current_cod_timeline' ORDER BY data_criacao DESC";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8" />
    <title>Avaliações - Sistema IFCora</title>
    <!-- Fonte e Ícones -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

    <!-- Bootstrap -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">

    <!-- CSS Personalizado -->
    <link rel="stylesheet" href="../css/global.css">
    <link rel="stylesheet" href="../css/header.css">
    <link rel="stylesheet" href="../css/sidebar.css">

    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f9fafb;
            color: #2d3748;
        }

        .container-page {
            margin-top: 60px;
            margin-left: 220px;
            padding: 20px;
        }

        h1 {
            color: #08C89E;
            font-size: 24px;
            margin-bottom: 20px;
        }

        /* Tabela de Avaliações */
        .evaluations-table {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
        }

        .evaluations-table table {
            width: 100%;
        }

        .evaluations-table th,
        .evaluations-table td {
            text-align: center;
            vertical-align: middle;
        }

        .evaluations-table th {
            background-color: #f7fafc;
            color: #2d3748;
        }

        /* Botões de Ação */
        .action-btn {
            background-color: #08C89E;
            color: #fff;
            border: none;
            border-radius: 6px;
            padding: 6px 10px;
            font-size: 12px;
            cursor: pointer;
            transition: background 0.3s;
            margin: 0 2px;
        }

        .action-btn:hover {
            background-color: #06b287;
        }

        /* Botão para criar nova avaliação */
        .new-evaluation-btn {
            background-color: #08C89E;
            color: #fff;
            border: none;
            padding: 10px 20px;
            border-radius: 8px;
            font-size: 14px;
            cursor: pointer;
            transition: background 0.3s;
            margin-bottom: 20px;
        }

        .new-evaluation-btn:hover {
            background-color: #06b287;
        }

        /* Modal Estilização */
        .modal-header {
            border-bottom: 1px solid #e2e8f0;
        }

        .modal-title {
            font-weight: 600;
            color: #08C89E;
        }

        .modal-footer {
            border-top: 1px solid #e2e8f0;
        }

        .form-group label {
            font-weight: 600;
            margin-bottom: 5px;
            color: #2d3748;
        }

        .form-control {
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            font-size: 14px;
            color: #2d3748;
        }

        /* Toasts */
        .toast-container {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1055;
        }

        /* Responsividade */
        @media(max-width: 768px) {
            .container-page {
                margin-left: 0;
                padding: 10px;
            }

            .info-section {
                padding: 15px;
            }

            .evaluations-table {
                padding: 15px;
            }

            .new-evaluation-btn {
                width: 100%;
                text-align: center;
            }

            .action-btn {
                padding: 4px 8px;
                font-size: 10px;
            }
        }

        /* Informações da Criança */
        .child-info {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 0px 15px;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
        }
        .child-info img {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            border: 2px solid #08C89E;
            margin-right: 15px;
            object-fit: cover;
        }
        .child-info div {
            font-size: 16px;
        }
        .child-info div p {
            margin-bottom: 5px;
            color: #2d3748;
        }

        /* Nova Coluna Senha */
        .senha-cell {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }

        .copy-url-btn {
            background-color: #3182ce;
            color: #fff;
            border: none;
            border-radius: 4px;
            padding: 4px 8px;
            font-size: 12px;
            cursor: pointer;
            transition: background 0.3s;
        }

        .copy-url-btn:hover {
            background-color: #2b6cb0;
        }

        .timeline-info {
            background-color: #fff;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
        }
        .timeline-info p {
            margin-bottom: 0px;
        }

        /* Garantir que o modal tenha z-index maior que o backdrop */
        .modal {
            z-index: 1050 !important;
        }

        .modal-backdrop {
            z-index: 1040 !important;
        }

        /* Opcional: Evitar que o corpo do documento role quando o modal estiver aberto */
        body.modal-open {
            overflow: hidden;
        }
    </style>
</head>
<body>
    <!-- Cabeçalho e Sidebar padrão do sistema -->
    <?php include '../includes/header.php'; ?>
    <?php include '../includes/sidebar-painel-clinica-crianças.php'; ?>

    <div class="container-page">
        <?php
        // Exibe mensagens de sucesso ou erro
        if (isset($_GET['success'])) {
            $success_message = '';
            switch ($_GET['success']) {
                case '1':
                    $success_message = 'Nova avaliação criada com sucesso!';
                    break;
                case '2':
                    $success_message = 'Status da avaliação alterado com sucesso!';
                    break;
                case '3':
                    $success_message = 'Avaliação excluída com sucesso!';
                    break;
                default:
                    $success_message = '';
            }
            if ($success_message):
        ?>
                <script>
                    document.addEventListener("DOMContentLoaded", function() {
                        showToast('Sucesso', '<?php echo addslashes($success_message); ?>');
                    });
                </script>
        <?php
            endif;
        }

        if (isset($_GET['error'])) {
            $error_message = '';
            switch ($_GET['error']) {
                case '1':
                    $error_message = 'Erro ao criar a avaliação.';
                    break;
                case '2':
                    $error_message = 'Avaliações finalizadas não podem ser excluídas.';
                    break;
                case '3':
                    $error_message = 'Erro ao excluir a avaliação.';
                    break;
                default:
                    $error_message = '';
            }
            if ($error_message):
        ?>
                <script>
                    document.addEventListener("DOMContentLoaded", function() {
                        showToast('Erro', '<?php echo addslashes($error_message); ?>');
                    });
                </script>
        <?php
            endif;
        }
        ?>

        <h1 style="margin-bottom: -10px">
            Linha do Tempo: <span style="color: #F7702D"><?php echo htmlspecialchars($current_cod_timeline); ?> (<?php echo date('d/m/Y', strtotime($current_data_criacao)); ?>)</span>
        </h1>
        <hr>
        <p style="margin-top: -10px">Aqui você registra as avaliações iniciais e reavaliações do paciente criança.</p>

        <!-- Seção de orientações e informações da linha do tempo -->
        <section class="timeline-info">
            <p>
                <strong>Instruções:</strong> Use o botão abaixo para copiar a URL, as orientações e a chave de acesso para acessar o checklist em outro dispositivo.
            </p>
            <p><strong>Chave de Acesso:</strong> <?php echo htmlspecialchars($current_chave_acesso); ?></p>
        </section>

        <!-- Botões Portage e Nova Avaliação -->
        <!-- <div style="margin-bottom: 0px;">
            <button class="new-evaluation-btn" onclick="window.location.href='painel-clinica-perfil-crian%C3%A7a-portage-novo-avalia%C3%A7%C3%B5es.php?timelineId=LTA000&key=ABC12345'" > <i class="fas fa-list"></i> Portage </button>
            <button
                class="new-evaluation-btn"
                onclick="window.location.href='painel-clinica-perfil-criança-portage.php'"
            >
                <i class="fas fa-chart-line"></i> Análise
            </button>

            <button class="new-evaluation-btn" onclick="copyInstructions()"><i class="fas fa-copy"></i> Copiar URL e Instruções</button>
            <button class="new-evaluation-btn" data-toggle="modal" data-target="#createEvaluationModal"><i class="fas fa-plus"></i> Nova Avaliação</button>
        </div> -->
        
        <!-- Botões Portage e Nova Avaliação -->
        <div style="margin-bottom: 0px;">
            <!-- <button class="new-evaluation-btn" onclick="window.location.href='painel-clinica-perfil-crian%C3%A7a-portage-novo-avalia%C3%A7%C3%B5es.php?timelineId=LTA000&key=ABC12345'" > <i class="fas fa-list"></i> Portage </button>
            <!-- <button class="new-evaluation-btn" onclick="window.location.href='painel-clinica-perfil-criança-portage.php'"><i class="fas fa-chart-line"></i> Análise</button>
            <!-- Botão que chama a função de copiar instruções -->
            <!-- <button class="new-evaluation-btn" onclick="copyInstructions()"><i class="fas fa-copy"></i> Copiar URL e Instruções</button> -->
            <button class="new-evaluation-btn" data-toggle="modal" data-target="#createEvaluationModal"><i class="fas fa-plus"></i> Nova Avaliação</button>
        </div>

        <!-- Tabela de Avaliações -->
        <div class="evaluations-table">
            <table class="table table-bordered table-hover">
                <thead class="thead-light">
                    <tr>
                        <th>ORD</th>
                        <th>ID Avaliação</th>
                        <th>Gerado Em</th>
                        <th>Tipo de Avaliação</th>
                        <th>Status</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody id="evaluationsTableBody">
                    <?php
                    if ($result->num_rows > 0) {
                        $ord = 0;
                        while($row = $result->fetch_assoc()) {
                            $ord++;
                            $codAvaliacao = htmlspecialchars($row['cod_avaliacao']);
                            $dataCriacao = date('d/m/Y', strtotime($row['data_criacao']));
                            $tipoAvaliacao = htmlspecialchars(ucfirst($row['tipo_avaliacao']));
                            $status = htmlspecialchars(ucfirst($row['status']));

                            // Definir classes de badge com base no tipo e status
                            if ($row['tipo_avaliacao'] === 'inicial') {
                                $tipoBadgeClass = 'badge-info';
                                $tipoBadgeText = 'Inicial';
                            } else {
                                $tipoBadgeClass = 'badge-warning';
                                $tipoBadgeText = 'Reavaliação';
                            }

                            if ($row['status'] === 'aberta') {
                                $statusBadgeClass = 'badge-secondary';
                                $statusBadgeText = 'Aberta';
                                $deleteBtnDisabled = '';
                            } else {
                                $statusBadgeClass = 'badge-success';
                                $statusBadgeText = 'Finalizada';
                                $deleteBtnDisabled = 'disabled';
                            }

                            echo "<tr>
        <td>{$ord}</td>
        <td>{$codAvaliacao}</td>
        <td>{$dataCriacao}</td>
        <td><span class=\"badge {$tipoBadgeClass}\">{$tipoBadgeText}</span></td>
        <td><span class=\"badge {$statusBadgeClass}\">{$statusBadgeText}</span></td>
        <td>
        <button class=\"action-btn\" onclick=\"copyInstructions()\">
                <i class=\"fas fa-copy\"></i> Url</button>
            <button class=\"action-btn\" onclick=\"window.location.href='painel-clinica-perfil-criança-portage-novo.php'\" id=\"status-btn-{$codAvaliacao}\">
                <i class=\"fas fas fa-list\"></i> Portage
            </button>
            <button class=\"action-btn\" onclick=\"window.location.href='painel-clinica-perfil-criança-portage.php'\" id=\"status-btn-{$codAvaliacao}\">
                <i class=\"fas fa-chart-line\"></i> Análise
            </button>
            <button class=\"action-btn\" onclick=\"window.location.href='6_plano_intervencao.php'\" id=\"status-btn-{$codAvaliacao}\">
                <i class=\"fas fa-clipboard-check\"></i> Plano
            </button>
            <button class=\"action-btn\" onclick=\"deleteEvaluation('{$codAvaliacao}')\" id=\"delete-btn-{$codAvaliacao}\" {$deleteBtnDisabled}>
                <i class=\"fas fa-trash-alt\"></i> Excluir
            </button>
        </td>
      </tr>";

                        }
                    } else {
                        echo "<tr><td colspan='6'>Nenhuma avaliação encontrada para esta linha do tempo.</td></tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>
        <p>(a análise só pode ser feita em avaliações finalizadas)</p>
    </div>

    <!-- Modal Nova Avaliação -->
    <div class="modal fade" id="createEvaluationModal" tabindex="-1" role="dialog" aria-labelledby="createEvaluationModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h2 class="modal-title" id="createEvaluationModalLabel">Nova Avaliação</h2>
                    <button
                        type="button"
                        class="close"
                        data-dismiss="modal"
                        aria-label="Fechar"
                        style="border:none;background:none;font-size:20px;"
                    >
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="evaluationForm" method="POST" action="painel-clinica-perfil-criança-linha-lista-portage.php">
                    <input type="hidden" name="action" value="create_evaluation">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="evaluationDate">Data da Avaliação</label>
                            <input
                                type="date"
                                id="evaluationDate"
                                name="evaluationDate"
                                class="form-control"
                                value="<?php echo date('Y-m-d'); ?>"
                                required
                            />
                        </div>
                        <!-- Removido o campo de seleção de tipo de avaliação -->
                        <p class="text-muted" style="font-size:12px;">
                            Ao criar uma nova avaliação, o status será definido automaticamente como "Aberta".
                            Somente você terá acesso a esta avaliação, outros profissionais não terão acesso.
                        </p>
                    </div>
                    <div class="modal-footer">
                        <button
                            type="button"
                            class="action-btn"
                            style="background-color:#e53e3e;"
                            data-dismiss="modal"
                        >
                            <i class="fas fa-times"></i> Cancelar
                        </button>
                        <button
                            type="submit"
                            class="action-btn"
                            style="background-color:#08C89E;"
                        >
                            <i class="fas fa-save"></i> Criar Avaliação
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Alterar Status -->
    <div class="modal fade" id="changeStatusModal" tabindex="-1" role="dialog" aria-labelledby="changeStatusModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h2 class="modal-title" id="changeStatusModalLabel">Alterar Status da Avaliação</h2>
                    <button
                        type="button"
                        class="close"
                        data-dismiss="modal"
                        aria-label="Fechar"
                        style="border:none;background:none;font-size:20px;"
                    >
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="changeStatusForm" method="POST" action="alterar_status.php">
                    <input type="hidden" id="currentEvalId" name="cod_avaliacao" />
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="newStatus">Novo Status</label>
                            <select id="newStatus" name="newStatus" class="form-control" required>
                                <option value="" disabled selected>Selecione o Novo Status</option>
                                <option value="finalizada">Finalizada</option>
                                <option value="aberta">Aberta</option>
                            </select>
                        </div>
                        <p class="text-muted" style="font-size:12px;">
                            Após finalizar a avaliação, ela não poderá ser editada até que o status seja alterado para "Aberta".
                        </p>
                    </div>
                    <div class="modal-footer">
                        <button
                            type="button"
                            class="action-btn"
                            style="background-color:#e53e3e;"
                            data-dismiss="modal"
                        >
                            <i class="fas fa-times"></i> Cancelar
                        </button>
                        <button
                            type="submit"
                            class="action-btn"
                            style="background-color:#08C89E;"
                        >
                            <i class="fas fa-save"></i> Alterar Status
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Container para Toasts -->
    <div class="toast-container" aria-live="polite" aria-atomic="true">
        <!-- Toasts serão inseridos via JavaScript -->
    </div>

    <!-- Scripts Bootstrap e jQuery -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Script para Gerenciar Avaliações -->
    <script>
        // Função para copiar as instruções
        function copyInstructions() {
            const timelineId = '<?php echo htmlspecialchars($current_cod_timeline); ?>';
            const chaveAcesso = '<?php echo htmlspecialchars($current_chave_acesso); ?>';
            const key = chaveAcesso;
            // Monte a mensagem de instruções
            const instructions = `Acesse o link abaixo em outro dispositivo para preencher o checklist:
https://ifcora.com/av/av3/portage/painel-clinica-perfil-crian%C3%A7a-portage-novo-avalia%C3%A7%C3%B5es.php?timelineId=${timelineId}&key=${key}

Chave de Acesso: ${key}

Após preencher, clique em “Finalizar” para que a avaliação fique disponível para análise.`;

            // Copia para a área de transferência
            navigator.clipboard.writeText(instructions)
                .then(() => {
                    showToast('Sucesso', 'Instruções copiadas para a área de transferência.');
                })
                .catch(err => {
                    console.error('Erro ao copiar instruções:', err);
                    showToast('Erro', 'Não foi possível copiar as instruções.');
                });
        }

        // Função para acessar o Painel de Análise do Portage
        function accessAnalysisPanel(evalId) {
            window.location.href = `analise-portage.php?evalId=${encodeURIComponent(evalId)}`;
        }

        // Função para mostrar toasts de notificações
        function showToast(title, message) {
            const toastId = 'toast' + Date.now();

            const toastHTML = `
                <div class="toast" id="${toastId}" role="alert" aria-live="assertive" aria-atomic="true" data-delay="3000">
                    <div class="toast-header">
                        <strong class="mr-auto text-success">${title}</strong>
                        <small>Agora</small>
                        <button type="button" class="ml-2 mb-1 close" data-dismiss="toast" aria-label="Fechar">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="toast-body">
                        ${message}
                    </div>
                </div>
            `;

            $('.toast-container').append(toastHTML);
            $(`#${toastId}`).toast('show');

            // Remove o toast do DOM após ocultar
            $(`#${toastId}`).on('hidden.bs.toast', function () {
                $(this).remove();
            });
        }

        // Função para alternar o status (mostrar modal)
        function toggleStatus(evalId) {
            const row = $(`#evaluationsTableBody tr:has(td:nth-child(2):contains("${evalId}"))`);
            const currentStatusBadge = row.find('td:nth-child(5) .badge');
            const currentStatus = currentStatusBadge.text().trim();

            $('#currentEvalId').val(evalId);
            const newStatusSelect = $('#newStatus');
            newStatusSelect.empty();

            if (currentStatus === 'Aberta') {
                newStatusSelect.append('<option value="" disabled selected>Selecione o Novo Status</option>');
                newStatusSelect.append('<option value="finalizada">Finalizada</option>');
            } else if (currentStatus === 'Finalizada') {
                newStatusSelect.append('<option value="" disabled selected>Selecione o Novo Status</option>');
                newStatusSelect.append('<option value="aberta">Aberta</option>');
            }

            $('#changeStatusModal').modal('show');
        }

        // Função para deletar avaliação
        function deleteEvaluation(evalId) {
            const row = $(`#evaluationsTableBody tr:has(td:nth-child(2):contains("${evalId}"))`);
            const status = row.find('td:nth-child(5) .badge').text().trim();

            if (status === 'Finalizada') {
                showToast('Erro', 'Avaliações finalizadas não podem ser excluídas.');
                return;
            }

            if (confirm(`Tem certeza que deseja excluir a avaliação ${evalId}?`)) {
                // Redireciona para o script de exclusão com o cod_avaliacao
                window.location.href = `painel-clinica-perfil-criança-linha-lista-portage_excluir_avaliacao.php?cod_avaliacao=${encodeURIComponent(evalId)}`;
            }
        }
    </script>
</body>
</html>

<?php
$conn->close();
?>
