<?php
// painel-clinica-perfil-criança-portage-card-avaliacoes.php

// Configurações do banco de dados
$servername = "localhost";
$username   = "wwifcora_teste";
$password   = "Lucas@31!";
$dbname     = "wwifcora_teste";

// Inicia a sessão
session_start();

// Tenta obter o timelineId da sessão ou via GET
$current_timeline_id = null;
if (isset($_SESSION['timelineId'])) {
    $current_timeline_id = $_SESSION['timelineId'];
} elseif (isset($_GET['timelineId'])) {
    $current_timeline_id = $_GET['timelineId'];
    $_SESSION['timelineId'] = $current_timeline_id;  // Armazena na sessão para futuros acessos
}

// Verifica se o timelineId está definido
if (!$current_timeline_id) {
    die("Linha do Tempo não especificada.");
}

// Conecta ao banco de dados
$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    die("Conexão falhou: " . $conn->connect_error);
}

// Consulta para verificar se há uma avaliação aberta na linha do tempo atual
$sql_check = "SELECT cod_avaliacao FROM portage_avaliacao WHERE cod_timeline = ? AND status = 'aberta' LIMIT 1";
$stmt_check = $conn->prepare($sql_check);
$stmt_check->bind_param("s", $current_timeline_id);
$stmt_check->execute();
$result_check = $stmt_check->get_result();

$has_open_evaluation = false;
$open_evaluation_id = "";

if ($result_check->num_rows > 0) {
    $row = $result_check->fetch_assoc();
    $has_open_evaluation = true;
    $open_evaluation_id = htmlspecialchars($row['cod_avaliacao']);
}

$stmt_check->close();
$conn->close();

// Dados da Criança
$child_cod = "ABS82394";
$child_birthdate = "20/05/2018";
$child_gender = "Maria Virginiea Silva";

// Dados do Profissional
$professional_name = "Coralina da Sila Matos";
$professional_specialty = "Terapeuta Ocupacional";
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8" />
  <title>Portage - Sistema Coralina Matos</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- FontAwesome para os ícones -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" />
  <style>
    /* Reset e estilos gerais */
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }
    body {
      font-family: 'Arial', sans-serif;
      background: linear-gradient(to bottom right, #08CA9D, #234EA1);
      color: #333;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
      overflow: hidden;
    }
    .container {
      width: 100%;
      max-width: 420px;
      background: #ffffff;
      border-radius: 10px;
      box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
      padding: 40px 30px;
      text-align: center;
      animation: fadeIn 1s ease-in-out;
    }

    @keyframes fadeIn {
      from {
        opacity: 0;
        transform: translateY(-10px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    /* Logo */
    .logo img {
      width: 60px;
      margin-bottom: 15px;
    }

    h1 {
      font-size: 1.6rem;
      font-weight: 600;
      color: #333;
      margin-bottom: 5px;
    }

    .subheading {
      font-size: 0.95rem;
      color: #666;
      margin-bottom: 25px;
    }

    /* Seções de Informações */
.info-sections {
  display: flex;
  flex-direction: column;
  align-items: flex-start;
  margin-bottom: 25px;
  text-align: left;
}

.info-section {
  margin-bottom: 15px;
}

.info-row {
  display: flex;
  align-items: center; /* Alinha o ícone e o conteúdo verticalmente */
  gap: 15px; /* Espaço entre o ícone e o conteúdo */
}

.info-icon {
  flex-shrink: 0; /* Impede que o ícone encolha */
  font-size: 1.8rem;
  color: #08CA9D;
}

.info-content {
  flex-grow: 1; /* Permite que o conteúdo ocupe o restante do espaço disponível */
}

.info-content h2 {
  font-size: 1.1rem;
  color: #555;
  margin-bottom: 8px;
}

.info-content p {
  font-size: 0.95rem;
  color: #444;
  line-height: 1.4;
}


    /* Cards */
    .cards {
      display: flex;
      flex-direction: column;
      gap: 15px;
      justify-content: center;
    }

    .card {
      background-color: #ffffff;
      border: 1px solid #e0e0e0;
      border-radius: 6px;
      padding: 15px 20px;
      text-align: center;
      transition: background-color 0.3s, box-shadow 0.3s;
      cursor: pointer;
      display: flex;
      align-items: center;
      gap: 15px;
    }

    .card:hover, .card:focus {
      background-color: #f0f8f7;
      box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
      border-color: #08CA9D;
    }

    .card:focus {
      outline: none;
      border-color: #08CA9D;
      box-shadow: 0 0 0 3px rgba(8, 202, 157, 0.3);
    }

    .card-icon {
      font-size: 1.5rem;
      color: #08CA9D;
      flex-shrink: 0;
    }

    .card-content {
      text-align: left;
      flex-grow: 1;
    }

    .card-title {
      font-size: 1rem;
      font-weight: 600;
      color: #333;
      margin-bottom: 5px;
    }

    .card-description {
      font-size: 0.85rem;
      color: #666;
    }

    /* Footer / Links */
    footer.footer {
      margin-top: 20px;
    }

    footer.footer p {
      font-size: 0.85rem;
      color: #666;
    }

    footer.footer a {
      color: #08CA9D;
      text-decoration: none;
      font-weight: 500;
      transition: color 0.3s;
    }

    footer.footer a:hover {
      color: #005f56;
      text-decoration: underline;
    }

    /* Responsividade */
    @media (max-width: 480px) {
      .container {
        padding: 20px 15px;
      }

      h1 {
        font-size: 1.4rem;
      }

      .subheading {
        font-size: 0.9rem;
      }

      .info-section h2 {
        font-size: 0.95rem;
      }

      .info-section p {
        font-size: 0.85rem;
      }

      .card {
        padding: 12px 15px;
        gap: 12px;
      }

      .card-icon {
        font-size: 1.3rem;
      }

      .card-title {
        font-size: 0.95rem;
      }

      .card-description {
        font-size: 0.8rem;
      }

      footer.footer p {
        font-size: 0.8rem;
      }
    }
    
    /* Seções de Informações */
    .info-sections {
      display: flex;
      flex-direction: column;
      gap: 20px;
      margin-bottom: 25px;
    }

    .info-card {
      background-color: #f9fafe;
      border-left: 4px solid #08CA9D;
      padding: 15px 20px;
      border-radius: 8px;
      text-align: left;
      transition: background-color 0.3s;
      width: 100%;
    }

    .info-card:hover {
      background-color: #eef5fb;
    }

    .info-card h3 {
      font-size: 1rem;
      color: #08CA9D;
      margin-bottom: 8px;
      display: flex;
      align-items: center;
    }

    .info-card h3 i {
      margin-right: 6px;
    }

    .info-card p {
      font-size: 0.95rem;
      color: #555;
      margin-bottom: 5px;
    }
  </style>
</head>
<body>
  <div class="container">
    <!-- Logo -->
    <div class="logo">
      <img src="https://ifcora.com/av/av3/includes/logo.webp" alt="Sistema Coralina Matos" />
    </div>

    <!-- Título e Subtítulo -->
    <h1><i class="fa-solid fa-list-check" style="margin-right: 8px; color: #08CA9D;"></i>PORTAGE</h1>
    <p class="subheading">Linha do Tempo: LTA000</p>

    

<!-- Seções de Informações -->
    <div class="info-sections">
      <!-- Informações da Criança -->
      <div class="info-card">
        <h3><i class="fas fa-child"></i> Helena Silva Simon</h3>
        <p><strong>Código:</strong> <?php echo htmlspecialchars($child_cod); ?></p>
        <p><strong>Profissional:</strong> <?php echo htmlspecialchars($professional_name); ?></p>
        <p><strong>Especialidade:</strong> <?php echo htmlspecialchars($professional_specialty); ?></p>
      </div>
    </div>


    <!-- Cards -->
    <div class="cards">
      <!-- Card Checklist -->
      
        
      
        <div class="card" role="button" tabindex="0" aria-label="Criar Nova Avaliação" onclick="goToChecklist()">
          <div class="card-icon"><i class="fas fa-clipboard-list"></i></div>
          <div class="card-content">
            <div class="card-title">Checklist</div>
            <div class="card-description">
              Realize o preenchimento do Inventário Portage referente ao paciente.
            </div>
          </div>
        </div>
      

      <!-- Card Plano de Intervenção -->
      <div class="card" role="button" tabindex="0" aria-label="Acessar Plano de Intervenção" onclick="goToPlanoIntervencao()">
        <div class="card-icon"><i class="fas fa-cogs"></i></div>
        <div class="card-content">
          <div class="card-title">Plano de Intervenção</div>
          <div class="card-description">
            Configure e gerencie os objetivos e ações terapêuticas sugeridas no Portage.
          </div>
        </div>
      </div>
    </div>

    <!-- Rodapé ou Footer -->
    <footer class="footer">
      <p>
        <a href="#">Sair</a>
      </p>
    </footer>
  </div>

  <script>
    /**
     * Função para redirecionar para o Checklist
     * Se um ID de avaliação for fornecido, redireciona para essa avaliação existente
     * Caso contrário, redireciona para criar uma nova avaliação
     * @param {string} [evaluationId] - Opcional. ID da avaliação existente
     */
    function goToChecklist(evaluationId) {
      if (evaluationId) {
        // Redirecionar para a avaliação existente
        window.location.href = `painel-clinica-perfil-criança-portage-novo.php`;
      } else {
        // Redirecionar para criar uma nova avaliação
        window.location.href = `painel-clinica-perfil-criança-portage-novo.php`;
      }
    }

    // Redireciona para a página do Plano de Intervenção
    function goToPlanoIntervencao() {
      window.location.href = "6_plano_intervencao.php";
    }
  </script>
</body>
</html>
