<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Processa Avaliação - Sistema Coralina Matos</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <style>
    /* Reset e estilos gerais */
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }
    body {
      font-family: 'Arial', sans-serif;
      background: linear-gradient(to bottom right, #08CA9D, #234EA1);
      color: #333;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
      overflow: hidden;
    }
    .container {
      width: 100%;
      max-width: 420px;
      background: #ffffff;
      border-radius: 10px;
      box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
      padding: 40px 30px;
      text-align: center;
      animation: fadeIn 1s ease-in-out;
    }
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(-20px); }
      to { opacity: 1; transform: translateY(0); }
    }
    .logo img { width: 80px; margin-bottom: 20px; }
    h1 { font-size: 1.8rem; font-weight: bold; color: #234EA1; margin-bottom: 10px; }
    p.subheading { font-size: 1rem; color: #555; margin-bottom: 30px; }
    .form-group { margin-bottom: 15px; text-align: left; }
    .form-group label { font-size: 0.9rem; color: #555; display: block; margin-bottom: 5px; }
    .form-group input {
      width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 5px;
      font-size: 1rem; background: #f9f9f9; transition: all 0.3s ease;
    }
    .form-group input:focus {
      border-color: #08CA9D; background: #fff; outline: none;
      box-shadow: 0 0 5px rgba(8, 202, 157, 0.5);
    }
    .btn-primary {
      width: 100%; padding: 12px;
      background: linear-gradient(to right, #08CA9D, #234EA1);
      border: none; color: white; font-size: 1rem; font-weight: bold;
      border-radius: 5px; cursor: pointer; transition: all 0.3s ease;
    }
    .btn-primary:hover {
      background: linear-gradient(to right, #06b487, #1e3f8c);
      box-shadow: 0 4px 10px rgba(0, 0, 0, 0.15);
    }
    .link { display: block; margin-top: 15px; font-size: 0.9rem; color: #08CA9D; text-decoration: none; transition: color 0.3s ease; }
    .link:hover { color: #234EA1; text-decoration: underline; }
    .footer { margin-top: 25px; }
    .footer p { font-size: 0.9rem; color: #555; margin-bottom: 10px; }
    .btn-secondary {
      padding: 10px 20px; border: 2px solid #08CA9D; color: #08CA9D;
      font-size: 0.9rem; border-radius: 5px; text-decoration: none; cursor: pointer;
      transition: all 0.3s ease;
    }
    .btn-secondary:hover { background: #08CA9D; color: white; box-shadow: 0 0 10px rgba(8, 202, 157, 0.5); }
    .error-message { color: #E53E3E; font-size: 0.9rem; margin-top: 10px; }
    @media(max-width: 768px) {
      .container { padding: 30px 20px; margin: 10px; }
      h1 { font-size: 1.6rem; }
      .form-group input { padding: 10px; }
      .btn-primary { padding: 10px; font-size: 0.9rem; }
      .link { font-size: 0.8rem; }
      .btn-secondary { padding: 8px 16px; font-size: 0.8rem; }
    }
  </style>
</head>
<body>
  <div class="container">
    <!-- Logo -->
    <div class="logo">
      <img src="../includes/logo.webp" alt="Sistema Coralina Matos">
    </div>

    <!-- Heading -->
    <h1 style="color: #F7702D"><i class="fa-solid fa-list-check" style="margin-right: 8px"></i>PORTAGE</h1>
    <p class="subheading"></p>

    <!-- Formulário de Validação -->
    <form id="processEvaluationForm">
      <div class="form-group">
        <label for="timelineId">ID da Linha do Tempo</label>
        <input type="text" id="timelineId" placeholder="Ex: LTA000" required>
      </div>
      <div class="form-group">
        <label for="key">Chave de acesso:</label>
        <input type="text" id="key" placeholder="Digite a chave" required>
      </div>
      
      <!-- CAPTCHA Matemático -->
        <div class="form-group">
          <label for="captcha">Quanto é 3 + 5?</label>
          <input type="text" id="captcha" name="captcha" placeholder="Digite a resposta" value="8" required>
        </div>
      
      <button type="submit" class="btn-primary">Acessar Avaliação</button>
      <div id="errorMessage" class="error-message"></div>
    </form>
  </div>
  

  <script>
    // Simulação de Dados de Linhas do Tempo e suas chaves de acesso
    const timelines = {
      'LTA000': 'ABC12345',
      'LTA001': 'DEF67890',
      'LTA002': 'GHI11223'
    };

    /**
     * Função para obter parâmetros da URL
     * @returns {URLSearchParams} Objeto URLSearchParams com os parâmetros da URL
     */
    function getURLParameters() {
      return new URLSearchParams(window.location.search);
    }

    /**
     * Função para validar as credenciais e redirecionar o usuário
     * @param {string} timelineId - ID da Linha do Tempo
     * @param {string} key - Chave de acesso
     */
    function validateAndRedirect(timelineId, key) {
      const errorMessage = document.getElementById('errorMessage');

      // Limpar mensagem de erro anterior
      errorMessage.textContent = '';

      // Verificar se o timelineId existe
      if(timelines.hasOwnProperty(timelineId)) {
        // Verificar se a chave está correta
        if(timelines[timelineId] === key) {
          // Construir a URL de redirecionamento com o parâmetro timelineId
          const redirectURL = 'https://ifcora.com/av/av3/portage/painel-clinica-perfil-crian%C3%A7a-portage-card-avalia%C3%A7%C3%B5es.php?timelineId=' + encodeURIComponent(timelineId);
          // Redirecionar para a página
          window.location.href = redirectURL;
        } else {
          // Chave incorreta
          errorMessage.textContent = 'Chave incorreta. Por favor, verifique os dados e tente novamente.';
        }
      } else {
        // timelineId não encontrado
        errorMessage.textContent = 'ID da Linha do Tempo não encontrado. Por favor, verifique os dados e tente novamente.';
      }
    }


    /**
     * Função para preencher automaticamente os campos se os parâmetros estiverem presentes na URL
     * E redirecionar automaticamente se os parâmetros timelineId e key estiverem presentes e corretos
     * Alteração: Removido o redirecionamento automático
     */
    function prefillFields() {
      const urlParams = getURLParameters();
      const timelineIdFromURL = urlParams.get('timelineId');
      const keyFromURL = urlParams.get('key');
      
      if (timelineIdFromURL) {
        document.getElementById('timelineId').value = timelineIdFromURL;

        // Se a chave também estiver presente, preenche
        if (keyFromURL) {
          document.getElementById('key').value = keyFromURL;
          // Opcional: Focar no campo CAPTCHA para melhorar a usabilidade
          document.getElementById('captcha').focus();
        } else {
          // Opcional: Focar no campo "Chave" para melhorar a usabilidade
          document.getElementById('key').focus();
        }
      }
    }

    /**
     * Função para validar e processar a avaliação ao submeter o formulário
     * @param {Event} e - Evento de submissão do formulário
     */
    function processEvaluation(e) {
      e.preventDefault();

      const timelineId = document.getElementById('timelineId').value.trim();
      const key = document.getElementById('key').value.trim();
      const captcha = document.getElementById('captcha').value.trim();
      const errorMessage = document.getElementById('errorMessage');

      // Limpar mensagem de erro anterior
      errorMessage.textContent = '';

      // Validar o CAPTCHA
      if (captcha !== '8') {
        errorMessage.textContent = 'Resposta do CAPTCHA incorreta.';
        return;
      }

      // Validar e redirecionar
      validateAndRedirect(timelineId, key);
    }

    // Inicializar a página
    document.addEventListener('DOMContentLoaded', () => {
      prefillFields();
      document.getElementById('processEvaluationForm').addEventListener('submit', processEvaluation);
    });
  </script>
</body>
</html>
