<?php
// Iniciar a sessão se necessário (opcional, dependendo do seu fluxo)
session_start();

// Validação do Honeypot (campo invisível)
if (!empty($_POST['honeypot'])) {
    die("Acesso negado: bot detectado.");
}

// Validação do CAPTCHA Matemático
if (!isset($_POST['captcha']) || $_POST['captcha'] != '8') {
    die("Resposta errada para o CAPTCHA.");
}

// Validação de Tempo
$min_time = 3; // Tempo mínimo em segundos
if (!isset($_POST['form_start_time'])) {
    die("Erro: Tempo de formulário não definido.");
}

$time_diff = time() - intval($_POST['form_start_time']);

if ($time_diff < $min_time) {
    die("Formulário enviado rápido demais. CAPTCHA falhou.");
}

// Validação do Campo de Verificação
if (empty($_POST['captcha_verified']) || $_POST['captcha_verified'] != 'true') {
    die("Verificação CAPTCHA falhou.");
}

// Verificar se os campos 'email' e 'password' estão presentes
if (empty($_POST['email']) || empty($_POST['password'])) {
    die("Todos os campos são obrigatórios.");
}

// Obter e sanitizar os dados de entrada
$email = filter_var(trim($_POST['email']), FILTER_VALIDATE_EMAIL);
$password = trim($_POST['password']);

// Verificar se o e-mail é válido após a sanitização
if (!$email) {
    die("E-mail inválido.");
}

// **Redirecionamento Baseado no E-mail**
if ($email === 'user@mail.com') {
    header("Location: painel-p-clinicas.php");
    exit();
} elseif ($email === 'admin@mail.com') {
    header("Location: painel-superadmin-dashboard.php");
    exit();
} elseif ($email === 'responsavel@mail.com') {
    header("Location: painel-responsavel-listar-criancas.php");
    exit();
} elseif ($email === 'assistente@mail.com') {
    header("Location: painel-assistente-crianças.php");
    exit();
} else {
    die("Acesso negado: e-mail não reconhecido.");
}


// **Observação Importante:**
// As funções header() devem ser chamadas antes de qualquer saída ser enviada ao navegador.
// Certifique-se de que não haja espaços em branco ou quebras de linha antes da tag <?php
?>
