<?php
// processa_verifica_codigo.php

session_start(); // Inicia a sessão

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Filtrar e validar dados de entrada
    $email = filter_input(INPUT_POST, 'email', FILTER_VALIDATE_EMAIL);
    $codigo = trim($_POST['codigo']);
    $form_start_time = isset($_POST['form_start_time']) ? intval($_POST['form_start_time']) : 0;
    $current_time = time();

    // Verificar se o formulário foi preenchido muito rapidamente (menos de 5 segundos)
    if (($current_time - $form_start_time) < 3) {
        die('Formulário preenchido muito rapidamente. Por favor, tente novamente.');
    }

    // Verificar honeypot
    if (!empty($_POST['honeypot'])) {
        die('Bot detectado.');
    }

    if (!$email || empty($codigo)) {
        die('Todos os campos são obrigatórios.');
    }

    // Verificar se os dados correspondem à sessão
    if (isset($_SESSION['recupera_senha'])) {
        $recupera = $_SESSION['recupera_senha'];
        if ($recupera['email'] === $email && $recupera['codigo'] === $codigo && $recupera['expira'] >= $current_time) {
            // Código válido, redirecionar para a página de nova senha com parâmetros na URL
            header("Location: nova_senha.php?email=" . urlencode($email) . "&codigo=" . urlencode($codigo));
            exit();
        } else {
            die('Código inválido ou expirado.');
        }
    } else {
        die('Sessão inválida ou expirada. Por favor, inicie o processo novamente.');
    }
} else {
    header('Location: verifica_codigo.php');
    exit();
}
?>
