<?php
// --------------------------------------
// 1. Configurações de conexão
// --------------------------------------
$servername = "localhost"; // Altere se o servidor não for local
$username   = "wwifcora_teste";
$password   = "Lucas@31!";
$dbname     = "wwifcora_teste";

// --------------------------------------
// 2. Criar conexão
// --------------------------------------
$conn = new mysqli($servername, $username, $password, $dbname);

// --------------------------------------
// 3. Verificar conexão
// --------------------------------------
if ($conn->connect_error) {
    die("Falha na conexão: " . $conn->connect_error);
}

// --------------------------------------
// 4. Consultar dados da tabela avl_rsp
// --------------------------------------
$sql = "SELECT qst, rsp FROM avl_rsp WHERE avl = 'AVA001'";
$result = $conn->query($sql);

// --------------------------------------
// 5. Array para mapear qst para rsp
// --------------------------------------
$qst_rsp_map = array();

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        // Remover o 'S' de qst, caso exista, e converter para inteiro
        $qst_num = intval(str_replace('S', '', $row["qst"]));
        $qst_rsp_map[$qst_num] = intval($row["rsp"]);
    }
}

// Fecha a conexão
$conn->close();

// --------------------------------------
// 6. Função para determinar a cor de fundo com base no rsp
// --------------------------------------
function getBackgroundColor($rsp) {
    if ($rsp === 3) {
        return "background-color: #08CA9D; color: #fff";
    } elseif ($rsp === 2) {
        return "background-color: #F7702E; color: #fff";
    } elseif ($rsp === 1 || $rsp === 0) {
        return "background-color: #DCDCDC;";
    } else {
        return ""; // Transparente
    }
}

// --------------------------------------
// 7. Função para calcular pontos com base no rsp
// --------------------------------------
function calculatePoints($rsp) {
    if ($rsp === 3) {
        return 1.0;
    } elseif ($rsp === 2) {
        return 0.5;
    } else {
        // rsp = 1 ou 0 ou nulo => 0 ponto
        return 0.0;
    }
}

// --------------------------------------
// 8. Função para detectar inconsistências dentro de uma classe
// --------------------------------------
function detectarInconsistenciaManual($qsts, $qst_rsp_map) {
    $inconsistencias = [];

    // Ordenar as questões do menor para o maior
    sort($qsts);

    // Percorrer todas as combinações de perguntas para detectar inconsistências
    for ($i = 0; $i < count($qsts); $i++) {
        for ($j = $i + 1; $j < count($qsts); $j++) {
            $qstMenor = $qsts[$i];
            $qstMaior = $qsts[$j];

            // Obter as respostas
            $rspMenor = isset($qst_rsp_map[$qstMenor]) ? $qst_rsp_map[$qstMenor] : null;
            $rspMaior = isset($qst_rsp_map[$qstMaior]) ? $qst_rsp_map[$qstMaior] : null;

            // Verificar a inconsistência conforme a definição
            if ($rspMaior === 3 && $rspMenor !== 3) {
                $inconsistencias[] = "Qst {$qstMaior}=3, mas Qst {$qstMenor} não está adquirida (rsp=" . ($rspMenor ?? 'null') . ")";
            }
        }
    }

    return $inconsistencias;
}

// --------------------------------------
// 9. Dados das linhas (classes) da tabela
// --------------------------------------
$linhasData = [
    1 => ['titulo' => 'Discriminação visual',        'qsts' => [1, 4]],
    2 => ['titulo' => 'Sorrir',                      'qsts' => [2, 6, 7]],
    3 => ['titulo' => 'Vocalização',                 'qsts' => [3, 7, 17]],
    4 => ['titulo' => 'Reatividade ao contato humano','qsts' => [5]],
    5 => ['titulo' => 'Acariciar/abraçar',           'qsts' => [8, 23, 35]],
    6 => ['titulo' => 'Estender mãos/braços...',      'qsts' => [9, 10, 11]],
    7 => ['titulo' => 'Manipular objetos',           'qsts' => [12, 13, 25, 26, 34]],
    8 => ['titulo' => 'Brincar',                     'qsts' => [14, 16, 30, 31, 41, 49, 63, 66, 70, 74]],
    9 => ['titulo' => 'Contato Visual',              'qsts' => [15]],
    10 => ['titulo' => 'Imitação Motora',            'qsts' => [18, 19, 20, 21, 28, 29, 36, 76]],
    11 => ['titulo' => 'Dar/ Compartilhar objetos',   'qsts' => [22, 27, 37, 42]],
    12 => ['titulo' => 'Discriminação Auditiva',      'qsts' => [24]],
    13 => ['titulo' => 'Independência dos pais',      'qsts' => [32]],
    14 => ['titulo' => 'Exploração do ambiente',      'qsts' => [33]],
    15 => ['titulo' => 'Puxar pessoas p/ mostrar',    'qsts' => [38]],
    16 => ['titulo' => 'Cumprimentar',               'qsts' => [43, 54]],
    17 => ['titulo' => 'Seguir ordens/instruções',    'qsts' => [39, 44, 45, 61]],
    18 => ['titulo' => 'Esperar a vez',              'qsts' => [40, 59, 69]],
    19 => ['titulo' => 'Prestar atenção',            'qsts' => [46]],
    20 => ['titulo' => 'Agradecer',                  'qsts' => [47, 57]],
    21 => ['titulo' => 'Ajudar',                     'qsts' => [48]],
    22 => ['titulo' => 'Escolher',                   'qsts' => [50, 80]],
    23 => ['titulo' => 'Expressão de sentimentos',    'qsts' => [51, 73, 79]],
    24 => ['titulo' => 'Cantar/dançar',              'qsts' => [52, 66]],
    25 => ['titulo' => 'Seguir regras de jogo',      'qsts' => [53, 55, 60, 78]],
    26 => ['titulo' => 'Pedir permissão',            'qsts' => [56, 72]],
    27 => ['titulo' => 'Falar ao telefone',          'qsts' => [58]],
    28 => ['titulo' => 'Permanecer em sua área',     'qsts' => [62]],
    29 => ['titulo' => 'Pedir ajuda',                'qsts' => [64]],
    30 => ['titulo' => 'Verbalizar para adultos',    'qsts' => [65, 77]],
    31 => ['titulo' => 'Fazer tarefa sozinho',       'qsts' => [67]],
    32 => ['titulo' => 'Pedir desculpas',            'qsts' => [68]],
    33 => ['titulo' => 'Comp. aceitáveis em público','qsts' => [71]],
    34 => ['titulo' => 'Explicar regras',            'qsts' => [75]],
    35 => ['titulo' => 'Usar ferramentas',           'qsts' => [81]],
    36 => ['titulo' => 'Estabelecer metas p/ si',     'qsts' => [82]],
    37 => ['titulo' => 'Dramatizar',                 'qsts' => [83]],
];

// --------------------------------------
// 10. Construção da Tabela HTML
// --------------------------------------
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Análise de Habilidades - AVA001</title>
    <style>
        .tabela-planilha {
            width: 100%;
            border-collapse: collapse;
        }
        .tabela-planilha th, .tabela-planilha td {
            border: 1px solid #000;
            padding: 8px;
            text-align: center;
        }
        .titulo-cabecalho {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        .titulo-centralizado {
            text-align: center;
            background-color: #d9d9d9;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <table class="tabela-planilha">
        <thead>
            <tr>
                <th rowspan="2" class="titulo-cabecalho">Classe de Respostas</th>
                <th colspan="17" class="titulo-centralizado">Faixa Etária</th>
            </tr>
            <tr>
                <th colspan="5" class="titulo-cabecalho">0-1</th>
                <th colspan="3" class="titulo-cabecalho">1-2</th>
                <th colspan="2" class="titulo-cabecalho">2-3</th>
                <th colspan="3" class="titulo-cabecalho">3-4</th>
                <th colspan="1" class="titulo-cabecalho">4-5</th>
                <th colspan="2" class="titulo-cabecalho">5-6</th>
                <th class="titulo-cabecalho">Total</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($linhasData as $idx => $info): ?>
                <tr>
                    <td style="text-align: left"><?php echo $idx . ". " . $info['titulo']; ?></td>
                    
                    <?php
                    // Obter as colunas correspondentes às perguntas da linha
                    $qsts = $info['qsts'];
                    $totalQst = count($qsts);
                    $sumPoints = 0.0;

                    // Inicializar um array para armazenar quais colunas devem ser preenchidas
                    // Assumindo que cada coluna representa uma pergunta específica; ajustar conforme necessário
                    $colunasPreenchidas = [];

                    foreach ($qsts as $qstNum) {
                        $sumPoints += calculatePoints(isset($qst_rsp_map[$qstNum]) ? $qst_rsp_map[$qstNum] : null);
                        // Aqui, você deve mapear cada qstNum para a coluna correta na tabela
                        // Por simplicidade, vamos assumir que as colunas são sequenciais e que cada qst ocupa uma coluna
                        // Isso pode precisar ser ajustado conforme a estrutura real da tabela
                        // Para este exemplo, preenchemos as colunas na ordem em que aparecem
                        $colunasPreenchidas[] = $qstNum;
                    }

                    // Preencher as células da tabela
                    $colIndex = 0;
                    for ($i = 1; $i <= 17; $i++) { // Supondo que há 17 colunas após a primeira
                        if (isset($colunasPreenchidas[$colIndex]) && $i <= count($colunasPreenchidas)) {
                            $qst = $colunasPreenchidas[$colIndex];
                            echo "<td " . (isset($qst_rsp_map[$qst]) ? "style='" . getBackgroundColor($qst_rsp_map[$qst]) . "'" : "") . ">";
                            echo isset($qst_rsp_map[$qst]) ? $qst : "";
                            echo "</td>";
                            $colIndex++;
                        } else {
                            echo "<td colspan='1'></td>";
                        }
                    }
                    ?>

                    <?php
                    // Calcular a porcentagem
                    $percentage = ($sumPoints / $totalQst) * 100;
                    $percentageFormatted = round($percentage) . "%";

                    // Exibir a última célula com o total e a porcentagem
                    echo "<td>" . $totalQst . " (" . $percentageFormatted . ")</td>";
                    ?>
                </tr>
            <?php endforeach; ?>

            <!-- Totais das classes "Novas" e "Antigas" -->
            <tr>
                <th class="titulo-cabecalho">Total de classes: "Novas"</th>
                <th colspan="5" class="titulo-cabecalho">12</th>
                <th colspan="3" class="titulo-cabecalho">6</th>
                <th colspan="2" class="titulo-cabecalho">5</th>
                <th colspan="3" class="titulo-cabecalho">5</th>
                <th class="titulo-cabecalho">5</th>
                <th colspan="2" class="titulo-cabecalho">4</th>
                <th class="titulo-cabecalho">TI: 84*</th>
            </tr>
            <tr>
                <th class="titulo-cabecalho">Total de classes: "Antigas"</th>
                <th colspan="5" class="titulo-cabecalho"></th>
                <th colspan="3" class="titulo-cabecalho">5</th>
                <th colspan="2" class="titulo-cabecalho">2</th>
                <th colspan="3" class="titulo-cabecalho">5</th>
                <th class="titulo-cabecalho">3</th>
                <th colspan="2" class="titulo-cabecalho">6</th>
                <th class="titulo-cabecalho">TC: 37</th>
            </tr>
        </tbody>
    </table>

    <!-- --------------------------------------
         11. Seção de Inconsistências (Abordagem Manual)
         -------------------------------------- -->
    <div style="margin-top: 20px;">
        <h2>Inconsistências Encontradas</h2>
        <?php
        $inconsistenciasEncontradas = false; // Flag para verificar se há inconsistências

        foreach ($linhasData as $idx => $info) {
            $titulo = $info['titulo'];
            $qsts   = $info['qsts'];

            // Detectar inconsistências para a linha atual
            $inconsistencias = detectarInconsistenciaManual($qsts, $qst_rsp_map);

            if (count($inconsistencias) > 0) {
                $inconsistenciasEncontradas = true;
                echo "<div style='margin-bottom: 15px;'>";
                echo "<h3 style='color: red;'>Linha {$idx} ({$titulo})</h3>";
                echo "<ul>";
                foreach ($inconsistencias as $msg) {
                    echo "<li style='color: #E53E3E;'>{$msg}</li>";
                }
                echo "</ul>";
                echo "</div>";
            }
        }

        if (!$inconsistenciasEncontradas) {
            echo "<p style='color: #38A169;'>Nenhuma inconsistência encontrada.</p>";
        }
        ?>
    </div>
</body>
</html>
