<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Cadastro - Sistema de Avaliação IFCora</title>
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Nunito', sans-serif;
            background-color: #f0f2f5;
            color: #333;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            padding: 20px;
        }

        .container-cadastro {
            background: #fff;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            max-width: 900px;
            width: 100%;
            display: flex;
            flex-direction: row;
            overflow: hidden;
        }

        .left-panel {
            background: linear-gradient(to bottom right, #08CA9D, #234EA1);
            color: #fff;
            padding: 50px;
            width: 50%;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .left-panel h1 {
            font-size: 2.5rem;
            margin-bottom: 20px;
        }

        .left-panel p {
            font-size: 1.2rem;
            line-height: 1.5;
        }

        .right-panel {
            padding: 50px;
            width: 50%;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .logo img {
            width: 80px;
            margin-bottom: 30px;
        }

        .form-group {
            margin-bottom: 20px;
            position: relative;
        }

        .form-group label {
            position: absolute;
            top: -10px;
            left: 15px;
            background: #fff;
            padding: 0 5px;
            font-size: 0.9rem;
            color: #888;
        }

        .form-group input,
        .form-group select {
            width: 100%;
            padding: 15px;
            border: 2px solid #ddd;
            border-radius: 10px;
            font-size: 1rem;
            transition: border-color 0.3s;
        }

        .form-group input:focus,
        .form-group select:focus {
            border-color: #08CA9D;
            outline: none;
        }

        .btn-primary {
            width: 100%;
            padding: 15px;
            background: #08CA9D;
            border: none;
            color: white;
            font-size: 1rem;
            font-weight: bold;
            border-radius: 10px;
            cursor: pointer;
            transition: background 0.3s;
            margin-top: 10px;
            text-align: center;
        }

        .btn-primary:hover {
            background: #06b487;
        }

        .link {
            display: block;
            margin-top: 20px;
            font-size: 0.9rem;
            color: #08CA9D;
            text-decoration: none;
            text-align: center;
        }

        .link:hover {
            text-decoration: underline;
        }

        .footer {
            margin-top: 30px;
            text-align: center;
        }

        .footer p {
            font-size: 0.9rem;
            color: #555;
            margin-bottom: 15px;
        }

        .btn-secondary {
            padding: 12px 25px;
            border: 2px solid #08CA9D;
            color: #08CA9D;
            font-size: 0.9rem;
            border-radius: 10px;
            text-decoration: none;
            cursor: pointer;
            transition: background 0.3s, color 0.3s;
            text-align: center;
            display: inline-block;
        }

        .btn-secondary:hover {
            background: #08CA9D;
            color: white;
        }

        .profile-type-group {
            margin-bottom: 20px;
        }

        .hidden {
            display: none;
        }

        /* Responsividade */
        @media (max-width: 768px) {
            .container-cadastro {
                flex-direction: column;
            }

            .left-panel, .right-panel {
                width: 100%;
            }

            .left-panel {
                padding: 30px;
                text-align: center;
            }

            .left-panel h1 {
                font-size: 2rem;
            }

            .left-panel p {
                font-size: 1rem;
            }

            .right-panel {
                padding: 30px;
            }

            .logo img {
                width: 100px;
            }
        }

    </style>
</head>
<body>
    <div class="container-cadastro">
        <!-- Lado Esquerdo -->
        <div class="left-panel">
            <h1>Criar Conta</h1>
            <p>Cadastre-se e aproveite as funcionalidades do Sistema de Avaliação IFCora.</p>
        </div>

        <!-- Lado Direito -->
        <div class="right-panel">
            <div class="logo">
                <img src="includes/logo.webp" alt="Sistema Coralina Matos">
            </div>

            <!-- Formulário de Cadastro -->
            <form id="registerForm" action="processa_cadastro.php" method="POST">
                <div class="form-group profile-type-group">
                    <label for="profileType">Selecione o Tipo de Perfil</label>
                    <select id="profileType" name="profileType" required>
                        <option value="">-- Selecione --</option>
                        <option value="profissional">Profissional/Empresa</option>
                        <option value="responsavel">Responsável (Pais)</option>
                        <option value="assistente">Assistente</option>
                    </select>
                </div>

                <!-- Campos Comuns: Nome, Email, Senha -->
                <div class="form-group">
                    <label for="fullName">Nome Completo</label>
                    <input type="text" id="fullName" name="fullName" placeholder="Digite seu nome completo" required>
                </div>
                <div class="form-group">
                    <label for="email">E-mail</label>
                    <input type="email" id="email" name="email" placeholder="Digite seu e-mail" required>
                </div>
                <div class="form-group">
                    <label for="password">Senha</label>
                    <input type="password" id="password" name="password" placeholder="Digite sua senha" required>
                </div>

                <!-- Campos Específicos -->
                <div id="profissionalFields" class="hidden">
                    <div class="form-group">
                        <label for="profession">Profissão (Opcional)</label>
                        <input type="text" id="profession" name="profession" placeholder="Ex: Terapeuta Ocupacional, Fonoaudiólogo...">
                    </div>
                    <div class="form-group">
                        <label for="professionalRegister">Registro Profissional (Opcional)</label>
                        <input type="text" id="professionalRegister" name="professionalRegister" placeholder="Ex: CREFITO: 12.132-TO">
                    </div>
                </div>

                <div id="responsavelFields" class="hidden">
                    <p>Cadastre-se como responsável para acompanhar relatórios e orientações sobre a criança.</p>
                </div>

                <div id="assistenteFields" class="hidden">
                    <p>Como assistente, você poderá auxiliar em tarefas atribuídas por profissionais.</p>
                </div>

                <!-- Proteções Contra Bots -->
                <div class="form-group">
                    <label for="captcha">Quanto é 6 + 4?</label>
                    <input type="text" id="captcha" name="captcha" placeholder="Digite a resposta" required>
                </div>

                <div style="display: none;">
                    <label for="honeypot">Não preencha este campo</label>
                    <input type="text" id="honeypot" name="honeypot">
                </div>

                <input type="hidden" name="form_start_time" value="<?php echo time(); ?>">
                <input type="hidden" name="captcha_verified" id="captcha_verified" value="">

                <button type="submit" class="btn-primary">Cadastrar</button>
            </form>

            <!-- Links -->
            <a href="login.php" class="link">Já possui uma conta? Entre aqui</a>
        </div>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            document.getElementById('captcha_verified').value = 'true';
        });

        const profileTypeSelect = document.getElementById('profileType');
        profileTypeSelect.addEventListener('change', () => {
            const value = profileTypeSelect.value;

            document.getElementById('profissionalFields').classList.add('hidden');
            document.getElementById('responsavelFields').classList.add('hidden');
            document.getElementById('assistenteFields').classList.add('hidden');

            if (value === 'profissional') {
                document.getElementById('profissionalFields').classList.remove('hidden');
            } else if (value === 'responsavel') {
                document.getElementById('responsavelFields').classList.remove('hidden');
            } else if (value === 'assistente') {
                document.getElementById('assistenteFields').classList.remove('hidden');
            }
        });
    </script>
</body>
</html>
