<?php
   // 1. Configurações de conexão
   $servername = "localhost"; // Altere se o servidor não for local
   $username = "wwifcora_teste";
   $password = "Lucas@31!";
   $dbname = "wwifcora_teste";
   
   // 2. Criar conexão
   $conn = new mysqli($servername, $username, $password, $dbname);
   
   // 3. Verificar conexão
   if ($conn->connect_error) {
       die("Falha na conexão: " . $conn->connect_error);
   }
   
   // 4. Consultar dados da tabela avl_rsp
   $sql = "SELECT qst, rsp FROM avl_rsp WHERE avl = 'AVA001'";
   $result = $conn->query($sql);
   
   // 5. Array para mapear qst para rsp
   $qst_rsp_map = array();
   
   if ($result->num_rows > 0) {
       while($row = $result->fetch_assoc()) {
           // Remover o 'S' de qst se estiver presente e converter para inteiro
           $qst_num = intval(str_replace('S', '', $row["qst"]));
           $qst_rsp_map[$qst_num] = intval($row["rsp"]);
       }
   } 
   
   $conn->close();
   
   // 6. Função para determinar a cor de fundo com base no rsp
   function getBackgroundColor($rsp) {
       if ($rsp === 3) {
           return "background-color: #08CA9D; color: #fff";
       } elseif ($rsp === 2) {
           return "background-color: #F7702E; color: #fff";
       } elseif ($rsp === 1 || $rsp === 0) {
           return "background-color: #DCDCDC;";
       } else {
           return ""; // Transparente
       }
   }
   
   // Função para calcular pontos com base no rsp
   function calculatePoints($rsp) {
       if ($rsp === 3) {
           return 1.0;
       } elseif ($rsp === 2) {
           return 0.5;
       } else {
           // rsp = 1 ou 0 ou nulo => 0 ponto
           return 0.0;
       }
   }
   
   
   // 8. Funções de verificação de inconsistência
   /**
    * Verifica se, dentro de uma lista de questões ($qsts), 
    * existe a situação de “qst maior tem valor 3 enquanto qst menor 
    * não tem valor 3”.
    *
    * Retorna true se houver qualquer inconsistência, false caso contrário.
    */
   function existeInconsistencia(array $qsts, array $qst_rsp_map): bool {
       // Ordena as questões do menor para o maior
       sort($qsts);
   
       for ($i = 0; $i < count($qsts); $i++) {
           for ($j = $i + 1; $j < count($qsts); $j++) {
               $qstMenor = $qsts[$i];
               $qstMaior = $qsts[$j];
   
               // Respostas
               $rspMenor = $qst_rsp_map[$qstMenor] ?? null;
               $rspMaior = $qst_rsp_map[$qstMaior] ?? null;
   
               // Se a questão maior (qstMaior) tiver rsp=3 e a questão menor não for 3 => inconsistente
               if ($rspMaior === 3 && $rspMenor !== 3) {
                   return true;  // Achou inconsistência, pode retornar imediatamente
               }
           }
       }
       return false; // Se chegou até aqui, não achou inconsistência
   }
   
   
?>
<!-- Área Social -->
<div id="social" class="tab-pane fade show active" role="tabpanel" aria-labelledby="social-tab">
   <h4>Habilidades de Socialização</h4>
   <!-- Sub-abas de faixas etárias para Socialização -->
   <ul class="nav nav-tabs mt-3" role="tablist">
      <li class="nav-item">
         <a class="nav-link active" id="social0_1-tab" href="#social0_1" data-toggle="tab" role="tab" aria-controls="social0_1" aria-selected="true">0-1 ano</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="social1_2-tab" href="#social1_2" data-toggle="tab" role="tab" aria-controls="social1_2" aria-selected="false">1-2 anos</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="social2_3-tab" href="#social2_3" data-toggle="tab" role="tab" aria-controls="social2_3" aria-selected="false">2-3 anos</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="social3_4-tab" href="#social3_4" data-toggle="tab" role="tab" aria-controls="social3_4" aria-selected="false">3-4 anos</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="social4_5-tab" href="#social4_5" data-toggle="tab" role="tab" aria-controls="social4_5" aria-selected="false">4-5 anos</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="social5_6-tab" href="#social5_6" data-toggle="tab" role="tab" aria-controls="social5_6" aria-selected="false">5-6 anos</a>
         </li>
      <li class="nav-item">
         <a class="nav-link" id="social_classes-tab" href="#social_classes" data-toggle="tab" role="tab" aria-controls="social_classes" aria-selected="false">Classes</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="social_relatorio-tab" href="#social_relatorio" data-toggle="tab" role="tab" aria-controls="social_relatorio" aria-selected="false">Relatório</a>
      </li>
   </ul>
   <div class="tab-content nested-tab-content">
      <!-- Faixa 0-1 ano - Socialização -->
      <div id="social0_1" class="tab-pane fade show active" role="tabpanel" aria-labelledby="social0_1-tab">
         <h5>Faixa Etária 0-1 ano</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <!-- M1 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M1 - Alcança um objeto colocado a sua frente (distância de 15 a 20 cm).</div>
                     <div class="skill-description">A criança estende a mão para pegar um objeto posicionado à sua frente dentro da distância especificada.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item0" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item0" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item0" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item0" value="X" disabled>
                  </td>
               </tr>
               <!-- M2 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M2 - Apanha um objeto colocado a sua frente (8 cm).</div>
                     <div class="skill-description">A criança consegue pegar um objeto colocado a uma distância de 8 cm à sua frente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item1" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item1" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item1" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item1" value="X" disabled>
                  </td>
               </tr>
               <!-- M3 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M3 - Estende os braços em direção a um objeto colocado à sua frente e o apanha.</div>
                     <div class="skill-description">A criança estende os braços para alcançar e pegar um objeto posicionado à sua frente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item2" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item2" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item2" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item2" value="X" disabled>
                  </td>
               </tr>
               <!-- M4 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M4 - Alcança um objeto preferido.</div>
                     <div class="skill-description">A criança estende a mão para pegar seu objeto favorito.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item3" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item3" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item3" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item3" value="X" disabled>
                  </td>
               </tr>
               <!-- M5 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M5 - Coloca objetos na boca.</div>
                     <div class="skill-description">A criança leva objetos até a boca para explorá-los.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item4" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item4" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item4" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item4" value="X" disabled>
                  </td>
               </tr>
               <!-- M6 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M6 - Eleva a cabeça e o tronco, apoiando-se nos braços deitado de barriga para baixo.</div>
                     <div class="skill-description">A criança levanta a cabeça e o tronco enquanto está deitada de barriga para baixo, sustentando-se com os braços.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item5" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item5" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item5" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item5" value="X" disabled>
                  </td>
               </tr>
               <!-- M7 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M7 - Levanta a cabeça e tronco apoiando-se em um só braço.</div>
                     <div class="skill-description">A criança consegue levantar a cabeça e o tronco enquanto se apoia em apenas um braço.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item6" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item6" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item6" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item6" value="X" disabled>
                  </td>
               </tr>
               <!-- M8 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M8 - Toca e explora objetos com a boca.</div>
                     <div class="skill-description">A criança utiliza a boca para explorar texturas e formas de objetos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item7" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item7" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item7" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item7" value="X" disabled>
                  </td>
               </tr>
               <!-- M9 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M9 - Estando de barriga para baixo, vira de lado, mantém posição em 50% das vezes.</div>
                     <div class="skill-description">A criança consegue virar de lado enquanto está de barriga para baixo, mantendo a posição metade das tentativas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item8" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item8" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item8" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item8" value="X" disabled>
                  </td>
               </tr>
               <!-- M10 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M10 - Estando de barriga para baixo, vira de costas.</div>
                     <div class="skill-description">A criança consegue se virar completamente para as costas enquanto está de barriga para baixo.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item9" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item9" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item9" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item9" value="X" disabled>
                  </td>
               </tr>
               <!-- M11 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M11 - De barriga para baixo, move-se para frente (equivalente à altura do corpo).</div>
                     <div class="skill-description">A criança consegue mover-se para frente enquanto está de barriga para baixo, percorrendo uma distância equivalente à sua altura corporal.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item10" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item10" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item10" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item10" value="X" disabled>
                  </td>
               </tr>
               <!-- M12 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M12 - Deitado de costas, rola para o lado.</div>
                     <div class="skill-description">A criança consegue rolar para o lado enquanto está deitada de costas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item11" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item11" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item11" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item11" value="X" disabled>
                  </td>
               </tr>
               <!-- M13 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M13 - Deitado de costas, vira de barriga para baixo.</div>
                     <div class="skill-description">A criança consegue virar de costas para barriga enquanto está deitada.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item12" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item12" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item12" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item12" value="X" disabled>
                  </td>
               </tr>
               <!-- M14 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M14 - Faz esforço para sentar-se, segurando-se nos dedos de um adulto.</div>
                     <div class="skill-description">A criança tenta sentar-se utilizando os dedos de um adulto como apoio.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item13" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item13" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item13" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item13" value="X" disabled>
                  </td>
               </tr>
               <!-- M15 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M15 - Vira a cabeça com facilidade, quando o corpo está apoiado.</div>
                     <div class="skill-description">A criança consegue girar a cabeça facilmente enquanto seu corpo está apoiado.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item14" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item14" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item14" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item14" value="X" disabled>
                  </td>
               </tr>
               <!-- M16 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M16 - Mantém-se sentado por dois minutos.</div>
                     <div class="skill-description">A criança consegue permanecer sentada sem apoio por um período de dois minutos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item15" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item15" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item15" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item15" value="X" disabled>
                  </td>
               </tr>
               <!-- M17 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M17 - Solta um objeto deliberadamente para apanhar outro.</div>
                     <div class="skill-description">A criança intencionalmente solta um objeto que está segurando para pegar outro.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item16" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item16" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item16" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item16" value="X" disabled>
                  </td>
               </tr>
               <!-- M18 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M18 - Apanha e deixa cair um objeto propositalmente.</div>
                     <div class="skill-description">A criança pega um objeto e o solta de propósito.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item17" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item17" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item17" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item17" value="X" disabled>
                  </td>
               </tr>
               <!-- M19 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M19 - Fica em pé com o máximo de apoio.</div>
                     <div class="skill-description">A criança consegue ficar de pé utilizando o máximo de apoio possível.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item18" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item18" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item18" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item18" value="X" disabled>
                  </td>
               </tr>
               <!-- M20 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M20 - Estando de pé, com apoio, pula para cima e para baixo.</div>
                     <div class="skill-description">A criança consegue realizar pequenos saltos para cima e para baixo enquanto está de pé, utilizando apoio.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item19" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item19" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item19" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item19" value="X" disabled>
                  </td>
               </tr>
               <!-- M21 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M21 - Engatinha para apanhar um objeto (distância igual à altura do corpo).</div>
                     <div class="skill-description">A criança se movimenta engatinhando para alcançar um objeto situado a uma distância igual à sua altura corporal.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item20" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item20" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item20" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item20" value="X" disabled>
                  </td>
               </tr>
               <!-- M22 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M22 - Senta-se apoiando-se sozinho.</div>
                     <div class="skill-description">A criança consegue sentar-se sem apoio adicional.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item21" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item21" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item21" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item21" value="X" disabled>
                  </td>
               </tr>
               <!-- M23 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M23 - Estando sentado, vira de gatinhas.</div>
                     <div class="skill-description">A criança consegue girar o corpo de uma posição sentada para a posição de gatinhas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item22" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item22" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item22" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item22" value="X" disabled>
                  </td>
               </tr>
               <!-- M24 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M24 - Estando de barriga para baixo, consegue sentar-se.</div>
                     <div class="skill-description">A criança consegue mover-se de uma posição de barriga para baixo para sentar-se.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item23" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item23" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item23" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item23" value="X" disabled>
                  </td>
               </tr>
               <!-- M25 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M25 - Senta-se sem apoiar as mãos.</div>
                     <div class="skill-description">A criança consegue sentar-se sem utilizar as mãos para apoio.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item24" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item24" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item24" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item24" value="X" disabled>
                  </td>
               </tr>
               <!-- M26 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M26 - Atira objetos ao acaso.</div>
                     <div class="skill-description">A criança lança objetos de forma aleatória, sem direcionamento específico.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item25" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item25" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item25" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item25" value="X" disabled>
                  </td>
               </tr>
               <!-- M27 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M27 - Balança para frente e para trás, estando de gatinhas.</div>
                     <div class="skill-description">A criança move-se balançando o corpo para frente e para trás enquanto está na posição de gatinhas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item26" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item26" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item26" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item26" value="X" disabled>
                  </td>
               </tr>
               <!-- M28 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M28 - Transfere objetos de uma mão para outra, estando sentado.</div>
                     <div class="skill-description">A criança consegue mover objetos de uma mão para a outra enquanto está sentada.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item27" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item27" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item27" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item27" value="X" disabled>
                  </td>
               </tr>
               <!-- M29 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M29 - Retêm em uma das mãos dois cubos de 2,5 cm.</div>
                     <div class="skill-description">A criança consegue segurar dois cubos de 2,5 cm de lado em uma das mãos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item28" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item28" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item28" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item28" value="X" disabled>
                  </td>
               </tr>
               <!-- M30 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M30 - Fica de joelhos.</div>
                     <div class="skill-description">A criança consegue apoiar-se nos joelhos enquanto está de pé ou em movimento.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item29" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item29" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item29" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item29" value="X" disabled>
                  </td>
               </tr>
               <!-- M31 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M31 - Fica em pé, apoiando-se em algo.</div>
                     <div class="skill-description">A criança consegue ficar de pé utilizando algum tipo de apoio, como móveis ou brinquedos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item30" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item30" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item30" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item30" value="X" disabled>
                  </td>
               </tr>
               <!-- M32 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M32 - Usa preensão de pinça para pegar objetos.</div>
                     <div class="skill-description">A criança utiliza o polegar e o indicador para pegar pequenos objetos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item31" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item31" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item31" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item31" value="X" disabled>
                  </td>
               </tr>
               <!-- M33 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M33 - Engatinha.</div>
                     <div class="skill-description">A criança se movimenta engatinhando.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item32" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item32" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item32" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item32" value="X" disabled>
                  </td>
               </tr>
               <!-- M34 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M34 - Estando de gatinhas, estende uma das mãos para o alto, tentando alcançar algo.</div>
                     <div class="skill-description">A criança tenta alcançar objetos acima dela enquanto está na posição de gatinhas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item33" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item33" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item33" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item33" value="X" disabled>
                  </td>
               </tr>
               <!-- M35 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M35 - Fica em pé com o mínimo de apoio.</div>
                     <div class="skill-description">A criança consegue ficar de pé utilizando o mínimo de apoio possível.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item34" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item34" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item34" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item34" value="X" disabled>
                  </td>
               </tr>
               <!-- M36 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M36 - Lambe a comida ao redor da boca.</div>
                     <div class="skill-description">A criança utiliza a língua para limpar resíduos de comida ao redor da boca.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item35" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item35" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item35" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item35" value="X" disabled>
                  </td>
               </tr>
               <!-- M37 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M37 - Mantém-se em pé, sozinho, por um minuto.</div>
                     <div class="skill-description">A criança consegue permanecer em pé sem apoio por um minuto.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item36" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item36" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item36" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item36" value="X" disabled>
                  </td>
               </tr>
               <!-- M38 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M38 - Derruba um objeto que está dentro de um recipiente.</div>
                     <div class="skill-description">A criança consegue derrubar objetos de dentro de um recipiente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item37" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item37" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item37" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item37" value="X" disabled>
                  </td>
               </tr>
               <!-- M39 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M39 - Vira páginas de um livro (várias ao mesmo tempo).</div>
                     <div class="skill-description">A criança tenta virar múltiplas páginas de um livro simultaneamente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item38" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item38" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item38" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item38" value="X" disabled>
                  </td>
               </tr>
               <!-- M40 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M40 - Escava com uma colher ou pá.</div>
                     <div class="skill-description">A criança utiliza uma colher ou pá para escavar materiais como areia ou terra.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item39" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item39" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item39" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item39" value="X" disabled>
                  </td>
               </tr>
               <!-- M41 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M41 - Coloca pequenos objetos dentro de um recipiente.</div>
                     <div class="skill-description">A criança consegue inserir objetos pequenos dentro de um recipiente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item40" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item40" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item40" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item40" value="X" disabled>
                  </td>
               </tr>
               <!-- M42 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M42 - Estando em pé, abaixa-se e senta-se.</div>
                     <div class="skill-description">A criança consegue abaixar-se e sentar-se enquanto está em pé.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item41" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item41" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item41" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item41" value="X" disabled>
                  </td>
               </tr>
               <!-- M43 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M43 - Bate palmas.</div>
                     <div class="skill-description">A criança realiza o gesto de bater palmas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item42" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item42" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item42" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item42" value="X" disabled>
                  </td>
               </tr>
               <!-- M44 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M44 - Anda com um mínimo de apoio.</div>
                     <div class="skill-description">A criança dá passos enquanto se apoia em móveis ou outros suportes.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item43" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item43" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item43" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item43" value="X" disabled>
                  </td>
               </tr>
               <!-- M45 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M45 - Dá alguns passos sem apoio.</div>
                     <div class="skill-description">A criança consegue dar alguns passos sem utilizar apoio adicional.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item44" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item44" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item44" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item44" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Faixa 1-2 anos - Socialização -->
      <div id="social1_2" class="tab-pane fade" role="tabpanel" aria-labelledby="social1_2-tab">
         <h5>Faixa Etária 1-2 anos</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <!-- M46 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M46 - Sobe escadas engatinhando.</div>
                     <div class="skill-description">A criança consegue subir escadas utilizando a posição de engatinhar.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item46" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item46" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item46" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item46" value="X" disabled>
                  </td>
               </tr>
               <!-- M47 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M47 - Coloca-se em pé, estando sentado.</div>
                     <div class="skill-description">A criança consegue se levantar para ficar em pé a partir de uma posição sentada.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item47" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item47" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item47" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item47" value="X" disabled>
                  </td>
               </tr>
               <!-- M48 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M48 - Rola uma bola imitando um adulto.</div>
                     <div class="skill-description">A criança consegue rolar uma bola seguindo o exemplo de um adulto.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item48" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item48" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item48" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item48" value="X" disabled>
                  </td>
               </tr>
               <!-- M49 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M49 - Sobe em uma cadeira de adulto, vira-se e senta-se.</div>
                     <div class="skill-description">A criança consegue subir em uma cadeira de adulto, girar-se e sentar-se novamente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item49" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item49" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item49" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item49" value="X" disabled>
                  </td>
               </tr>
               <!-- M50 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M50 - Coloca quatro aros em uma pequena estaca.</div>
                     <div class="skill-description">A criança consegue posicionar quatro aros em uma estaca pequena.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item50" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item50" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item50" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item50" value="X" disabled>
                  </td>
               </tr>
               <!-- M51 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M51 - Retira pinos de 2,5 de uma prancha ou tabuleiro de encaixe.</div>
                     <div class="skill-description">A criança consegue retirar pinos de 2,5 cm de uma prancha ou tabuleiro de encaixe.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item51" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item51" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item51" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item51" value="X" disabled>
                  </td>
               </tr>
               <!-- M52 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M52 - Encaixa pinos de 2,5 em uma prancha de encaixe.</div>
                     <div class="skill-description">A criança consegue encaixar pinos de 2,5 cm em uma prancha de encaixe.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item52" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item52" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item52" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item52" value="X" disabled>
                  </td>
               </tr>
               <!-- M53 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M53 - Constrói uma torre de três blocos.</div>
                     <div class="skill-description">A criança consegue empilhar três blocos para construir uma torre.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item53" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item53" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item53" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item53" value="X" disabled>
                  </td>
               </tr>
               <!-- M54 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M54 - Faz traços no papel com lápis de cera.</div>
                     <div class="skill-description">A criança consegue fazer traços simples no papel utilizando um lápis de cera.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item54" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item54" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item54" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item54" value="X" disabled>
                  </td>
               </tr>
               <!-- M55 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M55 - Anda sozinho.</div>
                     <div class="skill-description">A criança consegue dar passos e andar sem apoio.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item55" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item55" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item55" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item55" value="X" disabled>
                  </td>
               </tr>
               <!-- M56 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M56 - Desce as escadas sentado, colocando primeiro os pés.</div>
                     <div class="skill-description">A criança consegue descer escadas sentado, colocando os pés primeiro.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item56" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item56" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item56" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item56" value="X" disabled>
                  </td>
               </tr>
               <!-- M57 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M57 - Senta-se em uma cadeirinha.</div>
                     <div class="skill-description">A criança consegue sentar-se de forma independente em uma cadeirinha.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item57" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item57" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item57" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item57" value="X" disabled>
                  </td>
               </tr>
               <!-- M58 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M58 - Agacha-se e volta a ficar em pé.</div>
                     <div class="skill-description">A criança consegue agachar-se e levantar-se novamente sem cair.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item58" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item58" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item58" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item58" value="X" disabled>
                  </td>
               </tr>
               <!-- M59 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M59 - Empurra e puxa brinquedos ao andar.</div>
                     <div class="skill-description">A criança consegue empurrar e puxar brinquedos enquanto anda.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item59" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item59" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item59" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item59" value="X" disabled>
                  </td>
               </tr>
               <!-- M60 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M60 - Usa cadeira ou cavalo de balanço.</div>
                     <div class="skill-description">A criança consegue utilizar uma cadeira ou cavalo de balanço de forma apropriada.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item60" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item60" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item60" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item60" value="X" disabled>
                  </td>
               </tr>
               <!-- M61 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M61 - Sobe escadas com ajuda.</div>
                     <div class="skill-description">A criança consegue subir escadas com auxílio de um adulto.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item61" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item61" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item61" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item61" value="X" disabled>
                  </td>
               </tr>
               <!-- M62 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M62 - Dobra o corpo, sem cair, para apanhar objetos.</div>
                     <div class="skill-description">A criança consegue dobrar o corpo sem perder o equilíbrio para pegar objetos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item62" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item62" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item62" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item62" value="X" disabled>
                  </td>
               </tr>
               <!-- M63 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M63 - Imita o movimento circular.</div>
                     <div class="skill-description">A criança consegue imitar movimentos circulares feitos por um adulto.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item63" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item63" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item63" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item63" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Faixa 2-3 anos - Socialização -->
      <div id="social2_3" class="tab-pane fade" role="tabpanel" aria-labelledby="social2_3-tab">
         <h5>Faixa Etária 2-3 anos</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td>
                     <div class="checkbox-title">Corre com agilidade</div>
                     <div class="skill-description">A criança corre sem cair facilmente, mudando de direção quando necessário.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor2_3_item1" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor2_3_item1" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor2_3_item1" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor2_3_item1" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Faixa 3-4 anos - Socialização -->
      <div id="social3_4" class="tab-pane fade" role="tabpanel" aria-labelledby="social3_4-tab">
         <h5>Faixa Etária 3-4 anos</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td>
                     <div class="checkbox-title">Pula corda</div>
                     <div class="skill-description">A criança consegue pular corda sem tropeçar.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor3_4_item1" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor3_4_item1" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor3_4_item1" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor3_4_item1" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Faixa 4-5 anos - Socialização -->
      <div id="social4_5" class="tab-pane fade" role="tabpanel" aria-labelledby="social4_5-tab">
         <h5>Faixa Etária 4-5 anos</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td>
                     <div class="checkbox-title">Fazer movimentos precisos com as mãos</div>
                     <div class="skill-description">A criança realiza atividades que exigem coordenação fina, como desenhar círculos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Faixa 5-6 anos - Socialização -->
      <div id="social5_6" class="tab-pane fade" role="tabpanel" aria-labelledby="social5_6-tab">
         <h5>Faixa Etária 5-6 anos</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td>
                     <div class="checkbox-title">Fazer movimentos precisos com as mãos</div>
                     <div class="skill-description">A criança realiza atividades que exigem coordenação fina, como desenhar círculos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Classes - Socialização -->
      <div id="social_classes" class="tab-pane fade" role="tabpanel" aria-labelledby="social_classes-tab">
         <h5>Análise de Classes de Resposta</h5>
         <table class="tabela-planilha">
            <thead>
               <tr>
                  <th rowspan="2" class="titulo-cabecalho">Classe de Respostas</th>
                  <th colspan="18" class="titulo-centralizado">Faixa Etária</th>
               </tr>
               <tr>
                  <th colspan="5" class="titulo-cabecalho">0-1</th>
                  <th colspan="3" class="titulo-cabecalho">1-2</th>
                  <th colspan="2" class="titulo-cabecalho">2-3</th>
                  <th colspan="3" class="titulo-cabecalho">3-4</th>
                  <th colspan="1" class="titulo-cabecalho">4-5</th>
                  <th colspan="2" class="titulo-cabecalho">5-6</th>
                  <th class="titulo-cabecalho">Total</th>
                  <th class="titulo-cabecalho">*</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td style="text-align: left">1. Discriminação visual</td>
                  <td <?php if(isset($qst_rsp_map[1])) echo "style='" . getBackgroundColor($qst_rsp_map[1]) . "'"; ?>><?php echo 1; ?></td>
                  <td <?php if(isset($qst_rsp_map[4])) echo "style='" . getBackgroundColor($qst_rsp_map[4]) . "'"; ?>><?php echo 4; ?></td>
                  <td colspan="3"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <?php
                     // Defina os qsts presentes na linha
                     $qsts = [1, 4];
                     $totalQst = 2;
                     
                     // Inicialize a soma de pontos
                     $sumPoints = 0.0;
                     
                     // Calcule a soma de pontos
                     foreach ($qsts as $qstNum) {
                         if (isset($qst_rsp_map[$qstNum])) {
                             $sumPoints += calculatePoints($qst_rsp_map[$qstNum]);
                         }
                     }
                     
                     // Calcule a porcentagem
                     $percentage = ($sumPoints / $totalQst) * 100;
                     $percentageFormatted = round($percentage) . "%";
                     
                     // Exiba a última célula com o total e a porcentagem
                     echo "<td >2({$percentageFormatted})</td>";
                     ?>
                  <td><?php $qstsLinha = [1, 4]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">2. Sorrir</td>
                  <td <?php if(isset($qst_rsp_map[2])) echo "style='" . getBackgroundColor($qst_rsp_map[2]) . "'"; ?>><?php echo 2; ?></td>
                  <td <?php if(isset($qst_rsp_map[6])) echo "style='" . getBackgroundColor($qst_rsp_map[6]) . "'"; ?>><?php echo 6; ?></td>
                  <td <?php if(isset($qst_rsp_map[7])) echo "style='" . getBackgroundColor($qst_rsp_map[7]) . "'"; ?>><?php echo 7; ?></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <?php
                     // Defina os qsts presentes na linha
                     $qsts = [2, 6, 7];
                     $totalQst = 3;
                     
                     // Inicialize a soma de pontos
                     $sumPoints = 0.0;
                     
                     // Calcule a soma de pontos
                     foreach ($qsts as $qstNum) {
                         if (isset($qst_rsp_map[$qstNum])) {
                             $sumPoints += calculatePoints($qst_rsp_map[$qstNum]);
                         }
                     }
                     
                     // Calcule a porcentagem
                     $percentage = ($sumPoints / $totalQst) * 100;
                     $percentageFormatted = round($percentage) . "%";
                     
                     // Exiba a última célula com o total e a porcentagem
                     echo "<td >3({$percentageFormatted})</td>";
                     ?>
                  <td><?php $qstsLinha = [2, 6, 7]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">3. Vocalização</td>
                  <td <?php if(isset($qst_rsp_map[3])) echo "style='" . getBackgroundColor($qst_rsp_map[3]) . "'"; ?>><?php echo 3; ?></td>
                  <td <?php if(isset($qst_rsp_map[7])) echo "style='" . getBackgroundColor($qst_rsp_map[7]) . "'"; ?>><?php echo 7; ?></td>
                  <td <?php if(isset($qst_rsp_map[17])) echo "style='" . getBackgroundColor($qst_rsp_map[17]) . "'"; ?>><input type="checkbox" name="qst83" value="83" class="custom-checkbox"><?php echo 17; ?></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td >3</td>
                  <td><?php $qstsLinha = [3, 7, 17]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">4. Reatividade ao contato humano</td>
                  <td <?php if(isset($qst_rsp_map[5])) echo "style='" . getBackgroundColor($qst_rsp_map[5]) . "'"; ?>><?php echo 5; ?></td>
                  <td colspan="4"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">5. Acariciar/abraçar</td>
                  <td <?php if(isset($qst_rsp_map[8])) echo "style='" . getBackgroundColor($qst_rsp_map[8]) . "'"; ?>><?php echo 8; ?></td>
                  <td <?php if(isset($qst_rsp_map[23])) echo "style='" . getBackgroundColor($qst_rsp_map[23]) . "'"; ?>><?php echo 23; ?></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[35])) echo "style='" . getBackgroundColor($qst_rsp_map[35]) . "'"; ?>><?php echo 35; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td><?php $qstsLinha = [8, 23, 35]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">6. Estender mãos/braços em direção a ...</td>
                  <td <?php if(isset($qst_rsp_map[9])) echo "style='" . getBackgroundColor($qst_rsp_map[9]) . "'"; ?>><?php echo 9; ?></td>
                  <td <?php if(isset($qst_rsp_map[10])) echo "style='" . getBackgroundColor($qst_rsp_map[10]) . "'"; ?>><?php echo 10; ?></td>
                  <td <?php if(isset($qst_rsp_map[11])) echo "style='" . getBackgroundColor($qst_rsp_map[11]) . "'"; ?>><?php echo 11; ?></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>3</td>
                  <td><?php $qstsLinha = [9, 10, 11]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">7. Manipular objetos</td>
                  <td <?php if(isset($qst_rsp_map[12])) echo "style='" . getBackgroundColor($qst_rsp_map[12]) . "'"; ?>><?php echo 12; ?></td>
                  <td <?php if(isset($qst_rsp_map[13])) echo "style='" . getBackgroundColor($qst_rsp_map[13]) . "'"; ?>><?php echo 13; ?></td>
                  <td <?php if(isset($qst_rsp_map[25])) echo "style='" . getBackgroundColor($qst_rsp_map[25]) . "'"; ?>><?php echo 25; ?></td>
                  <td <?php if(isset($qst_rsp_map[26])) echo "style='" . getBackgroundColor($qst_rsp_map[26]) . "'"; ?>><?php echo 26; ?></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[34])) echo "style='" . getBackgroundColor($qst_rsp_map[34]) . "'"; ?>><?php echo 34; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>5</td>
                  <td><?php $qstsLinha = [12, 13, 25, 26, 34]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">8. Brincar</td>
                  <td <?php if(isset($qst_rsp_map[14])) echo "style='" . getBackgroundColor($qst_rsp_map[14]) . "'"; ?>><?php echo 14; ?></td>
                  <td <?php if(isset($qst_rsp_map[16])) echo "style='" . getBackgroundColor($qst_rsp_map[16]) . "'"; ?>><?php echo 16; ?></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[30])) echo "style='" . getBackgroundColor($qst_rsp_map[30]) . "'"; ?>><?php echo 30; ?></td>
                  <td <?php if(isset($qst_rsp_map[31])) echo "style='" . getBackgroundColor($qst_rsp_map[31]) . "'"; ?>><?php echo 31; ?></td>
                  <td <?php if(isset($qst_rsp_map[41])) echo "style='" . getBackgroundColor($qst_rsp_map[41]) . "'"; ?>><?php echo 41; ?></td>
                  <td <?php if(isset($qst_rsp_map[49])) echo "style='" . getBackgroundColor($qst_rsp_map[49]) . "'"; ?>><?php echo 49; ?></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[63])) echo "style='" . getBackgroundColor($qst_rsp_map[63]) . "'"; ?>><?php echo 63; ?></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[70])) echo "style='" . getBackgroundColor($qst_rsp_map[70]) . "'"; ?>><?php echo 70; ?></td>
                  <td <?php if(isset($qst_rsp_map[74])) echo "style='" . getBackgroundColor($qst_rsp_map[74]) . "'"; ?>><?php echo 74; ?></td>
                  <td ></td>
                  <td>9</td>
                  <td><?php $qstsLinha = [14, 16, 30, 31, 41, 49, 63, 70, 74]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">9. Contato Visual</td>
                  <td <?php if(isset($qst_rsp_map[15])) echo "style='" . getBackgroundColor($qst_rsp_map[15]) . "'"; ?>><?php echo 15; ?></td>
                  <td colspan="4"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">10. Imitação Motora</td>
                  <td <?php if(isset($qst_rsp_map[18])) echo "style='" . getBackgroundColor($qst_rsp_map[18]) . "'"; ?>><?php echo 18; ?></td>
                  <td <?php if(isset($qst_rsp_map[19])) echo "style='" . getBackgroundColor($qst_rsp_map[19]) . "'"; ?>><?php echo 19; ?></td>
                  <td <?php if(isset($qst_rsp_map[20])) echo "style='" . getBackgroundColor($qst_rsp_map[20]) . "'"; ?>><?php echo 20; ?></td>
                  <td <?php if(isset($qst_rsp_map[21])) echo "style='" . getBackgroundColor($qst_rsp_map[21]) . "'"; ?>><?php echo 21; ?></td>
                  <td <?php if(isset($qst_rsp_map[28])) echo "style='" . getBackgroundColor($qst_rsp_map[28]) . "'"; ?>><?php echo 28; ?></td>
                  <td <?php if(isset($qst_rsp_map[29])) echo "style='" . getBackgroundColor($qst_rsp_map[29]) . "'"; ?>><?php echo 29; ?></td>
                  <td <?php if(isset($qst_rsp_map[36])) echo "style='" . getBackgroundColor($qst_rsp_map[36]) . "'"; ?>><?php echo 36; ?></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td <?php if(isset($qst_rsp_map[76])) echo "style='" . getBackgroundColor($qst_rsp_map[76]) . "'"; ?>><?php echo 76; ?></td>
                  <td></td>
                  <td>8</td>
                  <td><?php $qstsLinha = [18, 19, 20, 21, 28, 29, 36]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">11. Dar/ Compartilhar objetos</td>
                  <td <?php if(isset($qst_rsp_map[22])) echo "style='" . getBackgroundColor($qst_rsp_map[22]) . "'"; ?>><?php echo 22; ?></td>
                  <td <?php if(isset($qst_rsp_map[27])) echo "style='" . getBackgroundColor($qst_rsp_map[27]) . "'"; ?>><?php echo 27; ?></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[37])) echo "style='" . getBackgroundColor($qst_rsp_map[37]) . "'"; ?>><?php echo 37; ?></td>
                  <td <?php if(isset($qst_rsp_map[42])) echo "style='" . getBackgroundColor($qst_rsp_map[42]) . "'"; ?>><?php echo 42; ?></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>4</td>
                  <td><?php $qstsLinha = [22, 27, 37, 42]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">12. Discriminação Auditiva</td>
                  <td <?php if(isset($qst_rsp_map[24])) echo "style='" . getBackgroundColor($qst_rsp_map[24]) . "'"; ?>><?php echo 24; ?></td>
                  <td colspan="4"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">13. Independência dos pais</td>
                  <td colspan="5"></td>
                  <td <?php if(isset($qst_rsp_map[32])) echo "style='" . getBackgroundColor($qst_rsp_map[32]) . "'"; ?>><?php echo 32; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">14. Exploração do ambiente</td>
                  <td colspan="5"></td>
                  <td <?php if(isset($qst_rsp_map[33])) echo "style='" . getBackgroundColor($qst_rsp_map[33]) . "'"; ?>><?php echo 33; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">15. Puxar pessoas para mostrar</td>
                  <td colspan="5"></td>
                  <td <?php if(isset($qst_rsp_map[38])) echo "style='" . getBackgroundColor($qst_rsp_map[38]) . "'"; ?>><?php echo 38; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">16. Cumprimentar</td>
                  <td colspan="5"></td>
                  <td <?php if(isset($qst_rsp_map[43])) echo "style='" . getBackgroundColor($qst_rsp_map[43]) . "'"; ?>><?php echo 43; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[54])) echo "style='" . getBackgroundColor($qst_rsp_map[54]) . "'"; ?>><?php echo 54; ?></td>
                  <td colspan="2"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>2</td>
                  <td><?php $qstsLinha = [43, 54]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">17. Seguir ordens/ Instruções</td>
                  <td colspan="5"></td>
                  <td <?php if(isset($qst_rsp_map[39])) echo "style='" . getBackgroundColor($qst_rsp_map[39]) . "'"; ?>><?php echo 39; ?></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[44])) echo "style='" . getBackgroundColor($qst_rsp_map[44]) . "'"; ?>><?php echo 44; ?></td>
                  <td <?php if(isset($qst_rsp_map[45])) echo "style='" . getBackgroundColor($qst_rsp_map[45]) . "'"; ?>><?php echo 45; ?></td>
                  <td <?php if(isset($qst_rsp_map[61])) echo "style='" . getBackgroundColor($qst_rsp_map[61]) . "'"; ?>><?php echo 61; ?></td>
                  <td colspan="2"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>4</td>
                  <td><?php $qstsLinha = [39, 44, 45, 61]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">18. Esperar a vez</td>
                  <td colspan="5"></td>
                  <td <?php if(isset($qst_rsp_map[40])) echo "style='" . getBackgroundColor($qst_rsp_map[40]) . "'"; ?>><?php echo 40; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[59])) echo "style='" . getBackgroundColor($qst_rsp_map[59]) . "'"; ?>><?php echo 59; ?></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[69])) echo "style='" . getBackgroundColor($qst_rsp_map[69]) . "'"; ?>><?php echo 69; ?></td>
                  <td colspan="2"></td>
                  <td>3</td>
                  <td><?php $qstsLinha = [40, 59, 69]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">19. Prestar atenção</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[46])) echo "style='" . getBackgroundColor($qst_rsp_map[46]) . "'"; ?>><?php echo 46; ?></td>
                  <td></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">20. Agradecer</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[47])) echo "style='" . getBackgroundColor($qst_rsp_map[47]) . "'"; ?>><?php echo 47; ?></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[57])) echo "style='" . getBackgroundColor($qst_rsp_map[57]) . "'"; ?>><?php echo 57; ?></td>
                  <td colspan="2"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>2</td>
                  <td><?php $qstsLinha = [47, 57]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">21. Ajudar</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[48])) echo "style='" . getBackgroundColor($qst_rsp_map[48]) . "'"; ?>><?php echo 48; ?></td>
                  <td ></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">22. Escolher</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[50])) echo "style='" . getBackgroundColor($qst_rsp_map[50]) . "'"; ?>><?php echo 50; ?></td>
                  <td></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[80])) echo "style='" . getBackgroundColor($qst_rsp_map[80]) . "'"; ?>><?php echo 80; ?></td>
                  <td></td>
                  <td>2</td>
                  <td><?php $qstsLinha = [50, 80]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">23. Expressão de sentimentos</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[51])) echo "style='" . getBackgroundColor($qst_rsp_map[51]) . "'"; ?>><?php echo 51; ?></td>
                  <td></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[73])) echo "style='" . getBackgroundColor($qst_rsp_map[73]) . "'"; ?>><?php echo 73; ?></td>
                  <td <?php if(isset($qst_rsp_map[79])) echo "style='" . getBackgroundColor($qst_rsp_map[79]) . "'"; ?>><?php echo 79; ?></td>
                  <td>3</td>
                  <td><?php $qstsLinha = [51, 73, 79]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">24. Cantar/dançar</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[52])) echo "style='" . getBackgroundColor($qst_rsp_map[52]) . "'"; ?>><?php echo 52; ?></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[66])) echo "style='" . getBackgroundColor($qst_rsp_map[66]) . "'"; ?>><?php echo 66; ?></td>
                  <td colspan="2"></td>
                  <td>2</td>
                  <td><?php $qstsLinha = [52, 66]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">25. Seguir regras de jogo</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[53])) echo "style='" . getBackgroundColor($qst_rsp_map[53]) . "'"; ?>><?php echo 53; ?></td>
                  <td <?php if(isset($qst_rsp_map[55])) echo "style='" . getBackgroundColor($qst_rsp_map[55]) . "'"; ?>><?php echo 55; ?></td>
                  <td <?php if(isset($qst_rsp_map[60])) echo "style='" . getBackgroundColor($qst_rsp_map[60]) . "'"; ?>><?php echo 60; ?></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[78])) echo "style='" . getBackgroundColor($qst_rsp_map[78]) . "'"; ?>><?php echo 78; ?></td>
                  <td></td>
                  <td>4</td>
                  <td><?php $qstsLinha = [53, 55, 60, 78]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">26. Pedir permissão</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[56])) echo "style='" . getBackgroundColor($qst_rsp_map[56]) . "'"; ?>><?php echo 56; ?></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[72])) echo "style='" . getBackgroundColor($qst_rsp_map[72]) . "'"; ?>><?php echo 72; ?></td>
                  <td colspan="2"></td>
                  <td>2</td>
                  <td><?php $qstsLinha = [56, 72]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">27. Falar ao telefone</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[58])) echo "style='" . getBackgroundColor($qst_rsp_map[58]) . "'"; ?>><?php echo 58; ?></td>
                  <td colspan="2"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">28. Permanecer em sua área</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[62])) echo "style='" . getBackgroundColor($qst_rsp_map[62]) . "'"; ?>><?php echo 62; ?></td>
                  <td colspan="2"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">29. Pedir ajuda</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[64])) echo "style='" . getBackgroundColor($qst_rsp_map[64]) . "'"; ?>><?php echo 64; ?></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">30. Verbalizar para adultos</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[65])) echo "style='" . getBackgroundColor($qst_rsp_map[65]) . "'"; ?>><?php echo 65; ?></td>
                  <td <?php if(isset($qst_rsp_map[77])) echo "style='" . getBackgroundColor($qst_rsp_map[77]) . "'"; ?>><?php echo 77; ?></td>
                  <td></td>
                  <td>2</td>
                  <td><?php $qstsLinha = [65, 77]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">31. Fazer tarefa sozinho</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[67])) echo "style='" . getBackgroundColor($qst_rsp_map[67]) . "'"; ?>><?php echo 67; ?></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">32. Pedir desculpas</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[68])) echo "style='" . getBackgroundColor($qst_rsp_map[68]) . "'"; ?>><?php echo 68; ?></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">33. Comportamentos aceitáveis em público</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[71])) echo "style='" . getBackgroundColor($qst_rsp_map[71]) . "'"; ?>><?php echo 71; ?></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">34. Explicar regras</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[75])) echo "style='" . getBackgroundColor($qst_rsp_map[75]) . "'"; ?>><?php echo 75; ?></td>
                  <td></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">35. Usar ferramentas</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[81])) echo "style='" . getBackgroundColor($qst_rsp_map[81]) . "'"; ?>><?php echo 81; ?></td>
                  <td></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">36. Estabelecer metas para si</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[82])) echo "style='" . getBackgroundColor($qst_rsp_map[82]) . "'"; ?>><?php echo 82; ?></td>
                  <td></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">37. Dramatizar</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[83])) echo "style='" . getBackgroundColor($qst_rsp_map[83]) . "'"; ?>><?php echo 83; ?></td>
                  <td></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <th class="titulo-cabecalho">Total de classes: "Novas"</th>
                  <th colspan="5" class="titulo-cabecalho">12</th>
                  <th colspan="3" class="titulo-cabecalho">6</th>
                  <th colspan="2" class="titulo-cabecalho">5</th>
                  <th colspan="3" class="titulo-cabecalho">5</th>
                  <th class="titulo-cabecalho">5</th>
                  <th colspan="2" class="titulo-cabecalho">4</th>
                  <th colspan="2" class="titulo-cabecalho">TI: 84*</th>
               </tr>
               <tr>
                  <th class="titulo-cabecalho">Total de classes: "Antigas"</th>
                  <th colspan="5" class="titulo-cabecalho"></th>
                  <th colspan="3" class="titulo-cabecalho">5</th>
                  <th colspan="2" class="titulo-cabecalho">2</th>
                  <th colspan="3" class="titulo-cabecalho">5</th>
                  <th class="titulo-cabecalho">3</th>
                  <th colspan="2" class="titulo-cabecalho">6</th>
                  <th colspan="2" class="titulo-cabecalho">TC: 37</th>
               </tr>
            </tbody>
         </table>
         <p><i class='fa fa-exclamation-circle' style='color: red;'></i> = Inconsistência nas respostas</p>
         <hr>
      </div>
      <!-- relatório -->
      <div id="social_relatorio" class="tab-pane fade" role="tabpanel" aria-labelledby="social_relatorio">
         <h5>Relatório de Socialização</h5>
      </div>
   </div>
</div>

<!-- Área Cognição -->
<div id="cognicao" class="tab-pane fade" role="tabpanel" aria-labelledby="cognicao-tab">
   <h4>Habilidades Cognitivas</h4>
   <!-- Sub-abas de faixas etárias para Cognição -->

   <ul class="nav nav-tabs mt-3" role="tablist">
      <li class="nav-item">
         <a class="nav-link active" id="cog0_1-tab" href="#cog0_1" data-toggle="tab" role="tab" aria-controls="cog0_1" aria-selected="true">0-1 ano</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="cog1_2-tab" href="#cog1_2" data-toggle="tab" role="tab" aria-controls="cog1_2" aria-selected="false">1-2 anos</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="cog2_3-tab" href="#cog2_3" data-toggle="tab" role="tab" aria-controls="cog2_3" aria-selected="false">2-3 anos</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="cog3_4-tab" href="#cog3_4" data-toggle="tab" role="tab" aria-controls="cog3_4" aria-selected="false">3-4 anos</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="cog4_5-tab" href="#cog4_5" data-toggle="tab" role="tab" aria-controls="scog4_5" aria-selected="false">4-5 anos</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="cog5_6-tab" href="#cog5_6" data-toggle="tab" role="tab" aria-controls="cog5_6" aria-selected="false">5-6 anos</a>
         </li>
      <li class="nav-item">
         <a class="nav-link" id="cog_classes-tab" href="#cog_classes" data-toggle="tab" role="tab" aria-controls="cog_classes" aria-selected="false">Classes</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="cog_relatorio-tab" href="#cog_relatorio" data-toggle="tab" role="tab" aria-controls="cog_relatorio" aria-selected="false">Relatório</a>
      </li>
   </ul>
   
   
   
   
   
   <div class="tab-content nested-tab-content">
      <!-- Faixa 0-1 ano - Cognição -->
      <div id="cog0_1" class="tab-pane fade show active" role="tabpanel" aria-labelledby="cog0_1-tab">
         <h5>Faixa Etária 0-1 ano</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <!-- M1 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M1 - Alcança um objeto colocado a sua frente (distância de 15 a 20 cm).</div>
                     <div class="skill-description">A criança estende a mão para pegar um objeto posicionado à sua frente dentro da distância especificada.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item0" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item0" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item0" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item0" value="X" disabled>
                  </td>
               </tr>
               <!-- M2 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M2 - Apanha um objeto colocado a sua frente (8 cm).</div>
                     <div class="skill-description">A criança consegue pegar um objeto colocado a uma distância de 8 cm à sua frente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item1" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item1" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item1" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item1" value="X" disabled>
                  </td>
               </tr>
               <!-- M3 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M3 - Estende os braços em direção a um objeto colocado à sua frente e o apanha.</div>
                     <div class="skill-description">A criança estende os braços para alcançar e pegar um objeto posicionado à sua frente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item2" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item2" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item2" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item2" value="X" disabled>
                  </td>
               </tr>
               <!-- M4 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M4 - Alcança um objeto preferido.</div>
                     <div class="skill-description">A criança estende a mão para pegar seu objeto favorito.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item3" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item3" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item3" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item3" value="X" disabled>
                  </td>
               </tr>
               <!-- M5 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M5 - Coloca objetos na boca.</div>
                     <div class="skill-description">A criança leva objetos até a boca para explorá-los.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item4" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item4" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item4" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item4" value="X" disabled>
                  </td>
               </tr>
               <!-- M6 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M6 - Eleva a cabeça e o tronco, apoiando-se nos braços deitado de barriga para baixo.</div>
                     <div class="skill-description">A criança levanta a cabeça e o tronco enquanto está deitada de barriga para baixo, sustentando-se com os braços.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item5" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item5" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item5" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item5" value="X" disabled>
                  </td>
               </tr>
               <!-- M7 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M7 - Levanta a cabeça e tronco apoiando-se em um só braço.</div>
                     <div class="skill-description">A criança consegue levantar a cabeça e o tronco enquanto se apoia em apenas um braço.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item6" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item6" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item6" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item6" value="X" disabled>
                  </td>
               </tr>
               <!-- M8 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M8 - Toca e explora objetos com a boca.</div>
                     <div class="skill-description">A criança utiliza a boca para explorar texturas e formas de objetos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item7" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item7" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item7" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item7" value="X" disabled>
                  </td>
               </tr>
               <!-- M9 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M9 - Estando de barriga para baixo, vira de lado, mantém posição em 50% das vezes.</div>
                     <div class="skill-description">A criança consegue virar de lado enquanto está de barriga para baixo, mantendo a posição metade das tentativas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item8" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item8" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item8" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item8" value="X" disabled>
                  </td>
               </tr>
               <!-- M10 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M10 - Estando de barriga para baixo, vira de costas.</div>
                     <div class="skill-description">A criança consegue se virar completamente para as costas enquanto está de barriga para baixo.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item9" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item9" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item9" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item9" value="X" disabled>
                  </td>
               </tr>
               <!-- M11 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M11 - De barriga para baixo, move-se para frente (equivalente à altura do corpo).</div>
                     <div class="skill-description">A criança consegue mover-se para frente enquanto está de barriga para baixo, percorrendo uma distância equivalente à sua altura corporal.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item10" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item10" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item10" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item10" value="X" disabled>
                  </td>
               </tr>
               <!-- M12 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M12 - Deitado de costas, rola para o lado.</div>
                     <div class="skill-description">A criança consegue rolar para o lado enquanto está deitada de costas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item11" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item11" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item11" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item11" value="X" disabled>
                  </td>
               </tr>
               <!-- M13 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M13 - Deitado de costas, vira de barriga para baixo.</div>
                     <div class="skill-description">A criança consegue virar de costas para barriga enquanto está deitada.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item12" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item12" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item12" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item12" value="X" disabled>
                  </td>
               </tr>
               <!-- M14 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M14 - Faz esforço para sentar-se, segurando-se nos dedos de um adulto.</div>
                     <div class="skill-description">A criança tenta sentar-se utilizando os dedos de um adulto como apoio.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item13" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item13" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item13" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item13" value="X" disabled>
                  </td>
               </tr>
               <!-- M15 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M15 - Vira a cabeça com facilidade, quando o corpo está apoiado.</div>
                     <div class="skill-description">A criança consegue girar a cabeça facilmente enquanto seu corpo está apoiado.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item14" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item14" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item14" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item14" value="X" disabled>
                  </td>
               </tr>
               <!-- M16 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M16 - Mantém-se sentado por dois minutos.</div>
                     <div class="skill-description">A criança consegue permanecer sentada sem apoio por um período de dois minutos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item15" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item15" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item15" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item15" value="X" disabled>
                  </td>
               </tr>
               <!-- M17 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M17 - Solta um objeto deliberadamente para apanhar outro.</div>
                     <div class="skill-description">A criança intencionalmente solta um objeto que está segurando para pegar outro.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item16" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item16" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item16" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item16" value="X" disabled>
                  </td>
               </tr>
               <!-- M18 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M18 - Apanha e deixa cair um objeto propositalmente.</div>
                     <div class="skill-description">A criança pega um objeto e o solta de propósito.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item17" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item17" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item17" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item17" value="X" disabled>
                  </td>
               </tr>
               <!-- M19 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M19 - Fica em pé com o máximo de apoio.</div>
                     <div class="skill-description">A criança consegue ficar de pé utilizando o máximo de apoio possível.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item18" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item18" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item18" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item18" value="X" disabled>
                  </td>
               </tr>
               <!-- M20 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M20 - Estando de pé, com apoio, pula para cima e para baixo.</div>
                     <div class="skill-description">A criança consegue realizar pequenos saltos para cima e para baixo enquanto está de pé, utilizando apoio.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item19" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item19" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item19" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item19" value="X" disabled>
                  </td>
               </tr>
               <!-- M21 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M21 - Engatinha para apanhar um objeto (distância igual à altura do corpo).</div>
                     <div class="skill-description">A criança se movimenta engatinhando para alcançar um objeto situado a uma distância igual à sua altura corporal.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item20" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item20" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item20" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item20" value="X" disabled>
                  </td>
               </tr>
               <!-- M22 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M22 - Senta-se apoiando-se sozinho.</div>
                     <div class="skill-description">A criança consegue sentar-se sem apoio adicional.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item21" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item21" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item21" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item21" value="X" disabled>
                  </td>
               </tr>
               <!-- M23 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M23 - Estando sentado, vira de gatinhas.</div>
                     <div class="skill-description">A criança consegue girar o corpo de uma posição sentada para a posição de gatinhas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item22" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item22" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item22" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item22" value="X" disabled>
                  </td>
               </tr>
               <!-- M24 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M24 - Estando de barriga para baixo, consegue sentar-se.</div>
                     <div class="skill-description">A criança consegue mover-se de uma posição de barriga para baixo para sentar-se.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item23" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item23" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item23" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item23" value="X" disabled>
                  </td>
               </tr>
               <!-- M25 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M25 - Senta-se sem apoiar as mãos.</div>
                     <div class="skill-description">A criança consegue sentar-se sem utilizar as mãos para apoio.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item24" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item24" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item24" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item24" value="X" disabled>
                  </td>
               </tr>
               <!-- M26 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M26 - Atira objetos ao acaso.</div>
                     <div class="skill-description">A criança lança objetos de forma aleatória, sem direcionamento específico.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item25" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item25" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item25" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item25" value="X" disabled>
                  </td>
               </tr>
               <!-- M27 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M27 - Balança para frente e para trás, estando de gatinhas.</div>
                     <div class="skill-description">A criança move-se balançando o corpo para frente e para trás enquanto está na posição de gatinhas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item26" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item26" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item26" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item26" value="X" disabled>
                  </td>
               </tr>
               <!-- M28 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M28 - Transfere objetos de uma mão para outra, estando sentado.</div>
                     <div class="skill-description">A criança consegue mover objetos de uma mão para a outra enquanto está sentada.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item27" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item27" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item27" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item27" value="X" disabled>
                  </td>
               </tr>
               <!-- M29 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M29 - Retêm em uma das mãos dois cubos de 2,5 cm.</div>
                     <div class="skill-description">A criança consegue segurar dois cubos de 2,5 cm de lado em uma das mãos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item28" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item28" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item28" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item28" value="X" disabled>
                  </td>
               </tr>
               <!-- M30 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M30 - Fica de joelhos.</div>
                     <div class="skill-description">A criança consegue apoiar-se nos joelhos enquanto está de pé ou em movimento.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item29" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item29" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item29" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item29" value="X" disabled>
                  </td>
               </tr>
               <!-- M31 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M31 - Fica em pé, apoiando-se em algo.</div>
                     <div class="skill-description">A criança consegue ficar de pé utilizando algum tipo de apoio, como móveis ou brinquedos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item30" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item30" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item30" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item30" value="X" disabled>
                  </td>
               </tr>
               <!-- M32 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M32 - Usa preensão de pinça para pegar objetos.</div>
                     <div class="skill-description">A criança utiliza o polegar e o indicador para pegar pequenos objetos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item31" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item31" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item31" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item31" value="X" disabled>
                  </td>
               </tr>
               <!-- M33 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M33 - Engatinha.</div>
                     <div class="skill-description">A criança se movimenta engatinhando.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item32" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item32" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item32" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item32" value="X" disabled>
                  </td>
               </tr>
               <!-- M34 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M34 - Estando de gatinhas, estende uma das mãos para o alto, tentando alcançar algo.</div>
                     <div class="skill-description">A criança tenta alcançar objetos acima dela enquanto está na posição de gatinhas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item33" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item33" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item33" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item33" value="X" disabled>
                  </td>
               </tr>
               <!-- M35 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M35 - Fica em pé com o mínimo de apoio.</div>
                     <div class="skill-description">A criança consegue ficar de pé utilizando o mínimo de apoio possível.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item34" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item34" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item34" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item34" value="X" disabled>
                  </td>
               </tr>
               <!-- M36 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M36 - Lambe a comida ao redor da boca.</div>
                     <div class="skill-description">A criança utiliza a língua para limpar resíduos de comida ao redor da boca.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item35" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item35" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item35" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item35" value="X" disabled>
                  </td>
               </tr>
               <!-- M37 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M37 - Mantém-se em pé, sozinho, por um minuto.</div>
                     <div class="skill-description">A criança consegue permanecer em pé sem apoio por um minuto.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item36" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item36" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item36" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item36" value="X" disabled>
                  </td>
               </tr>
               <!-- M38 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M38 - Derruba um objeto que está dentro de um recipiente.</div>
                     <div class="skill-description">A criança consegue derrubar objetos de dentro de um recipiente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item37" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item37" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item37" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item37" value="X" disabled>
                  </td>
               </tr>
               <!-- M39 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M39 - Vira páginas de um livro (várias ao mesmo tempo).</div>
                     <div class="skill-description">A criança tenta virar múltiplas páginas de um livro simultaneamente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item38" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item38" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item38" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item38" value="X" disabled>
                  </td>
               </tr>
               <!-- M40 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M40 - Escava com uma colher ou pá.</div>
                     <div class="skill-description">A criança utiliza uma colher ou pá para escavar materiais como areia ou terra.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item39" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item39" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item39" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item39" value="X" disabled>
                  </td>
               </tr>
               <!-- M41 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M41 - Coloca pequenos objetos dentro de um recipiente.</div>
                     <div class="skill-description">A criança consegue inserir objetos pequenos dentro de um recipiente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item40" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item40" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item40" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item40" value="X" disabled>
                  </td>
               </tr>
               <!-- M42 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M42 - Estando em pé, abaixa-se e senta-se.</div>
                     <div class="skill-description">A criança consegue abaixar-se e sentar-se enquanto está em pé.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item41" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item41" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item41" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item41" value="X" disabled>
                  </td>
               </tr>
               <!-- M43 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M43 - Bate palmas.</div>
                     <div class="skill-description">A criança realiza o gesto de bater palmas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item42" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item42" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item42" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item42" value="X" disabled>
                  </td>
               </tr>
               <!-- M44 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M44 - Anda com um mínimo de apoio.</div>
                     <div class="skill-description">A criança dá passos enquanto se apoia em móveis ou outros suportes.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item43" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item43" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item43" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item43" value="X" disabled>
                  </td>
               </tr>
               <!-- M45 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M45 - Dá alguns passos sem apoio.</div>
                     <div class="skill-description">A criança consegue dar alguns passos sem utilizar apoio adicional.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item44" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item44" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item44" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item44" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Faixa 1-2 anos - Cognição -->
      <div id="cog1_2" class="tab-pane fade" role="tabpanel" aria-labelledby="cog1_2-tab">
         <h5>Faixa Etária 1-2 anos</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <!-- M46 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M46 - Sobe escadas engatinhando.</div>
                     <div class="skill-description">A criança consegue subir escadas utilizando a posição de engatinhar.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item46" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item46" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item46" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item46" value="X" disabled>
                  </td>
               </tr>
               <!-- M47 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M47 - Coloca-se em pé, estando sentado.</div>
                     <div class="skill-description">A criança consegue se levantar para ficar em pé a partir de uma posição sentada.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item47" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item47" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item47" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item47" value="X" disabled>
                  </td>
               </tr>
               <!-- M48 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M48 - Rola uma bola imitando um adulto.</div>
                     <div class="skill-description">A criança consegue rolar uma bola seguindo o exemplo de um adulto.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item48" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item48" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item48" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item48" value="X" disabled>
                  </td>
               </tr>
               <!-- M49 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M49 - Sobe em uma cadeira de adulto, vira-se e senta-se.</div>
                     <div class="skill-description">A criança consegue subir em uma cadeira de adulto, girar-se e sentar-se novamente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item49" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item49" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item49" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item49" value="X" disabled>
                  </td>
               </tr>
               <!-- M50 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M50 - Coloca quatro aros em uma pequena estaca.</div>
                     <div class="skill-description">A criança consegue posicionar quatro aros em uma estaca pequena.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item50" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item50" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item50" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item50" value="X" disabled>
                  </td>
               </tr>
               <!-- M51 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M51 - Retira pinos de 2,5 de uma prancha ou tabuleiro de encaixe.</div>
                     <div class="skill-description">A criança consegue retirar pinos de 2,5 cm de uma prancha ou tabuleiro de encaixe.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item51" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item51" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item51" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item51" value="X" disabled>
                  </td>
               </tr>
               <!-- M52 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M52 - Encaixa pinos de 2,5 em uma prancha de encaixe.</div>
                     <div class="skill-description">A criança consegue encaixar pinos de 2,5 cm em uma prancha de encaixe.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item52" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item52" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item52" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item52" value="X" disabled>
                  </td>
               </tr>
               <!-- M53 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M53 - Constrói uma torre de três blocos.</div>
                     <div class="skill-description">A criança consegue empilhar três blocos para construir uma torre.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item53" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item53" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item53" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item53" value="X" disabled>
                  </td>
               </tr>
               <!-- M54 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M54 - Faz traços no papel com lápis de cera.</div>
                     <div class="skill-description">A criança consegue fazer traços simples no papel utilizando um lápis de cera.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item54" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item54" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item54" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item54" value="X" disabled>
                  </td>
               </tr>
               <!-- M55 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M55 - Anda sozinho.</div>
                     <div class="skill-description">A criança consegue dar passos e andar sem apoio.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item55" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item55" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item55" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item55" value="X" disabled>
                  </td>
               </tr>
               <!-- M56 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M56 - Desce as escadas sentado, colocando primeiro os pés.</div>
                     <div class="skill-description">A criança consegue descer escadas sentado, colocando os pés primeiro.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item56" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item56" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item56" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item56" value="X" disabled>
                  </td>
               </tr>
               <!-- M57 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M57 - Senta-se em uma cadeirinha.</div>
                     <div class="skill-description">A criança consegue sentar-se de forma independente em uma cadeirinha.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item57" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item57" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item57" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item57" value="X" disabled>
                  </td>
               </tr>
               <!-- M58 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M58 - Agacha-se e volta a ficar em pé.</div>
                     <div class="skill-description">A criança consegue agachar-se e levantar-se novamente sem cair.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item58" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item58" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item58" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item58" value="X" disabled>
                  </td>
               </tr>
               <!-- M59 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M59 - Empurra e puxa brinquedos ao andar.</div>
                     <div class="skill-description">A criança consegue empurrar e puxar brinquedos enquanto anda.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item59" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item59" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item59" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item59" value="X" disabled>
                  </td>
               </tr>
               <!-- M60 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M60 - Usa cadeira ou cavalo de balanço.</div>
                     <div class="skill-description">A criança consegue utilizar uma cadeira ou cavalo de balanço de forma apropriada.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item60" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item60" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item60" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item60" value="X" disabled>
                  </td>
               </tr>
               <!-- M61 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M61 - Sobe escadas com ajuda.</div>
                     <div class="skill-description">A criança consegue subir escadas com auxílio de um adulto.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item61" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item61" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item61" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item61" value="X" disabled>
                  </td>
               </tr>
               <!-- M62 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M62 - Dobra o corpo, sem cair, para apanhar objetos.</div>
                     <div class="skill-description">A criança consegue dobrar o corpo sem perder o equilíbrio para pegar objetos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item62" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item62" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item62" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item62" value="X" disabled>
                  </td>
               </tr>
               <!-- M63 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M63 - Imita o movimento circular.</div>
                     <div class="skill-description">A criança consegue imitar movimentos circulares feitos por um adulto.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item63" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item63" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item63" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item63" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Faixa 2-3 anos - Cognição -->
      <div id="cog2_3" class="tab-pane fade" role="tabpanel" aria-labelledby="cog2_3-tab">
         <h5>Faixa Etária 2-3 anos</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td>
                     <div class="checkbox-title">Corre com agilidade</div>
                     <div class="skill-description">A criança corre sem cair facilmente, mudando de direção quando necessário.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor2_3_item1" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor2_3_item1" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor2_3_item1" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor2_3_item1" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Faixa 3-4 anos - Cognição -->
      <div id="cog3_4" class="tab-pane fade" role="tabpanel" aria-labelledby="cog3_4-tab">
         <h5>Faixa Etária 3-4 anos</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td>
                     <div class="checkbox-title">Pula corda</div>
                     <div class="skill-description">A criança consegue pular corda sem tropeçar.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor3_4_item1" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor3_4_item1" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor3_4_item1" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor3_4_item1" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Faixa 4-5 anos - Cognição -->
      <div id="cog4_5" class="tab-pane fade" role="tabpanel" aria-labelledby="cog4_5-tab">
         <h5>Faixa Etária 4-5 anos</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td>
                     <div class="checkbox-title">Fazer movimentos precisos com as mãos</div>
                     <div class="skill-description">A criança realiza atividades que exigem coordenação fina, como desenhar círculos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Faixa 5-6 anos - Cognição -->
      <div id="cog5_6" class="tab-pane fade" role="tabpanel" aria-labelledby="cog5_6-tab">
         <h5>Faixa Etária 5-6 anos</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td>
                     <div class="checkbox-title">Fazer movimentos precisos com as mãos</div>
                     <div class="skill-description">A criança realiza atividades que exigem coordenação fina, como desenhar círculos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Classes - Cognição -->
      <div id="cog_classes" class="tab-pane fade" role="tabpanel" aria-labelledby="cog_classes-tab">
         <h5>Análise de Classes de Resposta</h5>
         <table class="tabela-planilha">
            <thead>
               <tr>
                  <th rowspan="2" class="titulo-cabecalho">Classe de Respostas</th>
                  <th colspan="18" class="titulo-centralizado">Faixa Etária</th>
               </tr>
               <tr>
                  <th colspan="5" class="titulo-cabecalho">0-1</th>
                  <th colspan="3" class="titulo-cabecalho">1-2</th>
                  <th colspan="2" class="titulo-cabecalho">2-3</th>
                  <th colspan="3" class="titulo-cabecalho">3-4</th>
                  <th colspan="1" class="titulo-cabecalho">4-5</th>
                  <th colspan="2" class="titulo-cabecalho">5-6</th>
                  <th class="titulo-cabecalho">Total</th>
                  <th class="titulo-cabecalho">*</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td style="text-align: left">1. Discriminação visual</td>
                  <td <?php if(isset($qst_rsp_map[1])) echo "style='" . getBackgroundColor($qst_rsp_map[1]) . "'"; ?>><?php echo 1; ?></td>
                  <td <?php if(isset($qst_rsp_map[4])) echo "style='" . getBackgroundColor($qst_rsp_map[4]) . "'"; ?>><?php echo 4; ?></td>
                  <td colspan="3"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <?php
                     // Defina os qsts presentes na linha
                     $qsts = [1, 4];
                     $totalQst = 2;
                     
                     // Inicialize a soma de pontos
                     $sumPoints = 0.0;
                     
                     // Calcule a soma de pontos
                     foreach ($qsts as $qstNum) {
                         if (isset($qst_rsp_map[$qstNum])) {
                             $sumPoints += calculatePoints($qst_rsp_map[$qstNum]);
                         }
                     }
                     
                     // Calcule a porcentagem
                     $percentage = ($sumPoints / $totalQst) * 100;
                     $percentageFormatted = round($percentage) . "%";
                     
                     // Exiba a última célula com o total e a porcentagem
                     echo "<td >2({$percentageFormatted})</td>";
                     ?>
                  <td><?php $qstsLinha = [1, 4]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">2. Sorrir</td>
                  <td <?php if(isset($qst_rsp_map[2])) echo "style='" . getBackgroundColor($qst_rsp_map[2]) . "'"; ?>><?php echo 2; ?></td>
                  <td <?php if(isset($qst_rsp_map[6])) echo "style='" . getBackgroundColor($qst_rsp_map[6]) . "'"; ?>><?php echo 6; ?></td>
                  <td <?php if(isset($qst_rsp_map[7])) echo "style='" . getBackgroundColor($qst_rsp_map[7]) . "'"; ?>><?php echo 7; ?></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <?php
                     // Defina os qsts presentes na linha
                     $qsts = [2, 6, 7];
                     $totalQst = 3;
                     
                     // Inicialize a soma de pontos
                     $sumPoints = 0.0;
                     
                     // Calcule a soma de pontos
                     foreach ($qsts as $qstNum) {
                         if (isset($qst_rsp_map[$qstNum])) {
                             $sumPoints += calculatePoints($qst_rsp_map[$qstNum]);
                         }
                     }
                     
                     // Calcule a porcentagem
                     $percentage = ($sumPoints / $totalQst) * 100;
                     $percentageFormatted = round($percentage) . "%";
                     
                     // Exiba a última célula com o total e a porcentagem
                     echo "<td >3({$percentageFormatted})</td>";
                     ?>
                  <td><?php $qstsLinha = [2, 6, 7]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">3. Vocalização</td>
                  <td <?php if(isset($qst_rsp_map[3])) echo "style='" . getBackgroundColor($qst_rsp_map[3]) . "'"; ?>><?php echo 3; ?></td>
                  <td <?php if(isset($qst_rsp_map[7])) echo "style='" . getBackgroundColor($qst_rsp_map[7]) . "'"; ?>><?php echo 7; ?></td>
                  <td <?php if(isset($qst_rsp_map[17])) echo "style='" . getBackgroundColor($qst_rsp_map[17]) . "'"; ?>><input type="checkbox" name="qst83" value="83" class="custom-checkbox"><?php echo 17; ?></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td >3</td>
                  <td><?php $qstsLinha = [3, 7, 17]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">4. Reatividade ao contato humano</td>
                  <td <?php if(isset($qst_rsp_map[5])) echo "style='" . getBackgroundColor($qst_rsp_map[5]) . "'"; ?>><?php echo 5; ?></td>
                  <td colspan="4"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">5. Acariciar/abraçar</td>
                  <td <?php if(isset($qst_rsp_map[8])) echo "style='" . getBackgroundColor($qst_rsp_map[8]) . "'"; ?>><?php echo 8; ?></td>
                  <td <?php if(isset($qst_rsp_map[23])) echo "style='" . getBackgroundColor($qst_rsp_map[23]) . "'"; ?>><?php echo 23; ?></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[35])) echo "style='" . getBackgroundColor($qst_rsp_map[35]) . "'"; ?>><?php echo 35; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td><?php $qstsLinha = [8, 23, 35]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">6. Estender mãos/braços em direção a ...</td>
                  <td <?php if(isset($qst_rsp_map[9])) echo "style='" . getBackgroundColor($qst_rsp_map[9]) . "'"; ?>><?php echo 9; ?></td>
                  <td <?php if(isset($qst_rsp_map[10])) echo "style='" . getBackgroundColor($qst_rsp_map[10]) . "'"; ?>><?php echo 10; ?></td>
                  <td <?php if(isset($qst_rsp_map[11])) echo "style='" . getBackgroundColor($qst_rsp_map[11]) . "'"; ?>><?php echo 11; ?></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>3</td>
                  <td><?php $qstsLinha = [9, 10, 11]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">7. Manipular objetos</td>
                  <td <?php if(isset($qst_rsp_map[12])) echo "style='" . getBackgroundColor($qst_rsp_map[12]) . "'"; ?>><?php echo 12; ?></td>
                  <td <?php if(isset($qst_rsp_map[13])) echo "style='" . getBackgroundColor($qst_rsp_map[13]) . "'"; ?>><?php echo 13; ?></td>
                  <td <?php if(isset($qst_rsp_map[25])) echo "style='" . getBackgroundColor($qst_rsp_map[25]) . "'"; ?>><?php echo 25; ?></td>
                  <td <?php if(isset($qst_rsp_map[26])) echo "style='" . getBackgroundColor($qst_rsp_map[26]) . "'"; ?>><?php echo 26; ?></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[34])) echo "style='" . getBackgroundColor($qst_rsp_map[34]) . "'"; ?>><?php echo 34; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>5</td>
                  <td><?php $qstsLinha = [12, 13, 25, 26, 34]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">8. Brincar</td>
                  <td <?php if(isset($qst_rsp_map[14])) echo "style='" . getBackgroundColor($qst_rsp_map[14]) . "'"; ?>><?php echo 14; ?></td>
                  <td <?php if(isset($qst_rsp_map[16])) echo "style='" . getBackgroundColor($qst_rsp_map[16]) . "'"; ?>><?php echo 16; ?></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[30])) echo "style='" . getBackgroundColor($qst_rsp_map[30]) . "'"; ?>><?php echo 30; ?></td>
                  <td <?php if(isset($qst_rsp_map[31])) echo "style='" . getBackgroundColor($qst_rsp_map[31]) . "'"; ?>><?php echo 31; ?></td>
                  <td <?php if(isset($qst_rsp_map[41])) echo "style='" . getBackgroundColor($qst_rsp_map[41]) . "'"; ?>><?php echo 41; ?></td>
                  <td <?php if(isset($qst_rsp_map[49])) echo "style='" . getBackgroundColor($qst_rsp_map[49]) . "'"; ?>><?php echo 49; ?></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[63])) echo "style='" . getBackgroundColor($qst_rsp_map[63]) . "'"; ?>><?php echo 63; ?></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[70])) echo "style='" . getBackgroundColor($qst_rsp_map[70]) . "'"; ?>><?php echo 70; ?></td>
                  <td <?php if(isset($qst_rsp_map[74])) echo "style='" . getBackgroundColor($qst_rsp_map[74]) . "'"; ?>><?php echo 74; ?></td>
                  <td ></td>
                  <td>9</td>
                  <td><?php $qstsLinha = [14, 16, 30, 31, 41, 49, 63, 70, 74]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">9. Contato Visual</td>
                  <td <?php if(isset($qst_rsp_map[15])) echo "style='" . getBackgroundColor($qst_rsp_map[15]) . "'"; ?>><?php echo 15; ?></td>
                  <td colspan="4"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">10. Imitação Motora</td>
                  <td <?php if(isset($qst_rsp_map[18])) echo "style='" . getBackgroundColor($qst_rsp_map[18]) . "'"; ?>><?php echo 18; ?></td>
                  <td <?php if(isset($qst_rsp_map[19])) echo "style='" . getBackgroundColor($qst_rsp_map[19]) . "'"; ?>><?php echo 19; ?></td>
                  <td <?php if(isset($qst_rsp_map[20])) echo "style='" . getBackgroundColor($qst_rsp_map[20]) . "'"; ?>><?php echo 20; ?></td>
                  <td <?php if(isset($qst_rsp_map[21])) echo "style='" . getBackgroundColor($qst_rsp_map[21]) . "'"; ?>><?php echo 21; ?></td>
                  <td <?php if(isset($qst_rsp_map[28])) echo "style='" . getBackgroundColor($qst_rsp_map[28]) . "'"; ?>><?php echo 28; ?></td>
                  <td <?php if(isset($qst_rsp_map[29])) echo "style='" . getBackgroundColor($qst_rsp_map[29]) . "'"; ?>><?php echo 29; ?></td>
                  <td <?php if(isset($qst_rsp_map[36])) echo "style='" . getBackgroundColor($qst_rsp_map[36]) . "'"; ?>><?php echo 36; ?></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td <?php if(isset($qst_rsp_map[76])) echo "style='" . getBackgroundColor($qst_rsp_map[76]) . "'"; ?>><?php echo 76; ?></td>
                  <td></td>
                  <td>8</td>
                  <td><?php $qstsLinha = [18, 19, 20, 21, 28, 29, 36]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">11. Dar/ Compartilhar objetos</td>
                  <td <?php if(isset($qst_rsp_map[22])) echo "style='" . getBackgroundColor($qst_rsp_map[22]) . "'"; ?>><?php echo 22; ?></td>
                  <td <?php if(isset($qst_rsp_map[27])) echo "style='" . getBackgroundColor($qst_rsp_map[27]) . "'"; ?>><?php echo 27; ?></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[37])) echo "style='" . getBackgroundColor($qst_rsp_map[37]) . "'"; ?>><?php echo 37; ?></td>
                  <td <?php if(isset($qst_rsp_map[42])) echo "style='" . getBackgroundColor($qst_rsp_map[42]) . "'"; ?>><?php echo 42; ?></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>4</td>
                  <td><?php $qstsLinha = [22, 27, 37, 42]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">12. Discriminação Auditiva</td>
                  <td <?php if(isset($qst_rsp_map[24])) echo "style='" . getBackgroundColor($qst_rsp_map[24]) . "'"; ?>><?php echo 24; ?></td>
                  <td colspan="4"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">13. Independência dos pais</td>
                  <td colspan="5"></td>
                  <td <?php if(isset($qst_rsp_map[32])) echo "style='" . getBackgroundColor($qst_rsp_map[32]) . "'"; ?>><?php echo 32; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">14. Exploração do ambiente</td>
                  <td colspan="5"></td>
                  <td <?php if(isset($qst_rsp_map[33])) echo "style='" . getBackgroundColor($qst_rsp_map[33]) . "'"; ?>><?php echo 33; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">15. Puxar pessoas para mostrar</td>
                  <td colspan="5"></td>
                  <td <?php if(isset($qst_rsp_map[38])) echo "style='" . getBackgroundColor($qst_rsp_map[38]) . "'"; ?>><?php echo 38; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">16. Cumprimentar</td>
                  <td colspan="5"></td>
                  <td <?php if(isset($qst_rsp_map[43])) echo "style='" . getBackgroundColor($qst_rsp_map[43]) . "'"; ?>><?php echo 43; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[54])) echo "style='" . getBackgroundColor($qst_rsp_map[54]) . "'"; ?>><?php echo 54; ?></td>
                  <td colspan="2"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>2</td>
                  <td><?php $qstsLinha = [43, 54]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">17. Seguir ordens/ Instruções</td>
                  <td colspan="5"></td>
                  <td <?php if(isset($qst_rsp_map[39])) echo "style='" . getBackgroundColor($qst_rsp_map[39]) . "'"; ?>><?php echo 39; ?></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[44])) echo "style='" . getBackgroundColor($qst_rsp_map[44]) . "'"; ?>><?php echo 44; ?></td>
                  <td <?php if(isset($qst_rsp_map[45])) echo "style='" . getBackgroundColor($qst_rsp_map[45]) . "'"; ?>><?php echo 45; ?></td>
                  <td <?php if(isset($qst_rsp_map[61])) echo "style='" . getBackgroundColor($qst_rsp_map[61]) . "'"; ?>><?php echo 61; ?></td>
                  <td colspan="2"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>4</td>
                  <td><?php $qstsLinha = [39, 44, 45, 61]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">18. Esperar a vez</td>
                  <td colspan="5"></td>
                  <td <?php if(isset($qst_rsp_map[40])) echo "style='" . getBackgroundColor($qst_rsp_map[40]) . "'"; ?>><?php echo 40; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[59])) echo "style='" . getBackgroundColor($qst_rsp_map[59]) . "'"; ?>><?php echo 59; ?></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[69])) echo "style='" . getBackgroundColor($qst_rsp_map[69]) . "'"; ?>><?php echo 69; ?></td>
                  <td colspan="2"></td>
                  <td>3</td>
                  <td><?php $qstsLinha = [40, 59, 69]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">19. Prestar atenção</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[46])) echo "style='" . getBackgroundColor($qst_rsp_map[46]) . "'"; ?>><?php echo 46; ?></td>
                  <td></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">20. Agradecer</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[47])) echo "style='" . getBackgroundColor($qst_rsp_map[47]) . "'"; ?>><?php echo 47; ?></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[57])) echo "style='" . getBackgroundColor($qst_rsp_map[57]) . "'"; ?>><?php echo 57; ?></td>
                  <td colspan="2"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>2</td>
                  <td><?php $qstsLinha = [47, 57]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">21. Ajudar</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[48])) echo "style='" . getBackgroundColor($qst_rsp_map[48]) . "'"; ?>><?php echo 48; ?></td>
                  <td ></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">22. Escolher</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[50])) echo "style='" . getBackgroundColor($qst_rsp_map[50]) . "'"; ?>><?php echo 50; ?></td>
                  <td></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[80])) echo "style='" . getBackgroundColor($qst_rsp_map[80]) . "'"; ?>><?php echo 80; ?></td>
                  <td></td>
                  <td>2</td>
                  <td><?php $qstsLinha = [50, 80]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">23. Expressão de sentimentos</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[51])) echo "style='" . getBackgroundColor($qst_rsp_map[51]) . "'"; ?>><?php echo 51; ?></td>
                  <td></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[73])) echo "style='" . getBackgroundColor($qst_rsp_map[73]) . "'"; ?>><?php echo 73; ?></td>
                  <td <?php if(isset($qst_rsp_map[79])) echo "style='" . getBackgroundColor($qst_rsp_map[79]) . "'"; ?>><?php echo 79; ?></td>
                  <td>3</td>
                  <td><?php $qstsLinha = [51, 73, 79]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">24. Cantar/dançar</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[52])) echo "style='" . getBackgroundColor($qst_rsp_map[52]) . "'"; ?>><?php echo 52; ?></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[66])) echo "style='" . getBackgroundColor($qst_rsp_map[66]) . "'"; ?>><?php echo 66; ?></td>
                  <td colspan="2"></td>
                  <td>2</td>
                  <td><?php $qstsLinha = [52, 66]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">25. Seguir regras de jogo</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[53])) echo "style='" . getBackgroundColor($qst_rsp_map[53]) . "'"; ?>><?php echo 53; ?></td>
                  <td <?php if(isset($qst_rsp_map[55])) echo "style='" . getBackgroundColor($qst_rsp_map[55]) . "'"; ?>><?php echo 55; ?></td>
                  <td <?php if(isset($qst_rsp_map[60])) echo "style='" . getBackgroundColor($qst_rsp_map[60]) . "'"; ?>><?php echo 60; ?></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[78])) echo "style='" . getBackgroundColor($qst_rsp_map[78]) . "'"; ?>><?php echo 78; ?></td>
                  <td></td>
                  <td>4</td>
                  <td><?php $qstsLinha = [53, 55, 60, 78]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">26. Pedir permissão</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[56])) echo "style='" . getBackgroundColor($qst_rsp_map[56]) . "'"; ?>><?php echo 56; ?></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[72])) echo "style='" . getBackgroundColor($qst_rsp_map[72]) . "'"; ?>><?php echo 72; ?></td>
                  <td colspan="2"></td>
                  <td>2</td>
                  <td><?php $qstsLinha = [56, 72]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">27. Falar ao telefone</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[58])) echo "style='" . getBackgroundColor($qst_rsp_map[58]) . "'"; ?>><?php echo 58; ?></td>
                  <td colspan="2"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">28. Permanecer em sua área</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[62])) echo "style='" . getBackgroundColor($qst_rsp_map[62]) . "'"; ?>><?php echo 62; ?></td>
                  <td colspan="2"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">29. Pedir ajuda</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[64])) echo "style='" . getBackgroundColor($qst_rsp_map[64]) . "'"; ?>><?php echo 64; ?></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">30. Verbalizar para adultos</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[65])) echo "style='" . getBackgroundColor($qst_rsp_map[65]) . "'"; ?>><?php echo 65; ?></td>
                  <td <?php if(isset($qst_rsp_map[77])) echo "style='" . getBackgroundColor($qst_rsp_map[77]) . "'"; ?>><?php echo 77; ?></td>
                  <td></td>
                  <td>2</td>
                  <td><?php $qstsLinha = [65, 77]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">31. Fazer tarefa sozinho</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[67])) echo "style='" . getBackgroundColor($qst_rsp_map[67]) . "'"; ?>><?php echo 67; ?></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">32. Pedir desculpas</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[68])) echo "style='" . getBackgroundColor($qst_rsp_map[68]) . "'"; ?>><?php echo 68; ?></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">33. Comportamentos aceitáveis em público</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[71])) echo "style='" . getBackgroundColor($qst_rsp_map[71]) . "'"; ?>><?php echo 71; ?></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">34. Explicar regras</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[75])) echo "style='" . getBackgroundColor($qst_rsp_map[75]) . "'"; ?>><?php echo 75; ?></td>
                  <td></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">35. Usar ferramentas</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[81])) echo "style='" . getBackgroundColor($qst_rsp_map[81]) . "'"; ?>><?php echo 81; ?></td>
                  <td></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">36. Estabelecer metas para si</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[82])) echo "style='" . getBackgroundColor($qst_rsp_map[82]) . "'"; ?>><?php echo 82; ?></td>
                  <td></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">37. Dramatizar</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[83])) echo "style='" . getBackgroundColor($qst_rsp_map[83]) . "'"; ?>><?php echo 83; ?></td>
                  <td></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <th class="titulo-cabecalho">Total de classes: "Novas"</th>
                  <th colspan="5" class="titulo-cabecalho">12</th>
                  <th colspan="3" class="titulo-cabecalho">6</th>
                  <th colspan="2" class="titulo-cabecalho">5</th>
                  <th colspan="3" class="titulo-cabecalho">5</th>
                  <th class="titulo-cabecalho">5</th>
                  <th colspan="2" class="titulo-cabecalho">4</th>
                  <th colspan="2" class="titulo-cabecalho">TI: 84*</th>
               </tr>
               <tr>
                  <th class="titulo-cabecalho">Total de classes: "Antigas"</th>
                  <th colspan="5" class="titulo-cabecalho"></th>
                  <th colspan="3" class="titulo-cabecalho">5</th>
                  <th colspan="2" class="titulo-cabecalho">2</th>
                  <th colspan="3" class="titulo-cabecalho">5</th>
                  <th class="titulo-cabecalho">3</th>
                  <th colspan="2" class="titulo-cabecalho">6</th>
                  <th colspan="2" class="titulo-cabecalho">TC: 37</th>
               </tr>
            </tbody>
         </table>
         <p><i class='fa fa-exclamation-circle' style='color: red;'></i> = Inconsistência nas respostas</p>
         <hr>
      </div>
      <!-- relatório -->
      <div id="cog_relatorio" class="tab-pane fade" role="tabpanel" aria-labelledby="cog_relatorio">
         <h5>Relatório de Socialização</h5>
      </div>
   </div>
</div>

<!-- Área Linguagem -->
<div id="linguagem" class="tab-pane fade" role="tabpanel" aria-labelledby="linguagem-tab">
   <h4>Habilidades de Linguagem</h4>
   <!-- Sub-abas de faixas etárias para Linguagem -->
   <ul class="nav nav-tabs mt-3" role="tablist">
      <li class="nav-item">
         <a class="nav-link active" id="ling0_1-tab" href="#ling0_1" data-toggle="tab" role="tab" aria-controls="ling0_1" aria-selected="true">0-1 ano</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="ling1_2-tab" href="#ling1_2" data-toggle="tab" role="tab" aria-controls="ling1_2" aria-selected="false">1-2 anos</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="ling2_3-tab" href="#ling2_3" data-toggle="tab" role="tab" aria-controls="ling2_3" aria-selected="false">2-3 anos</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="ling3_4-tab" href="#ling3_4" data-toggle="tab" role="tab" aria-controls="ling3_4" aria-selected="false">3-4 anos</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="ling4_5-tab" href="#ling4_5" data-toggle="tab" role="tab" aria-controls="ling4_5" aria-selected="false">4-5 anos</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="ling5_6-tab" href="#ling5_6" data-toggle="tab" role="tab" aria-controls="ling5_6" aria-selected="false">5-6 anos</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="ling_classes-tab" href="#ling_classes" data-toggle="tab" role="tab" aria-controls="ling_classes" aria-selected="false">Classes</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="ling_relatorio-tab" href="#ling_relatorio" data-toggle="tab" role="tab" aria-controls="ling_relatorio" aria-selected="false">Relatório</a>
      </li>
   </ul>
   <div class="tab-content nested-tab-content">
      <!-- Faixa 0-1 ano - Linguagem -->
      <div id="ling0_1" class="tab-pane fade show active" role="tabpanel" aria-labelledby="ling0_1-tab">
         <h5>Faixa Etária 0-1 ano</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td>
                     <div class="checkbox-title">Emite sons para chamar atenção</div>
                     <div class="skill-description">A criança vocaliza (arrulhos, risadas) para interagir.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="ling0_1_item1" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="ling0_1_item1" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="ling0_1_item1" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="ling0_1_item1" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Faixa 1-2 anos - Linguagem -->
      <div id="ling1_2" class="tab-pane fade" role="tabpanel" aria-labelledby="ling1_2-tab">
         <h5>Faixa Etária 1-2 anos</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td>
                     <div class="checkbox-title">Fala palavras simples (ex: 'mama', 'dada')</div>
                     <div class="skill-description">A criança utiliza algumas palavras para se comunicar.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="ling1_2_item1" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="ling1_2_item1" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="ling1_2_item1" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="ling1_2_item1" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Faixa 2-3 anos - Linguagem -->
      <div id="ling2_3" class="tab-pane fade" role="tabpanel" aria-labelledby="ling2_3-tab">
         <h5>Faixa Etária 2-3 anos</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td>
                     <div class="checkbox-title">Fala palavras simples (ex: 'mama', 'dada')</div>
                     <div class="skill-description">A criança utiliza algumas palavras para se comunicar.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="ling1_2_item1" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="ling1_2_item1" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="ling1_2_item1" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="ling1_2_item1" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Faixa 3-4 anos - Linguagem -->
      <div id="ling3_4" class="tab-pane fade" role="tabpanel" aria-labelledby="ling3_4-tab">
         <h5>Faixa Etária 3-4 anos</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td>
                     <div class="checkbox-title">Fala palavras simples (ex: 'mama', 'dada')</div>
                     <div class="skill-description">A criança utiliza algumas palavras para se comunicar.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="ling1_2_item1" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="ling1_2_item1" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="ling1_2_item1" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="ling1_2_item1" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Faixa 4-5 anos - Linguagem -->
      <div id="ling4_5" class="tab-pane fade" role="tabpanel" aria-labelledby="ling4_5-tab">
         <h5>Faixa Etária 4-5 anos</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td>
                     <div class="checkbox-title">Fala palavras simples (ex: 'mama', 'dada')</div>
                     <div class="skill-description">A criança utiliza algumas palavras para se comunicar.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="ling1_2_item1" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="ling1_2_item1" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="ling1_2_item1" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="ling1_2_item1" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Faixa 5-6 anos - Linguagem -->
      <div id="ling5_6" class="tab-pane fade" role="tabpanel" aria-labelledby="ling5_6-tab">
         <h5>Faixa Etária 5-6 anos</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td>
                     <div class="checkbox-title">Fala palavras simples (ex: 'mama', 'dada')</div>
                     <div class="skill-description">A criança utiliza algumas palavras para se comunicar.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="ling1_2_item1" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="ling1_2_item1" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="ling1_2_item1" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="ling1_2_item1" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Classes - Linguagem -->
      <div id="ling_classes" class="tab-pane fade" role="tabpanel" aria-labelledby="ling_classes-tab">
         <h5>Análise de Classes de Resposta</h5>
         <table class="tabela-planilha">
            <thead>
               <tr>
                  <th rowspan="2" class="titulo-cabecalho">Classe de Respostas</th>
                  <th colspan="27" class="titulo-centralizado">Faixa Etária</th>
               </tr>
               <tr>
                  <th colspan="4" class="titulo-cabecalho">0-1</th>
                  <th colspan="2" class="titulo-cabecalho">1-2</th>
                  <th colspan="4" class="titulo-cabecalho">2-3</th>
                  <th colspan="5" class="titulo-cabecalho">3-4</th>
                  <th colspan="2" class="titulo-cabecalho">4-5</th>
                  <th colspan="8" class="titulo-cabecalho">5-6</th>
                  <th class="titulo-cabecalho">Total</th>
                  <th class="titulo-cabecalho">*</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td style="text-align: left">1. Discriminação Visual</td>
                  <td >1</td>
                  <td >2</td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td colspan="4"></td>
                  <td colspan="5"></td>
                  <td colspan="2"></td>
                  <td colspan="8"></td>
                  <td >2</td>
                  <td ></td>
               </tr>
                <tr>
                  <td style="text-align: left">2. Colocar/ remover objetos de recipientes</td>
                  <td >3</td>
                  <td >4</td>
                  <td >5</td>
                  <td >7</td>
                  <td >15</td>
                  <td ></td>
                  <td colspan="4"></td>
                  <td colspan="5"></td>
                  <td colspan="2"></td>
                  <td colspan="8"></td>
                  <td >5</td>
                  <td ></td>
                </tr>
               <tr>
                  <td style="text-align: left">3. Manipular objetos/brinquedos</td>
                  <td >6</td>
                  <td >8</td>
                  <td >9</td>
                  <td >11</td>
                  <td colspan="2"></td>
                  <td colspan="4"></td>
                  <td colspan="5"></td>
                  <td colspan="2"></td>
                  <td colspan="8"></td>
                  <td >4</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">4. Encontrar objetos/ figuras ausentes</td>
                  <td >10</td>
                  <td colspan="3"></td>
                  <td >24</td>
                  <td ></td>
                  <td >25</td>
                  <td colspan="3"></td>
                  <td colspan="5"></td>
                  <td >84</td>
                  <td ></td>
                  <td colspan="8"></td>
                  <td >4</td>
                  <td ></td>
                </tr>
                <tr>
                  <!-- <td style="text-align: left">5. Colocar/ remover peças em pranchas de encaixe/ quebra-cabeças</td> -->
                  <td style="text-align: left;" title="5. Colocar/ remover peças em pranchas de encaixe/ quebra-cabeças">5. Colocar/ remover peças em pranchas de encaixe/ quebra-cabeças</td>
                  <td >12</td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td >26</td>
                  <td >37</td>
                  <td colspan="2"></td>
                  <td >60</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="8"></td>
                  <td >4</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">6. Colocar pinos em pranchas</td>
                  <td >13</td>
                  <td colspan="3"></td>
                  <td >21</td>
                  <td ></td>
                  <td colspan="4"></td>
                  <td colspan="5"></td>
                  <td colspan="2"></td>
                  <td colspan="8"></td>
                  <td >2</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">7. Executar gestos</td>
                  <td >14</td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="4"></td>
                  <td >47</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="8"></td>
                  <td >2</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">8. Apontar partes do corpo</td>
                  <td colspan="4"></td>
                  <td >16</td>
                  <td ></td>
                  <td colspan="4"></td>
                  <td >42</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="8"></td>
                  <td >2</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">9. Empilhar blocos/ argolas</td>
                  <td colspan="4"></td>
                  <td >17</td>
                  <td ></td>
                  <td >40</td>
                  <td colspan="3"></td>
                  <td >56</td>
                  <td colspan="4"></td>
                  <td >80</td>
                  <td ></td>
                  <td colspan="8"></td>
                  <td >4</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">10. Emparelhar objetos/ figuras semelhantes</td>
                  <td colspan="4"></td>
                  <td >18</td>
                  <td >20</td>
                  <td colspan="4"></td>
                  <td >48</td>
                  <td >50</td>
                  <td >52</td>
                  <td >57</td>
                  <td ></td>
                  <td >83</td>
                  <td ></td>
                  <td colspan="8"></td>
                  <td >4</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">11. Realizar traços em papel</td>
                  <td colspan="4"></td>
                  <td >19</td>
                  <td ></td>
                  <td >28</td>
                  <td >29</td>
                  <td >30</td>
                  <td >33</td>
                  <td >53</td>
                  <td >54</td>
                  <td >58</td>
                  <td >59</td>
                  <td >62</td>
                  <td >67</td>
                  <td >78</td>
                  <td >100</td>
                  <td colspan="7"></td>
                  <td >13</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">12. Identificar a si próprio</td>
                  <td colspan="4"></td>
                  <td >20</td>
                  <td ></td>
                  <td colspan="4"></td>
                  <td colspan="5"></td>
                  <td colspan="2"></td>
                  <td colspan="8"></td>
                  <td >1</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">13. Apontar figuras nomeadas</td>
                  <td colspan="4"></td>
                  <td >23</td>
                  <td ></td>
                  <td colspan="4"></td>
                  <td >43</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="8"></td>
                  <td >2</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left;" title="14. Identificar tamanho e comprimento de objetos/ figuras">14. Identificar tamanho e comprimento de objetos/ figuras</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td >32</td>
                  <td colspan="3"></td>
                  <td >41</td>
                  <td >49</td>
                  <td colspan="3"></td>
                  <td >81</td>
                  <td ></td>
                  <td >93</td>
                  <td colspan="7"></td>
                  <td >5</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">15. Nomear figuras/ objetos</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td >27</td>
                  <td >36</td>
                  <td >38</td>
                  <td ></td>
                  <td colspan="5"></td>
                  <td colspan="2"></td>
                  <td colspan="8"></td>
                  <td >3</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">16. Identificar texturas</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td >31</td>
                  <td colspan="3"></td>
                  <td colspan="5"></td>
                  <td >66</td>
                  <td ></td>
                  <td colspan="8"></td>
                  <td >2</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">17. Identificar cores</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td >34</td>
                  <td colspan="3"></td>
                  <td >63</td>
                  <td colspan="4"></td>
                  <td >73</td>
                  <td >76</td>
                  <td colspan="8"></td>
                  <td >4</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">18. Identificar posição espacial de objetos</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td >35</td>
                  <td colspan="3"></td>
                  <td colspan="5"></td>
                  <td >82</td>
                  <td >86</td>
                  <td >96</td>
                  <td colspan="7"></td>
                  <td >4</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">19. Identifica/reunir formas geométricas</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td >39</td>
                  <td colspan="3"></td>
                  <td >64</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="8"></td>
                  <td >2</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">20. Identificar peso de objetos</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="4"></td>
                  <td >44</td>
                  <td colspan="4"></td>
                  <td >71</td>
                  <td ></td>
                  <td colspan="8"></td>
                  <td >2</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">21. Unir figuras</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="4"></td>
                  <td >45</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="8"></td>
                  <td >1</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">22. Descrever eventos</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="4"></td>
                  <td >46</td>
                  <td colspan="4"></td>
                  <td >77</td>
                  <td ></td>
                  <td colspan="8"></td>
                  <td >2</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">23. Contar objetos</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="4"></td>
                  <td >51</td>
                  <td >55</td>
                  <td colspan="3"></td>
                  <td >85</td>
                  <td ></td>
                  <td >87</td>
                  <td >108</td>
                  <td colspan="6"></td>
                  <td >5</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">24. Indicar se objetos são iguais ou diferentes</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="4"></td>
                  <td >61</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="8"></td>
                  <td >1</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">25. Identificar número de objetos</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="4"></td>
                  <td colspan="5"></td>
                  <td >65</td>
                  <td ></td>
                  <td colspan="8"></td>
                  <td >1</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">26. Recordar-se de objetos vistos</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="4"></td>
                  <td colspan="5"></td>
                  <td >68</td>
                  <td >72</td>
                  <td colspan="8"></td>
                  <td >2</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">27. Identificar tempo (manhã/tarde)</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="4"></td>
                  <td colspan="5"></td>
                  <td >69</td>
                  <td ></td>
                  <td colspan="8"></td>
                  <td >1</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">28. Repetir rimas/cantar</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="4"></td>
                  <td colspan="5"></td>
                  <td >70</td>
                  <td >79</td>
                  <td colspan="8"></td>
                  <td >2</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">29. Identificar valor de moedas</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="4"></td>
                  <td colspan="5"></td>
                  <td >74</td>
                  <td ></td>
                  <td colspan="8"></td>
                  <td >1</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">30. Emparelhar/nomear letras e números</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="4"></td>
                  <td colspan="5"></td>
                  <td >75</td>
                  <td ></td>
                  <td >88</td>
                  <td >90</td>
                  <td >92</td>
                  <td >94</td>
                  <td >95</td>
                  <td >97</td>
                  <td >98</td>
                  <td >99</td>
                  <td >9</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">31. Identificar esquerda/ direita</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="4"></td>
                  <td colspan="5"></td>
                  <td colspan="2"></td>
                  <td >89</td>
                  <td colspan="7"></td>
                  <td >1</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">32. Escrever seu nome</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="4"></td>
                  <td colspan="5"></td>
                  <td colspan="2"></td>
                  <td >91</td>
                  <td colspan="7"></td>
                  <td >1</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">33. Completar labirintos</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="4"></td>
                  <td colspan="5"></td>
                  <td colspan="2"></td>
                  <td >101</td>
                  <td colspan="7"></td>
                  <td >1</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">34. Identificar dias da semana</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="4"></td>
                  <td colspan="5"></td>
                  <td colspan="2"></td>
                  <td >102</td>
                  <td colspan="7"></td>
                  <td >1</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">35. Somar e subtrair</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="4"></td>
                  <td colspan="5"></td>
                  <td colspan="2"></td>
                  <td >103</td>
                  <td colspan="7"></td>
                  <td >1</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">36. Identificar mês e dia de nascimento</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="4"></td>
                  <td colspan="5"></td>
                  <td colspan="2"></td>
                  <td >104</td>
                  <td colspan="7"></td>
                  <td >1</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">37. Ler palavras</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="4"></td>
                  <td colspan="5"></td>
                  <td colspan="2"></td>
                  <td >105</td>
                  <td colspan="7"></td>
                  <td >1</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">38. Predizer o que ocorrerá</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="4"></td>
                  <td colspan="5"></td>
                  <td colspan="2"></td>
                  <td >106</td>
                  <td colspan="7"></td>
                  <td >1</td>
                  <td ></td>
                </tr>
                <tr>
                  <td style="text-align: left">39. Identificar objetos inteiros ou partidos ao meio</td>
                  <td colspan="4"></td>
                  <td colspan="2"></td>
                  <td colspan="4"></td>
                  <td colspan="5"></td>
                  <td colspan="2"></td>
                  <td >107</td>
                  <td colspan="7"></td>
                  <td >1</td>
                  <td ></td>
                </tr>


               <tr>
                  <th class="titulo-cabecalho">Total de classes: "Novas"</th>
                  <th colspan="4" class="titulo-cabecalho">7</th>
                  <th colspan="2" class="titulo-cabecalho">6</th>
                  <th colspan="4" class="titulo-cabecalho">6</th>
                  <th colspan="5" class="titulo-cabecalho">5</th>
                  <th colspan="2"class="titulo-cabecalho">6</th>
                  <th colspan="8" class="titulo-cabecalho">9</th>
                  <th colspan="2" class="titulo-cabecalho">TI: 84*</th>
               </tr>
               <tr>
                  <th class="titulo-cabecalho">Total de classes: "Antigas"</th>
                  <th colspan="4" class="titulo-cabecalho"></th>
                  <th colspan="2" class="titulo-cabecalho">3</th>
                  <th colspan="4" class="titulo-cabecalho">4</th>
                  <th colspan="5" class="titulo-cabecalho">10</th>
                  <th colspan="2" class="titulo-cabecalho">11</th>
                  <th colspan="8" class="titulo-cabecalho">5</th>
                  <th colspan="2" class="titulo-cabecalho">TC: 37</th>
               </tr>
            </tbody>
         </table>
         <p><i class='fa fa-exclamation-circle' style='color: red;'></i> = Inconsistência nas respostas</p>
         <hr>
      </div>
      <!-- relatório -->
      <div id="ling_relatorio" class="tab-pane fade" role="tabpanel" aria-labelledby="ling_relatorio-tab">
         <h5>Relatório</h5>
         
      </div>
      
   </div>
</div>

<!-- Área autocuidado -->
<div id="autocuidado" class="tab-pane fade" role="tabpanel" aria-labelledby="autocuidado-tab">
   <h4>Habilidades de Autocuidado</h4>
   <!-- Sub-abas de faixas etárias para Linguagem -->
   <ul class="nav nav-tabs mt-3" role="tablist">
      <li class="nav-item">
         <a class="nav-link active" id="autocuidado0_1-tab" href="#autocuidado0_1" data-toggle="tab" role="tab" aria-controls="autocuidado0_1" aria-selected="true">0-1 ano</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="autocuidado1_2-tab" href="#autocuidado1_2" data-toggle="tab" role="tab" aria-controls="autocuidado1_2" aria-selected="false">1-2 anos</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="autocuidado2_3-tab" href="#autocuidado2_3" data-toggle="tab" role="tab" aria-controls="autocuidado2_3" aria-selected="false">2-3 anos</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="autocuidado3_4-tab" href="#autocuidado3_4" data-toggle="tab" role="tab" aria-controls="autocuidado3_4" aria-selected="false">3-4 anos</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="autocuidado4_5-tab" href="#autocuidado4_5" data-toggle="tab" role="tab" aria-controls="autocuidado4_5" aria-selected="false">4-5 anos</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="autocuidado5_6-tab" href="#autocuidado5_6" data-toggle="tab" role="tab" aria-controls="autocuidado5_6" aria-selected="false">5-6 anos</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="autocuidado_classes-tab" href="#autocuidado_classes" data-toggle="tab" role="tab" aria-controls="autocuidado_classes" aria-selected="false">Classes</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="autocuidado_relatorio-tab" href="#autocuidado_relatorio" data-toggle="tab" role="tab" aria-controls="autocuidado_relatorio" aria-selected="false">Relatório</a>
      </li>
   </ul>
   <div class="tab-content nested-tab-content">
      <!-- Faixa 0-1 ano - Autocuidado -->
      <div id="autocuidado0_1" class="tab-pane fade show active" role="tabpanel" aria-labelledby="autocuidado0_1-tab">
         <h5>Faixa Etária 0-1 ano</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <!-- M1 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M1 - Alcança um objeto colocado a sua frente (distância de 15 a 20 cm).</div>
                     <div class="skill-description">A criança estende a mão para pegar um objeto posicionado à sua frente dentro da distância especificada.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item0" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item0" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item0" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item0" value="X" disabled>
                  </td>
               </tr>
               <!-- M2 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M2 - Apanha um objeto colocado a sua frente (8 cm).</div>
                     <div class="skill-description">A criança consegue pegar um objeto colocado a uma distância de 8 cm à sua frente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item1" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item1" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item1" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item1" value="X" disabled>
                  </td>
               </tr>
               <!-- M3 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M3 - Estende os braços em direção a um objeto colocado à sua frente e o apanha.</div>
                     <div class="skill-description">A criança estende os braços para alcançar e pegar um objeto posicionado à sua frente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item2" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item2" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item2" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item2" value="X" disabled>
                  </td>
               </tr>
               <!-- M4 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M4 - Alcança um objeto preferido.</div>
                     <div class="skill-description">A criança estende a mão para pegar seu objeto favorito.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item3" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item3" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item3" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item3" value="X" disabled>
                  </td>
               </tr>
               <!-- M5 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M5 - Coloca objetos na boca.</div>
                     <div class="skill-description">A criança leva objetos até a boca para explorá-los.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item4" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item4" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item4" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item4" value="X" disabled>
                  </td>
               </tr>
               <!-- M6 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M6 - Eleva a cabeça e o tronco, apoiando-se nos braços deitado de barriga para baixo.</div>
                     <div class="skill-description">A criança levanta a cabeça e o tronco enquanto está deitada de barriga para baixo, sustentando-se com os braços.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item5" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item5" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item5" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item5" value="X" disabled>
                  </td>
               </tr>
               <!-- M7 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M7 - Levanta a cabeça e tronco apoiando-se em um só braço.</div>
                     <div class="skill-description">A criança consegue levantar a cabeça e o tronco enquanto se apoia em apenas um braço.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item6" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item6" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item6" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item6" value="X" disabled>
                  </td>
               </tr>
               <!-- M8 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M8 - Toca e explora objetos com a boca.</div>
                     <div class="skill-description">A criança utiliza a boca para explorar texturas e formas de objetos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item7" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item7" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item7" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item7" value="X" disabled>
                  </td>
               </tr>
               <!-- M9 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M9 - Estando de barriga para baixo, vira de lado, mantém posição em 50% das vezes.</div>
                     <div class="skill-description">A criança consegue virar de lado enquanto está de barriga para baixo, mantendo a posição metade das tentativas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item8" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item8" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item8" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item8" value="X" disabled>
                  </td>
               </tr>
               <!-- M10 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M10 - Estando de barriga para baixo, vira de costas.</div>
                     <div class="skill-description">A criança consegue se virar completamente para as costas enquanto está de barriga para baixo.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item9" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item9" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item9" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item9" value="X" disabled>
                  </td>
               </tr>
               <!-- M11 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M11 - De barriga para baixo, move-se para frente (equivalente à altura do corpo).</div>
                     <div class="skill-description">A criança consegue mover-se para frente enquanto está de barriga para baixo, percorrendo uma distância equivalente à sua altura corporal.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item10" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item10" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item10" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item10" value="X" disabled>
                  </td>
               </tr>
               <!-- M12 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M12 - Deitado de costas, rola para o lado.</div>
                     <div class="skill-description">A criança consegue rolar para o lado enquanto está deitada de costas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item11" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item11" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item11" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item11" value="X" disabled>
                  </td>
               </tr>
               <!-- M13 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M13 - Deitado de costas, vira de barriga para baixo.</div>
                     <div class="skill-description">A criança consegue virar de costas para barriga enquanto está deitada.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item12" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item12" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item12" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item12" value="X" disabled>
                  </td>
               </tr>
               <!-- M14 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M14 - Faz esforço para sentar-se, segurando-se nos dedos de um adulto.</div>
                     <div class="skill-description">A criança tenta sentar-se utilizando os dedos de um adulto como apoio.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item13" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item13" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item13" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item13" value="X" disabled>
                  </td>
               </tr>
               <!-- M15 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M15 - Vira a cabeça com facilidade, quando o corpo está apoiado.</div>
                     <div class="skill-description">A criança consegue girar a cabeça facilmente enquanto seu corpo está apoiado.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item14" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item14" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item14" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item14" value="X" disabled>
                  </td>
               </tr>
               <!-- M16 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M16 - Mantém-se sentado por dois minutos.</div>
                     <div class="skill-description">A criança consegue permanecer sentada sem apoio por um período de dois minutos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item15" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item15" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item15" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item15" value="X" disabled>
                  </td>
               </tr>
               <!-- M17 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M17 - Solta um objeto deliberadamente para apanhar outro.</div>
                     <div class="skill-description">A criança intencionalmente solta um objeto que está segurando para pegar outro.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item16" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item16" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item16" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item16" value="X" disabled>
                  </td>
               </tr>
               <!-- M18 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M18 - Apanha e deixa cair um objeto propositalmente.</div>
                     <div class="skill-description">A criança pega um objeto e o solta de propósito.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item17" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item17" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item17" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item17" value="X" disabled>
                  </td>
               </tr>
               <!-- M19 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M19 - Fica em pé com o máximo de apoio.</div>
                     <div class="skill-description">A criança consegue ficar de pé utilizando o máximo de apoio possível.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item18" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item18" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item18" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item18" value="X" disabled>
                  </td>
               </tr>
               <!-- M20 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M20 - Estando de pé, com apoio, pula para cima e para baixo.</div>
                     <div class="skill-description">A criança consegue realizar pequenos saltos para cima e para baixo enquanto está de pé, utilizando apoio.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item19" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item19" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item19" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item19" value="X" disabled>
                  </td>
               </tr>
               <!-- M21 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M21 - Engatinha para apanhar um objeto (distância igual à altura do corpo).</div>
                     <div class="skill-description">A criança se movimenta engatinhando para alcançar um objeto situado a uma distância igual à sua altura corporal.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item20" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item20" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item20" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item20" value="X" disabled>
                  </td>
               </tr>
               <!-- M22 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M22 - Senta-se apoiando-se sozinho.</div>
                     <div class="skill-description">A criança consegue sentar-se sem apoio adicional.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item21" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item21" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item21" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item21" value="X" disabled>
                  </td>
               </tr>
               <!-- M23 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M23 - Estando sentado, vira de gatinhas.</div>
                     <div class="skill-description">A criança consegue girar o corpo de uma posição sentada para a posição de gatinhas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item22" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item22" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item22" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item22" value="X" disabled>
                  </td>
               </tr>
               <!-- M24 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M24 - Estando de barriga para baixo, consegue sentar-se.</div>
                     <div class="skill-description">A criança consegue mover-se de uma posição de barriga para baixo para sentar-se.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item23" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item23" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item23" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item23" value="X" disabled>
                  </td>
               </tr>
               <!-- M25 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M25 - Senta-se sem apoiar as mãos.</div>
                     <div class="skill-description">A criança consegue sentar-se sem utilizar as mãos para apoio.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item24" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item24" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item24" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item24" value="X" disabled>
                  </td>
               </tr>
               <!-- M26 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M26 - Atira objetos ao acaso.</div>
                     <div class="skill-description">A criança lança objetos de forma aleatória, sem direcionamento específico.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item25" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item25" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item25" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item25" value="X" disabled>
                  </td>
               </tr>
               <!-- M27 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M27 - Balança para frente e para trás, estando de gatinhas.</div>
                     <div class="skill-description">A criança move-se balançando o corpo para frente e para trás enquanto está na posição de gatinhas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item26" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item26" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item26" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item26" value="X" disabled>
                  </td>
               </tr>
               <!-- M28 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M28 - Transfere objetos de uma mão para outra, estando sentado.</div>
                     <div class="skill-description">A criança consegue mover objetos de uma mão para a outra enquanto está sentada.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item27" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item27" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item27" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item27" value="X" disabled>
                  </td>
               </tr>
               <!-- M29 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M29 - Retêm em uma das mãos dois cubos de 2,5 cm.</div>
                     <div class="skill-description">A criança consegue segurar dois cubos de 2,5 cm de lado em uma das mãos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item28" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item28" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item28" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item28" value="X" disabled>
                  </td>
               </tr>
               <!-- M30 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M30 - Fica de joelhos.</div>
                     <div class="skill-description">A criança consegue apoiar-se nos joelhos enquanto está de pé ou em movimento.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item29" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item29" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item29" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item29" value="X" disabled>
                  </td>
               </tr>
               <!-- M31 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M31 - Fica em pé, apoiando-se em algo.</div>
                     <div class="skill-description">A criança consegue ficar de pé utilizando algum tipo de apoio, como móveis ou brinquedos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item30" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item30" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item30" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item30" value="X" disabled>
                  </td>
               </tr>
               <!-- M32 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M32 - Usa preensão de pinça para pegar objetos.</div>
                     <div class="skill-description">A criança utiliza o polegar e o indicador para pegar pequenos objetos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item31" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item31" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item31" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item31" value="X" disabled>
                  </td>
               </tr>
               <!-- M33 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M33 - Engatinha.</div>
                     <div class="skill-description">A criança se movimenta engatinhando.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item32" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item32" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item32" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item32" value="X" disabled>
                  </td>
               </tr>
               <!-- M34 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M34 - Estando de gatinhas, estende uma das mãos para o alto, tentando alcançar algo.</div>
                     <div class="skill-description">A criança tenta alcançar objetos acima dela enquanto está na posição de gatinhas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item33" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item33" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item33" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item33" value="X" disabled>
                  </td>
               </tr>
               <!-- M35 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M35 - Fica em pé com o mínimo de apoio.</div>
                     <div class="skill-description">A criança consegue ficar de pé utilizando o mínimo de apoio possível.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item34" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item34" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item34" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item34" value="X" disabled>
                  </td>
               </tr>
               <!-- M36 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M36 - Lambe a comida ao redor da boca.</div>
                     <div class="skill-description">A criança utiliza a língua para limpar resíduos de comida ao redor da boca.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item35" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item35" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item35" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item35" value="X" disabled>
                  </td>
               </tr>
               <!-- M37 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M37 - Mantém-se em pé, sozinho, por um minuto.</div>
                     <div class="skill-description">A criança consegue permanecer em pé sem apoio por um minuto.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item36" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item36" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item36" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item36" value="X" disabled>
                  </td>
               </tr>
               <!-- M38 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M38 - Derruba um objeto que está dentro de um recipiente.</div>
                     <div class="skill-description">A criança consegue derrubar objetos de dentro de um recipiente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item37" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item37" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item37" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item37" value="X" disabled>
                  </td>
               </tr>
               <!-- M39 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M39 - Vira páginas de um livro (várias ao mesmo tempo).</div>
                     <div class="skill-description">A criança tenta virar múltiplas páginas de um livro simultaneamente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item38" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item38" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item38" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item38" value="X" disabled>
                  </td>
               </tr>
               <!-- M40 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M40 - Escava com uma colher ou pá.</div>
                     <div class="skill-description">A criança utiliza uma colher ou pá para escavar materiais como areia ou terra.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item39" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item39" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item39" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item39" value="X" disabled>
                  </td>
               </tr>
               <!-- M41 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M41 - Coloca pequenos objetos dentro de um recipiente.</div>
                     <div class="skill-description">A criança consegue inserir objetos pequenos dentro de um recipiente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item40" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item40" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item40" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item40" value="X" disabled>
                  </td>
               </tr>
               <!-- M42 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M42 - Estando em pé, abaixa-se e senta-se.</div>
                     <div class="skill-description">A criança consegue abaixar-se e sentar-se enquanto está em pé.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item41" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item41" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item41" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item41" value="X" disabled>
                  </td>
               </tr>
               <!-- M43 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M43 - Bate palmas.</div>
                     <div class="skill-description">A criança realiza o gesto de bater palmas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item42" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item42" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item42" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item42" value="X" disabled>
                  </td>
               </tr>
               <!-- M44 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M44 - Anda com um mínimo de apoio.</div>
                     <div class="skill-description">A criança dá passos enquanto se apoia em móveis ou outros suportes.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item43" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item43" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item43" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item43" value="X" disabled>
                  </td>
               </tr>
               <!-- M45 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M45 - Dá alguns passos sem apoio.</div>
                     <div class="skill-description">A criança consegue dar alguns passos sem utilizar apoio adicional.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item44" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item44" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item44" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item44" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Faixa 1-2 anos - Autocuidado -->
      <div id="autocuidado1_2" class="tab-pane fade" role="tabpanel" aria-labelledby="autocuidado1_2-tab">
         <h5>Faixa Etária 1-2 anos</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <!-- M46 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M46 - Sobe escadas engatinhando.</div>
                     <div class="skill-description">A criança consegue subir escadas utilizando a posição de engatinhar.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item46" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item46" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item46" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item46" value="X" disabled>
                  </td>
               </tr>
               <!-- M47 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M47 - Coloca-se em pé, estando sentado.</div>
                     <div class="skill-description">A criança consegue se levantar para ficar em pé a partir de uma posição sentada.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item47" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item47" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item47" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item47" value="X" disabled>
                  </td>
               </tr>
               <!-- M48 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M48 - Rola uma bola imitando um adulto.</div>
                     <div class="skill-description">A criança consegue rolar uma bola seguindo o exemplo de um adulto.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item48" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item48" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item48" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item48" value="X" disabled>
                  </td>
               </tr>
               <!-- M49 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M49 - Sobe em uma cadeira de adulto, vira-se e senta-se.</div>
                     <div class="skill-description">A criança consegue subir em uma cadeira de adulto, girar-se e sentar-se novamente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item49" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item49" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item49" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item49" value="X" disabled>
                  </td>
               </tr>
               <!-- M50 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M50 - Coloca quatro aros em uma pequena estaca.</div>
                     <div class="skill-description">A criança consegue posicionar quatro aros em uma estaca pequena.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item50" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item50" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item50" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item50" value="X" disabled>
                  </td>
               </tr>
               <!-- M51 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M51 - Retira pinos de 2,5 de uma prancha ou tabuleiro de encaixe.</div>
                     <div class="skill-description">A criança consegue retirar pinos de 2,5 cm de uma prancha ou tabuleiro de encaixe.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item51" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item51" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item51" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item51" value="X" disabled>
                  </td>
               </tr>
               <!-- M52 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M52 - Encaixa pinos de 2,5 em uma prancha de encaixe.</div>
                     <div class="skill-description">A criança consegue encaixar pinos de 2,5 cm em uma prancha de encaixe.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item52" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item52" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item52" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item52" value="X" disabled>
                  </td>
               </tr>
               <!-- M53 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M53 - Constrói uma torre de três blocos.</div>
                     <div class="skill-description">A criança consegue empilhar três blocos para construir uma torre.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item53" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item53" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item53" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item53" value="X" disabled>
                  </td>
               </tr>
               <!-- M54 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M54 - Faz traços no papel com lápis de cera.</div>
                     <div class="skill-description">A criança consegue fazer traços simples no papel utilizando um lápis de cera.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item54" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item54" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item54" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item54" value="X" disabled>
                  </td>
               </tr>
               <!-- M55 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M55 - Anda sozinho.</div>
                     <div class="skill-description">A criança consegue dar passos e andar sem apoio.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item55" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item55" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item55" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item55" value="X" disabled>
                  </td>
               </tr>
               <!-- M56 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M56 - Desce as escadas sentado, colocando primeiro os pés.</div>
                     <div class="skill-description">A criança consegue descer escadas sentado, colocando os pés primeiro.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item56" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item56" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item56" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item56" value="X" disabled>
                  </td>
               </tr>
               <!-- M57 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M57 - Senta-se em uma cadeirinha.</div>
                     <div class="skill-description">A criança consegue sentar-se de forma independente em uma cadeirinha.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item57" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item57" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item57" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item57" value="X" disabled>
                  </td>
               </tr>
               <!-- M58 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M58 - Agacha-se e volta a ficar em pé.</div>
                     <div class="skill-description">A criança consegue agachar-se e levantar-se novamente sem cair.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item58" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item58" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item58" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item58" value="X" disabled>
                  </td>
               </tr>
               <!-- M59 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M59 - Empurra e puxa brinquedos ao andar.</div>
                     <div class="skill-description">A criança consegue empurrar e puxar brinquedos enquanto anda.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item59" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item59" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item59" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item59" value="X" disabled>
                  </td>
               </tr>
               <!-- M60 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M60 - Usa cadeira ou cavalo de balanço.</div>
                     <div class="skill-description">A criança consegue utilizar uma cadeira ou cavalo de balanço de forma apropriada.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item60" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item60" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item60" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item60" value="X" disabled>
                  </td>
               </tr>
               <!-- M61 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M61 - Sobe escadas com ajuda.</div>
                     <div class="skill-description">A criança consegue subir escadas com auxílio de um adulto.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item61" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item61" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item61" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item61" value="X" disabled>
                  </td>
               </tr>
               <!-- M62 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M62 - Dobra o corpo, sem cair, para apanhar objetos.</div>
                     <div class="skill-description">A criança consegue dobrar o corpo sem perder o equilíbrio para pegar objetos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item62" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item62" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item62" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item62" value="X" disabled>
                  </td>
               </tr>
               <!-- M63 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M63 - Imita o movimento circular.</div>
                     <div class="skill-description">A criança consegue imitar movimentos circulares feitos por um adulto.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item63" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item63" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item63" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item63" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Faixa 2-3 anos - Autocuidado -->
      <div id="autocuidado2_3" class="tab-pane fade" role="tabpanel" aria-labelledby="autocuidado2_3-tab">
         <h5>Faixa Etária 2-3 anos</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td>
                     <div class="checkbox-title">Corre com agilidade</div>
                     <div class="skill-description">A criança corre sem cair facilmente, mudando de direção quando necessário.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor2_3_item1" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor2_3_item1" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor2_3_item1" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor2_3_item1" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Faixa 3-4 anos - Autocuidado -->
      <div id="autocuidado3_4" class="tab-pane fade" role="tabpanel" aria-labelledby="autocuidado3_4-tab">
         <h5>Faixa Etária 3-4 anos</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td>
                     <div class="checkbox-title">Pula corda</div>
                     <div class="skill-description">A criança consegue pular corda sem tropeçar.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor3_4_item1" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor3_4_item1" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor3_4_item1" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor3_4_item1" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Faixa 4-5 anos - Autocuidado -->
      <div id="autocuidado4_5" class="tab-pane fade" role="tabpanel" aria-labelledby="autocuidado4_5-tab">
         <h5>Faixa Etária 4-5 anos</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td>
                     <div class="checkbox-title">Fazer movimentos precisos com as mãos</div>
                     <div class="skill-description">A criança realiza atividades que exigem coordenação fina, como desenhar círculos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Faixa 5-6 anos - Autocuidado -->
      <div id="autocuidado5_6" class="tab-pane fade" role="tabpanel" aria-labelledby="autocuidado5_6-tab">
         <h5>Faixa Etária 5-6 anos</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td>
                     <div class="checkbox-title">Fazer movimentos precisos com as mãos</div>
                     <div class="skill-description">A criança realiza atividades que exigem coordenação fina, como desenhar círculos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Classes - Autocuidado -->
      <div id="autocuidado_classes" class="tab-pane fade" role="tabpanel" aria-labelledby="autocuidado_classes-tab">
         <h5>Análise de Classes de Resposta</h5>
         <table class="tabela-planilha">
            <thead>
               <tr>
                  <th rowspan="2" class="titulo-cabecalho">Classe de Respostas</th>
                  <th colspan="18" class="titulo-centralizado">Faixa Etária</th>
               </tr>
               <tr>
                  <th colspan="5" class="titulo-cabecalho">0-1</th>
                  <th colspan="3" class="titulo-cabecalho">1-2</th>
                  <th colspan="2" class="titulo-cabecalho">2-3</th>
                  <th colspan="3" class="titulo-cabecalho">3-4</th>
                  <th colspan="1" class="titulo-cabecalho">4-5</th>
                  <th colspan="2" class="titulo-cabecalho">5-6</th>
                  <th class="titulo-cabecalho">Total</th>
                  <th class="titulo-cabecalho">*</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td style="text-align: left">1. Discriminação visual</td>
                  <td <?php if(isset($qst_rsp_map[1])) echo "style='" . getBackgroundColor($qst_rsp_map[1]) . "'"; ?>><?php echo 1; ?></td>
                  <td <?php if(isset($qst_rsp_map[4])) echo "style='" . getBackgroundColor($qst_rsp_map[4]) . "'"; ?>><?php echo 4; ?></td>
                  <td colspan="3"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <?php
                     // Defina os qsts presentes na linha
                     $qsts = [1, 4];
                     $totalQst = 2;
                     
                     // Inicialize a soma de pontos
                     $sumPoints = 0.0;
                     
                     // Calcule a soma de pontos
                     foreach ($qsts as $qstNum) {
                         if (isset($qst_rsp_map[$qstNum])) {
                             $sumPoints += calculatePoints($qst_rsp_map[$qstNum]);
                         }
                     }
                     
                     // Calcule a porcentagem
                     $percentage = ($sumPoints / $totalQst) * 100;
                     $percentageFormatted = round($percentage) . "%";
                     
                     // Exiba a última célula com o total e a porcentagem
                     echo "<td >2({$percentageFormatted})</td>";
                     ?>
                  <td><?php $qstsLinha = [1, 4]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">2. Sorrir</td>
                  <td <?php if(isset($qst_rsp_map[2])) echo "style='" . getBackgroundColor($qst_rsp_map[2]) . "'"; ?>><?php echo 2; ?></td>
                  <td <?php if(isset($qst_rsp_map[6])) echo "style='" . getBackgroundColor($qst_rsp_map[6]) . "'"; ?>><?php echo 6; ?></td>
                  <td <?php if(isset($qst_rsp_map[7])) echo "style='" . getBackgroundColor($qst_rsp_map[7]) . "'"; ?>><?php echo 7; ?></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <?php
                     // Defina os qsts presentes na linha
                     $qsts = [2, 6, 7];
                     $totalQst = 3;
                     
                     // Inicialize a soma de pontos
                     $sumPoints = 0.0;
                     
                     // Calcule a soma de pontos
                     foreach ($qsts as $qstNum) {
                         if (isset($qst_rsp_map[$qstNum])) {
                             $sumPoints += calculatePoints($qst_rsp_map[$qstNum]);
                         }
                     }
                     
                     // Calcule a porcentagem
                     $percentage = ($sumPoints / $totalQst) * 100;
                     $percentageFormatted = round($percentage) . "%";
                     
                     // Exiba a última célula com o total e a porcentagem
                     echo "<td >3({$percentageFormatted})</td>";
                     ?>
                  <td><?php $qstsLinha = [2, 6, 7]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">3. Vocalização</td>
                  <td <?php if(isset($qst_rsp_map[3])) echo "style='" . getBackgroundColor($qst_rsp_map[3]) . "'"; ?>><?php echo 3; ?></td>
                  <td <?php if(isset($qst_rsp_map[7])) echo "style='" . getBackgroundColor($qst_rsp_map[7]) . "'"; ?>><?php echo 7; ?></td>
                  <td <?php if(isset($qst_rsp_map[17])) echo "style='" . getBackgroundColor($qst_rsp_map[17]) . "'"; ?>><input type="checkbox" name="qst83" value="83" class="custom-checkbox"><?php echo 17; ?></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td >3</td>
                  <td><?php $qstsLinha = [3, 7, 17]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">4. Reatividade ao contato humano</td>
                  <td <?php if(isset($qst_rsp_map[5])) echo "style='" . getBackgroundColor($qst_rsp_map[5]) . "'"; ?>><?php echo 5; ?></td>
                  <td colspan="4"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">5. Acariciar/abraçar</td>
                  <td <?php if(isset($qst_rsp_map[8])) echo "style='" . getBackgroundColor($qst_rsp_map[8]) . "'"; ?>><?php echo 8; ?></td>
                  <td <?php if(isset($qst_rsp_map[23])) echo "style='" . getBackgroundColor($qst_rsp_map[23]) . "'"; ?>><?php echo 23; ?></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[35])) echo "style='" . getBackgroundColor($qst_rsp_map[35]) . "'"; ?>><?php echo 35; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td><?php $qstsLinha = [8, 23, 35]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">6. Estender mãos/braços em direção a ...</td>
                  <td <?php if(isset($qst_rsp_map[9])) echo "style='" . getBackgroundColor($qst_rsp_map[9]) . "'"; ?>><?php echo 9; ?></td>
                  <td <?php if(isset($qst_rsp_map[10])) echo "style='" . getBackgroundColor($qst_rsp_map[10]) . "'"; ?>><?php echo 10; ?></td>
                  <td <?php if(isset($qst_rsp_map[11])) echo "style='" . getBackgroundColor($qst_rsp_map[11]) . "'"; ?>><?php echo 11; ?></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>3</td>
                  <td><?php $qstsLinha = [9, 10, 11]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">7. Manipular objetos</td>
                  <td <?php if(isset($qst_rsp_map[12])) echo "style='" . getBackgroundColor($qst_rsp_map[12]) . "'"; ?>><?php echo 12; ?></td>
                  <td <?php if(isset($qst_rsp_map[13])) echo "style='" . getBackgroundColor($qst_rsp_map[13]) . "'"; ?>><?php echo 13; ?></td>
                  <td <?php if(isset($qst_rsp_map[25])) echo "style='" . getBackgroundColor($qst_rsp_map[25]) . "'"; ?>><?php echo 25; ?></td>
                  <td <?php if(isset($qst_rsp_map[26])) echo "style='" . getBackgroundColor($qst_rsp_map[26]) . "'"; ?>><?php echo 26; ?></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[34])) echo "style='" . getBackgroundColor($qst_rsp_map[34]) . "'"; ?>><?php echo 34; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>5</td>
                  <td><?php $qstsLinha = [12, 13, 25, 26, 34]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">8. Brincar</td>
                  <td <?php if(isset($qst_rsp_map[14])) echo "style='" . getBackgroundColor($qst_rsp_map[14]) . "'"; ?>><?php echo 14; ?></td>
                  <td <?php if(isset($qst_rsp_map[16])) echo "style='" . getBackgroundColor($qst_rsp_map[16]) . "'"; ?>><?php echo 16; ?></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[30])) echo "style='" . getBackgroundColor($qst_rsp_map[30]) . "'"; ?>><?php echo 30; ?></td>
                  <td <?php if(isset($qst_rsp_map[31])) echo "style='" . getBackgroundColor($qst_rsp_map[31]) . "'"; ?>><?php echo 31; ?></td>
                  <td <?php if(isset($qst_rsp_map[41])) echo "style='" . getBackgroundColor($qst_rsp_map[41]) . "'"; ?>><?php echo 41; ?></td>
                  <td <?php if(isset($qst_rsp_map[49])) echo "style='" . getBackgroundColor($qst_rsp_map[49]) . "'"; ?>><?php echo 49; ?></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[63])) echo "style='" . getBackgroundColor($qst_rsp_map[63]) . "'"; ?>><?php echo 63; ?></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[70])) echo "style='" . getBackgroundColor($qst_rsp_map[70]) . "'"; ?>><?php echo 70; ?></td>
                  <td <?php if(isset($qst_rsp_map[74])) echo "style='" . getBackgroundColor($qst_rsp_map[74]) . "'"; ?>><?php echo 74; ?></td>
                  <td ></td>
                  <td>9</td>
                  <td><?php $qstsLinha = [14, 16, 30, 31, 41, 49, 63, 70, 74]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">9. Contato Visual</td>
                  <td <?php if(isset($qst_rsp_map[15])) echo "style='" . getBackgroundColor($qst_rsp_map[15]) . "'"; ?>><?php echo 15; ?></td>
                  <td colspan="4"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">10. Imitação Motora</td>
                  <td <?php if(isset($qst_rsp_map[18])) echo "style='" . getBackgroundColor($qst_rsp_map[18]) . "'"; ?>><?php echo 18; ?></td>
                  <td <?php if(isset($qst_rsp_map[19])) echo "style='" . getBackgroundColor($qst_rsp_map[19]) . "'"; ?>><?php echo 19; ?></td>
                  <td <?php if(isset($qst_rsp_map[20])) echo "style='" . getBackgroundColor($qst_rsp_map[20]) . "'"; ?>><?php echo 20; ?></td>
                  <td <?php if(isset($qst_rsp_map[21])) echo "style='" . getBackgroundColor($qst_rsp_map[21]) . "'"; ?>><?php echo 21; ?></td>
                  <td <?php if(isset($qst_rsp_map[28])) echo "style='" . getBackgroundColor($qst_rsp_map[28]) . "'"; ?>><?php echo 28; ?></td>
                  <td <?php if(isset($qst_rsp_map[29])) echo "style='" . getBackgroundColor($qst_rsp_map[29]) . "'"; ?>><?php echo 29; ?></td>
                  <td <?php if(isset($qst_rsp_map[36])) echo "style='" . getBackgroundColor($qst_rsp_map[36]) . "'"; ?>><?php echo 36; ?></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td <?php if(isset($qst_rsp_map[76])) echo "style='" . getBackgroundColor($qst_rsp_map[76]) . "'"; ?>><?php echo 76; ?></td>
                  <td></td>
                  <td>8</td>
                  <td><?php $qstsLinha = [18, 19, 20, 21, 28, 29, 36]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">11. Dar/ Compartilhar objetos</td>
                  <td <?php if(isset($qst_rsp_map[22])) echo "style='" . getBackgroundColor($qst_rsp_map[22]) . "'"; ?>><?php echo 22; ?></td>
                  <td <?php if(isset($qst_rsp_map[27])) echo "style='" . getBackgroundColor($qst_rsp_map[27]) . "'"; ?>><?php echo 27; ?></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[37])) echo "style='" . getBackgroundColor($qst_rsp_map[37]) . "'"; ?>><?php echo 37; ?></td>
                  <td <?php if(isset($qst_rsp_map[42])) echo "style='" . getBackgroundColor($qst_rsp_map[42]) . "'"; ?>><?php echo 42; ?></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>4</td>
                  <td><?php $qstsLinha = [22, 27, 37, 42]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">12. Discriminação Auditiva</td>
                  <td <?php if(isset($qst_rsp_map[24])) echo "style='" . getBackgroundColor($qst_rsp_map[24]) . "'"; ?>><?php echo 24; ?></td>
                  <td colspan="4"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">13. Independência dos pais</td>
                  <td colspan="5"></td>
                  <td <?php if(isset($qst_rsp_map[32])) echo "style='" . getBackgroundColor($qst_rsp_map[32]) . "'"; ?>><?php echo 32; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">14. Exploração do ambiente</td>
                  <td colspan="5"></td>
                  <td <?php if(isset($qst_rsp_map[33])) echo "style='" . getBackgroundColor($qst_rsp_map[33]) . "'"; ?>><?php echo 33; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">15. Puxar pessoas para mostrar</td>
                  <td colspan="5"></td>
                  <td <?php if(isset($qst_rsp_map[38])) echo "style='" . getBackgroundColor($qst_rsp_map[38]) . "'"; ?>><?php echo 38; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">16. Cumprimentar</td>
                  <td colspan="5"></td>
                  <td <?php if(isset($qst_rsp_map[43])) echo "style='" . getBackgroundColor($qst_rsp_map[43]) . "'"; ?>><?php echo 43; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[54])) echo "style='" . getBackgroundColor($qst_rsp_map[54]) . "'"; ?>><?php echo 54; ?></td>
                  <td colspan="2"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>2</td>
                  <td><?php $qstsLinha = [43, 54]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">17. Seguir ordens/ Instruções</td>
                  <td colspan="5"></td>
                  <td <?php if(isset($qst_rsp_map[39])) echo "style='" . getBackgroundColor($qst_rsp_map[39]) . "'"; ?>><?php echo 39; ?></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[44])) echo "style='" . getBackgroundColor($qst_rsp_map[44]) . "'"; ?>><?php echo 44; ?></td>
                  <td <?php if(isset($qst_rsp_map[45])) echo "style='" . getBackgroundColor($qst_rsp_map[45]) . "'"; ?>><?php echo 45; ?></td>
                  <td <?php if(isset($qst_rsp_map[61])) echo "style='" . getBackgroundColor($qst_rsp_map[61]) . "'"; ?>><?php echo 61; ?></td>
                  <td colspan="2"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>4</td>
                  <td><?php $qstsLinha = [39, 44, 45, 61]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">18. Esperar a vez</td>
                  <td colspan="5"></td>
                  <td <?php if(isset($qst_rsp_map[40])) echo "style='" . getBackgroundColor($qst_rsp_map[40]) . "'"; ?>><?php echo 40; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[59])) echo "style='" . getBackgroundColor($qst_rsp_map[59]) . "'"; ?>><?php echo 59; ?></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[69])) echo "style='" . getBackgroundColor($qst_rsp_map[69]) . "'"; ?>><?php echo 69; ?></td>
                  <td colspan="2"></td>
                  <td>3</td>
                  <td><?php $qstsLinha = [40, 59, 69]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">19. Prestar atenção</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[46])) echo "style='" . getBackgroundColor($qst_rsp_map[46]) . "'"; ?>><?php echo 46; ?></td>
                  <td></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">20. Agradecer</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[47])) echo "style='" . getBackgroundColor($qst_rsp_map[47]) . "'"; ?>><?php echo 47; ?></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[57])) echo "style='" . getBackgroundColor($qst_rsp_map[57]) . "'"; ?>><?php echo 57; ?></td>
                  <td colspan="2"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>2</td>
                  <td><?php $qstsLinha = [47, 57]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">21. Ajudar</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[48])) echo "style='" . getBackgroundColor($qst_rsp_map[48]) . "'"; ?>><?php echo 48; ?></td>
                  <td ></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">22. Escolher</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[50])) echo "style='" . getBackgroundColor($qst_rsp_map[50]) . "'"; ?>><?php echo 50; ?></td>
                  <td></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[80])) echo "style='" . getBackgroundColor($qst_rsp_map[80]) . "'"; ?>><?php echo 80; ?></td>
                  <td></td>
                  <td>2</td>
                  <td><?php $qstsLinha = [50, 80]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">23. Expressão de sentimentos</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[51])) echo "style='" . getBackgroundColor($qst_rsp_map[51]) . "'"; ?>><?php echo 51; ?></td>
                  <td></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[73])) echo "style='" . getBackgroundColor($qst_rsp_map[73]) . "'"; ?>><?php echo 73; ?></td>
                  <td <?php if(isset($qst_rsp_map[79])) echo "style='" . getBackgroundColor($qst_rsp_map[79]) . "'"; ?>><?php echo 79; ?></td>
                  <td>3</td>
                  <td><?php $qstsLinha = [51, 73, 79]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">24. Cantar/dançar</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[52])) echo "style='" . getBackgroundColor($qst_rsp_map[52]) . "'"; ?>><?php echo 52; ?></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[66])) echo "style='" . getBackgroundColor($qst_rsp_map[66]) . "'"; ?>><?php echo 66; ?></td>
                  <td colspan="2"></td>
                  <td>2</td>
                  <td><?php $qstsLinha = [52, 66]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">25. Seguir regras de jogo</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[53])) echo "style='" . getBackgroundColor($qst_rsp_map[53]) . "'"; ?>><?php echo 53; ?></td>
                  <td <?php if(isset($qst_rsp_map[55])) echo "style='" . getBackgroundColor($qst_rsp_map[55]) . "'"; ?>><?php echo 55; ?></td>
                  <td <?php if(isset($qst_rsp_map[60])) echo "style='" . getBackgroundColor($qst_rsp_map[60]) . "'"; ?>><?php echo 60; ?></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[78])) echo "style='" . getBackgroundColor($qst_rsp_map[78]) . "'"; ?>><?php echo 78; ?></td>
                  <td></td>
                  <td>4</td>
                  <td><?php $qstsLinha = [53, 55, 60, 78]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">26. Pedir permissão</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[56])) echo "style='" . getBackgroundColor($qst_rsp_map[56]) . "'"; ?>><?php echo 56; ?></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[72])) echo "style='" . getBackgroundColor($qst_rsp_map[72]) . "'"; ?>><?php echo 72; ?></td>
                  <td colspan="2"></td>
                  <td>2</td>
                  <td><?php $qstsLinha = [56, 72]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">27. Falar ao telefone</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[58])) echo "style='" . getBackgroundColor($qst_rsp_map[58]) . "'"; ?>><?php echo 58; ?></td>
                  <td colspan="2"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">28. Permanecer em sua área</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[62])) echo "style='" . getBackgroundColor($qst_rsp_map[62]) . "'"; ?>><?php echo 62; ?></td>
                  <td colspan="2"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">29. Pedir ajuda</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[64])) echo "style='" . getBackgroundColor($qst_rsp_map[64]) . "'"; ?>><?php echo 64; ?></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">30. Verbalizar para adultos</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[65])) echo "style='" . getBackgroundColor($qst_rsp_map[65]) . "'"; ?>><?php echo 65; ?></td>
                  <td <?php if(isset($qst_rsp_map[77])) echo "style='" . getBackgroundColor($qst_rsp_map[77]) . "'"; ?>><?php echo 77; ?></td>
                  <td></td>
                  <td>2</td>
                  <td><?php $qstsLinha = [65, 77]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">31. Fazer tarefa sozinho</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[67])) echo "style='" . getBackgroundColor($qst_rsp_map[67]) . "'"; ?>><?php echo 67; ?></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">32. Pedir desculpas</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[68])) echo "style='" . getBackgroundColor($qst_rsp_map[68]) . "'"; ?>><?php echo 68; ?></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">33. Comportamentos aceitáveis em público</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[71])) echo "style='" . getBackgroundColor($qst_rsp_map[71]) . "'"; ?>><?php echo 71; ?></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">34. Explicar regras</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[75])) echo "style='" . getBackgroundColor($qst_rsp_map[75]) . "'"; ?>><?php echo 75; ?></td>
                  <td></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">35. Usar ferramentas</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[81])) echo "style='" . getBackgroundColor($qst_rsp_map[81]) . "'"; ?>><?php echo 81; ?></td>
                  <td></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">36. Estabelecer metas para si</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[82])) echo "style='" . getBackgroundColor($qst_rsp_map[82]) . "'"; ?>><?php echo 82; ?></td>
                  <td></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">37. Dramatizar</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[83])) echo "style='" . getBackgroundColor($qst_rsp_map[83]) . "'"; ?>><?php echo 83; ?></td>
                  <td></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <th class="titulo-cabecalho">Total de classes: "Novas"</th>
                  <th colspan="5" class="titulo-cabecalho">12</th>
                  <th colspan="3" class="titulo-cabecalho">6</th>
                  <th colspan="2" class="titulo-cabecalho">5</th>
                  <th colspan="3" class="titulo-cabecalho">5</th>
                  <th class="titulo-cabecalho">5</th>
                  <th colspan="2" class="titulo-cabecalho">4</th>
                  <th colspan="2" class="titulo-cabecalho">TI: 84*</th>
               </tr>
               <tr>
                  <th class="titulo-cabecalho">Total de classes: "Antigas"</th>
                  <th colspan="5" class="titulo-cabecalho"></th>
                  <th colspan="3" class="titulo-cabecalho">5</th>
                  <th colspan="2" class="titulo-cabecalho">2</th>
                  <th colspan="3" class="titulo-cabecalho">5</th>
                  <th class="titulo-cabecalho">3</th>
                  <th colspan="2" class="titulo-cabecalho">6</th>
                  <th colspan="2" class="titulo-cabecalho">TC: 37</th>
               </tr>
            </tbody>
         </table>
         <p><i class='fa fa-exclamation-circle' style='color: red;'></i> = Inconsistência nas respostas</p>
         <hr>
      </div>
      <!-- relatório -->
      <div id="autocuidado_relatorio" class="tab-pane fade" role="tabpanel" aria-labelledby="autocuidado_relatorio">
         <h5>Relatório de Autocuidado</h5>
      </div>
   </div>
</div>

<!-- Área Motor -->
<div id="motor" class="tab-pane fade" role="tabpanel" aria-labelledby="motor-tab">
   <h4>Habilidades de Socialização</h4>
   <!-- Sub-abas de faixas etárias para Motor -->
   <ul class="nav nav-tabs mt-3" role="tablist">
      <li class="nav-item">
         <a class="nav-link active" id="motor0_1-tab" href="#motor0_1" data-toggle="tab" role="tab" aria-controls="motor0_1" aria-selected="true">0-1 ano</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="motor1_2-tab" href="#motor1_2" data-toggle="tab" role="tab" aria-controls="motor1_2" aria-selected="false">1-2 anos</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="motor2_3-tab" href="#motor2_3" data-toggle="tab" role="tab" aria-controls="motor2_3" aria-selected="false">2-3 anos</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="motor3_4-tab" href="#motor3_4" data-toggle="tab" role="tab" aria-controls="motor3_4" aria-selected="false">3-4 anos</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="motor4_5-tab" href="#motor4_5" data-toggle="tab" role="tab" aria-controls="motor4_5" aria-selected="false">4-5 anos</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="motor5_6-tab" href="#motor5_6" data-toggle="tab" role="tab" aria-controls="motor5_6" aria-selected="false">5-6 anos</a>
         </li>
      <li class="nav-item">
         <a class="nav-link" id="motor_classes-tab" href="#motor_classes" data-toggle="tab" role="tab" aria-controls="motor_classes" aria-selected="false">Classes</a>
      </li>
      <li class="nav-item">
         <a class="nav-link" id="motor_relatorio-tab" href="#motor_relatorio" data-toggle="tab" role="tab" aria-controls="motor_relatorio" aria-selected="false">Relatório</a>
      </li>
   </ul>
   <div class="tab-content nested-tab-content">
      <!-- Faixa 0-1 ano - Motor -->
      <div id="motor0_1" class="tab-pane fade show active" role="tabpanel" aria-labelledby="motor0_1-tab">
         <h5>Faixa Etária 0-1 ano</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <!-- M1 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M1 - Alcança um objeto colocado a sua frente (distância de 15 a 20 cm).</div>
                     <div class="skill-description">A criança estende a mão para pegar um objeto posicionado à sua frente dentro da distância especificada.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item0" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item0" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item0" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item0" value="X" disabled>
                  </td>
               </tr>
               <!-- M2 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M2 - Apanha um objeto colocado a sua frente (8 cm).</div>
                     <div class="skill-description">A criança consegue pegar um objeto colocado a uma distância de 8 cm à sua frente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item1" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item1" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item1" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item1" value="X" disabled>
                  </td>
               </tr>
               <!-- M3 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M3 - Estende os braços em direção a um objeto colocado à sua frente e o apanha.</div>
                     <div class="skill-description">A criança estende os braços para alcançar e pegar um objeto posicionado à sua frente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item2" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item2" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item2" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item2" value="X" disabled>
                  </td>
               </tr>
               <!-- M4 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M4 - Alcança um objeto preferido.</div>
                     <div class="skill-description">A criança estende a mão para pegar seu objeto favorito.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item3" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item3" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item3" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item3" value="X" disabled>
                  </td>
               </tr>
               <!-- M5 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M5 - Coloca objetos na boca.</div>
                     <div class="skill-description">A criança leva objetos até a boca para explorá-los.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item4" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item4" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item4" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item4" value="X" disabled>
                  </td>
               </tr>
               <!-- M6 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M6 - Eleva a cabeça e o tronco, apoiando-se nos braços deitado de barriga para baixo.</div>
                     <div class="skill-description">A criança levanta a cabeça e o tronco enquanto está deitada de barriga para baixo, sustentando-se com os braços.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item5" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item5" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item5" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item5" value="X" disabled>
                  </td>
               </tr>
               <!-- M7 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M7 - Levanta a cabeça e tronco apoiando-se em um só braço.</div>
                     <div class="skill-description">A criança consegue levantar a cabeça e o tronco enquanto se apoia em apenas um braço.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item6" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item6" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item6" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item6" value="X" disabled>
                  </td>
               </tr>
               <!-- M8 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M8 - Toca e explora objetos com a boca.</div>
                     <div class="skill-description">A criança utiliza a boca para explorar texturas e formas de objetos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item7" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item7" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item7" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item7" value="X" disabled>
                  </td>
               </tr>
               <!-- M9 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M9 - Estando de barriga para baixo, vira de lado, mantém posição em 50% das vezes.</div>
                     <div class="skill-description">A criança consegue virar de lado enquanto está de barriga para baixo, mantendo a posição metade das tentativas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item8" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item8" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item8" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item8" value="X" disabled>
                  </td>
               </tr>
               <!-- M10 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M10 - Estando de barriga para baixo, vira de costas.</div>
                     <div class="skill-description">A criança consegue se virar completamente para as costas enquanto está de barriga para baixo.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item9" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item9" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item9" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item9" value="X" disabled>
                  </td>
               </tr>
               <!-- M11 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M11 - De barriga para baixo, move-se para frente (equivalente à altura do corpo).</div>
                     <div class="skill-description">A criança consegue mover-se para frente enquanto está de barriga para baixo, percorrendo uma distância equivalente à sua altura corporal.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item10" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item10" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item10" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item10" value="X" disabled>
                  </td>
               </tr>
               <!-- M12 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M12 - Deitado de costas, rola para o lado.</div>
                     <div class="skill-description">A criança consegue rolar para o lado enquanto está deitada de costas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item11" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item11" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item11" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item11" value="X" disabled>
                  </td>
               </tr>
               <!-- M13 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M13 - Deitado de costas, vira de barriga para baixo.</div>
                     <div class="skill-description">A criança consegue virar de costas para barriga enquanto está deitada.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item12" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item12" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item12" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item12" value="X" disabled>
                  </td>
               </tr>
               <!-- M14 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M14 - Faz esforço para sentar-se, segurando-se nos dedos de um adulto.</div>
                     <div class="skill-description">A criança tenta sentar-se utilizando os dedos de um adulto como apoio.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item13" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item13" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item13" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item13" value="X" disabled>
                  </td>
               </tr>
               <!-- M15 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M15 - Vira a cabeça com facilidade, quando o corpo está apoiado.</div>
                     <div class="skill-description">A criança consegue girar a cabeça facilmente enquanto seu corpo está apoiado.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item14" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item14" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item14" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item14" value="X" disabled>
                  </td>
               </tr>
               <!-- M16 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M16 - Mantém-se sentado por dois minutos.</div>
                     <div class="skill-description">A criança consegue permanecer sentada sem apoio por um período de dois minutos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item15" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item15" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item15" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item15" value="X" disabled>
                  </td>
               </tr>
               <!-- M17 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M17 - Solta um objeto deliberadamente para apanhar outro.</div>
                     <div class="skill-description">A criança intencionalmente solta um objeto que está segurando para pegar outro.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item16" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item16" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item16" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item16" value="X" disabled>
                  </td>
               </tr>
               <!-- M18 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M18 - Apanha e deixa cair um objeto propositalmente.</div>
                     <div class="skill-description">A criança pega um objeto e o solta de propósito.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item17" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item17" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item17" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item17" value="X" disabled>
                  </td>
               </tr>
               <!-- M19 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M19 - Fica em pé com o máximo de apoio.</div>
                     <div class="skill-description">A criança consegue ficar de pé utilizando o máximo de apoio possível.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item18" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item18" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item18" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item18" value="X" disabled>
                  </td>
               </tr>
               <!-- M20 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M20 - Estando de pé, com apoio, pula para cima e para baixo.</div>
                     <div class="skill-description">A criança consegue realizar pequenos saltos para cima e para baixo enquanto está de pé, utilizando apoio.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item19" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item19" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item19" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item19" value="X" disabled>
                  </td>
               </tr>
               <!-- M21 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M21 - Engatinha para apanhar um objeto (distância igual à altura do corpo).</div>
                     <div class="skill-description">A criança se movimenta engatinhando para alcançar um objeto situado a uma distância igual à sua altura corporal.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item20" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item20" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item20" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item20" value="X" disabled>
                  </td>
               </tr>
               <!-- M22 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M22 - Senta-se apoiando-se sozinho.</div>
                     <div class="skill-description">A criança consegue sentar-se sem apoio adicional.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item21" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item21" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item21" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item21" value="X" disabled>
                  </td>
               </tr>
               <!-- M23 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M23 - Estando sentado, vira de gatinhas.</div>
                     <div class="skill-description">A criança consegue girar o corpo de uma posição sentada para a posição de gatinhas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item22" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item22" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item22" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item22" value="X" disabled>
                  </td>
               </tr>
               <!-- M24 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M24 - Estando de barriga para baixo, consegue sentar-se.</div>
                     <div class="skill-description">A criança consegue mover-se de uma posição de barriga para baixo para sentar-se.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item23" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item23" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item23" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item23" value="X" disabled>
                  </td>
               </tr>
               <!-- M25 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M25 - Senta-se sem apoiar as mãos.</div>
                     <div class="skill-description">A criança consegue sentar-se sem utilizar as mãos para apoio.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item24" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item24" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item24" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item24" value="X" disabled>
                  </td>
               </tr>
               <!-- M26 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M26 - Atira objetos ao acaso.</div>
                     <div class="skill-description">A criança lança objetos de forma aleatória, sem direcionamento específico.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item25" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item25" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item25" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item25" value="X" disabled>
                  </td>
               </tr>
               <!-- M27 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M27 - Balança para frente e para trás, estando de gatinhas.</div>
                     <div class="skill-description">A criança move-se balançando o corpo para frente e para trás enquanto está na posição de gatinhas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item26" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item26" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item26" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item26" value="X" disabled>
                  </td>
               </tr>
               <!-- M28 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M28 - Transfere objetos de uma mão para outra, estando sentado.</div>
                     <div class="skill-description">A criança consegue mover objetos de uma mão para a outra enquanto está sentada.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item27" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item27" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item27" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item27" value="X" disabled>
                  </td>
               </tr>
               <!-- M29 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M29 - Retêm em uma das mãos dois cubos de 2,5 cm.</div>
                     <div class="skill-description">A criança consegue segurar dois cubos de 2,5 cm de lado em uma das mãos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item28" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item28" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item28" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item28" value="X" disabled>
                  </td>
               </tr>
               <!-- M30 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M30 - Fica de joelhos.</div>
                     <div class="skill-description">A criança consegue apoiar-se nos joelhos enquanto está de pé ou em movimento.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item29" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item29" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item29" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item29" value="X" disabled>
                  </td>
               </tr>
               <!-- M31 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M31 - Fica em pé, apoiando-se em algo.</div>
                     <div class="skill-description">A criança consegue ficar de pé utilizando algum tipo de apoio, como móveis ou brinquedos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item30" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item30" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item30" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item30" value="X" disabled>
                  </td>
               </tr>
               <!-- M32 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M32 - Usa preensão de pinça para pegar objetos.</div>
                     <div class="skill-description">A criança utiliza o polegar e o indicador para pegar pequenos objetos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item31" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item31" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item31" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item31" value="X" disabled>
                  </td>
               </tr>
               <!-- M33 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M33 - Engatinha.</div>
                     <div class="skill-description">A criança se movimenta engatinhando.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item32" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item32" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item32" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item32" value="X" disabled>
                  </td>
               </tr>
               <!-- M34 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M34 - Estando de gatinhas, estende uma das mãos para o alto, tentando alcançar algo.</div>
                     <div class="skill-description">A criança tenta alcançar objetos acima dela enquanto está na posição de gatinhas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item33" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item33" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item33" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item33" value="X" disabled>
                  </td>
               </tr>
               <!-- M35 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M35 - Fica em pé com o mínimo de apoio.</div>
                     <div class="skill-description">A criança consegue ficar de pé utilizando o mínimo de apoio possível.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item34" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item34" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item34" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item34" value="X" disabled>
                  </td>
               </tr>
               <!-- M36 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M36 - Lambe a comida ao redor da boca.</div>
                     <div class="skill-description">A criança utiliza a língua para limpar resíduos de comida ao redor da boca.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item35" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item35" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item35" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item35" value="X" disabled>
                  </td>
               </tr>
               <!-- M37 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M37 - Mantém-se em pé, sozinho, por um minuto.</div>
                     <div class="skill-description">A criança consegue permanecer em pé sem apoio por um minuto.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item36" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item36" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item36" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item36" value="X" disabled>
                  </td>
               </tr>
               <!-- M38 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M38 - Derruba um objeto que está dentro de um recipiente.</div>
                     <div class="skill-description">A criança consegue derrubar objetos de dentro de um recipiente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item37" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item37" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item37" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item37" value="X" disabled>
                  </td>
               </tr>
               <!-- M39 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M39 - Vira páginas de um livro (várias ao mesmo tempo).</div>
                     <div class="skill-description">A criança tenta virar múltiplas páginas de um livro simultaneamente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item38" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item38" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item38" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item38" value="X" disabled>
                  </td>
               </tr>
               <!-- M40 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M40 - Escava com uma colher ou pá.</div>
                     <div class="skill-description">A criança utiliza uma colher ou pá para escavar materiais como areia ou terra.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item39" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item39" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item39" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item39" value="X" disabled>
                  </td>
               </tr>
               <!-- M41 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M41 - Coloca pequenos objetos dentro de um recipiente.</div>
                     <div class="skill-description">A criança consegue inserir objetos pequenos dentro de um recipiente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item40" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item40" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item40" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item40" value="X" disabled>
                  </td>
               </tr>
               <!-- M42 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M42 - Estando em pé, abaixa-se e senta-se.</div>
                     <div class="skill-description">A criança consegue abaixar-se e sentar-se enquanto está em pé.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item41" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item41" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item41" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item41" value="X" disabled>
                  </td>
               </tr>
               <!-- M43 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M43 - Bate palmas.</div>
                     <div class="skill-description">A criança realiza o gesto de bater palmas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item42" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item42" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item42" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item42" value="X" disabled>
                  </td>
               </tr>
               <!-- M44 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M44 - Anda com um mínimo de apoio.</div>
                     <div class="skill-description">A criança dá passos enquanto se apoia em móveis ou outros suportes.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item43" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item43" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item43" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item43" value="X" disabled>
                  </td>
               </tr>
               <!-- M45 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M45 - Dá alguns passos sem apoio.</div>
                     <div class="skill-description">A criança consegue dar alguns passos sem utilizar apoio adicional.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item44" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item44" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item44" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item44" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Faixa 1-2 anos - Motor -->
      <div id="motor1_2" class="tab-pane fade" role="tabpanel" aria-labelledby="motor1_2-tab">
         <h5>Faixa Etária 1-2 anos</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <!-- M46 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M46 - Sobe escadas engatinhando.</div>
                     <div class="skill-description">A criança consegue subir escadas utilizando a posição de engatinhar.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item46" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item46" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item46" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item46" value="X" disabled>
                  </td>
               </tr>
               <!-- M47 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M47 - Coloca-se em pé, estando sentado.</div>
                     <div class="skill-description">A criança consegue se levantar para ficar em pé a partir de uma posição sentada.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item47" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item47" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item47" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item47" value="X" disabled>
                  </td>
               </tr>
               <!-- M48 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M48 - Rola uma bola imitando um adulto.</div>
                     <div class="skill-description">A criança consegue rolar uma bola seguindo o exemplo de um adulto.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item48" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item48" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item48" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item48" value="X" disabled>
                  </td>
               </tr>
               <!-- M49 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M49 - Sobe em uma cadeira de adulto, vira-se e senta-se.</div>
                     <div class="skill-description">A criança consegue subir em uma cadeira de adulto, girar-se e sentar-se novamente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item49" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item49" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item49" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item49" value="X" disabled>
                  </td>
               </tr>
               <!-- M50 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M50 - Coloca quatro aros em uma pequena estaca.</div>
                     <div class="skill-description">A criança consegue posicionar quatro aros em uma estaca pequena.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item50" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item50" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item50" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item50" value="X" disabled>
                  </td>
               </tr>
               <!-- M51 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M51 - Retira pinos de 2,5 de uma prancha ou tabuleiro de encaixe.</div>
                     <div class="skill-description">A criança consegue retirar pinos de 2,5 cm de uma prancha ou tabuleiro de encaixe.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item51" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item51" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item51" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item51" value="X" disabled>
                  </td>
               </tr>
               <!-- M52 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M52 - Encaixa pinos de 2,5 em uma prancha de encaixe.</div>
                     <div class="skill-description">A criança consegue encaixar pinos de 2,5 cm em uma prancha de encaixe.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item52" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item52" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item52" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item52" value="X" disabled>
                  </td>
               </tr>
               <!-- M53 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M53 - Constrói uma torre de três blocos.</div>
                     <div class="skill-description">A criança consegue empilhar três blocos para construir uma torre.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item53" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item53" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item53" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item53" value="X" disabled>
                  </td>
               </tr>
               <!-- M54 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M54 - Faz traços no papel com lápis de cera.</div>
                     <div class="skill-description">A criança consegue fazer traços simples no papel utilizando um lápis de cera.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item54" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item54" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item54" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item54" value="X" disabled>
                  </td>
               </tr>
               <!-- M55 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M55 - Anda sozinho.</div>
                     <div class="skill-description">A criança consegue dar passos e andar sem apoio.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item55" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item55" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item55" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item55" value="X" disabled>
                  </td>
               </tr>
               <!-- M56 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M56 - Desce as escadas sentado, colocando primeiro os pés.</div>
                     <div class="skill-description">A criança consegue descer escadas sentado, colocando os pés primeiro.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item56" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item56" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item56" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item56" value="X" disabled>
                  </td>
               </tr>
               <!-- M57 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M57 - Senta-se em uma cadeirinha.</div>
                     <div class="skill-description">A criança consegue sentar-se de forma independente em uma cadeirinha.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item57" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item57" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item57" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item57" value="X" disabled>
                  </td>
               </tr>
               <!-- M58 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M58 - Agacha-se e volta a ficar em pé.</div>
                     <div class="skill-description">A criança consegue agachar-se e levantar-se novamente sem cair.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item58" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item58" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item58" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item58" value="X" disabled>
                  </td>
               </tr>
               <!-- M59 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M59 - Empurra e puxa brinquedos ao andar.</div>
                     <div class="skill-description">A criança consegue empurrar e puxar brinquedos enquanto anda.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item59" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item59" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item59" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item59" value="X" disabled>
                  </td>
               </tr>
               <!-- M60 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M60 - Usa cadeira ou cavalo de balanço.</div>
                     <div class="skill-description">A criança consegue utilizar uma cadeira ou cavalo de balanço de forma apropriada.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item60" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item60" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item60" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item60" value="X" disabled>
                  </td>
               </tr>
               <!-- M61 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M61 - Sobe escadas com ajuda.</div>
                     <div class="skill-description">A criança consegue subir escadas com auxílio de um adulto.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item61" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item61" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item61" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item61" value="X" disabled>
                  </td>
               </tr>
               <!-- M62 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M62 - Dobra o corpo, sem cair, para apanhar objetos.</div>
                     <div class="skill-description">A criança consegue dobrar o corpo sem perder o equilíbrio para pegar objetos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item62" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item62" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item62" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item62" value="X" disabled>
                  </td>
               </tr>
               <!-- M63 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M63 - Imita o movimento circular.</div>
                     <div class="skill-description">A criança consegue imitar movimentos circulares feitos por um adulto.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item63" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item63" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item63" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor1_2_item63" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Faixa 2-3 anos - Motor -->
      <div id="motor2_3" class="tab-pane fade" role="tabpanel" aria-labelledby="motor2_3-tab">
         <h5>Faixa Etária 2-3 anos</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td>
                     <div class="checkbox-title">Corre com agilidade</div>
                     <div class="skill-description">A criança corre sem cair facilmente, mudando de direção quando necessário.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor2_3_item1" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor2_3_item1" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor2_3_item1" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor2_3_item1" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Faixa 3-4 anos - Motor -->
      <div id="motor3_4" class="tab-pane fade" role="tabpanel" aria-labelledby="motor3_4-tab">
         <h5>Faixa Etária 3-4 anos</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td>
                     <div class="checkbox-title">Pula corda</div>
                     <div class="skill-description">A criança consegue pular corda sem tropeçar.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor3_4_item1" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor3_4_item1" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor3_4_item1" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor3_4_item1" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Faixa 4-5 anos - Motor -->
      <div id="motor4_5" class="tab-pane fade" role="tabpanel" aria-labelledby="motor4_5-tab">
         <h5>Faixa Etária 4-5 anos</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td>
                     <div class="checkbox-title">Fazer movimentos precisos com as mãos</div>
                     <div class="skill-description">A criança realiza atividades que exigem coordenação fina, como desenhar círculos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor4_5_item1" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Faixa 5-6 ano - Motor -->
      <div id="motor5_6" class="tab-pane fade" role="tabpanel" aria-labelledby="motor5_6-tab">
         <h5>Faixa Etária 5-6 ano</h5>
         <table>
            <thead>
               <tr>
                  <th>Habilidade</th>
                  <th class="text-center">Sim</th>
                  <th class="text-center">AV</th>
                  <th class="text-center">Não</th>
                  <th class="text-center">X</th>
               </tr>
            </thead>
            <tbody>
               <!-- M1 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M1 - Alcança um objeto colocado a sua frente (distância de 15 a 20 cm).</div>
                     <div class="skill-description">A criança estende a mão para pegar um objeto posicionado à sua frente dentro da distância especificada.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item0" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item0" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item0" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item0" value="X" disabled>
                  </td>
               </tr>
               <!-- M2 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M2 - Apanha um objeto colocado a sua frente (8 cm).</div>
                     <div class="skill-description">A criança consegue pegar um objeto colocado a uma distância de 8 cm à sua frente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item1" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item1" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item1" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item1" value="X" disabled>
                  </td>
               </tr>
               <!-- M3 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M3 - Estende os braços em direção a um objeto colocado à sua frente e o apanha.</div>
                     <div class="skill-description">A criança estende os braços para alcançar e pegar um objeto posicionado à sua frente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item2" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item2" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item2" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item2" value="X" disabled>
                  </td>
               </tr>
               <!-- M4 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M4 - Alcança um objeto preferido.</div>
                     <div class="skill-description">A criança estende a mão para pegar seu objeto favorito.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item3" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item3" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item3" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item3" value="X" disabled>
                  </td>
               </tr>
               <!-- M5 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M5 - Coloca objetos na boca.</div>
                     <div class="skill-description">A criança leva objetos até a boca para explorá-los.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item4" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item4" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item4" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item4" value="X" disabled>
                  </td>
               </tr>
               <!-- M6 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M6 - Eleva a cabeça e o tronco, apoiando-se nos braços deitado de barriga para baixo.</div>
                     <div class="skill-description">A criança levanta a cabeça e o tronco enquanto está deitada de barriga para baixo, sustentando-se com os braços.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item5" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item5" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item5" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item5" value="X" disabled>
                  </td>
               </tr>
               <!-- M7 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M7 - Levanta a cabeça e tronco apoiando-se em um só braço.</div>
                     <div class="skill-description">A criança consegue levantar a cabeça e o tronco enquanto se apoia em apenas um braço.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item6" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item6" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item6" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item6" value="X" disabled>
                  </td>
               </tr>
               <!-- M8 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M8 - Toca e explora objetos com a boca.</div>
                     <div class="skill-description">A criança utiliza a boca para explorar texturas e formas de objetos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item7" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item7" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item7" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item7" value="X" disabled>
                  </td>
               </tr>
               <!-- M9 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M9 - Estando de barriga para baixo, vira de lado, mantém posição em 50% das vezes.</div>
                     <div class="skill-description">A criança consegue virar de lado enquanto está de barriga para baixo, mantendo a posição metade das tentativas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item8" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item8" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item8" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item8" value="X" disabled>
                  </td>
               </tr>
               <!-- M10 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M10 - Estando de barriga para baixo, vira de costas.</div>
                     <div class="skill-description">A criança consegue se virar completamente para as costas enquanto está de barriga para baixo.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item9" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item9" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item9" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item9" value="X" disabled>
                  </td>
               </tr>
               <!-- M11 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M11 - De barriga para baixo, move-se para frente (equivalente à altura do corpo).</div>
                     <div class="skill-description">A criança consegue mover-se para frente enquanto está de barriga para baixo, percorrendo uma distância equivalente à sua altura corporal.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item10" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item10" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item10" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item10" value="X" disabled>
                  </td>
               </tr>
               <!-- M12 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M12 - Deitado de costas, rola para o lado.</div>
                     <div class="skill-description">A criança consegue rolar para o lado enquanto está deitada de costas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item11" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item11" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item11" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item11" value="X" disabled>
                  </td>
               </tr>
               <!-- M13 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M13 - Deitado de costas, vira de barriga para baixo.</div>
                     <div class="skill-description">A criança consegue virar de costas para barriga enquanto está deitada.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item12" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item12" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item12" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item12" value="X" disabled>
                  </td>
               </tr>
               <!-- M14 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M14 - Faz esforço para sentar-se, segurando-se nos dedos de um adulto.</div>
                     <div class="skill-description">A criança tenta sentar-se utilizando os dedos de um adulto como apoio.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item13" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item13" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item13" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item13" value="X" disabled>
                  </td>
               </tr>
               <!-- M15 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M15 - Vira a cabeça com facilidade, quando o corpo está apoiado.</div>
                     <div class="skill-description">A criança consegue girar a cabeça facilmente enquanto seu corpo está apoiado.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item14" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item14" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item14" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item14" value="X" disabled>
                  </td>
               </tr>
               <!-- M16 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M16 - Mantém-se sentado por dois minutos.</div>
                     <div class="skill-description">A criança consegue permanecer sentada sem apoio por um período de dois minutos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item15" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item15" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item15" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item15" value="X" disabled>
                  </td>
               </tr>
               <!-- M17 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M17 - Solta um objeto deliberadamente para apanhar outro.</div>
                     <div class="skill-description">A criança intencionalmente solta um objeto que está segurando para pegar outro.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item16" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item16" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item16" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item16" value="X" disabled>
                  </td>
               </tr>
               <!-- M18 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M18 - Apanha e deixa cair um objeto propositalmente.</div>
                     <div class="skill-description">A criança pega um objeto e o solta de propósito.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item17" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item17" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item17" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item17" value="X" disabled>
                  </td>
               </tr>
               <!-- M19 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M19 - Fica em pé com o máximo de apoio.</div>
                     <div class="skill-description">A criança consegue ficar de pé utilizando o máximo de apoio possível.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item18" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item18" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item18" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item18" value="X" disabled>
                  </td>
               </tr>
               <!-- M20 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M20 - Estando de pé, com apoio, pula para cima e para baixo.</div>
                     <div class="skill-description">A criança consegue realizar pequenos saltos para cima e para baixo enquanto está de pé, utilizando apoio.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item19" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item19" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item19" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item19" value="X" disabled>
                  </td>
               </tr>
               <!-- M21 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M21 - Engatinha para apanhar um objeto (distância igual à altura do corpo).</div>
                     <div class="skill-description">A criança se movimenta engatinhando para alcançar um objeto situado a uma distância igual à sua altura corporal.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item20" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item20" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item20" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item20" value="X" disabled>
                  </td>
               </tr>
               <!-- M22 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M22 - Senta-se apoiando-se sozinho.</div>
                     <div class="skill-description">A criança consegue sentar-se sem apoio adicional.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item21" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item21" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item21" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item21" value="X" disabled>
                  </td>
               </tr>
               <!-- M23 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M23 - Estando sentado, vira de gatinhas.</div>
                     <div class="skill-description">A criança consegue girar o corpo de uma posição sentada para a posição de gatinhas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item22" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item22" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item22" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item22" value="X" disabled>
                  </td>
               </tr>
               <!-- M24 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M24 - Estando de barriga para baixo, consegue sentar-se.</div>
                     <div class="skill-description">A criança consegue mover-se de uma posição de barriga para baixo para sentar-se.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item23" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item23" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item23" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item23" value="X" disabled>
                  </td>
               </tr>
               <!-- M25 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M25 - Senta-se sem apoiar as mãos.</div>
                     <div class="skill-description">A criança consegue sentar-se sem utilizar as mãos para apoio.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item24" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item24" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item24" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item24" value="X" disabled>
                  </td>
               </tr>
               <!-- M26 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M26 - Atira objetos ao acaso.</div>
                     <div class="skill-description">A criança lança objetos de forma aleatória, sem direcionamento específico.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item25" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item25" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item25" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item25" value="X" disabled>
                  </td>
               </tr>
               <!-- M27 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M27 - Balança para frente e para trás, estando de gatinhas.</div>
                     <div class="skill-description">A criança move-se balançando o corpo para frente e para trás enquanto está na posição de gatinhas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item26" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item26" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item26" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item26" value="X" disabled>
                  </td>
               </tr>
               <!-- M28 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M28 - Transfere objetos de uma mão para outra, estando sentado.</div>
                     <div class="skill-description">A criança consegue mover objetos de uma mão para a outra enquanto está sentada.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item27" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item27" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item27" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item27" value="X" disabled>
                  </td>
               </tr>
               <!-- M29 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M29 - Retêm em uma das mãos dois cubos de 2,5 cm.</div>
                     <div class="skill-description">A criança consegue segurar dois cubos de 2,5 cm de lado em uma das mãos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item28" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item28" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item28" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item28" value="X" disabled>
                  </td>
               </tr>
               <!-- M30 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M30 - Fica de joelhos.</div>
                     <div class="skill-description">A criança consegue apoiar-se nos joelhos enquanto está de pé ou em movimento.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item29" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item29" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item29" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item29" value="X" disabled>
                  </td>
               </tr>
               <!-- M31 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M31 - Fica em pé, apoiando-se em algo.</div>
                     <div class="skill-description">A criança consegue ficar de pé utilizando algum tipo de apoio, como móveis ou brinquedos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item30" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item30" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item30" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item30" value="X" disabled>
                  </td>
               </tr>
               <!-- M32 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M32 - Usa preensão de pinça para pegar objetos.</div>
                     <div class="skill-description">A criança utiliza o polegar e o indicador para pegar pequenos objetos.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item31" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item31" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item31" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item31" value="X" disabled>
                  </td>
               </tr>
               <!-- M33 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M33 - Engatinha.</div>
                     <div class="skill-description">A criança se movimenta engatinhando.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item32" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item32" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item32" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item32" value="X" disabled>
                  </td>
               </tr>
               <!-- M34 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M34 - Estando de gatinhas, estende uma das mãos para o alto, tentando alcançar algo.</div>
                     <div class="skill-description">A criança tenta alcançar objetos acima dela enquanto está na posição de gatinhas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item33" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item33" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item33" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item33" value="X" disabled>
                  </td>
               </tr>
               <!-- M35 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M35 - Fica em pé com o mínimo de apoio.</div>
                     <div class="skill-description">A criança consegue ficar de pé utilizando o mínimo de apoio possível.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item34" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item34" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item34" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item34" value="X" disabled>
                  </td>
               </tr>
               <!-- M36 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M36 - Lambe a comida ao redor da boca.</div>
                     <div class="skill-description">A criança utiliza a língua para limpar resíduos de comida ao redor da boca.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item35" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item35" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item35" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item35" value="X" disabled>
                  </td>
               </tr>
               <!-- M37 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M37 - Mantém-se em pé, sozinho, por um minuto.</div>
                     <div class="skill-description">A criança consegue permanecer em pé sem apoio por um minuto.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item36" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item36" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item36" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item36" value="X" disabled>
                  </td>
               </tr>
               <!-- M38 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M38 - Derruba um objeto que está dentro de um recipiente.</div>
                     <div class="skill-description">A criança consegue derrubar objetos de dentro de um recipiente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item37" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item37" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item37" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item37" value="X" disabled>
                  </td>
               </tr>
               <!-- M39 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M39 - Vira páginas de um livro (várias ao mesmo tempo).</div>
                     <div class="skill-description">A criança tenta virar múltiplas páginas de um livro simultaneamente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item38" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item38" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item38" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item38" value="X" disabled>
                  </td>
               </tr>
               <!-- M40 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M40 - Escava com uma colher ou pá.</div>
                     <div class="skill-description">A criança utiliza uma colher ou pá para escavar materiais como areia ou terra.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item39" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item39" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item39" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item39" value="X" disabled>
                  </td>
               </tr>
               <!-- M41 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M41 - Coloca pequenos objetos dentro de um recipiente.</div>
                     <div class="skill-description">A criança consegue inserir objetos pequenos dentro de um recipiente.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item40" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item40" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item40" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item40" value="X" disabled>
                  </td>
               </tr>
               <!-- M42 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M42 - Estando em pé, abaixa-se e senta-se.</div>
                     <div class="skill-description">A criança consegue abaixar-se e sentar-se enquanto está em pé.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item41" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item41" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item41" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item41" value="X" disabled>
                  </td>
               </tr>
               <!-- M43 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M43 - Bate palmas.</div>
                     <div class="skill-description">A criança realiza o gesto de bater palmas.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item42" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item42" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item42" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item42" value="X" disabled>
                  </td>
               </tr>
               <!-- M44 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M44 - Anda com um mínimo de apoio.</div>
                     <div class="skill-description">A criança dá passos enquanto se apoia em móveis ou outros suportes.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item43" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item43" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item43" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item43" value="X" disabled>
                  </td>
               </tr>
               <!-- M45 -->
               <tr>
                  <td>
                     <div class="checkbox-title">M45 - Dá alguns passos sem apoio.</div>
                     <div class="skill-description">A criança consegue dar alguns passos sem utilizar apoio adicional.</div>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item44" value="Sim" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item44" value="AV" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item44" value="Não" disabled>
                  </td>
                  <td class="text-center">
                     <input type="radio" name="motor0_1_item44" value="X" disabled>
                  </td>
               </tr>
            </tbody>
         </table>
      </div>
      <!-- Classes - Motor -->
      <div id="motor_classes" class="tab-pane fade" role="tabpanel" aria-labelledby="motor_classes-tab">
         <h5>Análise de Classes de Resposta</h5>
         <table class="tabela-planilha">
            <thead>
               <tr>
                  <th rowspan="2" class="titulo-cabecalho">Classe de Respostas</th>
                  <th colspan="18" class="titulo-centralizado">Faixa Etária</th>
               </tr>
               <tr>
                  <th colspan="5" class="titulo-cabecalho">0-1</th>
                  <th colspan="3" class="titulo-cabecalho">1-2</th>
                  <th colspan="2" class="titulo-cabecalho">2-3</th>
                  <th colspan="3" class="titulo-cabecalho">3-4</th>
                  <th colspan="1" class="titulo-cabecalho">4-5</th>
                  <th colspan="2" class="titulo-cabecalho">5-6</th>
                  <th class="titulo-cabecalho">Total</th>
                  <th class="titulo-cabecalho">*</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <td style="text-align: left">1. Discriminação visual</td>
                  <td <?php if(isset($qst_rsp_map[1])) echo "style='" . getBackgroundColor($qst_rsp_map[1]) . "'"; ?>><?php echo 1; ?></td>
                  <td <?php if(isset($qst_rsp_map[4])) echo "style='" . getBackgroundColor($qst_rsp_map[4]) . "'"; ?>><?php echo 4; ?></td>
                  <td colspan="3"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <?php
                     // Defina os qsts presentes na linha
                     $qsts = [1, 4];
                     $totalQst = 2;
                     
                     // Inicialize a soma de pontos
                     $sumPoints = 0.0;
                     
                     // Calcule a soma de pontos
                     foreach ($qsts as $qstNum) {
                         if (isset($qst_rsp_map[$qstNum])) {
                             $sumPoints += calculatePoints($qst_rsp_map[$qstNum]);
                         }
                     }
                     
                     // Calcule a porcentagem
                     $percentage = ($sumPoints / $totalQst) * 100;
                     $percentageFormatted = round($percentage) . "%";
                     
                     // Exiba a última célula com o total e a porcentagem
                     echo "<td >2({$percentageFormatted})</td>";
                     ?>
                  <td><?php $qstsLinha = [1, 4]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">2. Sorrir</td>
                  <td <?php if(isset($qst_rsp_map[2])) echo "style='" . getBackgroundColor($qst_rsp_map[2]) . "'"; ?>><?php echo 2; ?></td>
                  <td <?php if(isset($qst_rsp_map[6])) echo "style='" . getBackgroundColor($qst_rsp_map[6]) . "'"; ?>><?php echo 6; ?></td>
                  <td <?php if(isset($qst_rsp_map[7])) echo "style='" . getBackgroundColor($qst_rsp_map[7]) . "'"; ?>><?php echo 7; ?></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <?php
                     // Defina os qsts presentes na linha
                     $qsts = [2, 6, 7];
                     $totalQst = 3;
                     
                     // Inicialize a soma de pontos
                     $sumPoints = 0.0;
                     
                     // Calcule a soma de pontos
                     foreach ($qsts as $qstNum) {
                         if (isset($qst_rsp_map[$qstNum])) {
                             $sumPoints += calculatePoints($qst_rsp_map[$qstNum]);
                         }
                     }
                     
                     // Calcule a porcentagem
                     $percentage = ($sumPoints / $totalQst) * 100;
                     $percentageFormatted = round($percentage) . "%";
                     
                     // Exiba a última célula com o total e a porcentagem
                     echo "<td >3({$percentageFormatted})</td>";
                     ?>
                  <td><?php $qstsLinha = [2, 6, 7]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">3. Vocalização</td>
                  <td <?php if(isset($qst_rsp_map[3])) echo "style='" . getBackgroundColor($qst_rsp_map[3]) . "'"; ?>><?php echo 3; ?></td>
                  <td <?php if(isset($qst_rsp_map[7])) echo "style='" . getBackgroundColor($qst_rsp_map[7]) . "'"; ?>><?php echo 7; ?></td>
                  <td <?php if(isset($qst_rsp_map[17])) echo "style='" . getBackgroundColor($qst_rsp_map[17]) . "'"; ?>><input type="checkbox" name="qst83" value="83" class="custom-checkbox"><?php echo 17; ?></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td >3</td>
                  <td><?php $qstsLinha = [3, 7, 17]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">4. Reatividade ao contato humano</td>
                  <td <?php if(isset($qst_rsp_map[5])) echo "style='" . getBackgroundColor($qst_rsp_map[5]) . "'"; ?>><?php echo 5; ?></td>
                  <td colspan="4"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">5. Acariciar/abraçar</td>
                  <td <?php if(isset($qst_rsp_map[8])) echo "style='" . getBackgroundColor($qst_rsp_map[8]) . "'"; ?>><?php echo 8; ?></td>
                  <td <?php if(isset($qst_rsp_map[23])) echo "style='" . getBackgroundColor($qst_rsp_map[23]) . "'"; ?>><?php echo 23; ?></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[35])) echo "style='" . getBackgroundColor($qst_rsp_map[35]) . "'"; ?>><?php echo 35; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td><?php $qstsLinha = [8, 23, 35]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">6. Estender mãos/braços em direção a ...</td>
                  <td <?php if(isset($qst_rsp_map[9])) echo "style='" . getBackgroundColor($qst_rsp_map[9]) . "'"; ?>><?php echo 9; ?></td>
                  <td <?php if(isset($qst_rsp_map[10])) echo "style='" . getBackgroundColor($qst_rsp_map[10]) . "'"; ?>><?php echo 10; ?></td>
                  <td <?php if(isset($qst_rsp_map[11])) echo "style='" . getBackgroundColor($qst_rsp_map[11]) . "'"; ?>><?php echo 11; ?></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>3</td>
                  <td><?php $qstsLinha = [9, 10, 11]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">7. Manipular objetos</td>
                  <td <?php if(isset($qst_rsp_map[12])) echo "style='" . getBackgroundColor($qst_rsp_map[12]) . "'"; ?>><?php echo 12; ?></td>
                  <td <?php if(isset($qst_rsp_map[13])) echo "style='" . getBackgroundColor($qst_rsp_map[13]) . "'"; ?>><?php echo 13; ?></td>
                  <td <?php if(isset($qst_rsp_map[25])) echo "style='" . getBackgroundColor($qst_rsp_map[25]) . "'"; ?>><?php echo 25; ?></td>
                  <td <?php if(isset($qst_rsp_map[26])) echo "style='" . getBackgroundColor($qst_rsp_map[26]) . "'"; ?>><?php echo 26; ?></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[34])) echo "style='" . getBackgroundColor($qst_rsp_map[34]) . "'"; ?>><?php echo 34; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>5</td>
                  <td><?php $qstsLinha = [12, 13, 25, 26, 34]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">8. Brincar</td>
                  <td <?php if(isset($qst_rsp_map[14])) echo "style='" . getBackgroundColor($qst_rsp_map[14]) . "'"; ?>><?php echo 14; ?></td>
                  <td <?php if(isset($qst_rsp_map[16])) echo "style='" . getBackgroundColor($qst_rsp_map[16]) . "'"; ?>><?php echo 16; ?></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[30])) echo "style='" . getBackgroundColor($qst_rsp_map[30]) . "'"; ?>><?php echo 30; ?></td>
                  <td <?php if(isset($qst_rsp_map[31])) echo "style='" . getBackgroundColor($qst_rsp_map[31]) . "'"; ?>><?php echo 31; ?></td>
                  <td <?php if(isset($qst_rsp_map[41])) echo "style='" . getBackgroundColor($qst_rsp_map[41]) . "'"; ?>><?php echo 41; ?></td>
                  <td <?php if(isset($qst_rsp_map[49])) echo "style='" . getBackgroundColor($qst_rsp_map[49]) . "'"; ?>><?php echo 49; ?></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[63])) echo "style='" . getBackgroundColor($qst_rsp_map[63]) . "'"; ?>><?php echo 63; ?></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[70])) echo "style='" . getBackgroundColor($qst_rsp_map[70]) . "'"; ?>><?php echo 70; ?></td>
                  <td <?php if(isset($qst_rsp_map[74])) echo "style='" . getBackgroundColor($qst_rsp_map[74]) . "'"; ?>><?php echo 74; ?></td>
                  <td ></td>
                  <td>9</td>
                  <td><?php $qstsLinha = [14, 16, 30, 31, 41, 49, 63, 70, 74]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">9. Contato Visual</td>
                  <td <?php if(isset($qst_rsp_map[15])) echo "style='" . getBackgroundColor($qst_rsp_map[15]) . "'"; ?>><?php echo 15; ?></td>
                  <td colspan="4"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">10. Imitação Motora</td>
                  <td <?php if(isset($qst_rsp_map[18])) echo "style='" . getBackgroundColor($qst_rsp_map[18]) . "'"; ?>><?php echo 18; ?></td>
                  <td <?php if(isset($qst_rsp_map[19])) echo "style='" . getBackgroundColor($qst_rsp_map[19]) . "'"; ?>><?php echo 19; ?></td>
                  <td <?php if(isset($qst_rsp_map[20])) echo "style='" . getBackgroundColor($qst_rsp_map[20]) . "'"; ?>><?php echo 20; ?></td>
                  <td <?php if(isset($qst_rsp_map[21])) echo "style='" . getBackgroundColor($qst_rsp_map[21]) . "'"; ?>><?php echo 21; ?></td>
                  <td <?php if(isset($qst_rsp_map[28])) echo "style='" . getBackgroundColor($qst_rsp_map[28]) . "'"; ?>><?php echo 28; ?></td>
                  <td <?php if(isset($qst_rsp_map[29])) echo "style='" . getBackgroundColor($qst_rsp_map[29]) . "'"; ?>><?php echo 29; ?></td>
                  <td <?php if(isset($qst_rsp_map[36])) echo "style='" . getBackgroundColor($qst_rsp_map[36]) . "'"; ?>><?php echo 36; ?></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td <?php if(isset($qst_rsp_map[76])) echo "style='" . getBackgroundColor($qst_rsp_map[76]) . "'"; ?>><?php echo 76; ?></td>
                  <td></td>
                  <td>8</td>
                  <td><?php $qstsLinha = [18, 19, 20, 21, 28, 29, 36]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">11. Dar/ Compartilhar objetos</td>
                  <td <?php if(isset($qst_rsp_map[22])) echo "style='" . getBackgroundColor($qst_rsp_map[22]) . "'"; ?>><?php echo 22; ?></td>
                  <td <?php if(isset($qst_rsp_map[27])) echo "style='" . getBackgroundColor($qst_rsp_map[27]) . "'"; ?>><?php echo 27; ?></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[37])) echo "style='" . getBackgroundColor($qst_rsp_map[37]) . "'"; ?>><?php echo 37; ?></td>
                  <td <?php if(isset($qst_rsp_map[42])) echo "style='" . getBackgroundColor($qst_rsp_map[42]) . "'"; ?>><?php echo 42; ?></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>4</td>
                  <td><?php $qstsLinha = [22, 27, 37, 42]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">12. Discriminação Auditiva</td>
                  <td <?php if(isset($qst_rsp_map[24])) echo "style='" . getBackgroundColor($qst_rsp_map[24]) . "'"; ?>><?php echo 24; ?></td>
                  <td colspan="4"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">13. Independência dos pais</td>
                  <td colspan="5"></td>
                  <td <?php if(isset($qst_rsp_map[32])) echo "style='" . getBackgroundColor($qst_rsp_map[32]) . "'"; ?>><?php echo 32; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">14. Exploração do ambiente</td>
                  <td colspan="5"></td>
                  <td <?php if(isset($qst_rsp_map[33])) echo "style='" . getBackgroundColor($qst_rsp_map[33]) . "'"; ?>><?php echo 33; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">15. Puxar pessoas para mostrar</td>
                  <td colspan="5"></td>
                  <td <?php if(isset($qst_rsp_map[38])) echo "style='" . getBackgroundColor($qst_rsp_map[38]) . "'"; ?>><?php echo 38; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">16. Cumprimentar</td>
                  <td colspan="5"></td>
                  <td <?php if(isset($qst_rsp_map[43])) echo "style='" . getBackgroundColor($qst_rsp_map[43]) . "'"; ?>><?php echo 43; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[54])) echo "style='" . getBackgroundColor($qst_rsp_map[54]) . "'"; ?>><?php echo 54; ?></td>
                  <td colspan="2"></td>
                  <td ></td>
                  <td colspan="2"></td>
                  <td>2</td>
                  <td><?php $qstsLinha = [43, 54]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">17. Seguir ordens/ Instruções</td>
                  <td colspan="5"></td>
                  <td <?php if(isset($qst_rsp_map[39])) echo "style='" . getBackgroundColor($qst_rsp_map[39]) . "'"; ?>><?php echo 39; ?></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[44])) echo "style='" . getBackgroundColor($qst_rsp_map[44]) . "'"; ?>><?php echo 44; ?></td>
                  <td <?php if(isset($qst_rsp_map[45])) echo "style='" . getBackgroundColor($qst_rsp_map[45]) . "'"; ?>><?php echo 45; ?></td>
                  <td <?php if(isset($qst_rsp_map[61])) echo "style='" . getBackgroundColor($qst_rsp_map[61]) . "'"; ?>><?php echo 61; ?></td>
                  <td colspan="2"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>4</td>
                  <td><?php $qstsLinha = [39, 44, 45, 61]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">18. Esperar a vez</td>
                  <td colspan="5"></td>
                  <td <?php if(isset($qst_rsp_map[40])) echo "style='" . getBackgroundColor($qst_rsp_map[40]) . "'"; ?>><?php echo 40; ?></td>
                  <td colspan="2"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[59])) echo "style='" . getBackgroundColor($qst_rsp_map[59]) . "'"; ?>><?php echo 59; ?></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[69])) echo "style='" . getBackgroundColor($qst_rsp_map[69]) . "'"; ?>><?php echo 69; ?></td>
                  <td colspan="2"></td>
                  <td>3</td>
                  <td><?php $qstsLinha = [40, 59, 69]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">19. Prestar atenção</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[46])) echo "style='" . getBackgroundColor($qst_rsp_map[46]) . "'"; ?>><?php echo 46; ?></td>
                  <td></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">20. Agradecer</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[47])) echo "style='" . getBackgroundColor($qst_rsp_map[47]) . "'"; ?>><?php echo 47; ?></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[57])) echo "style='" . getBackgroundColor($qst_rsp_map[57]) . "'"; ?>><?php echo 57; ?></td>
                  <td colspan="2"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>2</td>
                  <td><?php $qstsLinha = [47, 57]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">21. Ajudar</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[48])) echo "style='" . getBackgroundColor($qst_rsp_map[48]) . "'"; ?>><?php echo 48; ?></td>
                  <td ></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">22. Escolher</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[50])) echo "style='" . getBackgroundColor($qst_rsp_map[50]) . "'"; ?>><?php echo 50; ?></td>
                  <td></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[80])) echo "style='" . getBackgroundColor($qst_rsp_map[80]) . "'"; ?>><?php echo 80; ?></td>
                  <td></td>
                  <td>2</td>
                  <td><?php $qstsLinha = [50, 80]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">23. Expressão de sentimentos</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[51])) echo "style='" . getBackgroundColor($qst_rsp_map[51]) . "'"; ?>><?php echo 51; ?></td>
                  <td></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[73])) echo "style='" . getBackgroundColor($qst_rsp_map[73]) . "'"; ?>><?php echo 73; ?></td>
                  <td <?php if(isset($qst_rsp_map[79])) echo "style='" . getBackgroundColor($qst_rsp_map[79]) . "'"; ?>><?php echo 79; ?></td>
                  <td>3</td>
                  <td><?php $qstsLinha = [51, 73, 79]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">24. Cantar/dançar</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[52])) echo "style='" . getBackgroundColor($qst_rsp_map[52]) . "'"; ?>><?php echo 52; ?></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[66])) echo "style='" . getBackgroundColor($qst_rsp_map[66]) . "'"; ?>><?php echo 66; ?></td>
                  <td colspan="2"></td>
                  <td>2</td>
                  <td><?php $qstsLinha = [52, 66]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">25. Seguir regras de jogo</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[53])) echo "style='" . getBackgroundColor($qst_rsp_map[53]) . "'"; ?>><?php echo 53; ?></td>
                  <td <?php if(isset($qst_rsp_map[55])) echo "style='" . getBackgroundColor($qst_rsp_map[55]) . "'"; ?>><?php echo 55; ?></td>
                  <td <?php if(isset($qst_rsp_map[60])) echo "style='" . getBackgroundColor($qst_rsp_map[60]) . "'"; ?>><?php echo 60; ?></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[78])) echo "style='" . getBackgroundColor($qst_rsp_map[78]) . "'"; ?>><?php echo 78; ?></td>
                  <td></td>
                  <td>4</td>
                  <td><?php $qstsLinha = [53, 55, 60, 78]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">26. Pedir permissão</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[56])) echo "style='" . getBackgroundColor($qst_rsp_map[56]) . "'"; ?>><?php echo 56; ?></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[72])) echo "style='" . getBackgroundColor($qst_rsp_map[72]) . "'"; ?>><?php echo 72; ?></td>
                  <td colspan="2"></td>
                  <td>2</td>
                  <td><?php $qstsLinha = [56, 72]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">27. Falar ao telefone</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[58])) echo "style='" . getBackgroundColor($qst_rsp_map[58]) . "'"; ?>><?php echo 58; ?></td>
                  <td colspan="2"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">28. Permanecer em sua área</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td <?php if(isset($qst_rsp_map[62])) echo "style='" . getBackgroundColor($qst_rsp_map[62]) . "'"; ?>><?php echo 62; ?></td>
                  <td colspan="2"></td>
                  <td></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">29. Pedir ajuda</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[64])) echo "style='" . getBackgroundColor($qst_rsp_map[64]) . "'"; ?>><?php echo 64; ?></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">30. Verbalizar para adultos</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[65])) echo "style='" . getBackgroundColor($qst_rsp_map[65]) . "'"; ?>><?php echo 65; ?></td>
                  <td <?php if(isset($qst_rsp_map[77])) echo "style='" . getBackgroundColor($qst_rsp_map[77]) . "'"; ?>><?php echo 77; ?></td>
                  <td></td>
                  <td>2</td>
                  <td><?php $qstsLinha = [65, 77]; if (existeInconsistencia($qstsLinha, $qst_rsp_map)) {echo "<i class='fa fa-exclamation-circle' style='color: red;'></i>";} else {echo "";}?></td>
               </tr>
               <tr>
                  <td style="text-align: left">31. Fazer tarefa sozinho</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[67])) echo "style='" . getBackgroundColor($qst_rsp_map[67]) . "'"; ?>><?php echo 67; ?></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">32. Pedir desculpas</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[68])) echo "style='" . getBackgroundColor($qst_rsp_map[68]) . "'"; ?>><?php echo 68; ?></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">33. Comportamentos aceitáveis em público</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td <?php if(isset($qst_rsp_map[71])) echo "style='" . getBackgroundColor($qst_rsp_map[71]) . "'"; ?>><?php echo 71; ?></td>
                  <td colspan="2"></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">34. Explicar regras</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[75])) echo "style='" . getBackgroundColor($qst_rsp_map[75]) . "'"; ?>><?php echo 75; ?></td>
                  <td></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">35. Usar ferramentas</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[81])) echo "style='" . getBackgroundColor($qst_rsp_map[81]) . "'"; ?>><?php echo 81; ?></td>
                  <td></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">36. Estabelecer metas para si</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[82])) echo "style='" . getBackgroundColor($qst_rsp_map[82]) . "'"; ?>><?php echo 82; ?></td>
                  <td></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <td style="text-align: left">37. Dramatizar</td>
                  <td colspan="5"></td>
                  <td colspan="3"></td>
                  <td colspan="2"></td>
                  <td colspan="3"></td>
                  <td></td>
                  <td <?php if(isset($qst_rsp_map[83])) echo "style='" . getBackgroundColor($qst_rsp_map[83]) . "'"; ?>><?php echo 83; ?></td>
                  <td></td>
                  <td>1</td>
                  <td></td>
               </tr>
               <tr>
                  <th class="titulo-cabecalho">Total de classes: "Novas"</th>
                  <th colspan="5" class="titulo-cabecalho">12</th>
                  <th colspan="3" class="titulo-cabecalho">6</th>
                  <th colspan="2" class="titulo-cabecalho">5</th>
                  <th colspan="3" class="titulo-cabecalho">5</th>
                  <th class="titulo-cabecalho">5</th>
                  <th colspan="2" class="titulo-cabecalho">4</th>
                  <th colspan="2" class="titulo-cabecalho">TI: 84*</th>
               </tr>
               <tr>
                  <th class="titulo-cabecalho">Total de classes: "Antigas"</th>
                  <th colspan="5" class="titulo-cabecalho"></th>
                  <th colspan="3" class="titulo-cabecalho">5</th>
                  <th colspan="2" class="titulo-cabecalho">2</th>
                  <th colspan="3" class="titulo-cabecalho">5</th>
                  <th class="titulo-cabecalho">3</th>
                  <th colspan="2" class="titulo-cabecalho">6</th>
                  <th colspan="2" class="titulo-cabecalho">TC: 37</th>
               </tr>
            </tbody>
         </table>
         <p><i class='fa fa-exclamation-circle' style='color: red;'></i> = Inconsistência nas respostas</p>
         <hr>
      </div>
      <!-- relatório -->
      <div id="motor_relatorio" class="tab-pane fade" role="tabpanel" aria-labelledby="motor_relatorio">
         <h5>Relatório de Desenvolvimento Motor</h5>
      </div>
   </div>
</div>


