<header class="header">
    <div class="logo">
        <img src="includes/logo.webp" alt="Logo Sistema Coralina Matos">
        <h2>Sistema Avaliação - IFCora</h2>
    </div>
    <nav class="user-menu">
        <a href="#" class="icora-notebook-icon" title="Caderno de Anotações" id="icora-openNotebook"><i class="fas fa-book-medical"></i></a>
        <a href="#" title="Notificações"><i class="fas fa-bell"></i></a>
        <a href="#" title="Configurações"><i class="fas fa-cog"></i></a>
        <a href="#" title="Suporte"><i class="fas fa-headset"></i></a>
        <a href="#" title="Suporte"><i class="fas fa-headset"></i></a>

    </nav>
</header>

<!-- Estilos Personalizados Inline -->
<style>
    
    .icora-header {
      background-color: #fff;
      border-bottom: 1px solid #e2e8f0;
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 10px 20px;
    }
    .icora-header-logo {
      display: flex;
      align-items: center;
      gap: 15px;
    }
    .icora-header-logo img {
      width: 50px;
      height: 50px;
      object-fit: contain;
    }
    .icora-header-logo h2 {
      font-size: 18px;
      color: #08C89E;
      margin: 0;
    }
    .icora-user-menu a {
      margin-left: 15px;
      color: #4a5568;
      font-size: 18px;
      text-decoration: none;
      transition: color 0.3s;
    }
    .icora-user-menu a:hover {
      color: #08C89E;
    }

    /* Ícone do Caderno */
    .icora-user-menu a.icora-notebook-icon {
      position: relative;
    }

    /* Modal do Caderno (posicionado no centro da tela) */
    #icora-notebookModal {
      display: none; /* Oculto por padrão */
      position: fixed;
      z-index: 9999;
      top: 0; left: 0; right: 0; bottom: 0;
      background-color: rgba(0,0,0,0.4);
      justify-content: center;
      align-items: center;
      overflow: auto; /* Caso o conteúdo seja grande */
    }
    #icora-notebookModal .icora-modal-content {
      background-color: #ffffff;
      border-radius: 10px;
      width: 90%;
      max-width: 900px;
      margin: 5% auto;
      padding: 20px;
      position: relative;
      box-shadow: 0 2px 10px rgba(0,0,0,0.2);
      animation: fadeIn 0.3s ease-in-out;
    }
    #icora-notebookModal .icora-modal-header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      border-bottom: 1px solid #e2e8f0;
      padding-bottom: 10px;
      margin-bottom: 15px;
    }
    #icora-notebookModal .icora-modal-header h3 {
      font-size: 20px;
      color: #08C89E;
      margin: 0;
    }
    #icora-notebookModal .icora-modal-header .icora-close-btn {
      font-size: 24px;
      cursor: pointer;
      color: #a0aec0;
    }
    #icora-notebookModal .icora-modal-header .icora-close-btn:hover {
      color: #2d3748;
    }
    #icora-notebookModal .icora-modal-body {
      display: flex;
      gap: 20px;
      flex-wrap: wrap;
    }

    /* Listagem de anotações existentes */
    .icora-notes-list {
      flex: 1;
      min-width: 240px;
      border-right: 1px solid #e2e8f0;
      padding-right: 10px;
    }
    .icora-notes-list h4 {
      font-size: 16px;
      margin-bottom: 10px;
      color: #2d3748;
    }
    .icora-notes-list ul {
      list-style: none;
      padding-left: 0;
      margin: 0;
    }
    .icora-notes-list li {
      border-bottom: 1px solid #e2e8f0;
      padding: 8px 0;
    }
    .icora-notes-list li:last-child {
      border-bottom: none;
    }
    .icora-notes-list li a {
      text-decoration: none;
      color: #08C89E;
      cursor: pointer;
      font-size: 14px;
    }
    .icora-notes-list li a:hover {
      text-decoration: underline;
    }

    /* Botão "Nova Anotação" */
    .icora-new-note-btn {
      padding: 8px 14px;
      border: none;
      background: #08C89E;
      color: #fff;
      border-radius: 6px;
      font-size: 14px;
      margin-top: 10px;
      cursor: pointer;
      transition: background 0.3s;
    }
    .icora-new-note-btn:hover {
      background: #06b287;
    }

    /* Área de edição/visualização da anotação */
    .icora-notes-editor {
      flex: 2;
      min-width: 260px;
    }
    .icora-notes-editor h4 {
      font-size: 16px;
      margin-bottom: 10px;
      color: #2d3748;
    }
    .icora-notes-editor .icora-note-title {
      margin: 0 0 8px;
      padding: 8px;
      border: 1px solid #e2e8f0;
      border-radius: 6px;
      width: 100%;
      box-sizing: border-box;
      font-size: 14px;
    }
    .icora-notes-editor textarea {
      width: 100%;
      height: 380px;
      border: 1px solid #e2e8f0;
      border-radius: 6px;
      padding: 8px;
      font-size: 14px;
      box-sizing: border-box;
      resize: vertical;
      background-color: #f9f9f9; /* Bloqueado inicialmente */
    }
    .icora-notes-editor textarea:focus {
      outline: none;
      border-color: #08C89E;
      background-color: #fff;
      box-shadow: 0 0 3px rgba(8, 202, 158, 0.2);
    }

    /* Botões de ação da anotação */
    .icora-note-actions {
      margin-top: 10px;
      display: flex;
      gap: 10px;
    }
    .icora-note-actions button {
      border: none;
      border-radius: 6px;
      padding: 8px 12px;
      font-size: 14px;
      cursor: pointer;
      transition: background 0.2s;
    }
    .icora-note-actions .icora-btn-cancel {
      background-color: #e53e3e;
      color: #fff;
    }
    .icora-note-actions .icora-btn-cancel:hover {
      background-color: #c53030;
    }
    .icora-note-actions .icora-btn-save {
      background-color: #08C89E;
      color: #fff;
    }
    .icora-note-actions .icora-btn-save:hover {
      background-color: #06b287;
    }
    .icora-note-actions .icora-btn-edit {
      background-color: #4A5568;
      color: #fff;
      display: none; /* Surge somente no modo visualização */
    }
    .icora-note-actions .icora-btn-edit:hover {
      background-color: #2d3748;
    }

    /* Mensagens */
    .icora-message-success,
    .icora-message-error {
      font-size: 13px;
      margin-top: 5px;
      display: none;
    }
    .icora-message-success {
      color: #38A169;
    }
    .icora-message-error {
      color: #E53E3E;
    }

    /* Animação */
    @keyframes fadeIn {
      from { opacity:0; transform:translateY(-5px); }
      to   { opacity:1; transform:translateY(0); }
    }

    /* Responsividade do Modal */
    @media (max-width: 768px) {
      #icora-notebookModal .icora-modal-content {
        width: 95%;
        margin: 2% auto;
      }
      .icora-modal-body {
        flex-direction: column;
      }
      .icora-notes-list {
        border-right: none;
        padding-right: 0;
      }
    }
  </style>

<!-- Modal do Caderno -->
<div id="icora-notebookModal">
  <div class="icora-modal-content">
    <div class="icora-modal-header">
      <h3> <i class="fa-solid fa-calendar-check" style="margin-right: 8px"></i> Registros Clinicos</h3>

      <span class="icora-close-btn" id="icora-closeNotebookModal">&times;</span>
    </div>

    <div class="icora-modal-body">
      <!-- Lado Esquerdo: Lista de anotações -->
      <div class="icora-notes-list">
        <h4>Minhas Anotações</h4>
        <ul>
          <li>
            <a href="#" class="icora-note-link" data-code="NB001">
              NB001 - Observações Sessão 01
            </a>
          </li>
          <li>
            <a href="#" class="icora-note-link" data-code="NB002">
              NB002 - Resumo Aval. Sensorial
            </a>
          </li>
          <li>
            <a href="#" class="icora-note-link" data-code="NB003">
              NB003 - Planejamento Terapêutico
            </a>
          </li>
          <li>
            <a href="#" class="icora-note-link" data-code="NB004">
              NB004 - Revisão Metas Longo Prazo
            </a>
          </li>
        </ul>
        <hr>
        <!-- Criar nova anotação diretamente no caderno -->
        <button class="icora-new-note-btn" id="icora-btnNewNote">
          <i class="fas fa-plus"></i> Nova Anotação
        </button>
      </div>

      <!-- Lado Direito: Edição ou Visualização da anotação -->
      <div class="icora-notes-editor">
        <h4>Detalhes da Anotação</h4>
        <input type="text" class="icora-note-title" id="icora-noteTitle" placeholder="Título da anotação" disabled>

        <textarea id="icora-noteContent" disabled></textarea>

        <div class="icora-note-actions">
          <button class="icora-btn-cancel" id="icora-btnCancel">Cancelar</button>
          <button class="icora-btn-save" id="icora-btnSave">Salvar</button>
          <button class="icora-btn-edit" id="icora-btnEdit">Editar</button>
        </div>
        <div class="icora-message-success" id="icora-msgSuccess">Anotação salva com sucesso!</div>
        <div class="icora-message-error" id="icora-msgError">Erro ao salvar a anotação.</div>
      </div>
    </div>
  </div>
</div>

<!-- JavaScript de Demonstração (apenas para exibição do modal e manipulação local) -->
<script>
  // Simulação de dados fixos do caderno
  const icoraNotebookData = {
    "NB001": {
      title: "Observações Sessão 01",
      content: `1. Observações clínicas gerais
- Paciente apresentou humor estável...

2. Métodos aplicados
- Brincadeiras de interação 
- Exercícios de mobilidade

3. Notas extras
- Necessário maior atenção ao tempo de atenção e concentração`
    },
    "NB002": {
      title: "Resumo Aval. Sensorial",
      content: `Avaliação sensorial realizada na última sessão.

- Resposta tátil: Adequada.
- Resposta auditiva: Hipersensibilidade leve.
- Próximo passo: Consultar fonoaudiologia`
    },
    "NB003": {
      title: "Planejamento Terapêutico",
      content: `1. Curto Prazo: 
   - Aumentar vocabulário funcional 
   - Promover rotina de exercícios diários

2. Médio Prazo:
   - Melhorar integração sensorial
   - Reduzir crises de comportamento em 50%

3. Longo Prazo:
   - Favorecer socialização em ambientes diferentes`
    },
    "NB004": {
      title: "Revisão Metas Longo Prazo",
      content: `Revisar as metas definidas anteriormente:
- Avaliar progresso 
- Fazer ajustes ou trocar prioridades.

Observações: Familiar engajado, mas falta rotina sistemática de acompanhamento em casa.`
    }
  };

  // Botões e Elementos do DOM
  const icoraOpenNotebook = document.getElementById('icora-openNotebook');
  const icoraNotebookModal = document.getElementById('icora-notebookModal');
  const icoraCloseNotebookModal = document.getElementById('icora-closeNotebookModal');

  const icoraNoteLinks = document.querySelectorAll('.icora-note-link');
  const icoraNoteTitle = document.getElementById('icora-noteTitle');
  const icoraNoteContent = document.getElementById('icora-noteContent');

  const icoraBtnNewNote = document.getElementById('icora-btnNewNote');
  const icoraBtnCancel = document.getElementById('icora-btnCancel');
  const icoraBtnSave = document.getElementById('icora-btnSave');
  const icoraBtnEdit = document.getElementById('icora-btnEdit');

  const icoraMsgSuccess = document.getElementById('icora-msgSuccess');
  const icoraMsgError = document.getElementById('icora-msgError');

  let icoraCurrentNote = null; // código atual
  let icoraIsNewNote = false;

  // Abrir o modal do caderno
  icoraOpenNotebook.addEventListener('click', (e)=>{
    e.preventDefault();
    icoraNotebookModal.style.display='flex';
    icoraResetView();
  });

  // Fechar o modal
  icoraCloseNotebookModal.addEventListener('click', ()=> {
    icoraNotebookModal.style.display='none';
  });
  window.onclick = function(event) {
    if(event.target == icoraNotebookModal) {
      icoraNotebookModal.style.display='none';
    }
  };

  // Resetar mensagens e campos
  function icoraResetView() {
    icoraNoteTitle.value = '';
    icoraNoteContent.value = '';
    icoraDisableFields(true);
    icoraShowButtonsViewMode();
    icoraHideMessages();
    icoraCurrentNote = null;
    icoraIsNewNote = false;
  }

  function icoraHideMessages() {
    icoraMsgSuccess.style.display='none';
    icoraMsgError.style.display='none';
  }

  // Desabilitar/Habilitar campos
  function icoraDisableFields(disable) {
    icoraNoteTitle.disabled = disable;
    icoraNoteContent.disabled = disable;
    icoraNoteContent.style.backgroundColor = disable ? '#f9f9f9' : '#fff';
  }

  // Mostrar botões no modo visualização
  function icoraShowButtonsViewMode() {
    icoraBtnCancel.style.display='none';
    icoraBtnSave.style.display='none';
    icoraBtnEdit.style.display='inline-block';
  }
  // Mostrar botões no modo edição
  function icoraShowButtonsEditMode() {
    icoraBtnCancel.style.display='inline-block';
    icoraBtnSave.style.display='inline-block';
    icoraBtnEdit.style.display='none';
  }
  // Mostrar botões no modo novo
  function icoraShowButtonsNewMode() {
    icoraBtnCancel.style.display='inline-block';
    icoraBtnSave.style.display='inline-block';
    icoraBtnEdit.style.display='none';
  }

  // Abrir uma anotação existente
  icoraNoteLinks.forEach(link => {
    link.addEventListener('click', (e)=>{
      e.preventDefault();
      const code = link.getAttribute('data-code');
      if(icoraNotebookData[code]) {
        icoraCurrentNote = code;
        icoraIsNewNote = false;
        const { title, content } = icoraNotebookData[code];
        icoraNoteTitle.value = title;
        icoraNoteContent.value = content;
        icoraHideMessages();
        icoraDisableFields(true);
        icoraShowButtonsViewMode();
      }
    });
  });

  // Botão "Nova Anotação" dentro do caderno
  icoraBtnNewNote.addEventListener('click', ()=>{
    icoraHideMessages();
    icoraIsNewNote = true;
    icoraCurrentNote = null;
    icoraNoteTitle.value='';
    icoraNoteContent.value='';
    icoraDisableFields(false);
    icoraShowButtonsNewMode();
  });

  // Botão "Editar"
  icoraBtnEdit.addEventListener('click', ()=>{
    if(!icoraIsNewNote && icoraCurrentNote){
      icoraHideMessages();
      icoraDisableFields(false);
      icoraShowButtonsEditMode();
    }
  });

  // Botão "Cancelar"
  icoraBtnCancel.addEventListener('click', ()=>{
    icoraHideMessages();
    if(icoraIsNewNote){
      // Se for novo, limpa tudo
      icoraResetView();
    } else {
      // Se for existente, recarrega
      if(icoraCurrentNote && icoraNotebookData[icoraCurrentNote]){
        const { title, content } = icoraNotebookData[icoraCurrentNote];
        icoraNoteTitle.value = title;
        icoraNoteContent.value = content;
      }
      icoraDisableFields(true);
      icoraShowButtonsViewMode();
    }
  });

  // Botão "Salvar"
  icoraBtnSave.addEventListener('click', ()=>{
    icoraHideMessages();
    const titleVal = icoraNoteTitle.value.trim();
    const contentVal= icoraNoteContent.value.trim();

    if(!titleVal || !contentVal){
      icoraMsgError.textContent='Título e conteúdo não podem ficar vazios.';
      icoraMsgError.style.display='block';
      return;
    }
    // Caso de criar uma nova anotação
    if(icoraIsNewNote){
      // Simular criação de ID (geração simples para exemplo)
      const newCode = `NB00${Object.keys(icoraNotebookData).length + 1}`;
      icoraNotebookData[newCode] = {
        title: titleVal,
        content: contentVal
      };
      icoraMsgSuccess.textContent='Nova anotação criada com sucesso!';
      icoraMsgSuccess.style.display='block';
      // Atualizar a lista de anotações
      icoraAddNoteToList(newCode, titleVal);
      icoraResetView();
      // Opcional: Poderia fechar o modal ou não
    } else if(icoraCurrentNote){
      // Salvando alterações de um registro existente
      if(icoraNotebookData[icoraCurrentNote]){
        icoraNotebookData[icoraCurrentNote].title   = titleVal;
        icoraNotebookData[icoraCurrentNote].content = contentVal;
        icoraMsgSuccess.textContent='Anotação atualizada com sucesso!';
        icoraMsgSuccess.style.display='block';
        icoraDisableFields(true);
        icoraShowButtonsViewMode();
      }
    }
  });

  // Função para adicionar uma nova anotação à lista
  function icoraAddNoteToList(code, title) {
    const notesList = document.querySelector('.icora-notes-list ul');
    const newLi = document.createElement('li');
    const newA = document.createElement('a');
    newA.href = '#';
    newA.classList.add('icora-note-link');
    newA.setAttribute('data-code', code);
    newA.textContent = `${code} - ${title}`;
    newA.addEventListener('click', (e)=>{
      e.preventDefault();
      if(icoraNotebookData[code]) {
        icoraCurrentNote = code;
        icoraIsNewNote = false;
        const { title, content } = icoraNotebookData[code];
        icoraNoteTitle.value = title;
        icoraNoteContent.value = content;
        icoraHideMessages();
        icoraDisableFields(true);
        icoraShowButtonsViewMode();
      }
    });
    newLi.appendChild(newA);
    notesList.appendChild(newLi);
  }
</script>


