<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Assistente - Minhas Crianças</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">
    <style>
        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .cards {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(250px,1fr));
            gap: 20px;
            margin-top: 20px;
        }

        .card {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.05);
            padding: 20px;
            display: flex;
            flex-direction: column;
            transition: transform 0.2s;
            cursor: pointer;
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        }

        .card-header {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
        }

        .card-header .icon {
            font-size: 40px;
            color: #F6AD55;
            margin-right: 15px;
        }

        .card-header h3 {
            font-size: 20px;
            color: #08C89E;
            margin: 0;
        }

        .card-content p {
            margin: 5px 0;
            font-size: 14px;
            color: #4a5568;
        }

        .card-footer {
            margin-top: auto;
            display: flex;
            justify-content: flex-end;
        }

        .card-footer button {
            background-color: #08C89E;
            color: #fff;
            border: none;
            border-radius: 8px;
            padding: 8px 12px;
            cursor: pointer;
            font-size: 14px;
            transition: background 0.3s;
        }

        .card-footer button:hover {
            background-color: #06b287;
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-painel-assistente.php'; ?>

    <main class="content">
        <div class="header-content">
            <h1 style="color:#08C89E;">Minhas Crianças</h1>
        </div>

        <div class="cards" id="childrenCards">
            <!-- Cards serão renderizados via JS -->
        </div>
    </main>

    <script>
        // Dados simulados das crianças associadas a este assistente
        const children = [
            {id: '#CH001', nome: 'Ana Clara', idade: '5 anos', responsavel: 'João Silva'},
            {id: '#CH002', nome: 'Bruno Costa', idade: '6 anos', responsavel: 'Maria Oliveira'},
            {id: '#CH003', nome: 'Carla Souza', idade: '4 anos', responsavel: 'Pedro Souza'}
        ];

        const childrenCards = document.getElementById('childrenCards');

        function renderChildren() {
            childrenCards.innerHTML = '';
            children.forEach(child => {
                const card = document.createElement('div');
                card.className = 'card';
                card.innerHTML = `
                    <div class="card-header">
                        <span class="icon"><i class="fas fa-child"></i></span>
                        <h3>${child.nome}</h3>
                    </div>
                    <div class="card-content">
                        <p><b>ID:</b> ${child.id}</p>
                        <p><b>Idade:</b> ${child.idade}</p>
                        <p><b>Responsável:</b> ${child.responsavel}</p>
                    </div>
                    <div class="card-footer">
                        <button onclick="window.location.href='painel-assistente-perfil-criança.php';">Ver Perfil</button>
                    </div>
                `;
                childrenCards.appendChild(card);
            });
        }

        function acessarPerfil(id) {
            // Redireciona para a página de perfil da criança
            // Aqui seria algo como: window.location.href = `painel-assistente-perfil-criança.php?id=${id}`;
            alert('Acessar perfil da criança ' + id);
        }

        document.addEventListener('DOMContentLoaded', renderChildren);
    </script>
</body>
</html>
