<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8" />
    <title>Linhas do Tempo - Sistema IFCora</title>
    <!-- Fonte e Ícones -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

    <!-- Bootstrap -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">

    <!-- CSS Personalizado -->
    <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">

    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f9fafb;
            color: #2d3748;
        }

        .containere {
            margin-top: 60px;
            margin-left: 220px;
            padding: 20px;
        }

        h1 {
            color: #08C89E;
            font-size: 24px;
            margin-bottom: 20px;
        }

        /* Estilos dos Cards */
        .timeline-card {
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 20px;
            background-color: #fff;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
            transition: transform 0.2s, box-shadow 0.2s;
        }

        .timeline-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }

        .timeline-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }

        .timeline-header p {
            margin-bottom: 0;
            font-size: 14px;
        }

        .timeline-header .badge-success {
            background-color: #28a745;
        }

        .timeline-header .badge-secondary {
            background-color: #6c757d;
        }

        .action-btn {
            background-color: #08C89E;
            color: #fff;
            border: none;
            border-radius: 6px;
            padding: 6px 12px;
            font-size: 13px;
            cursor: pointer;
            transition: background 0.3s;
        }

        .action-btn:hover {
            background-color: #06b287;
        }

        /* Botão para criar nova linha do tempo */
        .new-timeline-btn {
            background-color: #08C89E;
            color: #fff;
            border: none;
            padding: 10px 20px;
            border-radius: 8px;
            font-size: 14px;
            cursor: pointer;
            transition: background 0.3s;
            margin-bottom: 20px;
        }

        .new-timeline-btn:hover {
            background-color: #06b287;
        }

        /* Filtros e Pesquisa */
        .filter-section {
            margin-bottom: 20px;
        }

        .filter-section .form-control {
            border-radius: 6px;
            border: 1px solid #e2e8f0;
        }

        /* Informações da Criança */
        .child-info {
            margin-top: 15px;
            padding: 15px;
            background-color: #f7fafc;
            border-radius: 6px;
        }

        .child-info h6 {
            color: #08C89E;
            margin-bottom: 10px;
        }

        .child-info p {
            margin: 0;
            font-size: 14px;
        }

        /* Informações do Profissional */
        .professional-info {
            margin-top: 15px;
            padding: 15px;
            background-color: #f7fafc;
            border-radius: 6px;
        }

        .professional-info h6 {
            color: #08C89E;
            margin-bottom: 10px;
        }

        .professional-info p {
            margin: 0;
            font-size: 14px;
        }

        /* Modal Estilização */
        .modal-header {
            border-bottom: 1px solid #e2e8f0;
        }

        .modal-title {
            font-weight: 600;
            color: #08C89E;
        }

        .modal-footer {
            border-top: 1px solid #e2e8f0;
        }

        .form-group label {
            font-weight: 600;
            margin-bottom: 5px;
            color: #2d3748;
        }

        .form-control {
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            font-size: 14px;
            color: #2d3748;
        }

        /* Responsividade */
        @media(max-width: 768px) {
            .containere {
                margin-left: 0;
                padding: 10px;
            }

            .timeline-header {
                flex-direction: column;
                align-items: flex-start;
            }

            .new-timeline-btn {
                width: 100%;
                text-align: center;
            }
        }

        /* Estilos para Toasts */
        .toast-container {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1055;
        }
        
        /* Estilos personalizados do modal */
        .modal-backdrop {
            display: none;
            z-index: 1040 !important; /* Assegura que o backdrop está atrás do conteúdo do modal */
        }
        .modal-dialog {
            z-index: 1050; /* Garantir que o modal fique em cima do backdrop */
        }
        
        
        ..modal-content {
            width: 100%;
            min-width: 700px;
        }
        
    </style>
</head>
<body>
    <!-- Cabeçalho e Sidebar padrão do sistema -->
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-linha-portage.php'; ?>

    <div class="containere">
        <h1>Linhas do Tempo - Portage</h1>
        
        <button class="new-timeline-btn" data-toggle="modal" data-target="#createTimelineModal">
            <i class="fas fa-plus"></i> Criar Nova Linha do Tempo
        </button>

        

        <!-- Container dos Cards de Linhas do Tempo -->
        <div class="row" id="timelinesContainer">
            <!-- Exemplo de Linha do Tempo 1 -->
            <div class="col-md-4 mb-4">
                <div class="timeline-card" data-timeline-id="TL001" data-status="public">
                    <div class="timeline-header">
                        <p><strong>ID:</strong> TL001</p>
                        <span class="badge badge-success">Pública</span>
                    </div>

                    <!-- Informações do Profissional -->
                    <div class="professional-info">
                        <h6><i class="fas fa-user-md"></i> Profissional Responsável</h6>
                        <p><strong>Nome:</strong> Dr. Carlos Pereira</p>
                        <p><strong>Código:</strong> PROF123</p>
                        <p><strong>Formação:</strong> Psicólogo Clínico</p>
                    </div>
                    <p><strong>Paciente:</strong> Luiz Gustavo</p>

                    <div class="mt-3">
                        <button class="action-btn" onclick="accessPortage('TL001')"><i class="fas fa-arrow-right"></i> Acessar</button>
                        <button class="action-btn ml-2" onclick="openEditTimelineModal('TL001')"><i class="fas fa-edit"></i> Editar</button>
                    </div>
                </div>
            </div>

            <!-- Exemplo de Linha do Tempo 2 -->
            <div class="col-md-4 mb-4">
                <div class="timeline-card" data-timeline-id="TL002" data-status="private">
                    <div class="timeline-header">
                        <p><strong>ID:</strong> TL002</p>
                        <span class="badge badge-secondary">Privada</span>
                    </div>
                    
                    <!-- Informações do Profissional -->
                    <div class="professional-info">
                        <h6><i class="fas fa-user-md"></i> Profissional Responsável</h6>
                        <p><strong>Nome:</strong> Dr. Carlos Pereira</p>
                        <p><strong>Código:</strong> PROF123</p>
                        <p><strong>Formação:</strong> Psicólogo Clínico</p>
                    </div>
                    <p><strong>Paciente:</strong> Luiz Gustavo</p>
                    <div class="mt-3">
                        <button class="action-btn" onclick="accessPortage('TL002')"><i class="fas fa-arrow-right"></i> Acessar</button>
                        <button class="action-btn ml-2" onclick="openEditTimelineModal('TL002')"><i class="fas fa-edit"></i> Editar</button>
                    </div>
                </div>
            </div>

            <!-- Exemplo de Linha do Tempo 3 -->
            <div class="col-md-4 mb-4">
                <div class="timeline-card" data-timeline-id="TL003" data-status="public">
                    <div class="timeline-header">
                        <p><strong>ID:</strong> TL003</p>
                        <span class="badge badge-success">Pública</span>
                    </div>
                    
                    <!-- Informações do Profissional -->
                    <div class="professional-info">
                        <h6><i class="fas fa-user-md"></i> Profissional Responsável</h6>
                        <p><strong>Nome:</strong> Dr. Carlos Pereira</p>
                        <p><strong>Código:</strong> PROF123</p>
                        <p><strong>Formação:</strong> Psicólogo Clínico</p>
                    </div>
                    <p><strong>Paciente:</strong> Luiz Gustavo</p>
                    <div class="mt-3">
                        <button class="action-btn" onclick="accessPortage('TL003')"><i class="fas fa-arrow-right"></i> Acessar</button>
                        <button class="action-btn ml-2" onclick="openEditTimelineModal('TL003')"><i class="fas fa-edit"></i> Editar</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Criar Nova Linha do Tempo -->
    <div class="modal fade" id="createTimelineModal" tabindex="-1" role="dialog" aria-labelledby="createTimelineModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h2 class="modal-title" id="createTimelineModalLabel"><span style="color: #ffffff;">Criar Nova Linha do Tempo</span></h2>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Fechar" style="border:none;background:none;font-size:20px;">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="timelineForm">
                    <div class="modal-body">
                        
                        
                    <!-- Informações da Criança -->
                    <div class="child-info">
                        <h6><i class="fas fa-child"></i> Informações da Criança</h6>
                        <p><strong>Data de Nascimento:</strong> 20/05/2018</p>
                        <p><strong>Gênero:</strong> Masculino</p>
                        <p><strong>Responsável:</strong> Maria Silva</p>
                    </div>
                        
                        <!-- Informações do Profissional -->
                    <div class="professional-info">
                        <h6><i class="fas fa-user-md"></i> Profissional Responsável</h6>
                        <p><strong>Nome:</strong> Dr. Carlos Pereira</p>
                        <p><strong>Código:</strong> PROF123</p>
                        <p><strong>Formação:</strong> Psicólogo Clínico</p>
                    </div>
                        
                        
                        
                        
                        <!-- Nova Seção: Público ou Privado -->
                        <div class="form-group">
                            <label>Status da Linha do Tempo</label>
                            <div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="timelineStatus" id="publicTimeline" value="public" checked>
                                    <label class="form-check-label" for="publicTimeline">Pública</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="timelineStatus" id="privateTimeline" value="private">
                                    <label class="form-check-label" for="privateTimeline">Privada</label>
                                </div>
                            </div>
                            <small class="form-text text-muted">Observação: Linhas do Tempo Públicas podem ser acessadas por outros profissionais. Privadas são restritas a você.</small>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="action-btn" style="background-color:#e53e3e;" data-dismiss="modal"><i class="fas fa-times"></i> Cancelar</button>
                        <button type="submit" class="action-btn" style="background-color:#08C89E;"><i class="fas fa-save"></i> Criar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Editar Linha do Tempo -->
    <div class="modal fade" id="editTimelineModal" tabindex="-1" role="dialog" aria-labelledby="editTimelineModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h2 class="modal-title" id="editTimelineModalLabel"><span style="color: #ffffff;">Editar: TL001</span></h2>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Fechar" style="border:none;background:none;font-size:20px;">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="editTimelineForm">
                    <div class="modal-body">
                        <!-- Campo Não Editável: ID da Linha do Tempo -->
                        <div class="form-group" style="display: none">
                            <label for="editTimelineId" >ID da Linha do Tempo</label>
                            <input type="text" id="editTimelineId" name="editTimelineId" class="form-control" readonly>
                        </div>
                        <!-- Campo Não Editável: Nome do Paciente -->
                        <div class="form-group" style="display: none">
                            <label for="editPatientName">Nome do Paciente</label>
                            <input type="text" id="editPatientName" name="editPatientName" class="form-control" readonly>
                        </div>
                        <!-- Campo para Alterar o Status: Público ou Privado -->
                        <div class="form-group">
                            <label>Status da Linha do Tempo</label>
                            <div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="editTimelineStatus" id="editPublicTimeline" value="public">
                                    <label class="form-check-label" for="editPublicTimeline">Pública</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="editTimelineStatus" id="editPrivateTimeline" value="private">
                                    <label class="form-check-label" for="editPrivateTimeline">Privada</label>
                                </div>
                            </div>
                            <small class="form-text text-muted">Alterar o status da Linha do Tempo para Pública ou Privada.</small>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="action-btn" style="background-color:#e53e3e;" data-dismiss="modal"><i class="fas fa-times"></i> Cancelar</button>
                        <button type="submit" class="action-btn" style="background-color:#08C89E;"><i class="fas fa-save"></i> Salvar Alterações</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Container para Toasts -->
    <div class="toast-container" aria-live="polite" aria-atomic="true">
        <!-- Toasts serão inseridos via JavaScript -->
    </div>

    <!-- Scripts Bootstrap -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Script para Gerenciar Linhas do Tempo -->
    <script>
        // Simulação do ID do Profissional Logado
        const currentProfessionalId = 'PROF123'; // Este valor deveria vir da sessão do usuário autenticado

        // Função para calcular a idade atual da criança
        function calculateAge(birthDate) {
            const today = new Date();
            const birth = new Date(birthDate);
            let age = today.getFullYear() - birth.getFullYear();
            const m = today.getMonth() - birth.getMonth();
            if (m < 0 || (m === 0 && today.getDate() < birth.getDate())) {
                age--;
            }
            return age;
        }

        // Função para formatar a data no formato dd/mm/yyyy
        function formatDate(dateString) {
            const options = { year: 'numeric', month: '2-digit', day: '2-digit' };
            return new Date(dateString).toLocaleDateString('pt-BR', options);
        }

        // Função para acessar o Portage da linha do tempo selecionada
        function accessPortage(timelineId) {
            // Redirecionar para a página do Portage com o timelineId como parâmetro
            window.location.href = 'painel-clinica-perfil-criança-linha-lista-portage.php?timelineId=' + timelineId;
        }

        // Função para abrir o modal de edição com os dados da Linha do Tempo selecionada
        function openEditTimelineModal(timelineId) {
            // Encontrar o card correspondente usando o data-timeline-id
            const card = document.querySelector(`.timeline-card[data-timeline-id="${timelineId}"]`);

            if(card) {
                // Extrair dados do card
                const patientName = card.querySelector('p strong').parentElement.nextElementSibling.textContent.trim();
                const statusBadge = card.querySelector('.badge').textContent.trim();
                const isPublic = statusBadge === 'Pública';

                // Preencher o formulário do modal de edição
                document.getElementById('editTimelineId').value = timelineId;
                document.getElementById('editPatientName').value = patientName;
                if(isPublic) {
                    document.getElementById('editPublicTimeline').checked = true;
                } else {
                    document.getElementById('editPrivateTimeline').checked = true;
                }

                // Abrir o modal de edição
                $('#editTimelineModal').modal('show');
            } else {
                alert('Linha do Tempo não encontrada.');
            }
        }

        // Função para excluir a linha do tempo
        function deleteTimeline(timelineId) {
            if(confirm('Tem certeza que deseja excluir a linha do tempo ' + timelineId + '? Esta ação não pode ser desfeita.')) {
                // Encontrar o card correspondente usando o data-timeline-id
                const card = document.querySelector(`.timeline-card[data-timeline-id="${timelineId}"]`);
                if(card) {
                    card.parentElement.remove(); // Remove o col que contém o card
                    // Mostrar notificação de sucesso
                    showToast('Linha do Tempo Excluída', 'A linha do tempo foi excluída com sucesso.');
                } else {
                    showToast('Erro', 'Não foi possível encontrar a Linha do Tempo para excluir.');
                }
            }
        }

        // Função para filtrar linhas do tempo pelo nome do paciente e ano de criação
        function filterTimelines() {
            const searchTerm = document.getElementById('searchInput').value.trim().toLowerCase();
            const filterYear = document.getElementById('filterDate').value;

            const cards = document.querySelectorAll('.timeline-card');
            cards.forEach(card => {
                // Filtrar apenas as linhas do tempo do profissional atual
                const professionalCode = card.querySelector('.professional-info p:nth-child(2)').textContent.replace('Código: ', '').trim();
                if(professionalCode !== currentProfessionalId){
                    card.parentElement.style.display = 'none';
                    return;
                }

                // Filtrar por nome do paciente
                const patientName = card.querySelector('p strong').parentElement.nextElementSibling.textContent.toLowerCase();
                const matchesSearch = patientName.includes(searchTerm);

                // Filtrar por ano de criação
                const creationDateText = card.querySelectorAll('p strong')[1].parentElement.nextElementSibling.textContent.trim(); // Assumindo que o segundo <p> com <strong> é a data
                const creationDate = creationDateText.split(': ')[1];
                const creationYear = new Date(creationDate).getFullYear().toString();
                const matchesYear = filterYear === '' || creationYear === filterYear;

                // Exibir ou ocultar o card
                if(matchesSearch && matchesYear){
                    card.parentElement.style.display = 'block';
                } else {
                    card.parentElement.style.display = 'none';
                }
            });
        }

        // Função para resetar os filtros
        function resetFilters() {
            document.getElementById('searchInput').value = '';
            document.getElementById('filterDate').value = '';
            filterTimelines();
        }

        // Função para mostrar toasts de notificações
        function showToast(title, message) {
            const toastContainer = document.querySelector('.toast-container');
            const toastId = 'toast' + Date.now();

            const toastHTML = `
                <div class="toast" id="${toastId}" role="alert" aria-live="assertive" aria-atomic="true" data-delay="3000">
                    <div class="toast-header">
                        <strong class="mr-auto text-success">${title}</strong>
                        <small>Agora</small>
                        <button type="button" class="ml-2 mb-1 close" data-dismiss="toast" aria-label="Fechar">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="toast-body">
                        ${message}
                    </div>
                </div>
            `;

            toastContainer.innerHTML += toastHTML;
            $('#' + toastId).toast('show');

            // Remover o toast do DOM após ocultar
            $('#' + toastId).on('hidden.bs.toast', function () {
                this.remove();
            });
        }

        // Evento para pesquisar
        document.getElementById('searchBtn').addEventListener('click', filterTimelines);

        // Evento para resetar filtros
        document.getElementById('resetBtn').addEventListener('click', resetFilters);

        // Evento para criar nova linha do tempo
        document.getElementById('timelineForm').addEventListener('submit', (e) => {
            e.preventDefault();
            const patientName = document.getElementById('patientName').value.trim();
            const creationDate = document.getElementById('creationDate').value;
            const timelineStatus = document.querySelector('input[name="timelineStatus"]:checked').value;

            if (patientName === '' || creationDate === '') {
                showToast('Erro', 'Preencha todos os campos para criar a linha do tempo.');
                return;
            }

            // Criar um novo ID simulado
            const existingCards = document.querySelectorAll('.timeline-card');
            const newIdNumber = existingCards.length > 0 ? parseInt(existingCards[existingCards.length -1].getAttribute('data-timeline-id').substring(2)) + 1 : 1;
            const newId = 'TL' + String(newIdNumber).padStart(3, '0');

            // Calcular a idade atual (assumindo que a criança tem data de nascimento igual à data de criação)
            const age = calculateAge(creationDate);

            // Criar novo card de linha do tempo
            const container = document.getElementById('timelinesContainer');
            const col = document.createElement('div');
            col.className = 'col-md-4 mb-4';

            const card = document.createElement('div');
            card.className = 'timeline-card';
            card.setAttribute('data-timeline-id', newId);
            card.setAttribute('data-status', timelineStatus);

            card.innerHTML = `
                <div class="timeline-header">
                    <p><strong>ID:</strong> ${newId}</p>
                    <span class="badge ${timelineStatus === 'public' ? 'badge-success' : 'badge-secondary'}">${timelineStatus === 'public' ? 'Pública' : 'Privada'}</span>
                </div>
                <!-- Informações da Criança -->
                <div class="child-info">
                    <h6><i class="fas fa-child"></i> Informações da Criança</h6>
                    <p><strong>Data de Nascimento:</strong> ${formatDate(creationDate)} (${age} anos)</p>
                    <p><strong>Gênero:</strong> <!-- Adicionar campo se necessário --></p>
                    <p><strong>Contato do Responsável:</strong> <!-- Adicionar campo se necessário --></p>
                </div>
                <!-- Informações do Profissional -->
                <div class="professional-info">
                    <h6><i class="fas fa-user-md"></i> Profissional Responsável</h6>
                    <p><strong>Nome:</strong> Dr. Carlos Pereira</p>
                    <p><strong>Código:</strong> PROF123</p>
                    <p><strong>Formação:</strong> Psicólogo Clínico</p>
                </div>
                <p><strong>Paciente:</strong> ${patientName}</p>
                <div class="mt-3">
                    <button class="action-btn" onclick="accessPortage('${newId}')"><i class="fas fa-arrow-right"></i> Acessar</button>
                    <button class="action-btn ml-2" onclick="openEditTimelineModal('${newId}')"><i class="fas fa-edit"></i> Editar</button>
                    <button class="action-btn ml-2" onclick="deleteTimeline('${newId}')"><i class="fas fa-trash-alt"></i> Excluir</button>
                </div>
            `;

            col.appendChild(card);
            container.appendChild(col);

            // Mostrar notificação de sucesso
            showToast('Sucesso', 'Nova linha do tempo criada com sucesso!');
            // Fechar modal
            $('#createTimelineModal').modal('hide');
            // Resetar o formulário
            document.getElementById('timelineForm').reset();
        });

        // Evento para salvar as alterações no modal de edição
        document.getElementById('editTimelineForm').addEventListener('submit', function(e) {
            e.preventDefault();
            const timelineId = document.getElementById('editTimelineId').value;
            const newStatus = document.querySelector('input[name="editTimelineStatus"]:checked').value;

            // Encontrar o card correspondente usando o data-timeline-id
            const card = document.querySelector(`.timeline-card[data-timeline-id="${timelineId}"]`);

            if(card) {
                // Atualizar o badge de status
                const badge = card.querySelector('.badge');
                if(newStatus === 'public') {
                    badge.textContent = 'Pública';
                    badge.className = 'badge badge-success';
                } else {
                    badge.textContent = 'Privada';
                    badge.className = 'badge badge-secondary';
                }

                // Atualizar o atributo data-status
                card.setAttribute('data-status', newStatus);

                // Mostrar notificação de sucesso
                showToast('Sucesso', 'Status da Linha do Tempo atualizado com sucesso.');

                // Fechar o modal
                $('#editTimelineModal').modal('hide');
            } else {
                showToast('Erro', 'Não foi possível atualizar o status da Linha do Tempo.');
            }
        });
    </script>
</body>
</html>
