<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Checklist PORTAGE - Avaliação Móvel</title>
    
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">

    <!-- Font Awesome para Ícones -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">

    <!-- Custom CSS -->
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f9fafb;
            color: #2d3748;
            padding-top: 70px; /* Espaço para o cabeçalho fixo */
        }

        h3, h4, h5 {
            color: #08C89E;
            margin-bottom: 15px;
        }

        p {
            font-size: 14px;
            color: #4a5568;
        }

        .info-section {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 10px 10px 0px 10px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }

        .info-section h5 {
            color: #08C89E;
            margin-bottom: 10px;
        }

        .info-section p {
            margin-bottom: 5px;
        }

        .avaliacoes-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            flex-wrap: wrap;
        }

        .checklist-left-section {
            display: flex;
            align-items: center;
            gap: 10px;
            flex-wrap: wrap;
            width: 100%;
            margin-bottom: 10px;
        }

        /* Estilização dos Botões */
        .checklist-editar-btn,
        .btn-back,
        .btn-save,
        .btn-load {
            padding: 8px 16px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
            display: flex;
            align-items: center;
            gap: 5px;
            color: white;
        }

        .btn-back {
            background-color: #4a5568;
        }

        .btn-back:hover {
            background-color: #2d3748;
        }

        .btn-save {
            background-color: #08C89E;
        }

        .btn-save:hover {
            background-color: #069f7a;
        }

        .btn-load {
            background-color: #3182ce;
        }

        .btn-load:hover {
            background-color: #2c5282;
        }

        /* Responsividade */
        @media (max-width: 576px) {
            .avaliacoes-container {
                flex-direction: column;
                align-items: stretch;
            }

            .checklist-left-section {
                width: 100%;
                justify-content: center;
            }

            .checklist-avaliacao-select {
                width: 100%;
                margin-top: 10px;
            }
        }

        /* Card renomeado para evitar conflitos */
        .portage-card {
            background: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            transition: box-shadow 0.3s ease, border 0.3s ease;
            cursor: pointer;
        }

        .portage-card:hover {
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }

        /* Estilo quando card estiver selecionado */
        .portage-card.selected {
            border: 2px solid #08C89E;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }

        .checkbox-title {
            font-weight: 600;
            margin-bottom: 5px;
            font-size: 16px;
            color: #2d3748;
        }

        .skill-description {
            font-size: 13px;
            color: #4a5568;
            margin-bottom: 10px;
        }

        .skill-actions {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
            border-top: 1px solid #e2e8f0;
            border-bottom: 1px solid #e2e8f0;
            padding: 10px 0;
        }

        .skill-actions .option {
            flex: 1;
            text-align: center;
        }

        .skill-actions .option:not(:last-child) {
            border-right: 1px solid #e2e8f0;
        }

        .skill-actions .option:last-child {
            border-right: none;
        }

        .skill-actions .option label {
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100%;
        }

        .skill-actions .option input[type="radio"] {
            margin-right: 5px;
        }

        /* Renomeando classes de orientação */
        .portage-orientation-toggle {
            display: flex;
            align-items: center;
            gap: 5px;
            cursor: pointer;
            color: #3182ce;
            font-size: 14px;
        }

        .portage-orientation-text {
            margin-top: 10px;
            display: none;
            font-size: 13px;
            line-height: 1.4;
            color: #4a5568;
        }

        /* Ícone de seta rotacionar quando ativo */
        .portage-orientation-toggle.rotate i {
            transform: rotate(180deg);
            transition: transform 0.3s;
        }

        /* Modal Customizado */
        .modal-header {
            background-color: #08C89E;
            color: white;
            border-bottom: none;
        }

        .modal-footer {
            border-top: none;
        }
        
        /* Estilização Geral das Abas */
        .nav-tabs {
            border-bottom: 2px solid #08C89E; /* Linha inferior das abas principais */
        }

        .nav-tabs .nav-link {
            color: #4a5568; /* Cor do texto das abas */
            font-weight: 600; /* Peso da fonte */
            border: none; /* Remove bordas padrão */
            border-radius: 10px 10px 0px 0px; /* Remove bordas arredondadas */
            margin-right: 0px; /* Espaçamento entre as abas */
            padding: 10px 15px; /* Padding interno das abas */
            transition: background-color 0.3s, color 0.3s; /* Transições suaves */
            border-bottom: 1px solid #e2e8f0; /* Borda das abas */
        }

        .nav-tabs .nav-link.active {
            color: #ffffff; /* Cor do texto da aba ativa */
            background-color: #08C89E; /* Fundo da aba ativa */
            border-bottom: 2px solid #08C89E; /* Linha inferior da aba ativa */
        }

        /* Estilização das Sub-Abas */
        .tab-content .nav-tabs {
            border-bottom: 1px solid #e2e8f0; /* Linha inferior das sub-abas */
            margin-bottom: 15px; /* Espaçamento abaixo das sub-abas */
        }

        .tab-content .nav-tabs .nav-link {
            color: #2d3748; /* Cor do texto das sub-abas */
            background-color: #f5f8fb; /* Fundo das sub-abas */
            font-weight: 500; /* Peso da fonte */
            margin-right: 2px;
        }

        .tab-content .nav-tabs .nav-link.active {
            color: #ffffff; /* Cor do texto da sub-aba ativa */
            background-color: #3182ce; /* Fundo da sub-aba ativa */
            border-bottom: none; /* Remove a linha inferior da sub-aba ativa */
        }

        /* Estilização das Páginas das Abas (Tab Panes) */
        .tab-pane {
            padding: 20px; /* Padding interno das abas */
            background-color: #ffffff; /* Fundo das abas */
            border: 1px solid #e2e8f0; /* Borda das abas */
            border-top: none; /* Remove a borda superior para conectar com as abas */
            border-radius: 0 0 8px 8px; /* Bordas arredondadas na parte inferior */
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05); /* Sombra sutil */
            transition: opacity 0.3s ease-in-out; /* Transição de opacidade suave */
            opacity: 0; /* Opacidade inicial */
            height: 100%; /* Altura completa */
        }

        .tab-pane.show {
            opacity: 1; /* Opacidade quando a aba está ativa */
        }

        /* Estilização para Abas Aninhadas */
        .tab-content .tab-content .nav-tabs {
            border-bottom: 1px solid #cbd5e0; /* Linha inferior das sub-sub-abas */
            margin-bottom: 10px; /* Espaçamento abaixo das sub-sub-abas */
        }

        .tab-content .tab-content .nav-tabs .nav-link {
            color: #2d3748; /* Cor do texto das sub-sub-abas */
            background-color: #edf2f7; /* Fundo das sub-sub-abas */
            font-weight: 500; /* Peso da fonte */
            margin-right: 2px;
        }

        .tab-content .tab-content .nav-tabs .nav-link.active {
            color: #ffffff; /* Cor do texto da sub-sub-aba ativa */
            background-color: #2b6cb0; /* Fundo da sub-sub-aba ativa */
            border-bottom: none; /* Remove a borda inferior da sub-sub-aba ativa */
        }

        .tab-content .tab-content .tab-pane {
            padding: 15px; /* Padding interno das sub-abas */
            background-color: #e9f4ff; /* Fundo das sub-abas */
            border: 1px solid #cbd5e0; /* Borda das sub-abas */
            border-top: none; /* Remove a borda superior para conectar com as sub-abas */
            border-radius: 0 0 6px 6px; /* Bordas arredondadas na parte inferior */
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05); /* Sombra sutil */
        }

        .tab-content .tab-content .tab-pane.show {
            opacity: 1; /* Opacidade quando a sub-aba está ativa */
        }

        /* Transições Suaves para Abas Aninhadas */
        .tab-content .tab-content .tab-pane {
            transition: opacity 0.3s ease-in-out;
            opacity: 0;
        }

        /* Responsividade para Dispositivos Móveis */
        @media (max-width: 768px) {
            body {
                padding: 0px;
                margin-top: 70px;
            }
            
            .nav-tabs .nav-link {
                padding: 8px 12px; /* Reduz o padding em telas menores */
                font-size: 14px; /* Reduz o tamanho da fonte */
            }

            .tab-content .nav-tabs .nav-link {
                padding: 6px 10px; /* Reduz o padding das sub-abas */
                font-size: 13px; /* Reduz o tamanho da fonte das sub-abas */
            }

            .tab-content .tab-content .nav-tabs .nav-link {
                padding: 5px 8px; /* Reduz ainda mais o padding das sub-sub-abas */
                font-size: 12px; /* Reduz o tamanho da fonte das sub-sub-abas */
            }

            .tab-pane, .tab-content .tab-content .tab-pane {
                padding: 15px; /* Ajusta o padding interno */
            }
        }

        /* Melhorias Visuais para Padrões de Abas */
        .tab-content .tab-content .nav-tabs .nav-link:hover {
            background-color: #2c5282; /* Fundo das sub-sub-abas ao passar o mouse */
        }

        /* Scroll suave para mobile */
        .tab-content {
            overflow-x: auto;
        }
        
        /* Navbar Customizada */
        .navbar {
            background-color: #08C89E;
        }

        .navbar-brand, .navbar-nav .nav-link, .navbar-toggler-icon {
            color: #fff !important;
        }
    </style>
</head>
<body>
    <!-- Cabeçalho (Navbar) -->
    <!-- Navbar Fixa -->
    <nav class="navbar navbar-expand-lg navbar-dark fixed-top">
        <a class="navbar-brand" href="#">IFCora - Portage</a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#mobileNavbar" aria-controls="mobileNavbar" aria-expanded="false" aria-label="Alternar navegação">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="mobileNavbar">
            <ul class="navbar-nav mr-auto">
                
                <!-- Adicione mais itens de navegação conforme necessário -->
            </ul>
            <ul class="navbar-nav">
                
                <li class="nav-item">
                    <a class="nav-link" href="logout.php"><i class="fas fa-sign-out-alt"></i> Sair</a>
                </li>
            </ul>
        </div>
    </nav>
    
    

    <div class="container-fluid">
        <h3>Checklist PORTAGE</h3>
        <p style="margin-top:-20px">Toque nas orientações para expandir dicas e informações adicionais.</p>
        
        
        
        <!-- Seção de Informações sobre a Criança, Profissional e Avaliação (Compacta com Accordion) -->
        <div class="info-section">
            <h5 data-toggle="collapse" href="#infoContent" role="button" aria-expanded="false" aria-controls="infoContent">
                <i class="fas fa-user"></i> Informações da Avaliação <i class="fas fa-chevron-down float-right"></i>
            </h5>
            <div class="collapse info-content" id="infoContent">
                <div class="row">
                    <!-- Informações da Criança -->
                    <div class="col-md-4">
                        <h6><i class="fas fa-child"></i> Criança</h6>
                        <p><strong>Nome:</strong> João da Silva</p>
                        <p><strong>Data de Nascimento:</strong> 20/05/2018 (6 anos)</p>
                        <p><strong>Gênero:</strong> Masculino</p>
                    </div>
                    <!-- Informações do Profissional -->
                    <div class="col-md-4">
                        <h6><i class="fas fa-user-md"></i> Profissional</h6>
                        <p><strong>Nome:</strong> Dr. Maria Oliveira</p>
                        <p><strong>Especialidade:</strong> Psicopedagoga</p>
                        <p><strong>Contato:</strong> maria.oliveira@clinicaportage.com</p>
                    </div>
                    <!-- Informações da Avaliação -->
                    <div class="col-md-4">
                        <h6><i class="fas fa-file-alt"></i> Avaliação</h6>
                        <p><strong>ID Avaliação:</strong> AV27490</p>
                        <p><strong>Data:</strong> 28/06/2024</p>
                        <p><strong>Status:</strong> Aberta</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Seção de Gerenciamento de Avaliações -->
        <div class="avaliacoes-container">
            <div class="checklist-left-section">
                
                <button type="button" class="btn-save" id="saveBtn">
                    <i class="fas fa-save"></i> Salvar Avaliação
                </button>
                
            </div>
        </div>
        
        <!-- Abas de áreas de desenvolvimento -->
        <ul class="nav nav-tabs" id="areaTabs" role="tablist">
            <li class="nav-item">
                <a class="nav-link active" href="#motor" data-toggle="tab" role="tab" aria-controls="motor" aria-selected="true">Motor</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#cognicao" data-toggle="tab" role="tab" aria-controls="cognicao" aria-selected="false">Cognição</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#social" data-toggle="tab" role="tab" aria-controls="social" aria-selected="false">Social</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#linguagem" data-toggle="tab" role="tab" aria-controls="linguagem" aria-selected="false">Linguagem</a>
            </li>
        </ul>

        <div class="tab-content nested-tab-content">
            <!-- Área Motor -->
            <div id="motor" class="tab-pane fade show active" role="tabpanel">
                <h4 class="mt-3">Motor</h4>
                
                <!-- Sub-abas de faixas etárias para Motor -->
                <ul class="nav nav-tabs mt-3" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" href="#motor0_1" data-toggle="tab" role="tab" aria-controls="motor0_1" aria-selected="true">0 - 1</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#motor1_2" data-toggle="tab" role="tab" aria-controls="motor1_2" aria-selected="false">1 - 2</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#motor2_3" data-toggle="tab" role="tab" aria-controls="motor2_3" aria-selected="false">2 - 3</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#motor3_4" data-toggle="tab" role="tab" aria-controls="motor3_4" aria-selected="false">3 - 4</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#motor4_5" data-toggle="tab" role="tab" aria-controls="motor4_5" aria-selected="false">4 - 5</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#motor5_6" data-toggle="tab" role="tab" aria-controls="motor5_6" aria-selected="false">5 - 6</a>
                    </li>
                </ul>

                <div class="tab-content nested-tab-content" style="margin-top: -15px">
                    <!-- Faixa 0-1 ano - Motor -->
                    <div id="motor0_1" class="tab-pane fade show active" role="tabpanel">
                        <h5 class="mt-3">0-1 ano</h5>
                        
                        <!-- Card 1 -->
                        <div class="portage-card">
                            <div class="checkbox-title">Seguir objeto com o olhar</div>
                            <div class="skill-description">A criança acompanha visualmente um objeto em movimento.</div>
                            <div class="skill-actions">
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor0_1_item1" value="Sim">
                                        Sim
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor0_1_item1" value="AV">
                                        AV
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor0_1_item1" value="Não">
                                        Não
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor0_1_item1" value="X">
                                        X
                                    </label>
                                </div>
                            </div>
                            <div class="portage-orientation-toggle" data-target="orientMotor0_1_item1">
                                <i class="fas fa-chevron-down"></i> Orientações
                            </div>
                            <div class="portage-orientation-text" id="orientMotor0_1_item1">
                                Acompanhar objetos visuais é crucial para o desenvolvimento visual e motor da criança. Observe se ela segue o objeto sem dificuldades.
                            </div>
                        </div>

                        <!-- Card 2 -->
                        <div class="portage-card">
                            <div class="checkbox-title">Levanta a cabeça ao deitar de bruços</div>
                            <div class="skill-description">A criança levanta a cabeça e a mantém erguida por alguns segundos ao ficar de barriga para baixo.</div>
                            <div class="skill-actions">
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor0_1_item2" value="Sim">
                                        Sim
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor0_1_item2" value="AV">
                                        AV
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor0_1_item2" value="Não">
                                        Não
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor0_1_item2" value="X">
                                        X
                                    </label>
                                </div>
                            </div>
                            <div class="portage-orientation-toggle" data-target="orientMotor0_1_item2">
                                <i class="fas fa-chevron-down"></i> Orientações
                            </div>
                            <div class="portage-orientation-text" id="orientMotor0_1_item2">
                                Levantar a cabeça durante o tempo de bruços fortalece os músculos do pescoço e costas, essenciais para futuros marcos motores.
                            </div>
                        </div>
                    </div>

                    <!-- Faixa 1-2 anos - Motor -->
                    <div id="motor1_2" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">1-2 anos</h5>
                        
                        <!-- Card 1 -->
                        <div class="portage-card">
                            <div class="checkbox-title">Fica em pé sem apoio</div>
                            <div class="skill-description">A criança consegue ficar em pé sozinha por alguns segundos.</div>
                            <div class="skill-actions">
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor1_2_item1" value="Sim">
                                        Sim
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor1_2_item1" value="AV">
                                        AV
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor1_2_item1" value="Não">
                                        Não
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor1_2_item1" value="X">
                                        X
                                    </label>
                                </div>
                            </div>
                            <div class="portage-orientation-toggle" data-target="orientMotor1_2_item1">
                                <i class="fas fa-chevron-down"></i> Orientações
                            </div>
                            <div class="portage-orientation-text" id="orientMotor1_2_item1">
                                Ficar em pé sem apoio é um indicador importante de força e equilíbrio. Observe se a criança consegue manter-se ereta sem ajuda.
                            </div>
                        </div>
                    </div>

                    <!-- Faixa 2-3 anos - Motor -->
                    <div id="motor2_3" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">2-3 anos</h5>
                        
                        <!-- Card 1 -->
                        <div class="portage-card">
                            <div class="checkbox-title">Corre com agilidade</div>
                            <div class="skill-description">A criança corre sem cair facilmente, mudando de direção quando necessário.</div>
                            <div class="skill-actions">
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor2_3_item1" value="Sim">
                                        Sim
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor2_3_item1" value="AV">
                                        AV
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor2_3_item1" value="Não">
                                        Não
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor2_3_item1" value="X">
                                        X
                                    </label>
                                </div>
                            </div>
                            <div class="portage-orientation-toggle" data-target="orientMotor2_3_item1">
                                <i class="fas fa-chevron-down"></i> Orientações
                            </div>
                            <div class="portage-orientation-text" id="orientMotor2_3_item1">
                                Correr com agilidade demonstra coordenação motora e equilíbrio. Observe se a criança consegue mudar de direção sem tropeçar frequentemente.
                            </div>
                        </div>
                    </div>

                    <!-- Faixa 3-4 anos - Motor -->
                    <div id="motor3_4" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">3-4 anos</h5>
                        
                        <!-- Card 1 -->
                        <div class="portage-card">
                            <div class="checkbox-title">Pula corda</div>
                            <div class="skill-description">A criança consegue pular corda sem tropeçar.</div>
                            <div class="skill-actions">
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor3_4_item1" value="Sim">
                                        Sim
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor3_4_item1" value="AV">
                                        AV
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor3_4_item1" value="Não">
                                        Não
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor3_4_item1" value="X">
                                        X
                                    </label>
                                </div>
                            </div>
                            <div class="portage-orientation-toggle" data-target="orientMotor3_4_item1">
                                <i class="fas fa-chevron-down"></i> Orientações
                            </div>
                            <div class="portage-orientation-text" id="orientMotor3_4_item1">
                                Pular corda desenvolve a coordenação motora fina e grossa, além de resistência física. Verifique se a criança realiza o movimento com fluidez.
                            </div>
                        </div>
                    </div>

                    <!-- Faixa 4-5 anos - Motor -->
                    <div id="motor4_5" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">4-5 anos</h5>
                        
                        <!-- Card 1 -->
                        <div class="portage-card">
                            <div class="checkbox-title">Fazer movimentos precisos com as mãos</div>
                            <div class="skill-description">A criança realiza atividades que exigem coordenação fina, como desenhar círculos.</div>
                            <div class="skill-actions">
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor4_5_item1" value="Sim">
                                        Sim
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor4_5_item1" value="AV">
                                        AV
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor4_5_item1" value="Não">
                                        Não
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor4_5_item1" value="X">
                                        X
                                    </label>
                                </div>
                            </div>
                            <div class="portage-orientation-toggle" data-target="orientMotor4_5_item1">
                                <i class="fas fa-chevron-down"></i> Orientações
                            </div>
                            <div class="portage-orientation-text" id="orientMotor4_5_item1">
                                Movimentos precisos com as mãos são essenciais para atividades escolares futuras, como escrita. Observe a capacidade de controle e precisão da criança.
                            </div>
                        </div>
                    </div>

                    <!-- Faixa 5-6 anos - Motor -->
                    <div id="motor5_6" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">5-6 anos</h5>
                        
                        <!-- Card 1 -->
                        <div class="portage-card">
                            <div class="checkbox-title">Participar de esportes organizados</div>
                            <div class="skill-description">A criança participa de atividades esportivas com regras estabelecidas.</div>
                            <div class="skill-actions">
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor5_6_item1" value="Sim">
                                        Sim
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor5_6_item1" value="AV">
                                        AV
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor5_6_item1" value="Não">
                                        Não
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="motor5_6_item1" value="X">
                                        X
                                    </label>
                                </div>
                            </div>
                            <div class="portage-orientation-toggle" data-target="orientMotor5_6_item1">
                                <i class="fas fa-chevron-down"></i> Orientações
                            </div>
                            <div class="portage-orientation-text" id="orientMotor5_6_item1">
                                Participar de esportes organizados desenvolve habilidades sociais, disciplina e coordenação motora avançada. Observe o engajamento e a compreensão das regras pela criança.
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Área Linguagem -->
            <div id="linguagem" class="tab-pane fade" role="tabpanel">
                <h4 class="mt-3">Linguagem</h4>
                
                <!-- Sub-abas de faixas etárias para Linguagem -->
                <ul class="nav nav-tabs mt-3" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" href="#ling0_1" data-toggle="tab" role="tab" aria-controls="ling0_1" aria-selected="true">0-1</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#ling1_2" data-toggle="tab" role="tab" aria-controls="ling1_2" aria-selected="false">1-2</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#ling2_3" data-toggle="tab" role="tab" aria-controls="ling2_3" aria-selected="false">2-3</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#ling3_4" data-toggle="tab" role="tab" aria-controls="ling3_4" aria-selected="false">3-4</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#ling4_5" data-toggle="tab" role="tab" aria-controls="ling4_5" aria-selected="false">4-5</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#ling5_6" data-toggle="tab" role="tab" aria-controls="ling5_6" aria-selected="false">5-6</a>
                    </li>
                </ul>

                <div class="tab-content nested-tab-content" style="margin-top: -15px">
                    <!-- Faixa 0-1 ano - Linguagem -->
                    <div id="ling0_1" class="tab-pane fade show active" role="tabpanel">
                        <h5 class="mt-3">0-1 ano</h5>
                        
                        <!-- Card 1 -->
                        <div class="portage-card">
                            <div class="checkbox-title">Emite sons para chamar atenção</div>
                            <div class="skill-description">A criança vocaliza (arrulhos, risadas) para interagir.</div>
                            <div class="skill-actions">
                                <div class="option">
                                    <label>
                                        <input type="radio" name="ling0_1_item1" value="Sim">
                                        Sim
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="ling0_1_item1" value="AV">
                                        AV
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="ling0_1_item1" value="Não">
                                        Não
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="ling0_1_item1" value="X">
                                        X
                                    </label>
                                </div>
                            </div>
                            <div class="portage-orientation-toggle" data-target="orientLing0_1_item1">
                                <i class="fas fa-chevron-down"></i> Orientações
                            </div>
                            <div class="portage-orientation-text" id="orientLing0_1_item1">
                                Emissão de sons é fundamental para o desenvolvimento da linguagem. Observe se a criança vocaliza de forma consistente para chamar atenção.
                            </div>
                        </div>
                    </div>

                    <!-- Faixa 1-2 anos - Linguagem -->
                    <div id="ling1_2" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">1-2 anos</h5>
                        
                        <!-- Card 1 -->
                        <div class="portage-card">
                            <div class="checkbox-title">Fala palavras simples (ex: 'mama', 'dada')</div>
                            <div class="skill-description">A criança utiliza algumas palavras para se comunicar.</div>
                            <div class="skill-actions">
                                <div class="option">
                                    <label>
                                        <input type="radio" name="ling1_2_item1" value="Sim">
                                        Sim
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="ling1_2_item1" value="AV">
                                        AV
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="ling1_2_item1" value="Não">
                                        Não
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="ling1_2_item1" value="X">
                                        X
                                    </label>
                                </div>
                            </div>
                            <div class="portage-orientation-toggle" data-target="orientLing1_2_item1">
                                <i class="fas fa-chevron-down"></i> Orientações
                            </div>
                            <div class="portage-orientation-text" id="orientLing1_2_item1">
                                Falar palavras simples indica o desenvolvimento da linguagem verbal. Verifique se a criança está começando a formar palavras para comunicação básica.
                            </div>
                        </div>
                    </div>

                    <!-- Faixa 2-3 anos - Linguagem -->
                    <div id="ling2_3" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">2-3 anos</h5>
                        
                        <!-- Card 1 -->
                        <div class="portage-card">
                            <div class="checkbox-title">Formação de frases simples</div>
                            <div class="skill-description">A criança começa a formar frases com duas ou três palavras.</div>
                            <div class="skill-actions">
                                <div class="option">
                                    <label>
                                        <input type="radio" name="ling2_3_item1" value="Sim">
                                        Sim
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="ling2_3_item1" value="AV">
                                        AV
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="ling2_3_item1" value="Não">
                                        Não
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="ling2_3_item1" value="X">
                                        X
                                    </label>
                                </div>
                            </div>
                            <div class="portage-orientation-toggle" data-target="orientLing2_3_item1">
                                <i class="fas fa-chevron-down"></i> Orientações
                            </div>
                            <div class="portage-orientation-text" id="orientLing2_3_item1">
                                A formação de frases simples demonstra o avanço na capacidade de comunicação. Observe se a criança consegue expressar ideias mais complexas com frases curtas.
                            </div>
                        </div>
                    </div>

                    <!-- Faixa 3-4 anos - Linguagem -->
                    <div id="ling3_4" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">3-4 anos</h5>
                        
                        <!-- Card 1 -->
                        <div class="portage-card">
                            <div class="checkbox-title">Conta histórias simples</div>
                            <div class="skill-description">A criança consegue narrar histórias com começo, meio e fim.</div>
                            <div class="skill-actions">
                                <div class="option">
                                    <label>
                                        <input type="radio" name="ling3_4_item1" value="Sim">
                                        Sim
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="ling3_4_item1" value="AV">
                                        AV
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="ling3_4_item1" value="Não">
                                        Não
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="ling3_4_item1" value="X">
                                        X
                                    </label>
                                </div>
                            </div>
                            <div class="portage-orientation-toggle" data-target="orientLing3_4_item1">
                                <i class="fas fa-chevron-down"></i> Orientações
                            </div>
                            <div class="portage-orientation-text" id="orientLing3_4_item1">
                                Contar histórias simples é um marco no desenvolvimento da linguagem e da capacidade de sequenciar eventos. Observe se a criança consegue organizar pensamentos de forma coerente.
                            </div>
                        </div>
                    </div>

                    <!-- Faixa 4-5 anos - Linguagem -->
                    <div id="ling4_5" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">4-5 anos</h5>
                        
                        <!-- Card 1 -->
                        <div class="portage-card">
                            <div class="checkbox-title">Utiliza tempos verbais corretos</div>
                            <div class="skill-description">A criança usa corretamente os tempos verbais passado, presente e futuro.</div>
                            <div class="skill-actions">
                                <div class="option">
                                    <label>
                                        <input type="radio" name="ling4_5_item1" value="Sim">
                                        Sim
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="ling4_5_item1" value="AV">
                                        AV
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="ling4_5_item1" value="Não">
                                        Não
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="ling4_5_item1" value="X">
                                        X
                                    </label>
                                </div>
                            </div>
                            <div class="portage-orientation-toggle" data-target="orientLing4_5_item1">
                                <i class="fas fa-chevron-down"></i> Orientações
                            </div>
                            <div class="portage-orientation-text" id="orientLing4_5_item1">
                                Utilizar tempos verbais corretos indica um avanço significativo na estruturação da linguagem. Observe se a criança consegue diferenciar e usar adequadamente os tempos passado, presente e futuro.
                            </div>
                        </div>
                    </div>

                    <!-- Faixa 5-6 anos - Linguagem -->
                    <div id="ling5_6" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">5-6 anos</h5>
                        
                        <!-- Card 1 -->
                        <div class="portage-card">
                            <div class="checkbox-title">Lê palavras simples</div>
                            <div class="skill-description">A criança consegue identificar e ler palavras simples.</div>
                            <div class="skill-actions">
                                <div class="option">
                                    <label>
                                        <input type="radio" name="ling5_6_item1" value="Sim">
                                        Sim
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="ling5_6_item1" value="AV">
                                        AV
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="ling5_6_item1" value="Não">
                                        Não
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="ling5_6_item1" value="X">
                                        X
                                    </label>
                                </div>
                            </div>
                            <div class="portage-orientation-toggle" data-target="orientLing5_6_item1">
                                <i class="fas fa-chevron-down"></i> Orientações
                            </div>
                            <div class="portage-orientation-text" id="orientLing5_6_item1">
                                Ler palavras simples é um marco importante na alfabetização. Observe se a criança reconhece e lê palavras comuns e simples com facilidade.
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Área Social -->
            <div id="social" class="tab-pane fade" role="tabpanel">
                <h4 class="mt-3">Social</h4>
                
                <!-- Sub-abas de faixas etárias para Social -->
                <ul class="nav nav-tabs mt-3" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" href="#social0_1" data-toggle="tab" role="tab" aria-controls="social0_1" aria-selected="true">0-1</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#social1_2" data-toggle="tab" role="tab" aria-controls="social1_2" aria-selected="false">1-2</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#social2_3" data-toggle="tab" role="tab" aria-controls="social2_3" aria-selected="false">2-3</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#social3_4" data-toggle="tab" role="tab" aria-controls="social3_4" aria-selected="false">3-4</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#social4_5" data-toggle="tab" role="tab" aria-controls="social4_5" aria-selected="false">4-5</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#social5_6" data-toggle="tab" role="tab" aria-controls="social5_6" aria-selected="false">5-6</a>
                    </li>
                </ul>

                <div class="tab-content nested-tab-content" style="margin-top: -15px">
                    <!-- Faixa 0-1 ano - Social -->
                    <div id="social0_1" class="tab-pane fade show active" role="tabpanel">
                        <h5 class="mt-3">0-1 ano</h5>
                        
                        <!-- Card 1 -->
                        <div class="portage-card">
                            <div class="checkbox-title">Sorrir em resposta a outro sorriso</div>
                            <div class="skill-description">Responde sorrindo quando alguém sorri para ela.</div>
                            <div class="skill-actions">
                                <div class="option">
                                    <label>
                                        <input type="radio" name="social0_1_item1" value="Sim">
                                        Sim
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="social0_1_item1" value="AV">
                                        AV
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="social0_1_item1" value="Não">
                                        Não
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="social0_1_item1" value="X">
                                        X
                                    </label>
                                </div>
                            </div>
                            <div class="portage-orientation-toggle" data-target="orientSocial0_1_item1">
                                <i class="fas fa-chevron-down"></i> Orientações
                            </div>
                            <div class="portage-orientation-text" id="orientSocial0_1_item1">
                                Sorrir em resposta é um sinal de desenvolvimento social saudável. Verifique se a criança está engajada em interações sociais básicas.
                            </div>
                        </div>
                    </div>

                    <!-- Faixa 1-2 anos - Social -->
                    <div id="social1_2" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">1-2 anos</h5>
                        
                        <!-- Card 1 -->
                        <div class="portage-card">
                            <div class="checkbox-title">Brinca de esconde-esconde (cadê-achou)</div>
                            <div class="skill-description">A criança participa de jogos simples de esconde-esconde.</div>
                            <div class="skill-actions">
                                <div class="option">
                                    <label>
                                        <input type="radio" name="social1_2_item1" value="Sim">
                                        Sim
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="social1_2_item1" value="AV">
                                        AV
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="social1_2_item1" value="Não">
                                        Não
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="social1_2_item1" value="X">
                                        X
                                    </label>
                                </div>
                            </div>
                            <div class="portage-orientation-toggle" data-target="orientSocial1_2_item1">
                                <i class="fas fa-chevron-down"></i> Orientações
                            </div>
                            <div class="portage-orientation-text" id="orientSocial1_2_item1">
                                Participar de jogos de esconde-esconde desenvolve habilidades sociais e cognitivas. Observe se a criança entende a lógica do jogo e participa ativamente.
                            </div>
                        </div>
                    </div>

                    <!-- Faixa 2-3 anos - Social -->
                    <div id="social2_3" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">2-3 anos</h5>
                        
                        <!-- Card 1 -->
                        <div class="portage-card">
                            <div class="checkbox-title">Compartilha brinquedos com outras crianças</div>
                            <div class="skill-description">A criança compartilha brinquedos voluntariamente durante as brincadeiras.</div>
                            <div class="skill-actions">
                                <div class="option">
                                    <label>
                                        <input type="radio" name="social2_3_item1" value="Sim">
                                        Sim
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="social2_3_item1" value="AV">
                                        AV
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="social2_3_item1" value="Não">
                                        Não
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="social2_3_item1" value="X">
                                        X
                                    </label>
                                </div>
                            </div>
                            <div class="portage-orientation-toggle" data-target="orientSocial2_3_item1">
                                <i class="fas fa-chevron-down"></i> Orientações
                            </div>
                            <div class="portage-orientation-text" id="orientSocial2_3_item1">
                                Compartilhar brinquedos é fundamental para o desenvolvimento das habilidades sociais, como empatia e cooperação. Observe se a criança está disposta a compartilhar durante as interações.
                            </div>
                        </div>
                    </div>

                    <!-- Faixa 3-4 anos - Social -->
                    <div id="social3_4" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">3-4 anos</h5>
                        
                        <!-- Card 1 -->
                        <div class="portage-card">
                            <div class="checkbox-title">Joga de faz de conta</div>
                            <div class="skill-description">A criança participa de brincadeiras de faz de conta, assumindo papéis diferentes.</div>
                            <div class="skill-actions">
                                <div class="option">
                                    <label>
                                        <input type="radio" name="social3_4_item1" value="Sim">
                                        Sim
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="social3_4_item1" value="AV">
                                        AV
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="social3_4_item1" value="Não">
                                        Não
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="social3_4_item1" value="X">
                                        X
                                    </label>
                                </div>
                            </div>
                            <div class="portage-orientation-toggle" data-target="orientSocial3_4_item1">
                                <i class="fas fa-chevron-down"></i> Orientações
                            </div>
                            <div class="portage-orientation-text" id="orientSocial3_4_item1">
                                Participar de brincadeiras de faz de conta desenvolve a imaginação e as habilidades sociais. Observe se a criança consegue assumir diferentes papéis e interagir de forma criativa.
                            </div>
                        </div>
                    </div>

                    <!-- Faixa 4-5 anos - Social -->
                    <div id="social4_5" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">4-5 anos</h5>
                        
                        <!-- Card 1 -->
                        <div class="portage-card">
                            <div class="checkbox-title">Trabalha em grupo durante as brincadeiras</div>
                            <div class="skill-description">A criança colabora e interage com outras crianças durante as brincadeiras em grupo.</div>
                            <div class="skill-actions">
                                <div class="option">
                                    <label>
                                        <input type="radio" name="social4_5_item1" value="Sim">
                                        Sim
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="social4_5_item1" value="AV">
                                        AV
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="social4_5_item1" value="Não">
                                        Não
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="social4_5_item1" value="X">
                                        X
                                    </label>
                                </div>
                            </div>
                            <div class="portage-orientation-toggle" data-target="orientSocial4_5_item1">
                                <i class="fas fa-chevron-down"></i> Orientações
                            </div>
                            <div class="portage-orientation-text" id="orientSocial4_5_item1">
                                Trabalhar em grupo durante as brincadeiras é essencial para o desenvolvimento das habilidades de cooperação e comunicação. Observe se a criança consegue colaborar e interagir positivamente com os demais.
                            </div>
                        </div>
                    </div>

                    <!-- Faixa 5-6 anos - Social -->
                    <div id="social5_6" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">5-6 anos</h5>
                        
                        <!-- Card 1 -->
                        <div class="portage-card">
                            <div class="checkbox-title">Respeita as regras de jogos</div>
                            <div class="skill-description">A criança entende e segue as regras estabelecidas em jogos e atividades.</div>
                            <div class="skill-actions">
                                <div class="option">
                                    <label>
                                        <input type="radio" name="social5_6_item1" value="Sim">
                                        Sim
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="social5_6_item1" value="AV">
                                        AV
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="social5_6_item1" value="Não">
                                        Não
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="social5_6_item1" value="X">
                                        X
                                    </label>
                                </div>
                            </div>
                            <div class="portage-orientation-toggle" data-target="orientSocial5_6_item1">
                                <i class="fas fa-chevron-down"></i> Orientações
                            </div>
                            <div class="portage-orientation-text" id="orientSocial5_6_item1">
                                Respeitar as regras de jogos é fundamental para a disciplina e a interação social saudável. Observe se a criança compreende e segue as regras estabelecidas durante as atividades.
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Área Cognição -->
            <div id="cognicao" class="tab-pane fade" role="tabpanel">
                <h4 class="mt-3">Cognição</h4>
                
                <!-- Sub-abas de faixas etárias para Cognição -->
                <ul class="nav nav-tabs mt-3" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" href="#cog0_1" data-toggle="tab" role="tab" aria-controls="cog0_1" aria-selected="true">0-1</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#cog1_2" data-toggle="tab" role="tab" aria-controls="cog1_2" aria-selected="false">1-2</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#cog2_3" data-toggle="tab" role="tab" aria-controls="cog2_3" aria-selected="false">2-3</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#cog3_4" data-toggle="tab" role="tab" aria-controls="cog3_4" aria-selected="false">3-4</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#cog4_5" data-toggle="tab" role="tab" aria-controls="cog4_5" aria-selected="false">4-5</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#cog5_6" data-toggle="tab" role="tab" aria-controls="cog5_6" aria-selected="false">5-6</a>
                    </li>
                </ul>

                <div class="tab-content nested-tab-content" style="margin-top: -15px">
                    <!-- Faixa 0-1 ano - Cognição -->
                    <div id="cog0_1" class="tab-pane fade show active" role="tabpanel">
                        <h5 class="mt-3">0-1 ano</h5>
                        
                        <!-- Card 1 -->
                        <div class="portage-card">
                            <div class="checkbox-title">Fixar olhar em objetos coloridos</div>
                            <div class="skill-description">Mantém o olhar fixo em objetos com cores vibrantes.</div>
                            <div class="skill-actions">
                                <div class="option">
                                    <label>
                                        <input type="radio" name="cog0_1_item1" value="Sim">
                                        Sim
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="cog0_1_item1" value="AV">
                                        AV
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="cog0_1_item1" value="Não">
                                        Não
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="cog0_1_item1" value="X">
                                        X
                                    </label>
                                </div>
                            </div>
                            <div class="portage-orientation-toggle" data-target="orientCog0_1_item1">
                                <i class="fas fa-chevron-down"></i> Orientações
                            </div>
                            <div class="portage-orientation-text" id="orientCog0_1_item1">
                                A capacidade de fixar o olhar em objetos coloridos é essencial para o desenvolvimento visual e cognitivo. Observe se a criança mantém o foco em estímulos visuais.
                            </div>
                        </div>
                    </div>

                    <!-- Faixa 1-2 anos - Cognição -->
                    <div id="cog1_2" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">1-2 anos</h5>
                        
                        <!-- Card 1 -->
                        <div class="portage-card">
                            <div class="checkbox-title">Empilhar blocos</div>
                            <div class="skill-description">A criança empilha blocos com estabilidade.</div>
                            <div class="skill-actions">
                                <div class="option">
                                    <label>
                                        <input type="radio" name="cog1_2_item1" value="Sim">
                                        Sim
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="cog1_2_item1" value="AV">
                                        AV
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="cog1_2_item1" value="Não">
                                        Não
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="cog1_2_item1" value="X">
                                        X
                                    </label>
                                </div>
                            </div>
                            <div class="portage-orientation-toggle" data-target="orientCog1_2_item1">
                                <i class="fas fa-chevron-down"></i> Orientações
                            </div>
                            <div class="portage-orientation-text" id="orientCog1_2_item1">
                                Empilhar blocos desenvolve a coordenação motora fina e a compreensão espacial. Observe se a criança consegue empilhar com estabilidade.
                            </div>
                        </div>
                    </div>

                    <!-- Faixa 2-3 anos - Cognição -->
                    <div id="cog2_3" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">2-3 anos</h5>
                        
                        <!-- Card 1 -->
                        <div class="portage-card">
                            <div class="checkbox-title">Reconhece formas básicas</div>
                            <div class="skill-description">A criança identifica e nomeia formas geométricas simples, como círculo e quadrado.</div>
                            <div class="skill-actions">
                                <div class="option">
                                    <label>
                                        <input type="radio" name="cog2_3_item1" value="Sim">
                                        Sim
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="cog2_3_item1" value="AV">
                                        AV
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="cog2_3_item1" value="Não">
                                        Não
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="cog2_3_item1" value="X">
                                        X
                                    </label>
                                </div>
                            </div>
                            <div class="portage-orientation-toggle" data-target="orientCog2_3_item1">
                                <i class="fas fa-chevron-down"></i> Orientações
                            </div>
                            <div class="portage-orientation-text" id="orientCog2_3_item1">
                                Reconhecer formas básicas é fundamental para o desenvolvimento cognitivo e a base para conceitos matemáticos futuros. Observe se a criança consegue identificar e nomear formas geométricas simples.
                            </div>
                        </div>
                    </div>

                    <!-- Faixa 3-4 anos - Cognição -->
                    <div id="cog3_4" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">3-4 anos</h5>
                        
                        <!-- Card 1 -->
                        <div class="portage-card">
                            <div class="checkbox-title">Completa sequências simples</div>
                            <div class="skill-description">A criança consegue completar sequências lógicas simples, como sequências de cores ou números.</div>
                            <div class="skill-actions">
                                <div class="option">
                                    <label>
                                        <input type="radio" name="cog3_4_item1" value="Sim">
                                        Sim
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="cog3_4_item1" value="AV">
                                        AV
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="cog3_4_item1" value="Não">
                                        Não
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="cog3_4_item1" value="X">
                                        X
                                    </label>
                                </div>
                            </div>
                            <div class="portage-orientation-toggle" data-target="orientCog3_4_item1">
                                <i class="fas fa-chevron-down"></i> Orientações
                            </div>
                            <div class="portage-orientation-text" id="orientCog3_4_item1">
                                Completar sequências simples ajuda no desenvolvimento do pensamento lógico e na resolução de problemas. Observe se a criança consegue seguir e completar sequências lógicas.
                            </div>
                        </div>
                    </div>

                    <!-- Faixa 4-5 anos - Cognição -->
                    <div id="cog4_5" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">4-5 anos</h5>
                        
                        <!-- Card 1 -->
                        <div class="portage-card">
                            <div class="checkbox-title">Resolução de quebra-cabeças complexos</div>
                            <div class="skill-description">A criança consegue montar quebra-cabeças com mais de 10 peças.</div>
                            <div class="skill-actions">
                                <div class="option">
                                    <label>
                                        <input type="radio" name="cog4_5_item1" value="Sim">
                                        Sim
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="cog4_5_item1" value="AV">
                                        AV
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="cog4_5_item1" value="Não">
                                        Não
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="cog4_5_item1" value="X">
                                        X
                                    </label>
                                </div>
                            </div>
                            <div class="portage-orientation-toggle" data-target="orientCog4_5_item1">
                                <i class="fas fa-chevron-down"></i> Orientações
                            </div>
                            <div class="portage-orientation-text" id="orientCog4_5_item1">
                                Resolver quebra-cabeças complexos desenvolve habilidades de resolução de problemas e pensamento espacial. Observe se a criança consegue montar quebra-cabeças com um número maior de peças e formas variadas.
                            </div>
                        </div>
                    </div>

                    <!-- Faixa 5-6 anos - Cognição -->
                    <div id="cog5_6" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">5-6 anos</h5>
                        
                        <!-- Card 1 -->
                        <div class="portage-card">
                            <div class="checkbox-title">Entende conceitos de tempo</div>
                            <div class="skill-description">A criança compreende e pode diferenciar passado, presente e futuro.</div>
                            <div class="skill-actions">
                                <div class="option">
                                    <label>
                                        <input type="radio" name="cog5_6_item1" value="Sim">
                                        Sim
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="cog5_6_item1" value="AV">
                                        AV
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="cog5_6_item1" value="Não">
                                        Não
                                    </label>
                                </div>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="cog5_6_item1" value="X">
                                        X
                                    </label>
                                </div>
                            </div>
                            <div class="portage-orientation-toggle" data-target="orientCog5_6_item1">
                                <i class="fas fa-chevron-down"></i> Orientações
                            </div>
                            <div class="portage-orientation-text" id="orientCog5_6_item1">
                                Compreender conceitos de tempo é fundamental para o planejamento e organização. Observe se a criança consegue diferenciar e falar sobre eventos passados, presentes e futuros.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal para Carregar Avaliação -->
<div class="modal fade" id="loadAvaliacaoModal" tabindex="-1" role="dialog" aria-labelledby="loadAvaliacaoModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="carregarAvaliacaoModalLabel" style="color: #fff">Carregar Avaliação Anterior</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Ao carregar, os itens com respostas iguais serão marcados, facilitando a continuidade.</p>
                <div class="form-group">
                    <label for="avaliacoesModalSelect">Avaliações Disponíveis:</label>
                    <select class="form-control" id="avaliacoesModalSelect">
                        <!-- Exemplos de Avaliações -->
                        <option value="AV10001">AV10001 - 01/01/2024 (mais recente)</option>
                        <option value="AV10002">AV10002 - 15/02/2024</option>
                        <option value="AV10003">AV10003 - 20/03/2024</option>
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" id="confirmarCarregarBtn">Carregar Avaliação</button>
            </div>
        </div>
    </div>
</div>

        
        
        
        
        
        
        

        <!-- Scripts Bootstrap e jQuery -->
        <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>
        
        <!-- Custom JavaScript -->
        <script>
            document.addEventListener('DOMContentLoaded', () => {
                // Função para gerar código único (simples)
                function gerarCodigo() {
                    return Math.floor(10000 + Math.random() * 90000);
                }

                function formatarData(data) {
                    const partes = data.split('-');
                    return `${partes[2]}/${partes[1]}/${partes[0]}`;
                }

                // Botões
                const backBtn = document.getElementById('backBtn');
                const saveBtn = document.getElementById('saveBtn');
                const loadBtn = document.getElementById('loadBtn');

                // Modal Elements
                const avaliacoesList = document.getElementById('avaliacoesList');

                // Função para salvar as respostas atuais como uma nova avaliação
                function salvarAvaliacao() {
                    const respostas = {};
                    const inputs = document.querySelectorAll('input[type="radio"]');
                    inputs.forEach(input => {
                        if (input.checked) {
                            respostas[input.name] = input.value;
                        }
                    });

                    const dataAtual = new Date();
                    const dataFormatada = dataAtual.toISOString().split('T')[0];
                    const codigo = gerarCodigo();

                    const novaAvaliacao = {
                        id: `AV${codigo}`,
                        data: dataFormatada,
                        status: 'Aberta',
                        respostas: respostas
                    };

                    let avaliacoes = JSON.parse(localStorage.getItem('avaliacoes')) || [];
                    avaliacoes.push(novaAvaliacao);
                    localStorage.setItem('avaliacoes', JSON.stringify(avaliacoes));

                    alert('Avaliação salva com sucesso!');
                }

                // Função para carregar avaliações no modal
                function carregarAvaliacoesNoModal() {
                    avaliacoesList.innerHTML = ''; // Limpa a lista existente
                    let avaliacoes = JSON.parse(localStorage.getItem('avaliacoes')) || [];

                    // Ordena as avaliações por data descendente
                    avaliacoes.sort((a, b) => new Date(b.data) - new Date(a.data));

                    if (avaliacoes.length === 0) {
                        avaliacoesList.innerHTML = '<li class="list-group-item">Nenhuma avaliação encontrada.</li>';
                        return;
                    }

                    avaliacoes.forEach((avaliacao, index) => {
                        const li = document.createElement('li');
                        li.className = 'list-group-item d-flex justify-content-between align-items-center';
                        if (index === 0) {
                            li.classList.add('list-group-item-info'); // Destaca a mais recente
                        }
                        li.innerHTML = `
                            <div>
                                <strong>ID:</strong> ${avaliacao.id} <br>
                                <strong>Data:</strong> ${formatarData(avaliacao.data)}
                            </div>
                            <button class="btn btn-primary btn-sm load-avaliacao-btn" data-id="${avaliacao.id}">Carregar</button>
                        `;
                        avaliacoesList.appendChild(li);
                    });

                    // Adiciona event listeners aos botões de carregar
                    const loadAvaliacaoBtns = document.querySelectorAll('.load-avaliacao-btn');
                    loadAvaliacaoBtns.forEach(btn => {
                        btn.addEventListener('click', () => {
                            const id = btn.getAttribute('data-id');
                            carregarAvaliacao(id);
                            $('#loadAvaliacaoModal').modal('hide');
                        });
                    });
                }

                // Função para carregar uma avaliação específica
                function carregarAvaliacao(id) {
                    let avaliacoes = JSON.parse(localStorage.getItem('avaliacoes')) || [];
                    const avaliacao = avaliacoes.find(a => a.id === id);
                    if (!avaliacao) {
                        alert('Avaliação não encontrada.');
                        return;
                    }

                    // Preenche os inputs com as respostas
                    for (const [key, value] of Object.entries(avaliacao.respostas)) {
                        const radio = document.querySelector(`input[name="${key}"][value="${value}"]`);
                        if (radio) {
                            radio.checked = true;
                        }
                    }

                    alert(`Avaliação ${id} carregada com sucesso!`);
                }

                // Função para resetar o formulário (Voltar)
                function resetarFormulario() {
                    const inputs = document.querySelectorAll('input[type="radio"]');
                    inputs.forEach(input => {
                        input.checked = false;
                    });

                    // Remove destaque de todos os cards
                    const portageCards = document.querySelectorAll('.portage-card');
                    portageCards.forEach(card => {
                        card.classList.remove('selected');
                    });

                    alert('Formulário resetado.');
                }

                // Event Listener para o botão Salvar
                saveBtn.addEventListener('click', salvarAvaliacao);

                // Event Listener para o botão Voltar
                backBtn.addEventListener('click', resetarFormulario);

                // Event Listener para o botão Carregar Avaliação
                loadBtn.addEventListener('click', carregarAvaliacoesNoModal);

                // Função para alternar a exibição das orientações
                const orientationToggles = document.querySelectorAll('.portage-orientation-toggle');
                orientationToggles.forEach(toggle => {
                    toggle.addEventListener('click', () => {
                        const targetId = toggle.getAttribute('data-target');
                        const targetElement = document.getElementById(targetId);
                        if (targetElement.style.display === 'block') {
                            targetElement.style.display = 'none';
                            toggle.classList.remove('rotate');
                        } else {
                            targetElement.style.display = 'block';
                            toggle.classList.add('rotate');
                        }
                    });
                });

                // Destacar o card ao clicar
                const portageCards = document.querySelectorAll('.portage-card');
                portageCards.forEach(card => {
                    card.addEventListener('click', (e) => {
                        // Evitar que o clique no input ou no toggle destaque o card
                        if (e.target.tagName.toLowerCase() === 'input' || e.target.closest('.portage-orientation-toggle')) {
                            return;
                        }
                        // Remover destaque de outros cards (opcional)
                        portageCards.forEach(c => c.classList.remove('selected'));
                        // Destacar o card clicado
                        card.classList.add('selected');
                    });
                });

                // Carregar avaliações existentes do localStorage ao iniciar (opcional)
                function carregarAvaliacoesExistentes() {
                    // Implementar lógica para exibir avaliações armazenadas, se necessário
                }

                carregarAvaliacoesExistentes();
            });
        </script>
        
        
    </div>
</body>
</html>
