<?php
// convites.php
// Inclua o arquivo de dados se estiver utilizando uma abordagem centralizada
// <?php include 'includes/data.php'; ?>
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Convites - Sistema de Avaliação IFCora</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">
    <style>
        /* Estilos específicos para Convites */
        .filters {
            display: flex;
            gap: 20px;
            margin-bottom: 20px;
            flex-wrap: wrap;
        }

        .filters label {
            font-weight: bold;
            margin-bottom: 5px;
            display: block;
        }

        .table-section {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        .table-section th, .table-section td {
            padding: 10px;
            border-bottom: 1px solid #e2e8f0;
            text-align: left;
            font-size: 14px;
        }

        .table-section th {
            background-color: #f7fafc;
            color: #2d3748;
        }

        .status-pendente {
            color: #08C89E;
            font-weight: bold;
        }

        .status-aceito {
            color: #4A5568;
            font-weight: bold;
        }

        .status-expirado {
            color: #E53E3E; /* Vermelho */
            font-weight: bold;
        }

        .action-icons button {
            background: transparent;
            border: none;
            cursor: pointer;
            padding: 4px;
            font-size: 16px;
            color: #4A5568;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .action-icons button:hover {
            color: #08C89E;
        }

        .action-icons .icon-trash:hover {
            color: red;
        }

        /* Botões */
        .btn.save {
            background-color: #08C89E;
            color: #fff;
            border: none;
            padding: 10px 20px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            margin-bottom: 20px;
        }

        .btn.save:hover {
            background-color: #06b287;
        }

        .btn.copy {
            background-color: #4299E1; /* Azul para copiar código */
            color: #fff;
            border: none;
            padding: 8px 16px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
        }

        .btn.copy:hover {
            background-color: #3182CE;
        }

        /* Modal Overlay */
        .modal-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.6);
            display: none;
            justify-content: center;
            align-items: center;
            z-index: 9999;
            transition: opacity 0.3s ease;
        }

        /* Modal Container */
        .modal-container {
            background-color: #ffffff;
            border-radius: 16px;
            padding: 24px;
            width: 90%;
            max-width: 500px;
            box-shadow: 0 4px 16px rgba(0, 0, 0, 0.2); /* Sombra mais suave */
            display: flex;
            flex-direction: column;
            gap: 16px;
            animation: fadeIn 0.3s ease;
            box-sizing: border-box;
            overflow: hidden;
        }

        /* Header */
        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding-bottom: 8px;
            background-color: #08C89E; /* Fundo expandido */
            border-radius: 8px 8px 0 0; /* Arredonda apenas os cantos superiores */
            padding: 16px;
        }

        .modal-title h2 {
            font-size: 20px;
            font-weight: bold;
            color: #ffffff;
            margin: 0;
        }

        .btn-close {
            background: none;
            border: none;
            font-size: 20px;
            cursor: pointer;
            color: #ffffff;
        }

        .btn-close:hover {
            color: #e53e3e;
        }

        /* Form Fields */
        .form-group {
            display: flex;
            flex-direction: column;
            gap: 8px;
        }

        label {
            font-size: 14px;
            font-weight: bold;
            color: #2d3748;
        }

        /* Inputs */
        input[type="text"], input[type="email"], select {
            width: 100%;
            max-width: 100%;
            padding: 10px 14px;
            border: 1.5px solid #e2e8f0;
            border-radius: 8px;
            font-size: 14px;
            outline: none;
            transition: border-color 0.2s;
            box-sizing: border-box;
        }

        input:focus, select:focus {
            border-color: #08C89E;
            box-shadow: 0 0 0 3px rgba(8, 200, 158, 0.2);
        }

        /* Footer */
        .modal-footer {
            display: flex;
            justify-content: flex-end;
            gap: 12px;
            border-top: 1px solid #e2e8f0;
            padding-top: 12px;
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-painel-profissional-profissionais-2.php'; ?>

    <!-- Conteúdo -->
    <main class="content">
        
        <div class="header-content" style="margin-top: -55px">
                <h1 style="color: #08C89E; margin-left: 0px"><i class="fas fa-envelope" style="margin-right: 8px"></i>Convites</h1>
                                <p style="margin-top: -5px">Aqui você pode criar e gerenciar convites para que novos profissionais se juntem às suas clínicas.</p>

            </div>
        
        <div class="tabs-container">
            
            <div class="header-content">
            </div>
    
            <!-- Botão Criar Convite -->
            <button id="openInviteModalBtn" class="btn save">Criar Novo Convite</button>
    
            <hr />
    
            <div class="filters">
                <div>
                    <label for="clinicFilterConvites">Selecione a Clínica:</label>
                    <select id="clinicFilterConvites" style="width: 200px;">
                        <option value="">Todas</option>
                        <option value="Clínica Sertãozinho">Clínica Sertãozinho</option>
                        <option value="Clínica Central">Clínica Central</option>
                        <option value="Clínica do Norte">Clínica do Norte</option>
                    </select>
                </div>
                <div>
                    <label for="searchConviteName">Pesquisar por Nome (Convidado):</label>
                    <input type="text" id="searchConviteName" placeholder="Nome do convidado..." style="width: 300px;">
                </div>
            </div>
    
            <table id="pendingInvitesTable" class="table-section">
                <thead>
                    <tr>
                        <th>Código</th>
                        <th>Nome</th>
                        <th>Email</th>
                        <th>Clínica</th>
                        <th>Perfil</th>
                        <th>Convite</th>
                        <th>Status</th>
                        <th>Ações</th>
                        <th>Excluir</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- Convites Pendentes via JS -->
                </tbody>
            </table>
        </div>
    </main>

    <!-- Modal Criar Convite Padronizado -->
    <div class="modal-overlay" id="inviteModalOverlay">
        <div class="modal-container">
            <header class="modal-header">
                <div class="modal-title">
                    <h2>Criar Novo Convite</h2>
                </div>
                <button type="button" class="btn-close" id="closeInviteModal" aria-label="Fechar">&times;</button>
            </header>
            <form id="inviteForm">
                <div class="form-group">
                    <label for="inviteName">Nome completo do profissional a ser convidado:</label>
                    <input type="text" id="inviteName" name="inviteName" required placeholder="Ex: Maria Silva">
                </div>
                <div class="form-group">
                    <label for="inviteEmail" style="margin-top: 10px">Endereço de e-mail do profissional:</label>
                    <input type="email" id="inviteEmail" name="inviteEmail" required placeholder="Ex: maria.silva@example.com">
                </div>
                <div class="form-group">
                    <label for="inviteClinic" style="margin-top: 10px">Clínica</label>
                    <select id="inviteClinic" name="inviteClinic" required>
                        <option value="">Selecione uma clínica</option>
                        <option value="Clínica Sertãozinho">Clínica Sertãozinho</option>
                        <option value="Clínica Central">Clínica Central</option>
                        <option value="Clínica do Norte">Clínica do Norte</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="invitePerfil" style="margin-top: 10px">Escolha o perfil do profissional:</label> <!-- Novo Campo de Perfil -->
                    <select id="invitePerfil" name="invitePerfil" required>
                        <option value="">Escolha o perfil do profissional</option>
                        <option value="Co-Administrador">Co-Administrador (Co-Admin)</option>
                        <option value="Supervisor">Supervisor</option>
                        <option value="Colaborador">Colaborador</option>
                    </select>
                </div>
                
                <!-- Seção de Notas sobre o Perfil Selecionado -->
                <div class="form-group" id="profileNotes" style="display: none; margin-top: 10px;">
                    <label>Detalhes sobre o perfil escolhido:</label>
                    <div id="profileNoteContent" style="background-color: #f9fafb; padding: 10px; border-radius: 8px; border-left: 4px solid #08C89E;">
                        <!-- Conteúdo dinâmico será inserido aqui -->
                    </div>
                </div>
                
                <footer class="modal-footer">
                    <button type="button" class="btn cancel" id="cancelInviteModal">Cancelar</button>
                    <button type="submit" class="btn save">Gerar Convite</button>
                </footer>
            </form>
            <div id="inviteCodeSection" style="display: none; text-align: center; margin-top: 20px;">
                <p>O código de convite é:</p>
                <h3 id="inviteCode"></h3>
                <button class="btn copy" id="copyInviteCodeBtn">
                    <i class="fas fa-copy"></i> Copiar Código
                </button>
                <p>Envie este código para o profissional convidado.</p>
            </div>
        </div>
    </div>

    <!-- Scripts específicos para Convites -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Inicializa os dados globais que serão usados por múltiplos scripts
            // Se estiver usando um arquivo de dados incluído, descomente a linha abaixo
            // <?php include 'includes/data.php'; ?>

            // Exemplo de dados locais (substitua com dados reais ou carregue via backend)
            let pendingInvites = [
                { id: 'INV001', name: 'Ana Silva', email: 'ana.silva@example.com', clinic: 'Clínica Sertãozinho', perfil: 'Colaborador', code: 'ABC123', status: 'Pendente' },
                { id: 'INV002', name: 'Bruno Lima', email: 'bruno.lima@example.com', clinic: 'Clínica Central', perfil: 'Administrador', code: 'DEF456', status: 'Pendente' },
                { id: 'INV003', name: 'Carla Mendes', email: 'carla.mendes@example.com', clinic: 'Clínica do Norte', perfil: 'Colaborador', code: 'GHI789', status: 'Expirado' }
            ];

            let inviteHistory = [
                { clinicId: 'CL001', clinicName: 'Clínica Sertãozinho', administrator: 'José Almeida', perfil: 'Administrador', status: 'Aceito', date: '01/10/2023' },
                { clinicId: 'CL002', clinicName: 'Clínica Central', administrator: 'Luiz Gustavo', perfil: 'Administrador', status: 'Aceito', date: '20/10/2023' },
                { clinicId: 'CL003', clinicName: 'Clínica do Norte', administrator: 'Maria Fernanda', perfil: 'Administrador', status: 'Encerrado', date: '25/10/2023' },
                { clinicId: 'CL003', clinicName: 'Clínica do Norte', administrator: 'Ana Paula', perfil: 'Colaborador', status: 'Aceito', date: '05/11/2023' },
            ];

            // Função para atualizar a tabela de convites pendentes
            function updatePendingInvitesTable() {
                const clinicFilter = document.getElementById('clinicFilterConvites').value;
                const searchNameFilter = document.getElementById('searchConviteName').value.toLowerCase();
                const tableBody = document.querySelector('#pendingInvitesTable tbody');
                tableBody.innerHTML = '';

                const filtered = pendingInvites.filter(invite => {
                    const matchClinic = !clinicFilter || invite.clinic === clinicFilter;
                    const matchName = invite.name.toLowerCase().includes(searchNameFilter);
                    return matchClinic && matchName;
                });

                filtered.forEach(invite => {
                    const row = document.createElement('tr');
                    row.innerHTML = `
                        <td>${invite.code}</td> <!-- Exibir Código -->
                        <td>${invite.name}</td>
                        <td>${invite.email}</td>
                        <td>${invite.clinic}</td>
                        <td>${invite.perfil}</td> <!-- Exibir Perfil -->
                        <td>${invite.code}</td>
                        <td class="status-${invite.status.toLowerCase()}">${invite.status}</td>
                        <td class="action-icons">
                            <button class="btn copy" onclick="copyCode('${invite.code}')">
                                <i class="fas fa-copy" title="Copiar Código"></i>
                            </button>
                        </td>
                        <td class="action-icons">
                            <button class="btn excluir" onclick="deleteInvite('${invite.id}')">
                                <i class="fas fa-trash-alt" title="Excluir Convite"></i>
                            </button>
                        </td>
                    `;
                    tableBody.appendChild(row);
                });
            }

            // Eventos de filtro
            document.getElementById('clinicFilterConvites').addEventListener('change', updatePendingInvitesTable);
            document.getElementById('searchConviteName').addEventListener('input', updatePendingInvitesTable);
            updatePendingInvitesTable();

            // Função para deletar convite
            window.deleteInvite = function(id) {
                if(confirm('Tem certeza que deseja excluir este convite?')) {
                    pendingInvites = pendingInvites.filter(inv => inv.id !== id);
                    updatePendingInvitesTable();
                    alert('Convite excluído com sucesso.');
                }
            }

            // Função para copiar o código para a área de transferência
            window.copyCode = function(code) {
                const inviteText = `Olá, você foi convidado(a) para atuar na clínica [Nome da Clínica]!

Para se juntar a nós, siga os passos abaixo:
1 - Acesse o nosso sistema no link: [URL do Sistema] 
2 - Caso ainda não tenha uma conta, clique em ‘Cadastrar’ e selecione o perfil “Profissional/Empresa”. Preencha suas informações. 
    • Se você já possui uma conta, basta fazer o login normalmente. 
3 - Após logar-se no sistema, acesse o menu “Clínicas”. 
4 - Siga as instruções na página para carregar o convite: 
    Código do Convite: ${code}
            
Após inserir o código, você será vinculado(a) à nossa clínica. O seu papel (Co-Admin, Supervisor ou Colaborador) já foi definido pelo Administrador.

Bem-vindo(a) à equipe!`;
            
                navigator.clipboard.writeText(inviteText).then(() => {
                    alert('Texto copiado para a área de transferência!');
                }).catch(err => {
                    alert('Erro ao copiar o texto: ' + err);
                });
            }

            // Inicializa os dados globais que serão usados por múltiplos scripts
            // Se estiver usando um arquivo de dados incluído, descomente a linha abaixo
            // <?php include 'includes/data.php'; ?>

            // Exemplo de dados locais (substitua com dados reais ou carregue via backend)
            let professionals = [
                { name: 'Mariana Santos', profession: 'Fonoaudióloga', email: 'mariana.santos@example.com', clinic: 'Clínica Sertãozinho', perfil: 'Administrador', status: 'Ativo', code: 'PRF001' },
                { name: 'Pedro Oliveira', profession: 'Psicólogo', email: 'pedro.oliveira@example.com', clinic: 'Clínica Central', perfil: 'Colaborador', status: 'Ativo', code: 'PRF002' },
                { name: 'Camila Rocha', profession: 'Nutricionista', email: 'camila.rocha@example.com', clinic: 'Clínica Sertãozinho', perfil: 'Colaborador', status: 'Ativo', code: 'PRF003' },
                { name: 'Beatriz Souza', profession: 'Terapeuta Ocupacional', email: 'beatriz.souza@example.com', clinic: 'Clínica Central', perfil: 'Administrador', status: 'Ativo', code: 'PRF004' },
                { name: 'Felipe Costa', profession: 'Fisioterapeuta', email: 'felipe.costa@example.com', clinic: 'Clínica do Norte', perfil: 'Colaborador', status: 'Ativo', code: 'PRF005' },
                { name: 'Juliana Lima', profession: 'Enfermeira', email: 'juliana.lima@example.com', clinic: 'Clínica Sertãozinho', perfil: 'Colaborador', status: 'Ativo', code: 'PRF006' },
                { name: 'Ricardo Pinto', profession: 'Nutricionista', email: 'ricardo.pinto@example.com', clinic: 'Clínica Central', perfil: 'Administrador', status: 'Ativo', code: 'PRF007' },
                { name: 'Gustavo Ribeiro', profession: 'Terapeuta Ocupacional', email: 'gustavo.ribeiro@example.com', clinic: 'Clínica do Norte', perfil: 'Colaborador', status: 'Ativo', code: 'PRF008' },
            ];

            // Função para gerar códigos únicos para profissionais
            function generateProfessionalCode(index) {
                return 'PRF' + String(index + 1).padStart(3, '0'); // Exemplo: PRF001, PRF002, etc.
            }

            // Função para atualizar a tabela de profissionais
            function updateProfessionalsTable() {
                const clinicFilter = document.getElementById('clinicSelect').value;
                const searchFilter = document.getElementById('searchProfessional').value.toLowerCase();
                const tableBody = document.querySelector('#professionalsTable tbody');
                tableBody.innerHTML = '';

                const filtered = professionals.filter(prof => {
                    const matchClinic = !clinicFilter || prof.clinic === clinicFilter;
                    const matchSearch = prof.name.toLowerCase().includes(searchFilter) ||
                                        prof.profession.toLowerCase().includes(searchFilter) ||
                                        prof.email.toLowerCase().includes(searchFilter);
                    return matchClinic && matchSearch;
                });

                filtered.forEach(prof => {
                    const row = document.createElement('tr');
                    row.innerHTML = `
                        <td>${prof.code}</td> <!-- Exibir Código -->
                        <td>${prof.name}</td>
                        <td>${prof.profession}</td>
                        <td>${prof.email}</td>
                        <td>${prof.clinic}</td>
                        <td>${prof.perfil}</td> <!-- Exibir Perfil -->
                        <td class="status-${prof.status.toLowerCase()}">${prof.status}</td> <!-- Exibir Status -->
                        <td class="action-icons">
                            <button class="btn manage-icon" onclick="openManageProfessionalModal('${prof.email}')">
                                <i class="fas fa-cog" title="Gerenciar"></i>
                            </button>
                        </td>
                    `;
                    tableBody.appendChild(row);
                });
            }

            // Eventos de filtro
            document.getElementById('clinicSelect').addEventListener('change', updateProfessionalsTable);
            document.getElementById('searchProfessional').addEventListener('input', updateProfessionalsTable);
            updateProfessionalsTable();

            // Função para abrir o modal de gerenciamento
            window.openManageProfessionalModal = function(email) {
                const professional = professionals.find(prof => prof.email === email);
                if (professional) {
                    document.getElementById('manageProfName').textContent = professional.name;
                    document.getElementById('manageProfProfession').textContent = professional.profession;
                    document.getElementById('manageProfEmail').textContent = professional.email;
                    document.getElementById('manageProfClinic').textContent = professional.clinic;
                    document.getElementById('manageProfPerfil').textContent = professional.perfil;
                    document.getElementById('manageProfStatus').textContent = professional.status;

                    // Armazenar o email do profissional no botão para referência
                    document.getElementById('manageProfEditButton').dataset.email = email;
                    document.getElementById('manageProfUnlinkButton').dataset.email = email;
                    document.getElementById('manageProfDeleteButton').dataset.email = email;

                    // Atualizar Botões de Ação com base no Status
                    updateManageModalActions(professional.status);

                    // Abrir o modal
                    document.getElementById('manageProfessionalModal').style.display = 'block';
                } else {
                    alert('Profissional não encontrado.');
                }
            }

            // Função para atualizar os botões de ação no modal com base no status
            function updateManageModalActions(status) {
                const editButton = document.getElementById('manageProfEditButton');
                const unlinkButton = document.getElementById('manageProfUnlinkButton');
                const deleteButton = document.getElementById('manageProfDeleteButton');

                if (status.toLowerCase() === 'ativo') {
                    // Situação 1 e 2
                    unlinkButton.style.display = 'inline-flex';
                    unlinkButton.innerHTML = `<i class="fas fa-unlink"></i> Inativar`;
                    deleteButton.style.display = 'none'; // Não permite excluir enquanto estiver ativo
                } else if (status.toLowerCase() === 'inativo') {
                    // Situação 3 e 4
                    unlinkButton.style.display = 'inline-flex';
                    unlinkButton.innerHTML = `<i class="fas fa-link"></i> Reativar`;
                    deleteButton.style.display = 'inline-flex'; // Permite excluir apenas se desvinculado
                } else {
                    // Outros statuses, se houver
                    unlinkButton.style.display = 'none';
                    deleteButton.style.display = 'none';
                }
            }

            // Função para fechar o modal de gerenciamento
            window.closeManageProfessionalModal = function() {
                document.getElementById('manageProfessionalModal').style.display = 'none';
                // Resetar dados no modal
                document.getElementById('manageProfName').textContent = '';
                document.getElementById('manageProfProfession').textContent = '';
                document.getElementById('manageProfEmail').textContent = '';
                document.getElementById('manageProfClinic').textContent = '';
                document.getElementById('manageProfPerfil').textContent = '';
                document.getElementById('manageProfStatus').textContent = '';
            }

            // Eventos para fechar o modal
            const manageProfModal = document.getElementById('manageProfessionalModal');
            const manageProfCloseBtn = manageProfModal.querySelector('.close');
            const manageProfCancelBtn = document.getElementById('manageProfCancelButton');

            manageProfCloseBtn.onclick = function() {
                closeManageProfessionalModal();
            }

            manageProfCancelBtn.onclick = function() {
                closeManageProfessionalModal();
            }

            window.onclick = function(event) {
                if (event.target == manageProfModal) {
                    closeManageProfessionalModal();
                }
            }

            // Função para editar perfil a partir do modal
            document.getElementById('manageProfEditButton').addEventListener('click', function() {
                const email = this.dataset.email;
                openEditPerfilModal(email);
                closeManageProfessionalModal();
            });

            // Função para desvincular ou vincular profissional a partir do modal
            document.getElementById('manageProfUnlinkButton').addEventListener('click', function() {
                const email = this.dataset.email;
                const professional = professionals.find(prof => prof.email === email);

                if (!professional) {
                    alert('Profissional não encontrado.');
                    return;
                }

                if (professional.status.toLowerCase() === 'ativo') {
                    // Situação 2: Desvincular
                    if (confirm('Tem certeza que deseja desvincular este profissional?')) {
                        professional.status = 'Inativo';
                        updateProfessionalsTable();
                        // Atualizar histórico se necessário
                        alert('Profissional desvinculado com sucesso.');
                        closeManageProfessionalModal();
                    }
                } else if (professional.status.toLowerCase() === 'inativo') {
                    // Situação 3: Vincular
                    if (confirm('Tem certeza que deseja vincular este profissional novamente?')) {
                        professional.status = 'Ativo';
                        updateProfessionalsTable();
                        // Atualizar histórico se necessário
                        alert('Profissional vinculado novamente com sucesso.');
                        closeManageProfessionalModal();
                    }
                }
            });

            // Função para excluir profissional a partir do modal
            document.getElementById('manageProfDeleteButton').addEventListener('click', function() {
                const email = this.dataset.email;
                const professional = professionals.find(prof => prof.email === email);

                if (!professional) {
                    alert('Profissional não encontrado.');
                    return;
                }

                if (professional.status.toLowerCase() !== 'inativo') {
                    alert('Para excluir, o profissional deve estar desvinculado.');
                    return;
                }

                if (confirm('Tem certeza que deseja excluir este profissional?')) {
                    professionals = professionals.filter(prof => prof.email !== email);
                    updateProfessionalsTable();
                    alert('Profissional excluído com sucesso.');
                    closeManageProfessionalModal();
                }
            });

            // Função para abrir o modal de editar perfil
            window.openEditPerfilModal = function(email) {
                // Crie ou reutilize um modal para editar perfil
                // Por simplicidade, este exemplo usa um prompt. Recomenda-se criar um modal dedicado.
                const newPerfil = prompt('Selecione o novo perfil: \n1. Co-Administrador\n2. Supervisor\n3. Colaborador');
                if (newPerfil) {
                    let perfilSelecionado = '';
                    switch(newPerfil.trim()) {
                        case '1':
                            perfilSelecionado = 'Co-Administrador';
                            break;
                        case '2':
                            perfilSelecionado = 'Supervisor';
                            break;
                        case '3':
                            perfilSelecionado = 'Colaborador';
                            break;
                        default:
                            alert('Opção inválida.');
                            return;
                    }

                    const professional = professionals.find(prof => prof.email === email);
                    if(professional) {
                        professional.perfil = perfilSelecionado;
                        updateProfessionalsTable();
                        alert('Perfil atualizado com sucesso.');
                    } else {
                        alert('Profissional não encontrado.');
                    }
                }
            }
        });
    </script>
    
    <script>
        // Modal Criar Convite Padronizado
document.addEventListener('DOMContentLoaded', () => {
    const inviteModalOverlay = document.getElementById('inviteModalOverlay');
    const closeInviteModalBtn = document.getElementById('closeInviteModal');
    const cancelInviteModalBtn = document.getElementById('cancelInviteModal');
    const inviteForm = document.getElementById('inviteForm');
    const inviteCodeSection = document.getElementById('inviteCodeSection');
    const inviteCodeDisplay = document.getElementById('inviteCode');
    const copyInviteCodeBtn = document.getElementById('copyInviteCodeBtn');
    const invitePerfilSelect = document.getElementById('invitePerfil');
    const profileNotesSection = document.getElementById('profileNotes');
    const profileNoteContent = document.getElementById('profileNoteContent');

    // Definição dos perfis e suas respectivas notas
    const profileNotes = {
    "Co-Administrador": `
        <strong style="font-size: 11px;">Co-Administrador (Co-Admin): Gestão e Acesso Completo</strong>
        <ul style="font-size: 10px; margin-top: 5px;">
            <li>Gerencie a clínica: convide profissionais e defina suas funções.</li>
            <li>Cadastre novos pacientes com facilidade.</li>
            <li>Tenha acesso total para aplicar e consultar avaliações e intervenções de todos os pacientes.</li>
        </ul>
    `,
    "Supervisor": `
        <strong style="font-size: 11px;">Supervisor: Acesso Clínico Total, Sem Gestão Administrativa</strong>
        <ul style="font-size: 10px; margin-top: 5px;">
            <li>Visualize e gerencie o atendimento de todos os pacientes da clínica.</li>
            <li>Realize e consulte avaliações e intervenções clínicas.</li>
            <li>Foque no atendimento sem lidar com tarefas administrativas (como convites ou assinaturas).</li>
        </ul>
    `,
    "Colaborador": `
        <strong style="font-size: 11px;">Colaborador: Acesso Limitado aos Pacientes Atribuídos</strong>
        <ul style="font-size: 10px; margin-top: 5px;">
            <li>Acesse apenas os pacientes designados pelo Admin, Co-Admin ou Supervisor.</li>
            <li>Realize e acompanhe avaliações exclusivamente nos pacientes atribuídos.</li>
            <li>Ideal para especialistas que atendem casos específicos.</li>
            <li>Sem acesso a configurações administrativas ou gestão de outros profissionais.</li>
        </ul>
    `
};


    // Abrir Modal ao clicar no botão correspondente
    const openInviteModalBtn = document.getElementById('openInviteModalBtn'); // Certifique-se de ter um botão com este ID para abrir o modal
    if (openInviteModalBtn) {
        openInviteModalBtn.addEventListener('click', () => {
            inviteModalOverlay.style.display = 'flex';
        });
    }

    // Fechar Modal ao clicar no 'x'
    closeInviteModalBtn.addEventListener('click', () => {
        closeInviteModal();
    });

    // Fechar Modal ao clicar no botão 'Cancelar'
    cancelInviteModalBtn.addEventListener('click', () => {
        closeInviteModal();
    });

    // Fechar Modal ao clicar fora do container do modal
    inviteModalOverlay.addEventListener('click', (e) => {
        if (e.target === inviteModalOverlay) {
            closeInviteModal();
        }
    });

    // Função para fechar o modal e resetar o formulário
    function closeInviteModal() {
        inviteModalOverlay.style.display = 'none';
        inviteForm.reset();
        inviteCodeSection.style.display = 'none';
        inviteForm.style.display = 'block';
        profileNotesSection.style.display = 'none';
        profileNoteContent.innerHTML = '';
    }

    // Manipulação do Formulário de Convite
    inviteForm.addEventListener('submit', function(event) {
        event.preventDefault();
        const name = document.getElementById('inviteName').value.trim();
        const email = document.getElementById('inviteEmail').value.trim();
        const clinic = document.getElementById('inviteClinic').value;
        const perfil = document.getElementById('invitePerfil').value;

        // Validação adicional
        if (!name || !email || !clinic || !perfil) {
            alert('Por favor, preencha todos os campos.');
            return;
        }

        // Geração de código único para o convite
        const code = generateInviteCode();
        const id = generateInviteId(); // Função para gerar ID único

        const newInvite = {
            id: id,
            name: name,
            email: email,
            clinic: clinic,
            perfil: perfil,
            code: code,
            status: 'Pendente'
        };

        // Adiciona o novo convite à lista de convites pendentes
        pendingInvites.push(newInvite);

        // Atualiza a tabela de convites pendentes
        updatePendingInvitesTable();

        // Exibe o código gerado
        inviteForm.style.display = 'none';
        inviteCodeDisplay.textContent = code;
        inviteCodeSection.style.display = 'block';
    });

    // Função para copiar o código de convite
    copyInviteCodeBtn.addEventListener('click', function() {
        const code = inviteCodeDisplay.textContent;
        if (code) {
            navigator.clipboard.writeText(code).then(() => {
                alert('Código copiado: ' + code);
            }).catch(err => {
                alert('Erro ao copiar o código');
            });
        } else {
            alert('Nenhum código para copiar.');
        }
    });

    // Função para gerar IDs únicos para convites
    let inviteIdCounter = pendingInvites.length ? Math.max(...pendingInvites.map(inv => parseInt(inv.id.replace('INV', '')))) : 0;
    function generateInviteId() {
        inviteIdCounter += 1;
        return 'INV' + String(inviteIdCounter).padStart(3, '0'); // Exemplo: INV001, INV002, etc.
    }

    // Função para gerar um código de convite único
    function generateInviteCode() {
        return Math.random().toString(36).substring(2, 8).toUpperCase(); // Gera um código de 6 caracteres
    }

    // Event Listener para o campo de Perfil
    invitePerfilSelect.addEventListener('change', function() {
        const selectedPerfil = this.value;
        if (profileNotes[selectedPerfil]) {
            profileNoteContent.innerHTML = profileNotes[selectedPerfil];
            profileNotesSection.style.display = 'block';
        } else {
            profileNoteContent.innerHTML = '';
            profileNotesSection.style.display = 'none';
        }
    });
});


    </script>
</body>
</html>
