<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Admin - Gestão de Pacientes</title>
    <!-- Fontes e Ícones -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- CSS Global do Projeto (Exemplo) -->
    <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: #f7fafc;
            margin: 0;
            padding: 0;
        }

        .header-content h1 {
            color: #08C89E;
            margin-top: -20px;
            font-size: 24px;
        }

        /* Filtros */
        .filters {
            display: flex;
            align-items: flex-end;
            gap: 20px;
            flex-wrap: wrap;
            margin-bottom: 20px;
        }
        .filters .filter-group {
            display: flex;
            flex-direction: column;
        }
        .filters label {
            font-size: 14px;
            font-weight: 600;
            margin-bottom: 5px;
            color: #2d3748;
        }
        .filters select,
        .filters input {
            padding: 8px 12px;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            font-size: 14px;
            width: 250px;
            box-sizing: border-box;
            transition: border-color 0.3s ease;
        }
        .filters select:focus,
        .filters input:focus {
            border-color: #08C89E;
            outline: none;
        }
        .filters .btn {
            padding: 8px 16px;
            background-color: #08C89E;
            color: #fff;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            transition: background-color 0.3s ease;
        }
        .filters .btn:hover {
            background-color: #06a08a;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            background: #fff;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            overflow: hidden;
            margin-bottom: 20px;
        }

        th, td {
            text-align: left;
            padding: 10px;
            border-bottom: 1px solid #e2e8f0;
            font-size: 14px;
            vertical-align: middle;
        }

        th {
            background: #f7fafc;
            color: #2d3748;
            font-weight: 600;
        }

        tr:hover {
            background: #f1f5f9;
        }

        .badge {
            display: inline-block;
            padding: 3px 8px;
            border-radius: 8px;
            font-size: 12px;
            font-weight: 600;
            color: #fff;
            text-transform: capitalize;
        }

        .badge.ativo { background: #48BB78; }
        .badge.bloqueado { background: #E53E3E; }
        .badge.removido { background: #718096; }

        .actions-cell {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .actions-cell button {
            background: #edf2f7;
            border: none;
            border-radius: 8px;
            padding: 8px;
            cursor: pointer;
            font-size: 14px;
            display: flex;
            align-items: center;
            color: #2d3748;
            transition: background-color 0.3s ease;
        }

        .actions-cell button:hover {
            background: #e2e8f0;
        }

        .actions-cell button i {
            font-size: 16px;
        }

        /* Paginação */
        .pagination {
            text-align: center;
            margin-top: 20px;
        }
        .pagination a {
            display: inline-block;
            margin: 0 4px;
            padding: 6px 10px;
            background-color: #ebf8ff;
            color: #2d3748;
            border-radius: 4px;
            text-decoration: none;
            transition: background-color 0.3s ease;
        }
        .pagination a.active {
            background-color: #08C89E;
            color: #fff;
        }
        .pagination a:hover:not(.active) {
            background-color: #cceaf5;
        }

        /* Modais */
        .modal {
            display: none;
            position: fixed;
            z-index: 9999;
            top: 0; left: 0; right: 0; bottom: 0;
            background: rgba(0,0,0,0.5);
            justify-content: center;
            align-items: center;
        }

        .modal-content {
            background: #fff;
            border-radius: 10px;
            padding: 20px;
            width: 90%;
            max-width: 600px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.2);
            position: relative;
            animation: fadeIn 0.3s ease-in-out;
        }

        .modal-content h2 {
            font-size: 20px;
            color: #08C89E;
            margin-bottom: 10px;
        }

        .modal-content .close-modal {
            position: absolute;
            right: 20px;
            top: 20px;
            font-size: 24px;
            cursor: pointer;
            color: #aaa;
            transition: color 0.3s ease;
        }

        .modal-content .close-modal:hover { color: #333; }

        .modal-content p {
            margin: 5px 0;
            font-size: 14px;
            color: #4a5568;
        }

        .modal-actions {
            margin-top: 20px;
            display: flex;
            justify-content: flex-end;
            gap: 10px;
        }

        .btn.cancel {
            background: #edf2f7;
            color: #2d3748;
            border-radius: 8px;
            padding: 8px 16px;
            cursor: pointer;
            font-size: 14px;
            transition: background-color 0.3s ease;
        }

        .btn.cancel:hover {
            background: #e2e8f0;
        }

        .btn.confirm {
            background: #08C89E;
            color: #fff;
            border-radius: 8px;
            padding: 8px 16px;
            cursor: pointer;
            font-size: 14px;
            transition: background-color 0.3s ease;
        }

        .btn.confirm:hover {
            background: #06b287;
        }

        .form-group-modal {
            margin-bottom: 15px;
        }

        .form-group-modal label {
            display: block;
            font-size: 14px;
            font-weight: 600;
            margin-bottom: 5px;
            color: #2d3748;
        }

        .form-group-modal textarea,
        .form-group-modal select,
        .form-group-modal input {
            width: 100%;
            padding: 8px 10px;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            font-size: 14px;
            box-sizing: border-box;
            color: #2d3748;
        }

        .details {
            background: #f7fafc;
            padding: 10px;
            border-radius: 8px;
            border: 1px solid #e2e8f0;
            margin-bottom: 10px;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        /* Container principal */
        .partnership-management {
            background-color: #fff;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-superadmin-pacientes.php'; ?>

    <!-- Main Content -->
    <main class="content">
        <div class="header-content">
            <h1>Gestão de Pacientes</h1>
        </div>
        
        <!-- Container de Gestão de Clínicas -->
        <div class="partnership-management">
            <p style="margin-top:-10px; margin-bottom:20px;">Filtre, visualize e gerencie pacientes. Mude de clínica, restaure, bloqueie e confira o histórico completo.</p>
            <hr />
            
            <!-- Filtros -->
            <div class="filters">
                    <div class="filter-group">
                        <label for="filterName">Nome do Paciente</label>
                        <input type="text" id="filterName" placeholder="Ex: João Silva" disabled>
                </div>
                    <div class="filter-group">
                        <label for="filterClinic">Clínica</label>
                        <select id="filterClinic" disabled>
                            <option value="">Todas</option>
                            <option value="Clínica Sertãozinho">Clínica Sertãozinho</option>
                            <option value="Clínica Central">Clínica Central</option>
                            <option value="Clínica do Norte">Clínica do Norte</option>
                        </select>
                </div>
                    <div class="filter-group">
                        <label for="filterProfessional">Profissional Responsável</label>
                        <select id="filterProfessional" disabled>
                            <option value="">Todos</option>
                            <option value="Mariana Santos">Mariana Santos</option>
                            <option value="Pedro Oliveira">Pedro Oliveira</option>
                            <option value="Ana Luiza">Ana Luiza</option>
                        </select>
                </div>

                    <button class="btn" id="applyFilters" disabled>Aplicar Filtros</button>
                    
            </div>
            
            <table>
                    <thead>
                        <tr>
                            <th>ORD</th>
                            <th>DT/Cadastro</th>
                            <th>Código</th>
                            <th>Nome Paciente</th>
                            <th>Clínica</th>
                            <th>Responsável</th>
                            <th>Status</th>
                            <th>Ações</th>
                        </tr>
                    </thead>
                    <tbody id="patientsTableBody">
                        <tr>
                            <td>1</td>
                            <td>2023-01-10</td>
                            <td>#ABC001</td>
                            <td>João Silva</td>
                            <td>Clínica Sertãozinho</td>
                            <td>Maria da Silva</td>
                            <td><span class="badge ativo">ativo</span></td>
                            <td class="actions-cell">
                                <button class="viewProfileBtn" title="Ver Perfil Completo" onclick="alert('Redirecionando para o perfil completo do paciente João Silva.')">
                                    <i class="fas fa-user"></i>
                                </button>
                                <button class="moveClinicBtn" title="Mudar Clínica" onclick="openMoveModal('#ABC001')">
                                    <i class="fas fa-exchange-alt"></i>
                                </button>
                                <button class="blockPatientBtn" title="Bloquear Paciente" onclick="openBlockModal('#ABC001')">
                                    <i class="fas fa-ban"></i>
                                </button>
                            </td>
                        </tr>
                        <tr>
                            <td>2</td>
                            <td>2023-02-20</td>
                            <td>#ABC002</td>
                            <td>Ana Clara</td>
                            <td>Clínica Central</td>
                            <td>Pedro Oliveira</td>
                            <td><span class="badge ativo">ativo</span></td>
                            <td class="actions-cell">
                                <button class="viewProfileBtn" title="Ver Perfil Completo" onclick="alert('Redirecionando para o perfil completo do paciente Ana Clara.')">
                                    <i class="fas fa-user"></i>
                                </button>
                                <button class="moveClinicBtn" title="Mudar Clínica" onclick="openMoveModal('#ABC002')">
                                    <i class="fas fa-exchange-alt"></i>
                                </button>
                                <button class="blockPatientBtn" title="Bloquear Paciente" onclick="openBlockModal('#ABC002')">
                                    <i class="fas fa-ban"></i>
                                </button>
                            </td>
                        </tr>
                        <tr>
                            <td>3</td>
                            <td>2023-01-01</td>
                            <td>#ABC003</td>
                            <td>Bruno Costa</td>
                            <td>Clínica do Norte</td>
                            <td>Carla Costa</td>
                            <td><span class="badge bloqueado">bloqueado</span></td>
                            <td class="actions-cell">
                                <button class="viewProfileBtn" title="Ver Perfil Completo" onclick="alert('Redirecionando para o perfil completo do paciente Bruno Costa.')">
                                    <i class="fas fa-user"></i>
                                </button>
                                <button class="restorePatientBtn" title="Restaurar Paciente" onclick="openRestoreModal('#ABC003')">
                                    <i class="fas fa-undo-alt"></i>
                                </button>
                            </td>
                        </tr>
                        <tr>
                            <td>4</td>
                            <td>2023-02-02</td>
                            <td>#ABC004</td>
                            <td>Carla Souza</td>
                            <td>Clínica Sertãozinho</td>
                            <td>João Souza</td>
                            <td><span class="badge removido">removido</span></td>
                            <td class="actions-cell">
                                <button class="viewProfileBtn" title="Ver Perfil Completo" onclick="alert('Redirecionando para o perfil completo do paciente Carla Souza.')">
                                    <i class="fas fa-user"></i>
                                </button>
                                <button class="restorePatientBtn" title="Restaurar Paciente" onclick="openRestoreModal('#ABC004')">
                                    <i class="fas fa-undo-alt"></i>
                                </button>
                            </td>
                        </tr>
                        <tr>
                            <td>5</td>
                            <td>2023-03-01</td>
                            <td>#ABC005</td>
                            <td>Daniel Lima</td>
                            <td>Clínica Central</td>
                            <td>Fernanda Lima</td>
                            <td><span class="badge ativo">ativo</span></td>
                            <td class="actions-cell">
                                <button class="viewProfileBtn" title="Ver Perfil Completo" onclick="alert('Redirecionando para o perfil completo do paciente Daniel Lima.')">
                                    <i class="fas fa-user"></i>
                                </button>
                                <button class="moveClinicBtn" title="Mudar Clínica" onclick="openMoveModal('#ABC005')">
                                    <i class="fas fa-exchange-alt"></i>
                                </button>
                                <button class="blockPatientBtn" title="Bloquear Paciente" onclick="openBlockModal('#ABC005')">
                                    <i class="fas fa-ban"></i>
                                </button>
                            </td>
                        </tr>
                    </tbody>
            </table>
            <!-- Paginação de Exemplo -->
            <div class="pagination" style="margin-top:20px;">
                <a href="#" class="active">1</a>
                <a href="#">2</a>
                <a href="#">Próximo &raquo;</a>
            </div>
    </main>

    <!-- Modal Mover Paciente -->
    <div class="modal" id="moveModal">
        <div class="modal-content">
            <span class="close-modal" onclick="closeModal('moveModal')">&times;</span>
            <h2>Mudar Paciente de Clínica</h2>
            <div class="form-group-modal">
                <label for="newClinicCode">Código da Nova Clínica</label>
                <input type="text" id="newClinicCode" placeholder="Ex: CL001" value="CL001">
                <button class="btn confirm" onclick="simulateMoveSearch()">Pesquisar</button>
            </div>
            <div class="details" id="moveClinicDetails" style="display:none;">
                <p><b>ID da Clínica:</b> CL002</p>
                <p><b>Nome da Clínica:</b> Clínica Central</p>
                <p><b>Localização:</b> São Paulo, SP</p>
                <p><b>Status:</b> Ativa</p>
            </div>
            <div class="form-group-modal" id="moveReasonGroup" style="display:none;">
                <label for="moveReason">Motivo da Mudança</label>
                <textarea id="moveReason" rows="3" placeholder="Descreva o motivo"></textarea>
            </div>
            <div class="modal-actions">
                <button class="btn cancel" onclick="closeModal('moveModal')">Cancelar</button>
                <button class="btn confirm" id="confirmMoveBtn" style="display:none;" onclick="confirmMove()">Confirmar Transferência</button>
            </div>
        </div>
    </div>

    <!-- Modal Restaurar Paciente -->
    <div class="modal" id="restoreModal">
        <div class="modal-content">
            <span class="close-modal" onclick="closeModal('restoreModal')">&times;</span>
            <h2>Restaurar Paciente Bloqueado</h2>
            <div class="form-group-modal">
                <label for="restoreClinicCode">Código da Clínica para Restaurar</label>
                <input type="text" id="restoreClinicCode" placeholder="Ex: CL003" value="CL003">
                <button class="btn confirm" onclick="simulateRestoreSearch()">Pesquisar</button>
            </div>
            <div class="details" id="restoreClinicDetails" style="display:none;">
                <p><b>ID da Clínica:</b> CL003</p>
                <p><b>Nome da Clínica:</b> Clínica do Norte</p>
                <p><b>Localização:</b> Manaus, AM</p>
                <p><b>Status:</b> Inativa</p>
            </div>
            <div class="form-group-modal" id="restoreReasonGroup" style="display:none;">
                <label for="restoreReason">Motivo da Restauração</label>
                <textarea id="restoreReason" rows="3" placeholder="Descreva o motivo"></textarea>
            </div>
            <div class="modal-actions">
                <button class="btn cancel" onclick="closeModal('restoreModal')">Cancelar</button>
                <button class="btn confirm" id="confirmRestoreBtn" style="display:none;" onclick="confirmRestore()">Confirmar Restauração</button>
            </div>
        </div>
    </div>

    <!-- Modal Bloquear Paciente -->
    <div class="modal" id="blockModal">
        <div class="modal-content">
            <span class="close-modal" onclick="closeModal('blockModal')">&times;</span>
            <h2>Bloquear Paciente</h2>
            <p>Ao bloquear, o paciente não poderá mais ser acessado, exceto pelo Admin do Sistema.</p>
            <p><b>ID:</b> <span id="blockPatientId"></span>, <b>Nome:</b> <span id="blockPatientName"></span></p>
            <div class="form-group-modal">
                <label for="blockReason">Motivo do Bloqueio</label>
                <textarea id="blockReason" rows="3" placeholder="Descreva o motivo"></textarea>
            </div>
            <div class="modal-actions">
                <button class="btn cancel" onclick="closeModal('blockModal')">Cancelar</button>
                <button class="btn confirm" onclick="confirmBlock()">Confirmar</button>
            </div>
        </div>
    </div>

    <script>
        // Funções para abrir e fechar modais
        function openMoveModal(patientId) {
            document.getElementById('moveModal').style.display = 'flex';
            // Aqui você pode pré-preencher informações específicas do paciente, se necessário
        }

        function openRestoreModal(patientId) {
            document.getElementById('restoreModal').style.display = 'flex';
            // Aqui você pode pré-preencher informações específicas do paciente, se necessário
        }

        function openBlockModal(patientId) {
            document.getElementById('blockModal').style.display = 'flex';
            // Preencher os detalhes do paciente
            const patientRow = document.querySelector(`button.blockPatientBtn[data-id="${patientId}"]`).closest('tr');
            const id = patientRow.children[2].textContent;
            const name = patientRow.children[3].textContent;
            document.getElementById('blockPatientId').textContent = id;
            document.getElementById('blockPatientName').textContent = name;
        }

        function closeModal(modalId) {
            document.getElementById(modalId).style.display = 'none';
            // Resetar campos dos modais
            if (modalId === 'moveModal') {
                document.getElementById('newClinicCode').value = '';
                document.getElementById('moveClinicDetails').style.display = 'none';
                document.getElementById('moveReasonGroup').style.display = 'none';
                document.getElementById('confirmMoveBtn').style.display = 'none';
            }
            if (modalId === 'restoreModal') {
                document.getElementById('restoreClinicCode').value = '';
                document.getElementById('restoreClinicDetails').style.display = 'none';
                document.getElementById('restoreReasonGroup').style.display = 'none';
                document.getElementById('confirmRestoreBtn').style.display = 'none';
            }
            if (modalId === 'blockModal') {
                document.getElementById('blockReason').value = '';
            }
        }

        // Simular busca na Mudança de Clínica
        function simulateMoveSearch() {
            // Simulação de sucesso na busca
            document.getElementById('moveClinicDetails').style.display = 'block';
            document.getElementById('moveReasonGroup').style.display = 'block';
            document.getElementById('confirmMoveBtn').style.display = 'inline-block';
        }

        // Confirmar Mudança de Clínica
        function confirmMove() {
            alert('Paciente transferido com sucesso!');
            closeModal('moveModal');
        }

        // Simular busca na Restauração de Paciente
        function simulateRestoreSearch() {
            // Simulação de sucesso na busca
            document.getElementById('restoreClinicDetails').style.display = 'block';
            document.getElementById('restoreReasonGroup').style.display = 'block';
            document.getElementById('confirmRestoreBtn').style.display = 'inline-block';
        }

        // Confirmar Restauração de Paciente
        function confirmRestore() {
            alert('Paciente restaurado com sucesso!');
            closeModal('restoreModal');
        }

        // Confirmar Bloqueio de Paciente
        function confirmBlock() {
            const id = document.getElementById('blockPatientId').textContent;
            const name = document.getElementById('blockPatientName').textContent;
            alert(`Paciente ${name} (${id}) bloqueado com sucesso!`);
            closeModal('blockModal');
        }
    </script>
</body>
</html>
