<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Sistema IFCora - Edição de Clínica</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body style="font-family: 'Poppins', sans-serif;">

    <!-- Cabeçalho e Sidebar (Incluídos via PHP ou arquivo separado) -->
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-painel-clinica.php'; ?>

    <main class="content" style="padding: 20px;">
        <div class="header-content" style="margin-bottom: 20px;">
            <h1 style="color: #08C89E; font-size: 24px;">
                <i class="fas fa-clinic-medical" style="margin-right: 8px;"></i>Cadastro de Clínica
            </h1>
            <p style="font-size: 14px; color: #4a5568;">
                Preencha as informações abaixo para cadastrar uma nova clínica no sistema.
            </p>
        </div>

        <!-- Exemplo de Card de Clínica -->
        <div class="clinic-info-card" style="
            background-color: #ffffff; 
            border: 1px solid #e2e8f0; 
            border-radius: 12px; 
            padding: 16px; 
            margin-bottom: 20px; 
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            font-family: 'Poppins', sans-serif;">
            
            <h2>Clínica Sertãozinho</h2>
            <div class="clinic-info-list">
                <p><strong>Razão Social:</strong> Clínica Sertãozinho Ltda.</p>
                <p><strong>Nome Fantasia:</strong> Clínica Sertãozinho</p>
                <p><strong>CNPJ:</strong> 12.345.678/0001-99</p>
                <p><strong>Endereço:</strong> Rua das Flores, 123 - Centro, CEP 14.100-000, Sertãozinho - SP</p>
                <p><strong>Telefone:</strong> (16) 3262-0000</p>
                <p><strong>E-mail:</strong> financeiro@clinicasertaozinho.com</p>
                <!-- Botão de Edição com Data Attributes -->
                <button class="clinic-edit-button" data-clinic='{
                    "type": "pj",
                    "name": "Clínica Sertãozinho",
                    "razao_social": "Clínica Sertãozinho Ltda.",
                    "nome_fantasia": "Clínica Sertãozinho",
                    "cnpj": "12.345.678/0001-99",
                    "cpf": "",
                    "telefone": "(16) 3262-0000",
                    "email_financeiro": "financeiro@clinicasertaozinho.com",
                    "endereco": {
                        "logradouro": "Rua das Flores",
                        "numero": "123",
                        "complemento": "",
                        "bairro": "Centro",
                        "cidade": "Sertãozinho",
                        "estado": "SP",
                        "cep": "14.100-000"
                    }
                }' style="
                    background-color: #F6AD55; 
                    color: #fff; 
                    border: none; 
                    border-radius: 8px; 
                    padding: 10px 20px; 
                    font-size: 14px; 
                    cursor: pointer; 
                    display: flex; 
                    align-items: center; 
                    gap: 8px;">
                    <i class="fas fa-edit"></i> Editar
                </button>
            </div>
        </div>
    </main>

    <!-- Modal para Edição da Clínica -->
    <div id="clinic-edit-modal" style="
        display: none; 
        position: fixed; 
        top: 0; 
        left: 0; 
        width: 100%; 
        height: 100%; 
        background-color: rgba(0,0,0,0.5); 
        justify-content: center; 
        align-items: center; 
        z-index: 9999;">
        
        <div style="
            background-color: #ffffff; 
            border-radius: 12px; 
            width: 90%; 
            max-width: 800px; 
            padding: 20px; 
            position: relative; 
            box-sizing: border-box; 
            max-height: 90vh; 
            overflow-y: auto;
            font-family: 'Poppins', sans-serif;">
            
            <!-- Botão para Fechar o Modal -->
            <span id="closeEditModalBtn" style="
                position: absolute; 
                top: 16px; 
                right: 16px; 
                font-size: 24px; 
                font-weight: bold; 
                color: #4a5568; 
                cursor: pointer;">
                &times;
            </span>
            
            <!-- Cabeçalho do Modal -->
            <div class="modal-header" style="text-align: center; margin-bottom: 20px;">
                <h2 style="
                    color: #fff; 
                    background-color: #F6AD55; 
                    padding: 10px 0; 
                    border-radius: 8px; 
                    margin: 0;">
                    Editar Clínica <span style="color: #08C89E;">#PRA008</span>
                </h2>
            </div>
            
            <!-- Descrição do Modal -->
            <p style="font-size: 14px; color: #4a5568; margin-bottom: 20px;">
                Ajuste as informações de acordo com o tipo de responsável 
                (<b>Pessoa Física</b> ou <b>Pessoa Jurídica</b>) e as necessidades de cobrança.
            </p>

            <!-- Formulário de Edição -->
            <form id="editClinicForm" style="display: flex; flex-direction: column; gap: 20px;">
                
                <!-- Seção 1: Seleção de Tipo (PF/PJ) -->
                <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                    <div style="flex: 1; min-width: 200px;">
                        <label for="editClinicType" style="
                            display: block; 
                            font-size: 14px; 
                            color: #2d3748; 
                            margin-bottom: 5px;">
                            Tipo de Responsável
                        </label>
                        <select id="editClinicType" name="editClinicType" required style="
                            width: 100%; 
                            padding: 8px; 
                            border: 1px solid #e2e8f0; 
                            border-radius: 8px; 
                            font-size: 14px; 
                            color: #2d3748;">
                            <option value="" disabled>Selecione</option>
                            <option value="pf">Pessoa Física</option>
                            <option value="pj">Pessoa Jurídica</option>
                        </select>
                    </div>
                </div>
                
                <!-- Seção 2: Campos Dinâmicos PF/PJ -->
                <div class="identification-section" style="display: flex; flex-direction: column; gap: 10px;">
                    
                    <!-- Pessoa Física -->
                    <div id="editPfFields" style="display: none; flex-direction: column; gap: 10px;">
                        <!-- PF - Nome Completo -->
                        <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                            <div style="flex: 1; min-width: 250px;">
                                <label for="editPfName" style="
                                    display: block; 
                                    font-size: 14px; 
                                    color: #2d3748; 
                                    margin-bottom: 5px;">
                                    Nome Completo (PF)
                                </label>
                                <input type="text" id="editPfName" name="editPfName" placeholder="Ex: João da Silva" required style="
                                    width: 100%; 
                                    padding: 8px; 
                                    border: 1px solid #e2e8f0; 
                                    border-radius: 8px; 
                                    font-size: 14px; 
                                    color: #2d3748; 
                                    box-sizing: border-box;">
                            </div>
                        </div>
                        
                        <!-- PF - CPF -->
                        <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                            <div style="flex: 1; min-width: 250px;">
                                <label for="editPfCPF" style="
                                    display: block; 
                                    font-size: 14px; 
                                    color: #2d3748; 
                                    margin-bottom: 5px;">
                                    CPF
                                </label>
                                <input type="text" id="editPfCPF" name="editPfCPF" placeholder="000.000.000-00" required style="
                                    width: 100%; 
                                    padding: 8px; 
                                    border: 1px solid #e2e8f0; 
                                    border-radius: 8px; 
                                    font-size: 14px; 
                                    color: #2d3748; 
                                    box-sizing: border-box;">
                            </div>
                        </div>
                    </div>
                    
                    <!-- Pessoa Jurídica -->
                    <div id="editPjFields" style="display: none; flex-direction: column; gap: 10px;">
                        <!-- PJ - Razão Social -->
                        <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                            <div style="flex: 1; min-width: 250px;">
                                <label for="editPjRazaoSocial" style="
                                    display: block; 
                                    font-size: 14px; 
                                    color: #2d3748; 
                                    margin-bottom: 5px;">
                                    Razão Social (PJ)
                                </label>
                                <input type="text" id="editPjRazaoSocial" name="editPjRazaoSocial" placeholder="Ex: Clínica Exemplo LTDA" required style="
                                    width: 100%; 
                                    padding: 8px; 
                                    border: 1px solid #e2e8f0; 
                                    border-radius: 8px; 
                                    font-size: 14px; 
                                    color: #2d3748; 
                                    box-sizing: border-box;">
                            </div>
                        </div>
                        
                        <!-- PJ - CNPJ -->
                        <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                            <div style="flex: 1; min-width: 250px;">
                                <label for="editPjCNPJ" style="
                                    display: block; 
                                    font-size: 14px; 
                                    color: #2d3748; 
                                    margin-bottom: 5px;">
                                    CNPJ
                                </label>
                                <input type="text" id="editPjCNPJ" name="editPjCNPJ" placeholder="00.000.000/0001-00" required style="
                                    width: 100%; 
                                    padding: 8px; 
                                    border: 1px solid #e2e8f0; 
                                    border-radius: 8px; 
                                    font-size: 14px; 
                                    color: #2d3748; 
                                    box-sizing: border-box;">
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Seção 3: Telefone e E-mail Financeiro -->
                <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                    <div style="flex: 1; min-width: 200px;">
                        <label for="editClinicPhone" style="
                            display: block; 
                            font-size: 14px; 
                            color: #2d3748; 
                            margin-bottom: 5px;">
                            Telefone / Celular
                        </label>
                        <input type="tel" id="editClinicPhone" name="editClinicPhone" placeholder="(99) 99999-9999" required style="
                            width: 100%; 
                            padding: 8px; 
                            border: 1px solid #e2e8f0; 
                            border-radius: 8px; 
                            font-size: 14px; 
                            color: #2d3748; 
                            box-sizing: border-box;">
                    </div>
                    <div style="flex: 1; min-width: 280px;">
                        <label for="editClinicFinanceEmail" style="
                            display: block; 
                            font-size: 14px; 
                            color: #2d3748; 
                            margin-bottom: 5px;">
                            E-mail Financeiro
                        </label>
                        <input type="email" id="editClinicFinanceEmail" name="editClinicFinanceEmail" placeholder="financeiro@exemplo.com" required style="
                            width: 100%; 
                            padding: 8px; 
                            border: 1px solid #e2e8f0; 
                            border-radius: 8px; 
                            font-size: 14px; 
                            color: #2d3748; 
                            box-sizing: border-box;">
                    </div>
                </div>
                
                <!-- Seção 4: Endereço -->
                <div style="display: flex; flex-direction: column; gap: 10px;">
                    <h3 style="
                        font-size: 16px; 
                        color: #2d3748; 
                        border-bottom: 1px solid #e2e8f0; 
                        padding-bottom: 5px; 
                        margin: 0;">
                        Endereço
                    </h3>
                    
                    <!-- Linha 1: Logradouro, Número e Complemento -->
                    <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                        <div style="flex: 2; min-width: 200px;">
                            <label for="editClinicStreet" style="
                                display: block; 
                                font-size: 14px; 
                                color: #2d3748; 
                                margin-bottom: 5px;">
                                Logradouro
                            </label>
                            <input type="text" id="editClinicStreet" name="editClinicStreet" placeholder="Rua / Avenida" required style="
                                width: 100%; 
                                padding: 8px; 
                                border: 1px solid #e2e8f0; 
                                border-radius: 8px; 
                                font-size: 14px; 
                                color: #2d3748; 
                                box-sizing: border-box;">
                        </div>
                        <div style="flex: 1; min-width: 100px;">
                            <label for="editClinicNumber" style="
                                display: block; 
                                font-size: 14px; 
                                color: #2d3748; 
                                margin-bottom: 5px;">
                                Número
                            </label>
                            <input type="text" id="editClinicNumber" name="editClinicNumber" placeholder="123" required style="
                                width: 100%; 
                                padding: 8px; 
                                border: 1px solid #e2e8f0; 
                                border-radius: 8px; 
                                font-size: 14px; 
                                color: #2d3748; 
                                box-sizing: border-box;">
                        </div>
                        <div style="flex: 1; min-width: 150px;">
                            <label for="editClinicComplement" style="
                                display: block; 
                                font-size: 14px; 
                                color: #2d3748; 
                                margin-bottom: 5px;">
                                Complemento
                            </label>
                            <input type="text" id="editClinicComplement" name="editClinicComplement" placeholder="Apto, Sala..." style="
                                width: 100%; 
                                padding: 8px; 
                                border: 1px solid #e2e8f0; 
                                border-radius: 8px; 
                                font-size: 14px; 
                                color: #2d3748; 
                                box-sizing: border-box;">
                        </div>
                    </div>
                    
                    <!-- Linha 2: Bairro, Cidade, Estado e CEP -->
                    <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                        <div style="flex: 1; min-width: 180px;">
                            <label for="editClinicNeighborhood" style="
                                display: block; 
                                font-size: 14px; 
                                color: #2d3748; 
                                margin-bottom: 5px;">
                                Bairro
                            </label>
                            <input type="text" id="editClinicNeighborhood" name="editClinicNeighborhood" placeholder="Centro" required style="
                                width: 100%; 
                                padding: 8px; 
                                border: 1px solid #e2e8f0; 
                                border-radius: 8px; 
                                font-size: 14px; 
                                color: #2d3748; 
                                box-sizing: border-box;">
                        </div>
                        <div style="flex: 1; min-width: 180px;">
                            <label for="editClinicCity" style="
                                display: block; 
                                font-size: 14px; 
                                color: #2d3748; 
                                margin-bottom: 5px;">
                                Cidade
                            </label>
                            <input type="text" id="editClinicCity" name="editClinicCity" placeholder="Sertãozinho" required style="
                                width: 100%; 
                                padding: 8px; 
                                border: 1px solid #e2e8f0; 
                                border-radius: 8px; 
                                font-size: 14px; 
                                color: #2d3748; 
                                box-sizing: border-box;">
                        </div>
                        <div style="flex: 1; min-width: 80px;">
                            <label for="editClinicState" style="
                                display: block; 
                                font-size: 14px; 
                                color: #2d3748; 
                                margin-bottom: 5px;">
                                Estado
                            </label>
                            <select id="editClinicState" name="editClinicState" required style="
                                width: 100%; 
                                padding: 8px; 
                                border: 1px solid #e2e8f0; 
                                border-radius: 8px; 
                                font-size: 14px; 
                                color: #2d3748; 
                                box-sizing: border-box;">
                                <option value="" disabled>UF</option>
                                <option value="SP">SP</option>
                                <option value="RJ">RJ</option>
                                <option value="MG">MG</option>
                                <option value="BA">BA</option>
                                <option value="RS">RS</option>
                                <!-- Adicione mais opções de estados conforme necessário -->
                            </select>
                        </div>
                        <div style="flex: 1; min-width: 150px;">
                            <label for="editClinicCEP" style="
                                display: block; 
                                font-size: 14px; 
                                color: #2d3748; 
                                margin-bottom: 5px;">
                                CEP
                            </label>
                            <input type="text" id="editClinicCEP" name="editClinicCEP" placeholder="12.345-678" required style="
                                width: 100%; 
                                padding: 8px; 
                                border: 1px solid #e2e8f0; 
                                border-radius: 8px; 
                                font-size: 14px; 
                                color: #2d3748; 
                                box-sizing: border-box;">
                        </div>
                    </div>
                </div>

                <!-- Botões de Ação -->
                <div style="display: flex; justify-content: flex-end; gap: 10px;">
                    <button type="button" id="cancelEditBtn" style="
                        background-color: #e53e3e; 
                        color: #fff; 
                        padding: 10px 20px; 
                        border: none; 
                        border-radius: 8px; 
                        font-size: 14px; 
                        cursor: pointer;">
                        Cancelar
                    </button>
                    <button type="submit" style="
                        background-color: #F6AD55; 
                        color: #fff; 
                        padding: 10px 20px; 
                        border: none; 
                        border-radius: 8px; 
                        font-size: 14px; 
                        cursor: pointer;">
                        Salvar
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Scripts -->
    <script>
        // Seleção de Tipo (PF ou PJ) no modal de edição
        const editClinicTypeSelect = document.getElementById('editClinicType');
        const editPfFields = document.getElementById('editPfFields');
        const editPjFields = document.getElementById('editPjFields');

        editClinicTypeSelect.addEventListener('change', function() {
            if (this.value === 'pf') {
                editPfFields.style.display = 'flex';
                editPjFields.style.display = 'none';
            } else if (this.value === 'pj') {
                editPfFields.style.display = 'none';
                editPjFields.style.display = 'flex';
            } else {
                editPfFields.style.display = 'none';
                editPjFields.style.display = 'none';
            }
        });

        // Abrir o modal de edição
        const editButtons = document.querySelectorAll('.clinic-edit-button');
        const clinicEditModal = document.getElementById('clinic-edit-modal');
        const closeEditModalBtn = document.getElementById('closeEditModalBtn');
        const cancelEditBtn = document.getElementById('cancelEditBtn');
        const editClinicForm = document.getElementById('editClinicForm');

        editButtons.forEach(button => {
            button.addEventListener('click', function() {
                const clinicData = JSON.parse(this.getAttribute('data-clinic'));
                populateEditForm(clinicData);
                clinicEditModal.style.display = 'flex';
            });
        });

        // Fechar o modal de edição
        closeEditModalBtn.addEventListener('click', () => {
            clinicEditModal.style.display = 'none';
            editClinicForm.reset();
            editPfFields.style.display = 'none';
            editPjFields.style.display = 'none';
        });

        cancelEditBtn.addEventListener('click', () => {
            clinicEditModal.style.display = 'none';
            editClinicForm.reset();
            editPfFields.style.display = 'none';
            editPjFields.style.display = 'none';
        });

        // Fechar o modal clicando fora dele
        window.addEventListener('click', function(event) {
            if (event.target === clinicEditModal) {
                clinicEditModal.style.display = 'none';
                editClinicForm.reset();
                editPfFields.style.display = 'none';
                editPjFields.style.display = 'none';
            }
        });

        // Função para preencher o formulário de edição com os dados da clínica
        function populateEditForm(data) {
            // Tipo
            document.getElementById('editClinicType').value = data.type;
            if (data.type === 'pf') {
                editPfFields.style.display = 'flex';
                editPjFields.style.display = 'none';
                document.getElementById('editPfName').value = data.name;
                document.getElementById('editPfCPF').value = data.cpf;
            } else if (data.type === 'pj') {
                editPfFields.style.display = 'none';
                editPjFields.style.display = 'flex';
                document.getElementById('editPjRazaoSocial').value = data.razao_social;
                document.getElementById('editPjCNPJ').value = data.cnpj;
            }

            // Contato
            document.getElementById('editClinicPhone').value = data.telefone;
            document.getElementById('editClinicFinanceEmail').value = data.email_financeiro;

            // Endereço
            document.getElementById('editClinicStreet').value = data.endereco.logradouro;
            document.getElementById('editClinicNumber').value = data.endereco.numero;
            document.getElementById('editClinicComplement').value = data.endereco.complemento;
            document.getElementById('editClinicNeighborhood').value = data.endereco.bairro;
            document.getElementById('editClinicCity').value = data.endereco.cidade;
            document.getElementById('editClinicState').value = data.endereco.estado;
            document.getElementById('editClinicCEP').value = data.endereco.cep;
        }

        // Submissão do Formulário de Edição
        editClinicForm.addEventListener('submit', function(event) {
            event.preventDefault();
            // Aqui você pode adicionar a lógica para enviar os dados para o servidor.
            alert('Clínica atualizada com sucesso!');
            clinicEditModal.style.display = 'none';
            editClinicForm.reset();
            editPfFields.style.display = 'none';
            editPjFields.style.display = 'none';
        });
    </script>
</body>
</html>
