<?php
/**
 * Proxy PHP para ChromaDB API
 * Redireciona requisições de api.ifcora.com para localhost:8001
 */

// Headers CORS
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
header('Access-Control-Max-Age: 3600');

// Responder OPTIONS para CORS preflight
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Configuração da API local
$api_host = '127.0.0.1';
$api_port = 8001;

// Capturar o path da requisição
$request_uri = $_SERVER['REQUEST_URI'];
$path = parse_url($request_uri, PHP_URL_PATH);
$query = parse_url($request_uri, PHP_URL_QUERY);

// Remover prefixos desnecessários do path
$path = str_replace('/chromadb-api', '', $path);
if (empty($path) || $path === '/') {
    $path = '/';
}

// Construir URL da API local
$api_url = "http://{$api_host}:{$api_port}{$path}";
if ($query) {
    $api_url .= "?{$query}";
}

// Capturar método HTTP
$method = $_SERVER['REQUEST_METHOD'];

// Capturar headers da requisição original
$headers = [];
foreach (getallheaders() as $name => $value) {
    // Pular headers problemáticos
    if (strtolower($name) === 'host' || strtolower($name) === 'connection') {
        continue;
    }
    $headers[] = "$name: $value";
}

// Capturar body da requisição (para POST, PUT, etc.)
$input = file_get_contents('php://input');

// Configurar cURL
$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $api_url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_CUSTOMREQUEST => $method,
    CURLOPT_HTTPHEADER => $headers,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_CONNECTTIMEOUT => 10,
    CURLOPT_HEADERFUNCTION => function($curl, $header) {
        $len = strlen($header);
        $header = explode(':', $header, 2);
        
        if (count($header) < 2) {
            return $len;
        }
        
        $name = strtolower(trim($header[0]));
        $value = trim($header[1]);
        
        // Repassar headers importantes (exceto alguns problemáticos)
        if (!in_array($name, ['transfer-encoding', 'connection', 'server', 'date'])) {
            header("$name: $value");
        }
        
        return $len;
    }
]);

// Adicionar body se houver
if ($input && in_array($method, ['POST', 'PUT', 'PATCH'])) {
    curl_setopt($ch, CURLOPT_POSTFIELDS, $input);
}

// Log de debug (opcional)
error_log("Proxy: $method $api_url");

// Executar requisição
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);

curl_close($ch);

// Verificar erros
if ($error) {
    http_response_code(502);
    header('Content-Type: application/json');
    echo json_encode([
        'error' => 'Proxy Error',
        'message' => 'Não foi possível conectar à API',
        'curl_error' => $error,
        'api_url' => $api_url
    ]);
    exit();
}

// Definir código de resposta HTTP
http_response_code($http_code);

// Retornar resposta
echo $response;
?>