#!/bin/bash

API_DIR="/home/wwifcora/public_html/chromadb-api"
LOG_FILE="$API_DIR/api.log"
PID_FILE="$API_DIR/api.pid"

cd $API_DIR

case $1 in
    start)
        if pgrep -f "uvicorn app:app" > /dev/null; then
            echo "❌ API já está rodando!"
            ps aux | grep uvicorn | grep -v grep
        else
            echo "🚀 Iniciando ChromaDB API..."
            source chromadb_env/bin/activate
            nohup uvicorn app:app --host 0.0.0.0 --port 8001 > $LOG_FILE 2>&1 &
            echo $! > $PID_FILE
            sleep 2
            if pgrep -f "uvicorn app:app" > /dev/null; then
                echo "✅ API iniciada com sucesso!"
                echo "🌐 Acesse: http://api.ifcora.com/"
                echo "📊 PID: $(cat $PID_FILE)"
            else
                echo "❌ Erro ao iniciar API. Verifique os logs:"
                tail -10 $LOG_FILE
            fi
        fi
        ;;
    
    stop)
        echo "🛑 Parando ChromaDB API..."
        pkill -f "uvicorn app:app"
        rm -f $PID_FILE
        sleep 2
        if pgrep -f "uvicorn app:app" > /dev/null; then
            echo "⚠️  API ainda rodando, forçando parada..."
            pkill -9 -f "uvicorn app:app"
        else
            echo "✅ API parada com sucesso!"
        fi
        ;;
    
    restart)
        echo "🔄 Reiniciando ChromaDB API..."
        $0 stop
        sleep 3
        $0 start
        ;;
    
    status)
        if pgrep -f "uvicorn app:app" > /dev/null; then
            echo "✅ ChromaDB API está RODANDO"
            echo "🔗 URL: http://api.ifcora.com/"
            echo "📊 Processo:"
            ps aux | grep uvicorn | grep -v grep | while read line; do
                echo "   $line"
            done
            echo "📈 Porta 8001:"
            netstat -tulpn | grep :8001
            if [ -f $PID_FILE ]; then
                echo "📋 PID salvo: $(cat $PID_FILE)"
            fi
        else
            echo "❌ ChromaDB API está PARADA"
        fi
        ;;
    
    logs)
        if [ -f $LOG_FILE ]; then
            echo "📋 Últimas 20 linhas do log:"
            echo "================================"
            tail -20 $LOG_FILE
        else
            echo "❌ Arquivo de log não encontrado: $LOG_FILE"
        fi
        ;;
    
    follow-logs)
        if [ -f $LOG_FILE ]; then
            echo "📋 Seguindo logs (Ctrl+C para sair):"
            echo "================================"
            tail -f $LOG_FILE
        else
            echo "❌ Arquivo de log não encontrado: $LOG_FILE"
        fi
        ;;
    
    test)
        echo "🧪 Testando ChromaDB API..."
        echo "1️⃣  Teste local:"
        curl -s http://localhost:8001/ | python3 -m json.tool 2>/dev/null || echo "❌ Falha no teste local"
        
        echo "2️⃣  Teste público:"
        curl -s http://api.ifcora.com/ | python3 -m json.tool 2>/dev/null || echo "❌ Falha no teste público"
        
        echo "3️⃣  Listando coleções:"
        curl -s http://api.ifcora.com/collections | python3 -m json.tool 2>/dev/null || echo "❌ Falha ao listar coleções"
        ;;
    
    *)
        echo "🔧 Uso: $0 {start|stop|restart|status|logs|follow-logs|test}"
        echo ""
        echo "Comandos disponíveis:"
        echo "  start       - Inicia a API"
        echo "  stop        - Para a API" 
        echo "  restart     - Reinicia a API"
        echo "  status      - Mostra status da API"
        echo "  logs        - Mostra últimas 20 linhas do log"
        echo "  follow-logs - Acompanha logs em tempo real"
        echo "  test        - Testa se a API está respondendo"
        echo ""
        echo "Exemplo: $0 start"
        ;;
esac
