<?php
/**
 * Arquivo de Configuração - OpenAI API e Prompts
 * Arquivo: config.php
 */

// Configurações da API OpenAI
define('OPENAI_API_KEY', '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'); // DEFINA SUA CHAVE AQUI!
define('OPENAI_API_URL', 'https://api.openai.com/v1/chat/completions');
define('OPENAI_MODEL', 'gpt-4o-mini'); // 'gpt-4o' 'gpt-4-turbo' 'gpt-4o-mini'

// Configurações do sistema
define('MAX_TOKENS', 4000);
define('TEMPERATURE', 0.3);
define('CHUNK_SIZE_TARGET', 500); // Tamanho alvo para cada chunk em palavras

/**
 * Função para fazer chamadas à API do OpenAI
 */
function callOpenAI($prompt, $system_message = null) {
    $headers = [
        'Content-Type: application/json',
        'Authorization: Bearer ' . OPENAI_API_KEY
    ];
    
    $messages = [];
    if ($system_message) {
        $messages[] = [
            'role' => 'system',
            'content' => $system_message
        ];
    }
    
    $messages[] = [
        'role' => 'user',
        'content' => $prompt
    ];
    
    $data = [
        'model' => OPENAI_MODEL,
        'messages' => $messages,
        'max_tokens' => MAX_TOKENS,
        'temperature' => TEMPERATURE
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, OPENAI_API_URL);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code !== 200) {
        throw new Exception("Erro na API OpenAI: HTTP $http_code - $response");
    }
    
    $result = json_decode($response, true);
    
    if (!isset($result['choices'][0]['message']['content'])) {
        throw new Exception("Resposta inválida da API OpenAI");
    }
    
    return $result['choices'][0]['message']['content'];
}
