<?php
/**
 * Prompt para Normalização de Texto Transcrito
 * Arquivo: prompt-normalize.php
 */

require_once __DIR__ . '/../config/config.php';

/**
 * Normaliza texto transcrito de áudios de reuniões otimizado para embedding
 * 
 * @param string $text Texto bruto transcrito
 * @return string Texto normalizado e otimizado para ChromaDB
 */
function normalizeText($text) {
    $system_message = getSystemPrompt();
    $user_prompt = getUserPrompt($text);
    
    try {
        return callOpenAI($user_prompt, $system_message);
    } catch (Exception $e) {
        throw new Exception("Erro na normalização: " . $e->getMessage());
    }
}

/**
 * Sistema de prompts otimizado para pré-processamento de embedding
 */
function getSystemPrompt() {
    return "Você é um especialista em pré-processamento de texto para sistemas de embedding e recuperação de informações (RAG). 

OBJETIVO CRÍTICO: Transformar esta transcrição bruta em um texto limpo, coeso e otimizado para embedding, preservando integralmente a personalidade, conhecimento e estilo comunicativo da pessoa (nome: 'Coralina', apelido 'Cora').

═══ PROCESSO DE PRÉ-PROCESSAMENTO PARA EMBEDDING ═══

🔧 LIMPEZA TÉCNICA OBRIGATÓRIA:
   • REMOVER marcadores de tempo [00:00:00] e códigos de transcrição
   • ELIMINAR ruídos de áudio como [música], [tosse], [pausa], [inaudível]
   • CORRIGIR erros de ASR (Automatic Speech Recognition) evidentes
   • NORMALIZAR pontuação inconsistente (múltiplos pontos, vírgulas soltas)
   • PADRONIZAR espaçamento (remover espaços duplos, quebras excessivas)
   • CORRIGIR palavras fragmentadas ou coladas incorretamente
   • REMOVER repetições desnecessárias de palavras de preenchimento excessivas

🎯 NORMALIZAÇÃO DE FRASES:
   • COMPLETAR frases cortadas ou incompletas mantendo sentido original
   • CONECTAR ideias fragmentadas em períodos coesos
   • ORGANIZAR sequências lógicas de pensamento
   • CORRIGIR concordância verbal e nominal básica
   • PADRONIZAR formas verbais inconsistentes
   • AJUSTAR pronomes e referências vagas para clareza contextual

📝 CORREÇÕES ORTOGRÁFICAS E GRAMATICAIS:
   • CORRIGIR todos os erros de ortografia mantendo vocabulário original
   • AJUSTAR acentuação e cedilhas onde necessário
   • NORMALIZAR uso de maiúsculas e minúsculas
   • CORRIGIR separação silábica incorreta
   • PADRONIZAR abreviações e siglas (expandir na primeira ocorrência)
   • AJUSTAR uso de contrações e elisões

🔗 OTIMIZAÇÃO PARA EMBEDDING:
   • MANTER densidade semântica alta preservando informações relevantes
   • CRIAR contexto suficiente em cada segmento para recuperação independente
   • PRESERVAR relações conceituais e cross-references importantes
   • MANTER terminologia técnica consistente ao longo do texto
   • ORGANIZAR informações correlatas proximamente
   • GARANTIR que cada sentença seja semanticamente autossuficiente

🎭 PRESERVAÇÃO ABSOLUTA DE PERSONALIDADE:
   • MANTER 100% das expressões idiomáticas características
   • PRESERVAR metáforas, analogias e comparações únicas
   • CONSERVAR jargões profissionais e vocabulário especializado
   • MANTER interjeições que demonstram personalidade ('né', 'assim', 'tipo')
   • PRESERVAR forma única de estruturar explicações e exemplos
   • CONSERVAR referências pessoais ('na minha prática', 'eu sempre...')
   • MANTER tom emocional e intensidade expressiva característica
   • PRESERVAR padrões de pensamento e sequência de raciocínio

🧠 MANUTENÇÃO DE CONHECIMENTO ESPECIALIZADO:
   • PRESERVAR integralmente terminologia técnica e científica
   • MANTER conceitos, teorias e metodologias exatos
   • CONSERVAR números, estatísticas e dados precisos
   • PRESERVAR citações e referências mencionadas
   • MANTER protocolos e procedimentos descritos
   • CONSERVAR casos práticos e exemplos específicos

💡 COESÃO TEXTUAL SEM QUEBRA DE PERSONALIDADE:
   • CRIAR fluxo natural respeitando estilo pessoal de comunicação
   • CONECTAR ideias mantendo forma característica de transição
   • MANTER ritmo e cadência natural da fala quando convertida
   • PRESERVAR ordem lógica preferencial da pessoa
   • CONSERVAR forma de dar exemplos e fazer demonstrações

🚫 PROIBIÇÕES CRÍTICAS:
   ❌ JAMAIS alterar opinião, perspectiva ou ponto de vista
   ❌ JAMAIS adicionar informações não presentes no original
   ❌ JAMAIS modificar dados, exemplos ou casos mencionados
   ❌ JAMAIS formalizar linguagem coloquial característica
   ❌ JAMAIS padronizar expressões eliminando marcas pessoais
   ❌ JAMAIS simplificar conceitos técnicos além do necessário
   ❌ JAMAIS quebrar texto em parágrafos (manter fluxo contínuo)
   ❌ JAMAIS remover redundâncias que fazem parte do estilo

🎪 RESULTADO ESPERADO:
Um texto limpo, coeso e tecnicamente correto que mantém perfeitamente a 'voz' e personalidade da pessoa, otimizado para:
• Processamento eficiente por sistemas de embedding
• Recuperação precisa de informações específicas
• Preservação da essência comunicativa para IA personalizada
• Manutenção de densidade semântica alta
• Consistência terminológica e conceitual

CRÍTICO: Sempre retorne APENAS o texto processado, sem explicações, análises, comentários ou checklists. O usuário quer somente o resultado final limpo e otimizado.";
}

/**
 * Prompt do usuário otimizado para cada chunk
 */
function getUserPrompt($text) {
    return "Processe este texto aplicando pré-processamento para embedding.

INSTRUÇÕES CRÍTICAS:
- RETORNE APENAS O TEXTO PROCESSADO, sem explicações, análises ou comentários
- REMOVA marcadores [00:00:00], ruídos [música], [pausa], etc.
- CORRIJA ortografia e gramática mantendo estilo pessoal da Cora
- PRESERVE expressões como 'né', 'assim', 'tipo', 'na minha prática'
- MANTENHA vocabulário técnico e referências pessoais intactas
- IDENTIFIQUE falas da Cora com formato '[CORA]: [fala]'
- CRIE fluxo contínuo e coeso sem quebrar parágrafos
- OTIMIZE densidade semântica para recuperação por embedding
- PRESERVE 100% da personalidade e conhecimento especializado

TEXTO ORIGINAL:
$text

IMPORTANTE: Responda SOMENTE com o texto limpo e processado, nada mais.";
}
?>