<?php
/**
 * Arquivo de Configuração - OpenAI API e Prompts
 * Arquivo: config.php
 */

// CONFIGURAÇÕES DA API OPENAI - OTIMIZADO PARA RESPOSTA RICA
function getOpenAIConfig() {
    return [
        'api_key' => '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', // DEFINA SUA CHAVE AQUI!
        'api_url' => 'https://api.openai.com/v1/chat/completions',
        'model' => 'gpt-4o-mini',           // 'gpt-4o' 'gpt-4-turbo' 'gpt-4o-mini'
        'max_tokens_per_chunk' => 8000,  // Muito maior para processar mais conteúdo
        'temperature' => 0.25,           // Mais preciso para preservar personalidade
        'max_tokens' => 16000            // Resposta muito mais rica e detalhada
    ];
}

// PROMPT PRINCIPAL PARA LIMPEZA DE TRANSCRIÇÕES - VERSÃO RICA E DETALHADA
function getSystemPrompt() {
    return "Você é um especialista mundial em edição de transcrições e análise linguística para personalização de IA. 

CONTEXTO CRÍTICO: Esta transcrição contém as falas de UMA PESSOA ESPECÍFICA (nome: 'Coralina', apelido 'Cora') que serão usadas para treinar uma IA personalizada via embedding. Seu objetivo é criar um texto que preserve PERFEITAMENTE a essência, conhecimento, estilo e personalidade desta pessoa para que uma IA possa replicar com precisão sua forma de comunicação.

═══ DIRETRIZES DETALHADAS DE PROCESSAMENTO ═══

🔤 CORREÇÕES TÉCNICAS PRECISAS:
   • Corrigir todos os erros ortográficos e de digitação mantendo vocabulário original
   • Ajustar pontuação para clareza sem alterar ritmo natural da fala
   • Reorganizar períodos confusos preservando 100% do conteúdo semântico
   • Corrigir concordâncias gramaticais mantendo estilo coloquial quando apropriado
   • Padronizar formatação de números, datas, percentuais e valores
   • Manter regionalismo e expressões geográficas específicas

🎭 PRESERVAÇÃO ABSOLUTA DE PERSONALIDADE:
   • MANTER integralmente todas as expressões idiomáticas e linguagem figurada
   • PRESERVAR metáforas, analogias e comparações únicas da pessoa
   • CONSERVAR vícios de linguagem característicos (mas reduzir excessos)
   • MANTER jargões profissionais, técnicos e de domínio específico
   • PRESERVAR interjeições que demonstram emoção ou ênfase
   • CONSERVAR forma única de estruturar raciocínios e argumentos
   • MANTER referências culturais, experiências pessoais e anedotas
   • PRESERVAR tom emocional e intensidade expressiva
   • CONSERVAR padrões de repetição quando usados para ênfase

🧠 ANÁLISE COGNITIVA E ESTILÍSTICA:
   • Identificar e preservar padrões de pensamento únicos da pessoa
   • Manter sequência lógica característica de apresentação de ideias
   • Preservar forma específica de dar exemplos e fazer conexões
   • Conservar nível de complexidade vocabular habitual
   • Manter densidade informacional típica da pessoa
   • Preservar ritmo e cadência natural da comunicação
   • Conservar forma de fazer transições entre tópicos
   • Manter estilo de perguntas retóricas e engajamento da audiência

📚 PRESERVAÇÃO DE CONHECIMENTO ESPECIALIZADO:
   • MANTER integralmente toda terminologia técnica e científica
   • PRESERVAR conceitos, teorias e metodologias mencionadas
   • CONSERVAR números, estatísticas, dados e referências precisas
   • MANTER citações, referências bibliográficas e fontes mencionadas
   • PRESERVAR cronologias, sequências e relações causais
   • CONSERVAR classificações, categorias e taxonomias utilizadas
   • MANTER protocolos, procedimentos e processos descritos
   • PRESERVAR casos clínicos, exemplos práticos e aplicações

🔗 OTIMIZAÇÃO AVANÇADA PARA EMBEDDING:
   • Estruturar informações em blocos semânticos coesos e recuperáveis
   • Criar parágrafos com densidade informacional balanceada
   • Organizar conceitos de forma hierárquica e logicamente conectada
   • Manter contexto suficiente em cada segmento para recuperação independente
   • Preservar relações conceituais e cross-references entre ideias
   • Equilibrar especificidade e generalização para máxima utilidade
   • Criar pontos de ancoragem semântica para busca eficiente
   • Manter consistência terminológica ao longo do texto

🎯 ESTRUTURAÇÃO INTELIGENTE E EXPANSIVA:
   • Identificar e nomear claramente todos os tópicos e subtópicos abordados
   • Criar títulos descritivos que capturem a essência de cada seção
   • Manter fluxo narrativo natural respeitando linha de raciocínio original
   • Expandir abreviações e siglas na primeira ocorrência
   • Adicionar contexto implícito quando necessário para clareza
   • Organizar informações correlatas em proximidade física
   • Criar transições fluidas que preservem lógica original
   • Manter elementos de storytelling e narrativa pessoal

💡 ENRIQUECIMENTO CONTEXTUAL INTELIGENTE:
   • Explicitar conhecimento implícito quando relevante para compreensão
   • Adicionar contexto técnico mínimo necessário sem alterar autenticidade
   • Clarificar referências vagas mantendo estilo original
   • Expandir conceitos complexos sem perder profundidade
   • Manter equilíbrio entre acessibilidade e rigor técnico
   • Preservar ambiguidades intencionais e nuances de significado

🚫 PROIBIÇÕES ABSOLUTAS:
   ❌ JAMAIS alterar opinião, perspectiva ou ponto de vista da pessoa
   ❌ JAMAIS adicionar informações não presentes no texto original
   ❌ JAMAIS modificar exemplos, dados ou casos mencionados
   ❌ JAMAIS alterar tom emocional ou intensidade expressiva
   ❌ JAMAIS padronizar linguagem eliminando características únicas
   ❌ JAMAIS remover elementos que demonstrem expertise ou experiência
   ❌ JAMAIS simplificar excessivamente conceitos complexos
   ❌ JAMAIS homogeneizar estilo eliminando marcas pessoais

🎪 RESULTADO ESPERADO:
Um texto que funcionará como 'DNA linguístico' da pessoa, permitindo que uma IA treinada com este material seja capaz de:
• Responder perguntas no mesmo estilo e tom
• Usar vocabulário e expressões características
• Aplicar mesmo nível de profundidade técnica
• Demonstrar mesmos padrões de raciocínio
• Manter consistência de personalidade em diferentes contextos
• Reproduzir forma única de explicar conceitos complexos

IMPORTANTE: Você está criando um 'perfil de comunicação completo' que deve capturar não apenas o QUE a pessoa fala, mas COMO ela fala, QUANDO ela usa certas expressões, e POR QUE ela estrutura ideias de determinada forma.";
}

// PROMPT PARA CHUNK INDIVIDUAL - VERSÃO FOCADA EM CORREÇÃO
function getUserPrompt($chunk, $chunkIndex, $totalChunks) {
    $chunkInfo = $totalChunks > 1 ? " (Segmento " . ($chunkIndex + 1) . " de $totalChunks)" : "";
    
    return "Corrija este texto$chunkInfo aplicando RIGOROSAMENTE as diretrizes de preservação de personalidade.

FOCO PRINCIPAL: Corrija apenas erros técnicos, mantenha 100% do estilo pessoal.
Estruture o texto em **parágrafos claros**, separando cada ideia em um novo parágrafo com uma linha em branco entre eles.

EXEMPLOS DO QUE FAZER:
✅ \"azerdo\" → \"azedo\" (corrige ortografia)
✅ \"eu pego um limão, encosto na minha língua\" → \"eu pego um limão, encosto na minha língua\" (mantém intacto)
✅ \"então né, eu sempre falo\" → \"então né, eu sempre falo\" (preserva expressões características)
✅ \"na minha prática clínica\" → \"na minha prática clínica\" (mantém referências pessoais)

EXEMPLOS DO QUE NÃO FAZER:
❌ Não transformar \"eu pego\" em \"ao pegar\"
❌ Não transformar \"eu encosto na minha língua\" em \"experimento\"
❌ Não remover \"né\", \"assim\", \"tipo\" quando fazem parte do estilo
❌ Não formalizar expressões coloquiais características

TEXTO ORIGINAL PARA CORREÇÃO:
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
$chunk
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

INSTRUÇÃO CRÍTICA: Faça apenas correções técnicas necessárias. A pessoa deve continuar \"falando\" exatamente como sempre falou, apenas sem erros de digitação.

TEXTO CORRIGIDO:";
}

// PROMPT PARA REVISÃO FINAL - VERSÃO CORREÇÃO FOCADA
function getFinalReviewPrompt() {
    return "Você é um especialista em revisão final de textos corrigidos, com foco total na preservação de personalidade linguística.

═══ REVISÃO FINAL DE QUALIDADE ═══

🔍 VERIFICAÇÕES FINAIS OBRIGATÓRIAS:
   ✓ Todas as expressões características foram mantidas intactas
   ✓ Nenhuma linguagem coloquial foi formalizada indevidamente
   ✓ Exemplos pessoais permanecem exatamente como mencionados
   ✓ Referências à experiência pessoal foram preservadas
   ✓ Vícios de linguagem característicos foram mantidos
   ✓ Sequência e estrutura de raciocínio original preservadas
   ✓ Correções ortográficas realizadas sem alterar vocabulário

⚠️ VERIFICAÇÃO ESPECÍFICA - EXPRESSÕES PESSOAIS:
   • Procure por construções como \"eu pego\", \"eu coloco\", \"eu encosto\"
   • Verifique se metáforas e analogias pessoais foram mantidas
   • Confirme que exemplos práticos não foram generalizados
   • Assegure que referências como \"na minha prática\" permaneceram
   • Garanta que interjeições características (né, assim, tipo) foram preservadas

🎯 CORREÇÕES PERMITIDAS NA REVISÃO:
   • Apenas erros ortográficos que passaram despercebidos
   • Ajustes mínimos de pontuação para clareza
   • Correção de concordância verbal/nominal quando claramente incorreta
   • Organização de parágrafos sem alterar sequência de ideias

🚫 PROIBIÇÕES ABSOLUTAS NA REVISÃO:
   ❌ NÃO padronize expressões únicas da pessoa
   ❌ NÃO formalize linguagem coloquial característica  
   ❌ NÃO substitua palavras por sinônimos \"mais elegantes\"
   ❌ NÃO remova redundâncias que fazem parte do estilo pessoal
   ❌ NÃO altere ordem de palavras característica
   ❌ NÃO transforme exemplos pessoais em casos genéricos

🎪 RESULTADO FINAL ESPERADO:
Um texto tecnicamente correto que mantém perfeitamente a 'voz' da pessoa. Qualquer leitor familiar com o estilo da oradora deve reconhecer imediatamente que é ela falando, apenas sem erros de digitação ou ortografia.

INSTRUÇÃO CRÍTICA: Esta é uma REVISÃO DE CORREÇÃO, não uma reescrita. A pessoa deve continuar falando exatamente como sempre falou, apenas de forma tecnicamente correta.";
}

// CONFIGURAÇÕES DE VALIDAÇÃO - OTIMIZADAS PARA PROCESSAMENTO RICO
function getValidationRules() {
    return [
        'min_text_length' => 200,        // Mínimo maior para análise rica
        'max_text_length' => 100000,     // Máximo muito maior - sem restrição de tokens
        'chunk_overlap' => 200,          // Sobreposição entre chunks para continuidade
        'quality_threshold' => 0.95      // Nível mínimo de qualidade esperado
    ];
}

// CONFIGURAÇÕES DE INTERFACE - VERSÃO PREMIUM
function getInterfaceConfig() {
    return [
        'app_name' => 'Processamento Premium de Transcrições',
        'app_subtitle' => 'IA Personalizada • GPT-4o-mini • Resposta Rica sem Limite de Tokens',
        'max_processing_time' => 600,        // 10 minutos para processamento rico
        'chunk_processing_delay' => 2,       // Mais tempo entre chunks para qualidade
        'show_processing_log' => true,
        'show_statistics' => true,
        'show_advanced_stats' => true,       // Estatísticas avançadas
        'enable_quality_analysis' => true,   // Análise de qualidade do resultado
        'premium_mode' => true               // Modo premium ativado
    ];
}

// MENSAGENS DA APLICAÇÃO - VERSÃO PREMIUM
function getMessages() {
    return [
        'success' => [
            'processing_complete' => '🎉 Transcrição processada com qualidade PREMIUM! Texto enriquecido e otimizado.',
            'text_copied' => '📋 Texto copiado! Pronto para uso em sistemas de embedding.',
            'quality_excellent' => '⭐ Qualidade excepcional! Perfeito para personalização de IA.',
            'analysis_complete' => '🔬 Análise linguística concluída com sucesso!'
        ],
        'errors' => [
            'api_key_missing' => '🔑 ERRO: Configure sua chave da API OpenAI no arquivo config.php para acesso premium.',
            'text_empty' => '📝 Texto obrigatório! Cole sua transcrição para processamento premium.',
            'text_too_short' => '📏 Texto muito curto para análise rica. Mínimo: {min} caracteres para qualidade premium.',
            'text_too_long' => '📊 Texto excede limite atual: {max} caracteres. Divida em partes ou ajuste configurações.',
            'processing_failed' => '❌ Falha no processamento premium. Verifique log detalhado para diagnóstico.',
            'connection_error' => '🌐 Erro de conexão com API. Verifique conectividade e tente novamente.',
            'api_error' => '⚠️ Erro na API OpenAI: {message}',
            'quality_low' => '⚡ Qualidade abaixo do padrão premium. Reprocessando automaticamente...'
        ],
        'processing' => [
            'analyzing' => '🔍 Analisando padrões linguísticos e características únicas da pessoa...',
            'splitting' => '📦 Dividindo texto em {chunks} segmentos otimizados para processamento premium...',
            'processing_chunk' => '⚙️ Processamento premium do segmento {current} de {total}...',
            'enriching' => '✨ Enriquecendo conteúdo e preservando personalidade linguística...',
            'final_review' => '🔬 Revisão final premium: otimizando para embedding e personalização...',
            'quality_check' => '🎯 Verificação de qualidade e consistência...',
            'complete' => '🏆 Processamento PREMIUM concluído! Texto otimizado para IA personalizada.'
        ],
        'info' => [
            'premium_mode' => '💎 MODO PREMIUM ativado: Sem limite de tokens, resposta ultra-rica!',
            'personal_focus' => '👤 Otimizado para preservação de personalidade e estilo individual.',
            'embedding_ready' => '🧠 Resultado pronto para embedding e treinamento de IA personalizada.'
        ]
    ];
}

// CONFIGURAÇÕES AVANÇADAS
function getAdvancedConfig() {
    return [
        'curl_timeout' => 120,
        'ssl_verify_peer' => true,
        'retry_attempts' => 3,
        'retry_delay' => 2,
        'debug_mode' => false,
        'log_requests' => false
    ];
}

// VERIFICAÇÃO DE DEPENDÊNCIAS
function checkDependencies() {
    $dependencies = [
        'curl' => extension_loaded('curl'),
        'json' => extension_loaded('json'),
        'mbstring' => extension_loaded('mbstring')
    ];
    
    $missing = array_filter($dependencies, function($loaded) {
        return !$loaded;
    });
    
    if (!empty($missing)) {
        throw new Exception('Extensões PHP necessárias não encontradas: ' . implode(', ', array_keys($missing)));
    }
    
    return true;
}

// VALIDAÇÃO DE CONFIGURAÇÃO
function validateConfig() {
    $config = getOpenAIConfig();
    
    if (empty($config['api_key']) || $config['api_key'] === 'sua-chave-api-openai-aqui') {
        return false;
    }
    
    return true;
}
?>