# 🦄 Gerador de Histórias - Uma Princesa Diferente

Sistema completo para criar novas aventuras da Amy e Huggy usando IA, mantendo fidelidade à estrutura original da coleção.

## 📋 Requisitos

- PHP 7.4 ou superior
- Extensão cURL habilitada
- Chave de API da Anthropic (Claude) ou OpenAI (GPT)
- Servidor web (Apache, Nginx, ou PHP built-in server)

## 🚀 Instalação Rápida

1. **Clone/baixe os arquivos:**
   ```
   gerador-historias/
   ├── index.html
   ├── processor.php
   └── README.md
   ```

2. **Inicie o servidor:**
   ```bash
   php -S localhost:8000
   ```

3. **Acesse no navegador:**
   ```
   http://localhost:8000
   ```

## 🔑 Obtendo Chaves de API

### Anthropic (Claude) - RECOMENDADO
1. Acesse: https://console.anthropic.com/
2. Crie uma conta ou faça login
3. Vá em "API Keys"
4. Crie uma nova chave (começa com `sk-ant-`)
5. **Custo aproximado:** ~$0.50 por história (modelo Claude Sonnet 4.5)

### OpenAI (GPT)
1. Acesse: https://platform.openai.com/
2. Crie uma conta ou faça login
3. Vá em "API Keys"
4. Crie uma nova chave (começa com `sk-`)
5. **Custo aproximado:** ~$0.30 por história (modelo GPT-4)

## 📖 Como Usar

### Passo 1: Configurar API
1. Abra `index.html` no navegador
2. Cole sua chave de API no campo "Chave da API"
3. Selecione o provedor (Anthropic ou OpenAI)

### Passo 2: Definir o Tema
Preencha os campos:

**Tema da História:**
- Exemplos: "Princesa Pirata", "Princesa Cientista", "Princesa Bombeira"
- Seja criativo mas específico

**Cenário Principal:**
- Onde acontece: "Alto mar", "Laboratório mágico", "Floresta encantada"

**Dica do Problema (opcional):**
- Deixe em branco para a IA criar
- Ou sugira: "Animais perderam suas cores", "Ilha sem água potável"

**Idade da Criança:**
- 3-5 anos: vocabulário mais simples
- 6-8 anos: padrão (igual aos livros originais)
- 9-11 anos: vocabulário mais rico

### Passo 3: Gerar
1. Clique em "Criar Nova Aventura"
2. Aguarde 2-5 minutos (são 6 chamadas à IA)
3. Acompanhe o progresso na barra

### Passo 4: Salvar
Após a geração:
- **Imprimir:** botão "Imprimir História"
- **Copiar:** botão "Copiar Texto"
- **Salvar:** Ctrl+S no navegador

## 🎨 Temas Sugeridos

### Já Existentes (para referência)
- ✅ Super Princesa (cidade, super-herói)
- ✅ Princesa Espacial (espaço, planetas)

### Novos Temas Recomendados

**Aventuras na Natureza:**
- 🌊 Princesa Mergulhadora (recife de coral)
- 🏔️ Princesa Alpinista (montanhas nevadas)
- 🌳 Princesa Guardiã da Floresta (floresta tropical)
- 🏜️ Princesa Arqueóloga (deserto com ruínas antigas)

**Profissões:**
- 👩‍🚒 Princesa Bombeira (cidade em perigo)
- 👩‍🔬 Princesa Cientista (laboratório)
- 👩‍🍳 Princesa Chef (reino culinário)
- 👩‍⚕️ Princesa Doutora (hospital animal)

**Culturas e Histórias:**
- ⚔️ Princesa Viking (terras geladas)
- 🏴‍☠️ Princesa Pirata (alto mar)
- 🐉 Princesa Samurai (Japão antigo)
- 🏺 Princesa Egípcia (pirâmides)

**Fantasia e Magia:**
- 🧙‍♀️ Princesa Feiticeira (escola de magia)
- 🦋 Princesa das Borboletas (jardim mágico)
- ❄️ Princesa do Gelo (reino congelado)
- 🌈 Princesa do Arco-Íris (céu)

**Tecnologia:**
- 🤖 Princesa Robô (cidade futurista)
- 💻 Princesa Programadora (mundo digital)
- 🚀 Princesa Astronauta (estação espacial)

## 🔧 Estrutura Técnica

### Como Funciona?

O sistema divide a criação em **6 chamadas sequenciais** à IA:

1. **Ato 1 (Apresentação):** Amy se transforma no tema escolhido
2. **Ato 2 (Exploração):** Descoberta do mundo/cenário
3. **Ato 3 (Problema):** 2-3 desafios interligados
4. **Ato 4 (Solução):** Huggy usa arco-íris + cenouras
5. **Ato 5 (Despedida):** Retorno e encerramento
6. **Título:** Geração do título final

### Por Que Múltiplas Chamadas?

✅ **Evita "alucinações":** cada ato tem foco específico
✅ **Mantém consistência:** contexto acumulativo
✅ **Controle de qualidade:** cada parte é otimizada
✅ **Fidelidade ao original:** estrutura preservada

### Elementos Garantidos em Toda História

- ✅ Amy como narradora em 1ª pessoa
- ✅ Huggy e seus poderes de arco-íris
- ✅ Obsessão de Huggy por cenouras
- ✅ Tom conversacional e entusiasta
- ✅ Pergunta interativa ao leitor
- ✅ 3 itens de figurino/equipamento
- ✅ Problemas interligados
- ✅ Solução criativa e cooperativa
- ✅ Frase final: "Diz adeus, Huggy"

## ⚙️ Personalizações Avançadas

### Ajustar Comprimento
Em `processor.php`, modifique os `max_tokens`:
```php
$act1 = callAI($prompt_act1, $api_key, $api_provider, 800);  // Padrão: 800
```

### Mudar Modelo de IA
Para Claude:
```php
'model' => 'claude-sonnet-4-5-20250929'  // Mais inteligente
'model' => 'claude-haiku-3-5-20241022'    // Mais rápido e barato
```

Para OpenAI:
```php
'model' => 'gpt-4'      // Melhor qualidade
'model' => 'gpt-3.5'    // Mais rápido e barato
```

### Adicionar Elementos Customizados
No `processor.php`, adicione ao `$base_context`:
```php
$base_context = "...
ELEMENTO ESPECIAL: Sempre incluir [seu elemento].";
```

## 🐛 Solução de Problemas

### "Erro na API"
- ✅ Verifique se a chave está correta
- ✅ Confirme que tem créditos na conta
- ✅ Teste a chave no console da API

### História muito curta/longa
- ✅ Ajuste `max_tokens` em cada ato
- ✅ Modifique as instruções de palavra no prompt

### Não mantém consistência
- ✅ Verifique se o contexto está sendo passado
- ✅ Reforce instruções importantes no `$base_context`

### Timeout/Erro 504
- ✅ Aumente `max_execution_time` no PHP
- ✅ Verifique conexão com internet

## 💰 Custos Estimados

| Provedor | Modelo | Custo/História | Qualidade |
|----------|--------|----------------|-----------|
| Anthropic | Claude Sonnet 4.5 | ~$0.50 | ⭐⭐⭐⭐⭐ |
| OpenAI | GPT-4 | ~$0.30 | ⭐⭐⭐⭐ |
| OpenAI | GPT-3.5 | ~$0.05 | ⭐⭐⭐ |

*Valores aproximados, variam conforme comprimento*

## 📝 Exemplo de Uso

```
Tema: Princesa Pirata
Cenário: Alto mar com ilhas misteriosas
Problema: Criaturas marinhas brigando por território
Idade: 6-8 anos

Resultado: História de ~1200 palavras em 3-4 minutos
```

## 🤝 Contribuindo

Ideias para melhorias:
- Adicionar tradução automática
- Sistema de favoritos/biblioteca
- Geração de imagens com IA
- Exportação para PDF formatado
- Modo "série" (histórias conectadas)

## 📄 Licença

Este projeto é um gerador de histórias baseado no formato da coleção "Uma Princesa Diferente". 

**Importante:** Este sistema cria histórias INSPIRADAS na estrutura original, mas todo conteúdo gerado é novo e original, criado pela IA.

## ✨ Dicas para Melhores Resultados

1. **Seja específico no tema:** "Princesa Cientista Marinha" é melhor que só "Princesa Cientista"
2. **Combine elementos:** "Princesa Pirata Viking" pode criar histórias únicas
3. **Use cenários ricos:** mais detalhes = história mais interessante
4. **Teste sem "Dica do Problema":** a IA é criativa!
5. **Mantenha idade adequada:** respeite o nível de compreensão

## 🎯 Próximos Passos

1. Teste com tema simples primeiro
2. Ajuste a idade da criança se necessário
3. Experimente deixar "Dica do Problema" vazio
4. Compare Claude vs OpenAI para seu caso
5. Compartilhe a história com sua filha! 🦄

---

**Criado com ❤️ para pais que querem infinitas aventuras da Amy e Huggy!**

Para suporte ou dúvidas, consulte a documentação das APIs:
- Anthropic: https://docs.anthropic.com
- OpenAI: https://platform.openai.com/docs