<?php
session_start();
header('Content-Type: text/html; charset=utf-8');

// Configurações
$theme = $_POST['theme'] ?? '';
$setting = $_POST['setting'] ?? '';
$problem_hint = $_POST['problem_hint'] ?? '';
$age_target = $_POST['age_target'] ?? '6-8';
$api_key = $_POST['api_key'] ?? '';
$api_provider = $_POST['api_provider'] ?? 'anthropic';

if (empty($theme) || empty($setting) || empty($api_key)) {
    die('Erro: Preencha todos os campos obrigatórios.');
}

// Função para chamar a API
function callAI($prompt, $api_key, $provider, $max_tokens = 1000) {
    if ($provider === 'anthropic') {
        return callClaude($prompt, $api_key, $max_tokens);
    } else {
        return callOpenAI($prompt, $api_key, $max_tokens);
    }
}

// Chamada para Claude (Anthropic)
function callClaude($prompt, $api_key, $max_tokens) {
    $ch = curl_init('https://api.anthropic.com/v1/messages');
    
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json',
            'x-api-key: ' . $api_key,
            'anthropic-version: 2023-06-01'
        ],
        CURLOPT_POSTFIELDS => json_encode([
            'model' => 'claude-sonnet-4-5-20250929',
            'max_tokens' => $max_tokens,
            'messages' => [
                ['role' => 'user', 'content' => $prompt]
            ]
        ])
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode !== 200) {
        throw new Exception("Erro na API: " . $response);
    }
    
    $data = json_decode($response, true);
    return $data['content'][0]['text'] ?? '';
}

// Chamada para OpenAI
function callOpenAI($prompt, $api_key, $max_tokens) {
    $ch = curl_init('https://api.openai.com/v1/chat/completions');
    
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json',
            'Authorization: Bearer ' . $api_key
        ],
        CURLOPT_POSTFIELDS => json_encode([
            'model' => 'gpt-4',
            'max_tokens' => $max_tokens,
            'messages' => [
                ['role' => 'user', 'content' => $prompt]
            ]
        ])
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode !== 200) {
        throw new Exception("Erro na API: " . $response);
    }
    
    $data = json_decode($response, true);
    return $data['choices'][0]['message']['content'] ?? '';
}

// Função para atualizar progresso
function updateProgress($step, $total, $message) {
    $percentage = round(($step / $total) * 100);
    echo "<script>
        document.getElementById('progress').style.width = '{$percentage}%';
        document.getElementById('progress').textContent = '{$percentage}%';
        document.getElementById('status-text').textContent = '{$message}';
    </script>";
    flush();
    ob_flush();
}

// Início da página de resultado
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nova História Criada!</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        h1 {
            color: #667eea;
            text-align: center;
            margin-bottom: 30px;
        }
        .loading {
            text-align: center;
            margin: 30px 0;
        }
        .spinner {
            border: 4px solid #f3f3f3;
            border-top: 4px solid #667eea;
            border-radius: 50%;
            width: 50px;
            height: 50px;
            animation: spin 1s linear infinite;
            margin: 0 auto 15px;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        .progress-bar {
            width: 100%;
            height: 30px;
            background: #e0e0e0;
            border-radius: 15px;
            overflow: hidden;
            margin: 20px 0;
        }
        .progress-fill {
            height: 100%;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            width: 0%;
            transition: width 0.5s;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 600;
        }
        .story-content {
            display: none;
            line-height: 1.8;
            font-size: 1.1em;
            color: #333;
        }
        .story-content.show {
            display: block;
        }
        .story-content p {
            margin-bottom: 15px;
        }
        .actions {
            margin-top: 30px;
            display: flex;
            gap: 15px;
            justify-content: center;
        }
        button, .btn {
            padding: 12px 30px;
            border: none;
            border-radius: 8px;
            font-size: 1em;
            font-weight: 600;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            transition: transform 0.2s;
        }
        button:hover, .btn:hover {
            transform: translateY(-2px);
        }
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        .btn-secondary {
            background: #6c757d;
            color: white;
        }
        .act-title {
            color: #667eea;
            font-weight: 600;
            margin: 25px 0 10px 0;
            font-size: 0.9em;
            text-transform: uppercase;
            border-top: 2px solid #e0e0e0;
            padding-top: 15px;
        }
        .act-title:first-child {
            border-top: none;
            padding-top: 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🦄 Criando Nova Aventura...</h1>
        
        <div class="loading" id="loading">
            <div class="spinner"></div>
            <p id="status-text">Preparando a história...</p>
            <div class="progress-bar">
                <div class="progress-fill" id="progress">0%</div>
            </div>
        </div>
        
        <div class="story-content" id="story">
            <!-- A história será inserida aqui -->
        </div>
        
        <div class="actions" id="actions" style="display: none;">
            <button class="btn btn-primary" onclick="window.print()">📄 Imprimir História</button>
            <button class="btn btn-primary" onclick="copyStory()">📋 Copiar Texto</button>
            <a href="index.html" class="btn btn-secondary">🔄 Criar Outra História</a>
        </div>
    </div>

<?php
ob_start();

try {
    // CONTEXTO BASE - para todas as chamadas
    $base_context = "Você é um escritor especializado em histórias infantis da coleção 'Uma Princesa Diferente'. 
    
PERSONAGENS FIXOS:
- Amy: narradora em primeira pessoa, criativa, empática, corajosa
- Huggy: seu unicórnio mágico, fiel companheiro, tem poderes de arco-íris, SEMPRE quer cenouras

ESTILO:
- Tom conversacional, diálogo direto com o leitor
- Frases curtas e entusiasmadas
- Interjeições frequentes (Olá! Fantástico! Iupi!)
- Humor leve (especialmente sobre as cenouras do Huggy)
- Adequado para crianças de {$age_target} anos

IMPORTANTE: Mantenha a consistência com as histórias existentes da coleção.";

    // ===== ATO 1: APRESENTAÇÃO E TRANSFORMAÇÃO =====
    updateProgress(1, 6, "Ato 1: Amy se transformando em {$theme}...");
    
    $prompt_act1 = "{$base_context}

TAREFA: Escreva APENAS o Ato 1 da história (Apresentação e Transformação).

TEMA: {$theme}
CENÁRIO: {$setting}

O Ato 1 deve ter aproximadamente 150-200 palavras e incluir:
1. Saudação da Amy apresentando-se
2. Apresentação do Huggy
3. Frase padrão: 'O papai diz sempre que eu sou a sua princesinha. Eu gosto de ser uma princesa, mas ser sempre a mesma princesa é chato. Por isso eu sou uma princesa diferente todas as noites. E esta noite, quero ser...'
4. Declaração do tema em MAIÚSCULAS
5. Lista de 3 itens específicos do figurino/equipamento necessário para se tornar essa princesa
6. Uma pergunta interativa ao leitor relacionada ao tema
7. Uma frase de transição indicando que a aventura começa

EXEMPLO (estrutura, não copie):
'Para me tornar numa verdadeira Princesa Pirata, preciso: um chapéu com caveira, um mapa do tesouro e uma espada de madeira.'

NÃO mencione ainda problemas ou vilões. Apenas apresentação e preparação.

Escreva agora o Ato 1:";

    $act1 = callAI($prompt_act1, $api_key, $api_provider, 800);
    
    // ===== ATO 2: EXPLORAÇÃO DO MUNDO =====
    updateProgress(2, 6, "Ato 2: Explorando o mundo de {$setting}...");
    
    $prompt_act2 = "{$base_context}

CONTEXTO DA HISTÓRIA ATÉ AGORA:
{$act1}

TAREFA: Escreva APENAS o Ato 2 (Exploração do Mundo).

O Ato 2 deve ter aproximadamente 150-200 palavras e incluir:
1. Amy e Huggy começam a explorar o cenário ({$setting})
2. Descrições vívidas de 2-3 elementos interessantes desse mundo
3. Interação natural entre Amy e Huggy
4. Senso de maravilhamento e descoberta
5. Transição suave indicando que vão encontrar algo/alguém

NÃO introduza ainda os problemas principais. Apenas exploração e descoberta do ambiente.

Escreva agora o Ato 2:";

    $act2 = callAI($prompt_act2, $api_key, $api_provider, 800);
    
    // ===== ATO 3: DESCOBERTA DO PROBLEMA =====
    updateProgress(3, 6, "Ato 3: Descobrindo os desafios...");
    
    $problem_context = !empty($problem_hint) ? "DICA DO PROBLEMA: {$problem_hint}" : "Crie problemas originais e interligados adequados ao cenário.";
    
    $prompt_act3 = "{$base_context}

CONTEXTO DA HISTÓRIA ATÉ AGORA:
{$act1}
{$act2}

{$problem_context}

TAREFA: Escreva APENAS o Ato 3 (Descoberta do Problema).

O Ato 3 deve ter aproximadamente 200-250 palavras e incluir:
1. Amy e Huggy encontram 2-3 grupos de personagens/criaturas diferentes
2. Cada grupo tem um problema RELACIONADO aos outros (ex: um tem muita água mas sem sol, outro tem sol mas sem água)
3. Os personagens pedem ajuda à Amy de forma educada
4. Amy demonstra empatia e promete ajudar
5. Diálogo entre Amy e Huggy analisando a situação
6. Amy percebe que os problemas estão conectados

IMPORTANTE: Os problemas devem ser resolvíveis com:
- Trabalho em equipe
- Criatividade
- Poderes de arco-íris do Huggy (pode criar pontes, laços, tubos, etc)
- Conexão/cooperação entre os grupos

Escreva agora o Ato 3:";

    $act3 = callAI($prompt_act3, $api_key, $api_provider, 1000);
    
    // ===== ATO 4: SOLUÇÃO CRIATIVA =====
    updateProgress(4, 6, "Ato 4: Amy resolvendo os problemas...");
    
    $prompt_act4 = "{$base_context}

CONTEXTO DA HISTÓRIA ATÉ AGORA:
{$act1}
{$act2}
{$act3}

TAREFA: Escreva APENAS o Ato 4 (Solução Criativa).

O Ato 4 deve ter aproximadamente 300-350 palavras e incluir:
1. Amy elabora um plano criativo (pode envolver Huggy dizendo 'Agora é a minha vez Amy')
2. Huggy usa seus poderes de arco-íris de forma inovadora (pontes, laços, tubos, etc)
3. A solução resolve TODOS os problemas simultaneamente
4. Descrição detalhada de como cada grupo é ajudado
5. Reações positivas e agradecimentos dos personagens
6. MOMENTO DA CENOURA: Amy recompensa Huggy com cenoura(s)
7. Os grupos agradecem e se tornam amigos/colaboradores

ELEMENTOS OBRIGATÓRIOS:
- Frase da Amy: 'Conseguimos Huggy!' ou similar
- Huggy menciona cenouras (antes ou depois da solução)
- Todos os problemas são resolvidos
- Ênfase na cooperação e amizade entre os grupos

Escreva agora o Ato 4:";

    $act4 = callAI($prompt_act4, $api_key, $api_provider, 1200);
    
    // ===== ATO 5: DESPEDIDA =====
    updateProgress(5, 6, "Ato 5: Finalizando a aventura...");
    
    $prompt_act5 = "{$base_context}

CONTEXTO DA HISTÓRIA COMPLETA:
{$act1}
{$act2}
{$act3}
{$act4}

TAREFA: Escreva APENAS o Ato 5 (Despedida).

O Ato 5 deve ter aproximadamente 100-150 palavras e incluir:
1. Reflexão positiva da Amy sobre a aventura
2. Momento de retorno para casa (voando, viajando, etc)
3. Interação final com Huggy
4. Amy pensando em qual tipo de princesa será amanhã (não precisa especificar qual)
5. FRASE OBRIGATÓRIA DE ENCERRAMENTO: 'Diz adeus, Huggy'

Escreva agora o Ato 5:";

    $act5 = callAI($prompt_act5, $api_key, $api_provider, 600);
    
    // ===== TÍTULO =====
    updateProgress(6, 6, "Criando título...");
    
    $prompt_title = "Com base no tema '{$theme}', crie um título no formato 'Uma Princesa [Adjetivo/Tema]' ou 'Uma-Princesa-[tema]'.

Exemplos existentes:
- Uma-Princesa-Diferente
- Uma-Princesa-espacial

Responda APENAS com o título, sem explicações.";

    $title = trim(callAI($prompt_title, $api_key, $api_provider, 100));
    
    // Montar história completa
    $complete_story = "
<h2 style='color: #667eea; text-align: center; margin-bottom: 30px;'>{$title}</h2>

<div class='act-title'>Ato 1: Apresentação</div>
{$act1}

<div class='act-title'>Ato 2: Exploração</div>
{$act2}

<div class='act-title'>Ato 3: O Desafio</div>
{$act3}

<div class='act-title'>Ato 4: A Solução</div>
{$act4}

<div class='act-title'>Ato 5: Despedida</div>
{$act5}
";

    // Inserir história na página
    echo "<script>
        document.getElementById('loading').style.display = 'none';
        document.getElementById('story').innerHTML = `{$complete_story}`;
        document.getElementById('story').classList.add('show');
        document.getElementById('actions').style.display = 'flex';
    </script>";
    
    echo "<script>
        function copyStory() {
            const story = document.getElementById('story').innerText;
            navigator.clipboard.writeText(story).then(() => {
                alert('História copiada para a área de transferência!');
            });
        }
    </script>";
    
} catch (Exception $e) {
    echo "<script>
        document.getElementById('loading').innerHTML = `
            <p style='color: red; font-weight: bold;'>Erro ao gerar história:</p>
            <p>{$e->getMessage()}</p>
            <a href='index.html' class='btn btn-secondary' style='margin-top: 20px;'>Voltar</a>
        `;
    </script>";
}
?>
    </div>
</body>
</html>